/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.events;

import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.cryofloric_arts.hao111111111.Cryofloric_arts;
import org.cryofloric_arts.hao111111111.config.ModConfig;
import org.cryofloric_arts.hao111111111.world.biome.ModBiomes;

@Mod.EventBusSubscriber(modid="cryofloric_arts")
public class WhiteBarrensSpawnHandler {
    @SubscribeEvent
    public static void onMobSpawnInWhiteBarrens(MobSpawnEvent.FinalizeSpawn event) {
        if (!(event.getEntity() instanceof Mob)) {
            return;
        }
        Mob mob = event.getEntity();
        if (!event.getLevel().m_204166_(mob.m_20183_()).m_203565_(ModBiomes.WHITE_BARRENS)) {
            return;
        }
        if (!WhiteBarrensSpawnHandler.isEntityInWhiteBarrensWhitelist(mob)) {
            event.setSpawnCancelled(true);
        }
    }

    private static boolean isEntityInWhiteBarrensWhitelist(Mob mob) {
        List whitelist = (List)ModConfig.WHITE_BARRENS_SPAWN_WHITELIST.get();
        ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.m_6095_());
        if (entityId == null) {
            return false;
        }
        String entityNamespace = entityId.m_135827_();
        for (String entry : whitelist) {
            if (entry.startsWith("#")) {
                String tagName = entry.substring(1);
                try {
                    ResourceLocation tagLocation = new ResourceLocation(tagName);
                    TagKey tagKey = TagKey.m_203882_((ResourceKey)ForgeRegistries.ENTITY_TYPES.getRegistryKey(), (ResourceLocation)tagLocation);
                    if (!mob.m_6095_().m_204039_(tagKey)) continue;
                    return true;
                }
                catch (Exception e) {
                    Cryofloric_arts.LOGGER.warn("\u767d\u8272\u8352\u539f\u767d\u540d\u5355\u6807\u7b7e\u683c\u5f0f\u65e0\u6548: {}", (Object)tagName);
                    continue;
                }
            }
            if (!(entry.contains(":") ? entry.equals(entityId.toString()) : entry.equals(entityNamespace))) continue;
            return true;
        }
        return false;
    }
}

