/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.item.item;

import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cryofloric_arts.hao111111111.client.gui.SoulHateBookScreen;
import org.cryofloric_arts.hao111111111.world.storage.InfectionResistanceData;
import org.jetbrains.annotations.NotNull;

public class SoulHateBook
extends Item {
    public SoulHateBook(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (level.f_46443_) {
            this.openGui(stack);
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                InfectionResistanceData data = InfectionResistanceData.get(serverLevel);
                Map<String, Integer> idCounts = data.getIdCounts();
                ArrayList<CompoundTag> pages = new ArrayList<CompoundTag>();
                for (Map.Entry<String, Integer> entry : idCounts.entrySet()) {
                    CompoundTag pageTag = new CompoundTag();
                    pageTag.m_128359_("id", entry.getKey());
                    pageTag.m_128405_("count", entry.getValue().intValue());
                    pages.add(pageTag);
                }
                CompoundTag nbt = stack.m_41784_();
                CompoundTag pagesTag = new CompoundTag();
                for (int i = 0; i < pages.size(); ++i) {
                    pagesTag.m_128365_("page_" + i, (Tag)pages.get(i));
                }
                nbt.m_128365_("pages", (Tag)pagesTag);
                nbt.m_128405_("totalPages", pages.size());
                nbt.m_128405_("currentPage", 0);
                nbt.m_128405_("threshold", InfectionResistanceData.INFECTION_THRESHOLD);
                stack.m_41751_(nbt);
                serverPlayer.m_213846_((Component)Component.m_237115_((String)"message.cryofloric_arts.soul_hate_book_updated"));
                return InteractionResultHolder.m_19090_((Object)stack);
            }
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openGui(ItemStack stack) {
        Minecraft.m_91087_().m_91152_((Screen)new SoulHateBookScreen(stack));
    }

    public static void changePage(ItemStack stack, int newPage) {
        CompoundTag nbt = stack.m_41784_();
        int totalPages = nbt.m_128451_("totalPages");
        if (newPage >= 0 && newPage < totalPages) {
            nbt.m_128405_("currentPage", newPage);
            stack.m_41751_(nbt);
        }
    }

    public static CompoundTag getPageData(ItemStack stack, int page) {
        String pageKey;
        CompoundTag pagesTag;
        CompoundTag nbt = stack.m_41784_();
        if (nbt.m_128441_("pages") && (pagesTag = nbt.m_128469_("pages")).m_128441_(pageKey = "page_" + page)) {
            return pagesTag.m_128469_(pageKey);
        }
        return new CompoundTag();
    }

    public static int getTotalPages(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        return nbt.m_128451_("totalPages");
    }

    public static int getCurrentPage(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        return nbt.m_128451_("currentPage");
    }
}

