/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.cryofloric_arts.hao111111111.blocks.AquaticFrigidGrass;
import org.cryofloric_arts.hao111111111.blocks.BlightSorrowLog;
import org.cryofloric_arts.hao111111111.blocks.ModBlock;
import org.cryofloric_arts.hao111111111.blocks.PatternedAnvilBlock;
import org.cryofloric_arts.hao111111111.blocks.TransmutationFurnaceBlock;
import org.cryofloric_arts.hao111111111.world.storage.PollenData;

public class PlantSpreader {
    public static final TagKey<Block> CAN_NOT_BEPOWDER = BlockTags.create((ResourceLocation)new ResourceLocation("cryofloric_arts", "can_not_bepowder"));
    public static final TagKey<Block> LEAVES = BlockTags.create((ResourceLocation)new ResourceLocation("minecraft", "leaves"));
    public static final TagKey<Block> SHORT_FLOWERS = BlockTags.create((ResourceLocation)new ResourceLocation("minecraft", "small_flowers"));
    public static final TagKey<Block> LOGS = BlockTags.create((ResourceLocation)new ResourceLocation("minecraft", "logs"));
    public static final TagKey<Block> PLANKS = BlockTags.create((ResourceLocation)new ResourceLocation("minecraft", "planks"));
    public static final TagKey<Block> DIRT = BlockTags.create((ResourceLocation)new ResourceLocation("cryofloric_arts", "dirt_snow"));
    public static final TagKey<Block> STONE = BlockTags.create((ResourceLocation)new ResourceLocation("cryofloric_arts", "stone_snow"));
    public static final TagKey<Block> ORES = BlockTags.create((ResourceLocation)new ResourceLocation("forge", "ores"));
    public static final TagKey<Block> STORAGE = BlockTags.create((ResourceLocation)new ResourceLocation("forge", "storage_blocks"));
    public static final TagKey<Block> ANVIL = BlockTags.create((ResourceLocation)new ResourceLocation("minecraft", "anvil"));
    public static final TagKey<Block> SAPLINGS = BlockTags.create((ResourceLocation)new ResourceLocation("minecraft", "saplings"));
    public static final TagKey<Block> ENCHANTMENT = BlockTags.create((ResourceLocation)new ResourceLocation("minecraft", "enchantment_power_provider"));
    private static final TagKey<Block> FURNACES = BlockTags.create((ResourceLocation)new ResourceLocation("forge", "furnaces"));

    public static void trySpawnIcePetalBloom(ServerLevel level, BlockPos pos, RandomSource random) {
        boolean lowLight = level.m_46803_(pos) < 3;
        Block targetBlock = lowLight ? (Block)ModBlock.SNOWFALL_TARO_BLOCK.get() : (Block)ModBlock.ICE_PETAL_DRYAD_BLOOM.get();
        BlockState targetState = targetBlock.m_49966_();
        int count = 5;
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-4, -1, -4), (BlockPos)pos.m_7918_(4, 1, 4))) {
            if (!level.m_8055_(blockpos).m_60713_(targetBlock) || --count > 0) continue;
            return;
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int attempt = 0; attempt < 4; ++attempt) {
            mutablePos.m_122178_(pos.m_123341_() + random.m_188503_(3) - 1, pos.m_123342_() + random.m_188503_(2) - random.m_188503_(2), pos.m_123343_() + random.m_188503_(3) - 1);
            if (!level.m_46859_((BlockPos)mutablePos) && !level.m_6425_((BlockPos)mutablePos).m_192917_((Fluid)Fluids.f_76193_)) continue;
            BlockState actualState = targetState;
            if (level.m_6425_((BlockPos)mutablePos).m_192917_((Fluid)Fluids.f_76193_) && targetBlock == ModBlock.ICE_PETAL_DRYAD_BLOOM.get()) {
                actualState = (BlockState)((Block)ModBlock.AQUATIC_FRIGID_GRASS.get()).m_49966_().m_61124_((Property)AquaticFrigidGrass.WATERLOGGED, (Comparable)Boolean.valueOf(true));
            }
            if (!actualState.m_60710_((LevelReader)level, (BlockPos)mutablePos)) continue;
            level.m_7731_((BlockPos)mutablePos, actualState, 2);
            PlantSpreader.updatePollenData(level, (BlockPos)mutablePos);
            return;
        }
    }

    private static void updatePollenData(ServerLevel level, BlockPos pos) {
        PollenData data = PollenData.get(level);
        if (data != null) {
            ChunkPos chunkPos = new ChunkPos(pos);
            data.addPollen(level, chunkPos, 1);
        }
    }

    public static boolean convertBlock(ServerLevel level, BlockPos pos) {
        BlockState currentState = level.m_8055_(pos);
        PollenData pollenData = PollenData.get(level);
        ChunkPos chunkPos = new ChunkPos(pos);
        boolean converted = false;
        if (currentState.m_204336_(CAN_NOT_BEPOWDER)) {
            return false;
        }
        if (currentState.m_204336_(LOGS)) {
            Direction.Axis axis = Direction.Axis.Y;
            if (currentState.m_61138_((Property)BlockStateProperties.f_61365_)) {
                axis = (Direction.Axis)currentState.m_61143_((Property)BlockStateProperties.f_61365_);
            }
            BlockState newState = (BlockState)((Block)ModBlock.BLIGHT_SORROW_LOG.get()).m_49966_().m_61124_(BlightSorrowLog.AXIS, (Comparable)axis);
            level.m_46597_(pos, newState);
            converted = true;
        } else if (currentState.m_204336_(PLANKS)) {
            level.m_46597_(pos, ((Block)ModBlock.BLIGHT_SORROW_PLANKS.get()).m_49966_());
            converted = true;
        } else if (currentState.m_204336_(DIRT)) {
            level.m_46597_(pos, ((Block)ModBlock.FROSTED_DIRT.get()).m_49966_());
            converted = true;
        } else if (currentState.m_204336_(ORES)) {
            level.m_46597_(pos, ((Block)ModBlock.FROZEN_SECRET_ORE.get()).m_49966_());
            converted = true;
        } else if (currentState.m_204336_(STONE)) {
            level.m_46597_(pos, ((Block)ModBlock.FROSTED_STONE.get()).m_49966_());
            converted = true;
        } else if (currentState.m_204336_(LEAVES)) {
            level.m_46597_(pos, Blocks.f_50016_.m_49966_());
            converted = true;
        } else if (currentState.m_204336_(ENCHANTMENT)) {
            level.m_46597_(pos, ((Block)ModBlock.VANISHINGBOOKSHELF.get()).m_49966_());
            converted = true;
        } else if (currentState.m_204336_(STORAGE)) {
            level.m_46597_(pos, ((Block)ModBlock.FROZEN_SECRET_ORE_BLOCK.get()).m_49966_());
            pollenData.addPollen(level, chunkPos, 100);
            converted = true;
        } else if (currentState.m_204336_(ANVIL)) {
            level.m_46597_(pos, ((Block)ModBlock.PATTERNED_ANVIL.get()).m_49966_());
            Direction direction = currentState.m_61138_((Property)BlockStateProperties.f_61374_) ? (Direction)currentState.m_61143_((Property)BlockStateProperties.f_61374_) : Direction.NORTH;
            BlockState newState = (BlockState)((Block)ModBlock.PATTERNED_ANVIL.get()).m_49966_().m_61124_((Property)PatternedAnvilBlock.FACING, (Comparable)direction);
            level.m_46597_(pos, newState);
            converted = true;
            pollenData.addPollen(level, chunkPos, 100);
        } else if (currentState.m_60713_(Blocks.f_50091_)) {
            level.m_46597_(pos, ((Block)ModBlock.BLIGHT_SORROW_CRAFTING_TABLE.get()).m_49966_());
            Direction direction = currentState.m_61138_((Property)BlockStateProperties.f_61374_) ? (Direction)currentState.m_61143_((Property)BlockStateProperties.f_61374_) : Direction.NORTH;
            BlockState newState = (BlockState)((Block)ModBlock.BLIGHT_SORROW_CRAFTING_TABLE.get()).m_49966_().m_61124_((Property)PatternedAnvilBlock.FACING, (Comparable)direction);
            level.m_46597_(pos, newState);
            converted = true;
            pollenData.addPollen(level, chunkPos, 100);
        } else if (currentState.m_204336_(FURNACES)) {
            Direction direction = currentState.m_61138_((Property)BlockStateProperties.f_61374_) ? (Direction)currentState.m_61143_((Property)BlockStateProperties.f_61374_) : Direction.NORTH;
            boolean lit = false;
            if (currentState.m_61138_((Property)BlockStateProperties.f_61443_)) {
                lit = (Boolean)currentState.m_61143_((Property)BlockStateProperties.f_61443_);
            }
            BlockState newState = (BlockState)((BlockState)((Block)ModBlock.TRANSMUTATION_FURNACE.get()).m_49966_().m_61124_((Property)TransmutationFurnaceBlock.FACING, (Comparable)direction)).m_61124_((Property)TransmutationFurnaceBlock.LIT, (Comparable)Boolean.valueOf(lit));
            level.m_46597_(pos, newState);
            converted = true;
        } else if (currentState.m_280296_()) {
            level.m_46597_(pos, Blocks.f_152499_.m_49966_());
            converted = true;
        } else if (currentState.m_204336_(SHORT_FLOWERS)) {
            level.m_46597_(pos, ((Block)ModBlock.ICE_PETAL_DRYAD_BLOOM.get()).m_49966_());
            converted = true;
        } else if (currentState.m_204336_(SAPLINGS)) {
            level.m_46597_(pos, ((Block)ModBlock.BLIGHT_SORROW_SAPLING.get()).m_49966_());
            converted = true;
        } else if (currentState.m_60819_().m_192917_((Fluid)Fluids.f_76193_) || currentState.m_60819_().m_192917_((Fluid)Fluids.f_76192_)) {
            level.m_46597_(pos, Blocks.f_50354_.m_49966_());
            converted = true;
        } else if (currentState.m_60819_().m_192917_((Fluid)Fluids.f_76195_)) {
            level.m_46597_(pos, Blocks.f_50080_.m_49966_());
            converted = true;
        } else if (currentState.m_60819_().m_192917_((Fluid)Fluids.f_76194_)) {
            level.m_46597_(pos, ((Block)ModBlock.FROSTED_STONE.get()).m_49966_());
            converted = true;
        } else if (!currentState.m_280296_()) {
            level.m_46597_(pos, ((Block)ModBlock.TRANSFORMATION_SAC.get()).m_49966_());
            converted = true;
        }
        if (converted && level.f_46441_.m_188501_() < 0.25f) {
            PlantSpreader.trySpawnRootLuminance(level, pos, level.f_46441_);
        }
        if (converted && pollenData != null) {
            pollenData.addPollen(level, chunkPos, 10);
        }
        return converted;
    }

    private static void trySpawnRootLuminance(ServerLevel level, BlockPos pos, RandomSource random) {
        BlockPos checkPos;
        BlockPos blockPos = checkPos = random.m_188499_() ? pos.m_7494_() : pos.m_7495_();
        if (level.m_46859_(checkPos) && level.m_46803_(checkPos) < 9) {
            level.m_46597_(checkPos, ((Block)ModBlock.ROOT_LUMINANCE_BLOCK.get()).m_49966_());
            PollenData pollenData = PollenData.get(level);
            if (pollenData != null) {
                ChunkPos chunkPos = new ChunkPos(checkPos);
                pollenData.addPollen(level, chunkPos, 5);
            }
        }
    }

    public static boolean convertToCloudSubstance(ServerLevel level, BlockPos pos) {
        BlockState currentState = level.m_8055_(pos);
        if (currentState.m_204336_(CAN_NOT_BEPOWDER)) {
            return false;
        }
        if (currentState.m_280296_() && currentState.m_60804_((BlockGetter)level, pos)) {
            level.m_46597_(pos, ((Block)ModBlock.CLOUD_SUBSTANCE_BLOCK.get()).m_49966_());
            PollenData pollenData = PollenData.get(level);
            if (pollenData != null) {
                ChunkPos chunkPos = new ChunkPos(pos);
                pollenData.addPollen(level, chunkPos, 5);
            }
            return true;
        }
        return false;
    }
}

