#version 150

uniform sampler2D Sampler0;
uniform vec4 ColorModulator;

in vec2 texCoord0;
in vec4 vertexColor;

out vec4 fragColor;

void main() {
    // 采样原始纹理
    vec4 color = texture(Sampler0, texCoord0);

    // 如果原始纹理是透明的，则丢弃片段（这是我们的遮挡机制）
    if (color.a < 0.1) {
        discard;
    }

    // 应用霜冻效果 - 使用蓝色调
    vec3 frostColor = vec3(0.6, 0.8, 1.0);

    // 增强霜冻效果，使用更高的混合比例
    float frostIntensity = 0.6;
    color.rgb = mix(color.rgb, frostColor, frostIntensity);

    // 增加一些光泽效果
    float shine = pow(max(0.0, 1.0 - length(texCoord0 - 0.5) * 2.0), 2.0);
    color.rgb += vec3(0.2, 0.3, 0.4) * shine * 0.5;

    // 应用顶点颜色和颜色调制器
    fragColor = color * vertexColor * ColorModulator;

    // 确保最终颜色有足够的透明度
    fragColor.a = color.a;
}