/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.cryofloric_arts.hao111111111.blockentity.ModBlockEntities;
import org.cryofloric_arts.hao111111111.blocks.DustAbsorberBlock;
import org.cryofloric_arts.hao111111111.inventory.DustAbsorberMenu;
import org.cryofloric_arts.hao111111111.item.ModItem;
import org.cryofloric_arts.hao111111111.world.storage.PollenData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DustAbsorberBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(18){

        protected void onContentsChanged(int slot) {
            DustAbsorberBlockEntity.this.m_6596_();
            DustAbsorberBlockEntity.this.updateTotalDust();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return stack.m_41720_() == ModItem.FROST_DUST.get();
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack stack = this.getStackInSlot(slot);
            if (stack.m_41619_() || stack.m_41720_() != ModItem.FROST_DUST.get()) {
                return ItemStack.f_41583_;
            }
            int extracted = Math.min(amount, stack.m_41613_());
            ItemStack result = stack.m_41777_();
            result.m_41764_(extracted);
            if (!simulate) {
                stack.m_41774_(extracted);
                if (stack.m_41619_()) {
                    this.setStackInSlot(slot, ItemStack.f_41583_);
                }
                this.onContentsChanged(slot);
            }
            return result;
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private final SimpleContainerData data = new SimpleContainerData(2);

    public DustAbsorberBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.DUST_ABSORBER.get(), pos, state);
        this.data.m_8050_(0, 0);
        this.data.m_8050_(1, 0);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.cryofloric_arts.dust_absorber");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
        return new DustAbsorberMenu(containerId, playerInventory, this, (ContainerData)this.data);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side != null) {
                return LazyOptional.empty();
            }
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(CompoundTag tag) {
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("totalDust", this.data.m_6413_(0));
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
        this.data.m_8050_(0, tag.m_128451_("totalDust"));
        this.updateBlockState();
    }

    public void absorbPollen() {
        ChunkPos chunkPos;
        ServerLevel serverLevel;
        PollenData pollenData;
        int currentPollen;
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        BlockState state = this.m_58900_();
        if (((Boolean)state.m_61143_((Property)DustAbsorberBlock.DAMAGED)).booleanValue()) {
            return;
        }
        if (this.hasBlocksAround()) {
            return;
        }
        Level level = this.f_58857_;
        if (level instanceof ServerLevel && (currentPollen = (pollenData = PollenData.get(serverLevel = (ServerLevel)level)).getPollenValue(chunkPos = new ChunkPos(this.f_58858_))) > 0) {
            int pollenToAbsorb = currentPollen / 100;
            int availableSpace = this.calculateAvailableSpace();
            if (availableSpace <= 0) {
                this.setDamaged(true);
                return;
            }
            int actualAbsorb = Math.min(pollenToAbsorb, availableSpace);
            pollenData.removePollen(chunkPos, actualAbsorb);
            this.addFrostDust(actualAbsorb);
            if (this.calculateAvailableSpace() == 0) {
                this.setDamaged(true);
            }
        }
    }

    private boolean hasBlocksAround() {
        if (this.f_58857_ == null) {
            return false;
        }
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = 0; y <= 3; ++y) {
                    BlockPos checkPos = this.f_58858_.m_7918_(x, y, z);
                    if (checkPos.equals((Object)this.f_58858_) || this.f_58857_.m_46859_(checkPos)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private int calculateAvailableSpace() {
        int totalSpace = 1152;
        int currentTotal = this.getTotalDust();
        return totalSpace - currentTotal;
    }

    private void addFrostDust(int amount) {
        int remaining = amount;
        for (int i = 0; i < this.itemHandler.getSlots() && remaining > 0; ++i) {
            int toAdd;
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.m_41619_() || stack.m_41720_() != ModItem.FROST_DUST.get()) {
                toAdd = Math.min(remaining, 64);
                this.itemHandler.setStackInSlot(i, new ItemStack((ItemLike)ModItem.FROST_DUST.get(), toAdd));
                remaining -= toAdd;
                continue;
            }
            toAdd = Math.min(remaining, 64 - stack.m_41613_());
            stack.m_41769_(toAdd);
            remaining -= toAdd;
        }
        this.updateTotalDust();
    }

    private void updateTotalDust() {
        int total = 0;
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.m_41720_() != ModItem.FROST_DUST.get()) continue;
            total += stack.m_41613_();
        }
        this.data.m_8050_(0, total);
        this.m_6596_();
    }

    public int getTotalDust() {
        return this.data.m_6413_(0);
    }

    private void setDamaged(boolean damaged) {
        BlockState state;
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && (Boolean)(state = this.m_58900_()).m_61143_((Property)DustAbsorberBlock.DAMAGED) != damaged) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)DustAbsorberBlock.DAMAGED, (Comparable)Boolean.valueOf(damaged)), 3);
            this.data.m_8050_(1, damaged ? 1 : 0);
        }
    }

    private void updateBlockState() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            boolean isDamaged = (Boolean)this.m_58900_().m_61143_((Property)DustAbsorberBlock.DAMAGED);
            this.data.m_8050_(1, isDamaged ? 1 : 0);
        }
    }

    public void dropAllDust(Level level, BlockPos pos) {
        int i;
        for (i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack);
        }
        for (i = 0; i < this.itemHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, ItemStack.f_41583_);
        }
        this.updateTotalDust();
    }

    public int getRedstoneSignal() {
        int totalDust = this.getTotalDust();
        int maxCapacity = 1152;
        return (int)(15.0f * ((float)totalDust / (float)maxCapacity));
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }
}

