/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.cryofloric_arts.hao111111111.blocks.ModBlock;
import org.cryofloric_arts.hao111111111.effect.ModEffects;
import org.jetbrains.annotations.NotNull;

public class CoagulatedMassBlock
extends Block {
    public static final EnumProperty<HyperplasiaType> HYPERPLASIA_TYPE = EnumProperty.m_61587_((String)"hyperplasia_type", HyperplasiaType.class);
    public static final IntegerProperty HYPERPLASIA_VALUE = IntegerProperty.m_61631_((String)"hyperplasia_value", (int)0, (int)100);

    public CoagulatedMassBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(HYPERPLASIA_TYPE, (Comparable)((Object)HyperplasiaType.NONE))).m_61124_((Property)HYPERPLASIA_VALUE, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HYPERPLASIA_TYPE, HYPERPLASIA_VALUE});
    }

    private float getCoagulatedValue(int hyperplasiaValue) {
        if (hyperplasiaValue <= 0) {
            return 0.0f;
        }
        return (float)hyperplasiaValue / (float)(hyperplasiaValue + 500) * 100.0f;
    }

    public float m_5880_(BlockState state, @NotNull Player player, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        HyperplasiaType type = (HyperplasiaType)((Object)state.m_61143_(HYPERPLASIA_TYPE));
        int value = (Integer)state.m_61143_((Property)HYPERPLASIA_VALUE);
        float baseProgress = super.m_5880_(state, player, level, pos);
        float coagulatedValue = this.getCoagulatedValue(value);
        if (type == HyperplasiaType.EXPAND && value > 0) {
            float adjustFactor = 1.0f + 5.0f * (coagulatedValue / 100.0f);
            return baseProgress / adjustFactor;
        }
        return baseProgress;
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        HyperplasiaType type = (HyperplasiaType)((Object)state.m_61143_(HYPERPLASIA_TYPE));
        int value = (Integer)state.m_61143_((Property)HYPERPLASIA_VALUE);
        float baseResistance = 6.0f;
        float coagulatedValue = this.getCoagulatedValue(value);
        if (type == HyperplasiaType.DEPOSIT && value > 0) {
            return baseResistance + 50.0f * coagulatedValue;
        }
        return baseResistance;
    }

    private static boolean canReplaceBlock(BlockState state, Level level, BlockPos pos) {
        return true;
    }

    public void m_6810_(BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            this.handleCrystalDamage(state, level, pos);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    private void handleCrystalDamage(BlockState state, Level level, BlockPos pos) {
        float coagulatedValue;
        float damage;
        HyperplasiaType type = (HyperplasiaType)((Object)state.m_61143_(HYPERPLASIA_TYPE));
        int value = (Integer)state.m_61143_((Property)HYPERPLASIA_VALUE);
        if (type == HyperplasiaType.CRYSTAL && value > 0 && !level.f_46443_ && (damage = 0.5f * (coagulatedValue = this.getCoagulatedValue(value))) > 0.0f) {
            AABB damageArea = new AABB(pos).m_82400_(3.0);
            List entities = level.m_45976_(LivingEntity.class, damageArea);
            for (LivingEntity entity : entities) {
                entity.m_6469_(level.m_269111_().m_269109_(), damage);
                entity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.FROST_POWDER.get(), 200, 0));
            }
        }
    }

    public static void spawnFromTaro(Level level, BlockPos taroPos, @Nullable String hyperplasiaType, int hyperplasiaValue) {
        Direction[] directions;
        if (level.m_5776_()) {
            return;
        }
        int limitedValue = Math.min(Math.max(hyperplasiaValue, 0), 100);
        for (Direction direction : directions = new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST}) {
            BlockPos massPos = taroPos.m_121945_(direction);
            BlockState existingState = level.m_8055_(massPos);
            if (!level.m_46859_(massPos) && !CoagulatedMassBlock.canReplaceBlock(existingState, level, massPos) || existingState.m_60734_() instanceof CoagulatedMassBlock) continue;
            BlockState massState = ((Block)ModBlock.COAGULATED_MASS_BLOCK.get()).m_49966_();
            HyperplasiaType type = HyperplasiaType.NONE;
            if (hyperplasiaType != null) {
                type = switch (hyperplasiaType) {
                    case "expand" -> HyperplasiaType.EXPAND;
                    case "deposit" -> HyperplasiaType.DEPOSIT;
                    case "crystal" -> HyperplasiaType.CRYSTAL;
                    default -> type;
                };
            }
            massState = (BlockState)((BlockState)massState.m_61124_(HYPERPLASIA_TYPE, (Comparable)((Object)type))).m_61124_((Property)HYPERPLASIA_VALUE, (Comparable)Integer.valueOf(limitedValue));
            level.m_7731_(massPos, massState, 3);
        }
    }

    public static void removeNearbyCoagulatedMass(Level level, BlockPos centerPos) {
        if (level.m_5776_()) {
            return;
        }
        for (Direction direction : Direction.values()) {
            BlockPos checkPos = centerPos.m_121945_(direction);
            if (!(level.m_8055_(checkPos).m_60734_() instanceof CoagulatedMassBlock)) continue;
            level.m_7471_(checkPos, false);
        }
    }

    public static boolean hasCoagulatedMassNearby(Level level, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockPos checkPos = pos.m_121945_(direction);
            if (!(level.m_8055_(checkPos).m_60734_() instanceof CoagulatedMassBlock)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasCoagulatedMassInDirection(Level level, BlockPos pos, Direction direction) {
        BlockPos checkPos = pos.m_121945_(direction);
        return level.m_8055_(checkPos).m_60734_() instanceof CoagulatedMassBlock;
    }

    public static enum HyperplasiaType implements StringRepresentable
    {
        NONE("none"),
        EXPAND("expand"),
        DEPOSIT("deposit"),
        CRYSTAL("crystal");

        private final String name;

        private HyperplasiaType(String name) {
            this.name = name;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

