/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.entity.custom;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TurtleEggBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.cryofloric_arts.hao111111111.attributes.ModAttributes;
import org.cryofloric_arts.hao111111111.blocks.ModBlock;
import org.cryofloric_arts.hao111111111.effect.ModEffects;
import org.cryofloric_arts.hao111111111.entity.custom.SnowfallTaroCreature;
import org.cryofloric_arts.hao111111111.item.ModItem;
import org.cryofloric_arts.hao111111111.world.storage.PollenData;
import org.jetbrains.annotations.Nullable;

public class FrostBee
extends SnowfallTaroCreature
implements FlyingAnimal {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(FrostBee.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final int FLAG_ROLL = 2;
    private static final int FLAG_HAS_STUNG = 4;
    public static final TagKey<Item> DUST = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("cryofloric_arts", "can_be_frost_dust"));

    public FrostBee(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level, 1, 9);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.f_21365_ = new FrostBeeLookControl((Mob)this);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 16.0f);
        this.m_21441_(BlockPathTypes.COCOA, -1.0f);
        this.m_21441_(BlockPathTypes.FENCE, -1.0f);
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource source) {
        return false;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    public void m_146924_(boolean isInPowderSnow) {
    }

    public boolean m_203117_() {
        return false;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FrostBeeAttackGoal((PathfinderMob)this, 1.4, true));
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new FrostBeeWanderGoal());
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, false, this::isValidTarget));
    }

    private boolean isValidTarget(LivingEntity entity) {
        return entity.m_21223_() <= 20.0f && entity instanceof Monster && entity != this;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22280_, 2.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_((Attribute)ModAttributes.MAX_DAMAGE_RATE.get(), 0.5);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.m_20096_() && this.f_19796_.m_188503_(10000) == 0) {
            this.tryLayEgg();
        }
    }

    private void tryLayEgg() {
        BlockPos eggPos;
        ChunkPos chunkPos;
        ServerLevel serverLevel = (ServerLevel)this.m_9236_();
        PollenData pollenData = PollenData.get(serverLevel);
        int pollenValue = pollenData.getPollenValue(chunkPos = new ChunkPos(this.m_20183_()));
        if (pollenValue < 1000) {
            return;
        }
        AABB area = new AABB(this.m_20183_()).m_82400_(64.0);
        List bees = this.m_9236_().m_45976_(FrostBee.class, area);
        int eggCount = 0;
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)this.m_20183_().m_7918_(-16, -16, -16), (BlockPos)this.m_20183_().m_7918_(16, 16, 16))) {
            if (this.m_9236_().m_8055_(pos).m_60734_() != ModBlock.FROST_BEE_EGG.get() || ++eggCount < 2) continue;
            return;
        }
        if (bees.size() < 5 && (eggPos = this.findSuitableEggPosition()) != null) {
            int eggCountToLay = this.f_19796_.m_188503_(4) + 1;
            BlockState eggState = (BlockState)((Block)ModBlock.FROST_BEE_EGG.get()).m_49966_().m_61124_((Property)TurtleEggBlock.f_57754_, (Comparable)Integer.valueOf(eggCountToLay));
            this.m_9236_().m_7731_(eggPos, eggState, 3);
            this.m_5496_(SoundEvents.f_12486_, 1.0f, 0.8f + this.f_19796_.m_188501_() * 0.2f);
        }
    }

    private BlockPos findSuitableEggPosition() {
        BlockPos currentPos = this.m_20183_();
        if (this.m_9236_().m_46859_(currentPos)) {
            return currentPos;
        }
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (x == 0 && z == 0) continue;
                BlockPos checkPos = currentPos.m_7918_(x, 0, z);
                if (!this.m_9236_().m_46859_(checkPos)) continue;
                return checkPos;
            }
        }
        return null;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (player.m_21023_((MobEffect)ModEffects.OVER_ROOTING.get())) {
            if (itemstack.m_204117_(DUST)) {
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                for (int i = 0; i < 10; ++i) {
                    if (!(this.f_19796_.m_188501_() < 0.8f)) continue;
                    this.m_19998_((ItemLike)ModItem.FROST_DUST.get());
                }
                this.m_5496_(SoundEvents.f_12019_, 1.0f, 1.0f);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (itemstack.m_41720_() == ModItem.BLIGHT_SORROW_HANDLE.get()) {
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                if (this.f_19796_.m_188501_() < 0.3f) {
                    this.m_19998_((ItemLike)ModItem.BLIGHT_SORROW_SAPLING.get());
                }
                this.m_5496_(SoundEvents.f_12019_, 1.0f, 1.0f);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_6898_(ItemStack stack) {
        return false;
    }

    public boolean m_7327_(Entity target) {
        boolean attacked = super.m_7327_(target);
        if (attacked && target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            livingTarget.m_7292_(new MobEffectInstance((MobEffect)ModEffects.FROSTED.get(), 100, 3));
            livingTarget.m_7292_(new MobEffectInstance((MobEffect)ModEffects.FROST_POWDER.get(), 200, 0));
            this.setHasStung(true);
            this.m_5496_(SoundEvents.f_11692_, 1.0f, 1.0f);
        }
        return attacked;
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        if (!this.m_9236_().f_46443_) {
            AreaEffectCloud cloud = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
            cloud.m_19712_(2.0f);
            cloud.m_19732_(-0.5f);
            cloud.m_19740_(10);
            cloud.m_19734_(100);
            cloud.m_19738_(-cloud.m_19743_() / (float)cloud.m_19748_());
            cloud.m_19716_(new MobEffectInstance((MobEffect)ModEffects.FROSTED.get(), 100, 9));
            cloud.m_19716_(new MobEffectInstance((MobEffect)ModEffects.FROST_POWDER.get(), 200, 0));
            cloud.m_19724_((ParticleOptions)ParticleTypes.f_175821_);
            this.m_9236_().m_7967_((Entity)cloud);
        }
    }

    protected PathNavigation m_6037_(Level level) {
        FlyingPathNavigation navigation = new FlyingPathNavigation((Mob)this, level){

            public boolean m_6342_(BlockPos pos) {
                return !this.f_26495_.m_8055_(pos.m_7495_()).m_60795_();
            }
        };
        navigation.m_26440_(false);
        navigation.m_7008_(false);
        navigation.m_26443_(true);
        return navigation;
    }

    public boolean m_29443_() {
        return !this.m_20096_();
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    private void setFlag(int flag, boolean value) {
        byte current = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        if (value) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(current | flag)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(current & ~flag)));
        }
    }

    private boolean getFlag(int flag) {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & flag) != 0;
    }

    public boolean hasStung() {
        return this.getFlag(4);
    }

    public void setHasStung(boolean hasStung) {
        this.setFlag(4, hasStung);
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_11741_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11740_;
    }

    class FrostBeeLookControl
    extends LookControl {
        public FrostBeeLookControl(Mob mob) {
            super(mob);
        }
    }

    class FrostBeeAttackGoal
    extends MeleeAttackGoal {
        public FrostBeeAttackGoal(PathfinderMob mob, double speed, boolean longMemory) {
            super(mob, speed, longMemory);
        }

        public boolean m_8036_() {
            return super.m_8036_() && FrostBee.this.m_5448_() != null;
        }
    }

    class FrostBeeWanderGoal
    extends Goal {
        FrostBeeWanderGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return FrostBee.this.f_21344_.m_26571_() && FrostBee.this.f_19796_.m_188503_(10) == 0;
        }

        public boolean m_8045_() {
            return FrostBee.this.f_21344_.m_26572_();
        }

        public void m_8056_() {
            Vec3 vec3 = this.findPos();
            if (vec3 != null) {
                FrostBee.this.f_21344_.m_26536_(FrostBee.this.f_21344_.m_7864_(BlockPos.m_274446_((Position)vec3), 1), 1.0);
            }
        }

        @Nullable
        private Vec3 findPos() {
            Vec3 viewVector = FrostBee.this.m_20252_(0.0f);
            Vec3 hoverPos = HoverRandomPos.m_148465_((PathfinderMob)FrostBee.this, (int)8, (int)4, (double)viewVector.f_82479_, (double)viewVector.f_82481_, (float)1.5707964f, (int)3, (int)1);
            if (hoverPos != null) {
                return hoverPos;
            }
            return AirRandomPos.m_148387_((PathfinderMob)FrostBee.this, (int)8, (int)4, (int)-2, (Vec3)viewVector, (double)1.5707963705062866);
        }
    }
}

