/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.item.item;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.cryofloric_arts.hao111111111.item.ModItem;
import org.jetbrains.annotations.NotNull;

public class CorrosiveShieldItem
extends ShieldItem {
    private static final float EFFECT_CHANCE = 0.15f;
    private static final float DURABILITY_COST_MULTIPLIER = 0.15f;
    private static final float MAX_DAMAGE_PERCENT_PER_HIT = 0.05f;

    public CorrosiveShieldItem(Item.Properties properties) {
        super(properties.m_41503_(168));
    }

    public boolean m_6832_(@NotNull ItemStack stack, ItemStack repairCandidate) {
        return repairCandidate.m_41720_() == ModItem.BLIGHT_SORROW_PLANKS.get();
    }

    static {
        MinecraftForge.EVENT_BUS.register(EventHandler.class);
    }

    public static class EventHandler {
        @SubscribeEvent
        public static void onLivingHurt(LivingHurtEvent event) {
            LivingEntity entity = event.getEntity();
            if (entity.m_21254_() && entity.m_21211_().m_41720_() instanceof CorrosiveShieldItem) {
                ItemStack shield = entity.m_21211_();
                float blockedDamage = event.getAmount() * 0.67f;
                int maxDamagePerHit = (int)((float)shield.m_41776_() * 0.05f);
                int actualDamage = Math.min((int)blockedDamage, maxDamagePerHit);
                shield.m_41622_(actualDamage, entity, e -> e.m_21190_(e.m_7655_()));
                if (entity.m_217043_().m_188501_() < 0.15f) {
                    EventHandler.triggerCorrosiveEffect(entity, event.getSource(), blockedDamage);
                    int extraDurabilityCost = (int)(blockedDamage * 0.15f);
                    extraDurabilityCost = Math.min(extraDurabilityCost, maxDamagePerHit - actualDamage);
                    if (extraDurabilityCost > 0) {
                        shield.m_41622_(extraDurabilityCost, entity, e -> e.m_21190_(e.m_7655_()));
                    }
                }
            }
        }

        private static void triggerCorrosiveEffect(LivingEntity entity, DamageSource source, float damageAmount) {
            Level level = entity.m_9236_();
            if (!level.f_46443_) {
                AABB area = new AABB(entity.m_20185_() - 5.0, entity.m_20186_() - 2.0, entity.m_20189_() - 5.0, entity.m_20185_() + 5.0, entity.m_20186_() + 2.0, entity.m_20189_() + 5.0);
                List entities = level.m_6443_(LivingEntity.class, area, e -> e != entity && e.m_6084_());
                DamageSource corrosiveDamage = entity.m_269291_().m_269425_();
                if (source.m_7639_() != null) {
                    corrosiveDamage = entity.m_269291_().m_269104_((Entity)entity, source.m_7639_());
                }
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    for (int i = 0; i < 20; ++i) {
                        double x = entity.m_20185_() + (serverLevel.f_46441_.m_188500_() - 0.5) * 5.0;
                        double y = entity.m_20186_() + serverLevel.f_46441_.m_188500_() * 3.0;
                        double z = entity.m_20189_() + (serverLevel.f_46441_.m_188500_() - 0.5) * 5.0;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175821_, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                    serverLevel.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_144205_, SoundSource.NEUTRAL, 0.5f, 0.8f + serverLevel.f_46441_.m_188501_() * 0.2f);
                }
                for (LivingEntity target : entities) {
                    target.m_6469_(corrosiveDamage, damageAmount * 0.5f);
                    if (!(level instanceof ServerLevel)) continue;
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175821_, target.m_20185_(), target.m_20186_() + (double)target.m_20206_() * 0.5, target.m_20189_(), 5, 0.3, 0.3, 0.3, 0.0);
                }
            }
        }
    }
}

