/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.utils;

import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import org.cryofloric_arts.hao111111111.attributes.ModAttributes;
import org.cryofloric_arts.hao111111111.config.ModConfig;
import org.cryofloric_arts.hao111111111.effect.ModEffects;
import org.cryofloric_arts.hao111111111.utils.DamageSourceUtil;
import org.cryofloric_arts.hao111111111.world.storage.PollenData;

public class HyperplasiaSystem {
    private static final UUID HYPERPLASIA_UUID = UUID.fromString("1a1b1c1d-2e2f-3a3b-4c4d-5e5f6a6b7c7d");
    private static final UUID DAMAGE_LIMIT_UUID = UUID.fromString("2b2c2c2e-3f9a-4c4d-5d5e-6f6a7b7c8d8e");

    private static int getUnlockThreshold() {
        return (Integer)ModConfig.HYPERPLASIA_UNLOCK_THRESHOLD.get();
    }

    private static int getSpecialEffectThreshold() {
        return (Integer)ModConfig.HYPERPLASIA_SPECIAL_EFFECT_THRESHOLD.get();
    }

    private static int getPollenMultiplier() {
        return (Integer)ModConfig.HYPERPLASIA_POLLEN_MULTIPLIER.get();
    }

    private static double calculateDynamicFormula(int hyperplasiaValue) {
        if (hyperplasiaValue <= 0) {
            return 0.0;
        }
        return (double)(hyperplasiaValue - 499) / (double)(hyperplasiaValue + 500);
    }

    public static boolean checkAndUnlockSystem(LivingEntity entity, PollenData pollenData) {
        CompoundTag persistentData = entity.getPersistentData();
        if (persistentData.m_128471_("HyperplasiaUnlocked")) {
            return true;
        }
        int pollenValue = pollenData.getPollenValueAtWithExtra(entity.m_20183_(), entity);
        if (pollenValue >= HyperplasiaSystem.getUnlockThreshold()) {
            persistentData.m_128379_("HyperplasiaUnlocked", true);
            return true;
        }
        return false;
    }

    public static void addHyperplasiaValue(LivingEntity killer, PollenData pollenData) {
        int requiredPollen;
        if (!killer.m_21023_((MobEffect)ModEffects.OVER_ROOTING.get())) {
            return;
        }
        CompoundTag persistentData = killer.getPersistentData();
        if (!persistentData.m_128471_("HyperplasiaUnlocked")) {
            return;
        }
        int currentValue = persistentData.m_128451_("HyperplasiaValue");
        int pollenValue = pollenData.getPollenValueAtWithExtra(killer.m_20183_(), killer);
        if (pollenValue < (requiredPollen = (currentValue + 1) * HyperplasiaSystem.getPollenMultiplier())) {
            return;
        }
        int newValue = currentValue + 1;
        persistentData.m_128405_("HyperplasiaValue", newValue);
        if (currentValue == 0 && !persistentData.m_128441_("HyperplasiaType")) {
            HyperplasiaSystem.assignRandomHyperplasiaType(killer);
        }
        HyperplasiaSystem.updateAttributeModifiers(killer);
        int specialEffectThreshold = HyperplasiaSystem.getSpecialEffectThreshold();
        if (newValue >= specialEffectThreshold) {
            HyperplasiaSystem.updateSpecialEffects(killer);
        }
    }

    private static void assignRandomHyperplasiaType(LivingEntity entity) {
        CompoundTag persistentData = entity.getPersistentData();
        double random = Math.random();
        if (random < 0.333) {
            persistentData.m_128359_("HyperplasiaType", "expand");
        } else if (random < 0.666) {
            persistentData.m_128359_("HyperplasiaType", "deposit");
        } else {
            persistentData.m_128359_("HyperplasiaType", "crystal");
        }
    }

    public static void updateAttributeModifiers(LivingEntity entity) {
        CompoundTag persistentData = entity.getPersistentData();
        if (!persistentData.m_128441_("HyperplasiaType")) {
            return;
        }
        int hyperplasiaValue = persistentData.m_128451_("HyperplasiaValue");
        String hyperplasiaType = persistentData.m_128461_("HyperplasiaType");
        HyperplasiaSystem.removeAllHyperplasiaModifiers(entity);
        switch (hyperplasiaType) {
            case "expand": {
                HyperplasiaSystem.applyExpandModifiers(entity, hyperplasiaValue);
                break;
            }
            case "deposit": {
                HyperplasiaSystem.applyDepositModifiers(entity, hyperplasiaValue);
                break;
            }
            case "crystal": {
                HyperplasiaSystem.applyCrystalModifiers(entity, hyperplasiaValue);
            }
        }
    }

    private static void removeAllHyperplasiaModifiers(LivingEntity entity) {
        AttributeInstance maxHealthAttr = entity.m_21051_(Attributes.f_22276_);
        AttributeInstance armorAttr = entity.m_21051_(Attributes.f_22284_);
        AttributeInstance armorToughnessAttr = entity.m_21051_(Attributes.f_22285_);
        AttributeInstance attackDamageAttr = entity.m_21051_(Attributes.f_22281_);
        AttributeInstance maxDamageRateAttr = entity.m_21051_((Attribute)ModAttributes.MAX_DAMAGE_RATE.get());
        if (maxHealthAttr != null) {
            maxHealthAttr.m_22120_(HYPERPLASIA_UUID);
        }
        if (armorAttr != null) {
            armorAttr.m_22120_(HYPERPLASIA_UUID);
        }
        if (armorToughnessAttr != null) {
            armorToughnessAttr.m_22120_(HYPERPLASIA_UUID);
        }
        if (attackDamageAttr != null) {
            attackDamageAttr.m_22120_(HYPERPLASIA_UUID);
        }
        if (maxDamageRateAttr != null) {
            maxDamageRateAttr.m_22120_(DAMAGE_LIMIT_UUID);
        }
    }

    private static void applyExpandModifiers(LivingEntity entity, int hyperplasiaValue) {
        double multiplier = (1.0 + (double)hyperplasiaValue) / (500.0 + (double)hyperplasiaValue) * 5.0;
        AttributeInstance maxHealthAttr = entity.m_21051_(Attributes.f_22276_);
        if (maxHealthAttr != null) {
            AttributeModifier modifier = new AttributeModifier(HYPERPLASIA_UUID, "hyperplasia_expand", multiplier, AttributeModifier.Operation.MULTIPLY_BASE);
            maxHealthAttr.m_22125_(modifier);
        }
    }

    private static void applyDepositModifiers(LivingEntity entity, int hyperplasiaValue) {
        AttributeModifier modifier;
        double armorBonus = (1.0 + (double)hyperplasiaValue) / (500.0 + (double)hyperplasiaValue) * 100.0;
        double toughnessBonus = (1.0 + (double)hyperplasiaValue) / (500.0 + (double)hyperplasiaValue) * 40.0;
        AttributeInstance armorAttr = entity.m_21051_(Attributes.f_22284_);
        AttributeInstance toughnessAttr = entity.m_21051_(Attributes.f_22285_);
        if (armorAttr != null) {
            modifier = new AttributeModifier(HYPERPLASIA_UUID, "hyperplasia_deposit_armor", armorBonus, AttributeModifier.Operation.ADDITION);
            armorAttr.m_22125_(modifier);
        }
        if (toughnessAttr != null) {
            modifier = new AttributeModifier(HYPERPLASIA_UUID, "hyperplasia_deposit_toughness", toughnessBonus, AttributeModifier.Operation.ADDITION);
            toughnessAttr.m_22125_(modifier);
        }
    }

    private static void applyCrystalModifiers(LivingEntity entity, int hyperplasiaValue) {
        double multiplier = (1.0 + (double)hyperplasiaValue) / (500.0 + (double)hyperplasiaValue) * 5.0;
        AttributeInstance attackDamageAttr = entity.m_21051_(Attributes.f_22281_);
        if (attackDamageAttr != null) {
            AttributeModifier modifier = new AttributeModifier(HYPERPLASIA_UUID, "hyperplasia_crystal", multiplier, AttributeModifier.Operation.MULTIPLY_BASE);
            attackDamageAttr.m_22125_(modifier);
        }
    }

    private static void updateSpecialEffects(LivingEntity entity) {
        int specialEffectThreshold;
        CompoundTag persistentData = entity.getPersistentData();
        String hyperplasiaType = persistentData.m_128461_("HyperplasiaType");
        int hyperplasiaValue = persistentData.m_128451_("HyperplasiaValue");
        if (hyperplasiaValue < (specialEffectThreshold = HyperplasiaSystem.getSpecialEffectThreshold())) {
            return;
        }
        double dynamicValue = HyperplasiaSystem.calculateDynamicFormula(hyperplasiaValue);
        switch (hyperplasiaType) {
            case "expand": {
                int blessingLevel = (int)Math.round(dynamicValue * 3.0);
                if (blessingLevel < 0) {
                    blessingLevel = 0;
                }
                entity.m_21195_((MobEffect)ModEffects.FROZEN_EARTH_BLESSING.get());
                entity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.FROZEN_EARTH_BLESSING.get(), Integer.MAX_VALUE, blessingLevel, true, true, true));
                break;
            }
            case "deposit": {
                double damageLimit = dynamicValue * 0.5;
                AttributeInstance maxDamageRateAttr = entity.m_21051_((Attribute)ModAttributes.MAX_DAMAGE_RATE.get());
                if (maxDamageRateAttr == null) break;
                maxDamageRateAttr.m_22120_(DAMAGE_LIMIT_UUID);
                AttributeModifier modifier = new AttributeModifier(DAMAGE_LIMIT_UUID, "hyperplasia_deposit_damage_limit", -damageLimit, AttributeModifier.Operation.MULTIPLY_BASE);
                maxDamageRateAttr.m_22125_(modifier);
                break;
            }
            case "crystal": {
                double triggerProbability = dynamicValue * 0.5;
                if (triggerProbability < 0.0) {
                    triggerProbability = 0.0;
                }
                if (triggerProbability > 1.0) {
                    triggerProbability = 1.0;
                }
                persistentData.m_128347_("CrystalSoulDamageProbability", triggerProbability);
                persistentData.m_128347_("CrystalSoulDamageMultiplier", 2.0);
            }
        }
    }

    public static void applyCrystalSoulDamageBonus(LivingEntity attacker, LivingEntity victim, float originalDamage) {
        CompoundTag persistentData = attacker.getPersistentData();
        int specialEffectThreshold = HyperplasiaSystem.getSpecialEffectThreshold();
        if (persistentData.m_128441_("CrystalSoulDamageProbability") && persistentData.m_128461_("HyperplasiaType").equals("crystal") && persistentData.m_128451_("HyperplasiaValue") >= specialEffectThreshold) {
            float soulDamage;
            double triggerProbability = persistentData.m_128459_("CrystalSoulDamageProbability");
            double damageMultiplier = persistentData.m_128459_("CrystalSoulDamageMultiplier");
            if (Math.random() < triggerProbability && (soulDamage = originalDamage * (float)damageMultiplier) > 0.0f) {
                victim.m_6469_(DamageSourceUtil.getSoulCrushingDamage(attacker.m_9236_()), soulDamage);
                Level level = victim.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    double x = victim.m_20185_();
                    double y = victim.m_20186_() + (double)(victim.m_20206_() / 2.0f);
                    double z = victim.m_20189_();
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123746_, x, y, z, 15, (double)(victim.m_20205_() / 2.0f), (double)(victim.m_20206_() / 3.0f), (double)(victim.m_20205_() / 2.0f), 0.1);
                }
            }
        }
    }

    public static void onEntityLoad(LivingEntity entity) {
        CompoundTag persistentData = entity.getPersistentData();
        if (persistentData.m_128441_("HyperplasiaType") && persistentData.m_128451_("HyperplasiaValue") > 0) {
            HyperplasiaSystem.updateAttributeModifiers(entity);
            int specialEffectThreshold = HyperplasiaSystem.getSpecialEffectThreshold();
            if (persistentData.m_128451_("HyperplasiaValue") >= specialEffectThreshold) {
                HyperplasiaSystem.updateSpecialEffects(entity);
            }
        }
    }

    public static boolean canGrowHyperplasia(LivingEntity entity, PollenData pollenData) {
        int requiredPollen;
        CompoundTag persistentData = entity.getPersistentData();
        if (!persistentData.m_128471_("HyperplasiaUnlocked")) {
            return false;
        }
        int currentValue = persistentData.m_128451_("HyperplasiaValue");
        int pollenValue = pollenData.getPollenValueAt(entity.m_20183_());
        return pollenValue >= (requiredPollen = (currentValue + 1) * HyperplasiaSystem.getPollenMultiplier());
    }

    public static int getRequiredPollenForNextGrowth(LivingEntity entity) {
        CompoundTag persistentData = entity.getPersistentData();
        int currentValue = persistentData.m_128451_("HyperplasiaValue");
        return (currentValue + 1) * HyperplasiaSystem.getPollenMultiplier();
    }
}

