/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.blockentity;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.cryofloric_arts.hao111111111.blockentity.ModBlockEntities;
import org.cryofloric_arts.hao111111111.blocks.ModBlock;

public class BloatedSnowfallTaroTuberBlockEntity
extends BlockEntity {
    private static final String ENTITY_TAG_KEY = "StoredEntity";
    private static final String DROPS_TAG_KEY = "StoredDrops";
    private static final String BLOCK_ENTITY_TAG = "BlockEntityTag";
    @Nullable
    private CompoundTag entityTag;
    private List<ItemStack> storedDrops = new ArrayList<ItemStack>();

    public BloatedSnowfallTaroTuberBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.BLOATED_SNOWFALL_TARO_TUBER.get(), pos, state);
    }

    public void setEntityData(@Nullable CompoundTag entityTag) {
        this.entityTag = entityTag;
        this.m_6596_();
    }

    public void setStoredDrops(List<ItemStack> drops) {
        this.storedDrops = new ArrayList<ItemStack>(drops);
        this.m_6596_();
    }

    public List<ItemStack> getStoredDrops() {
        return new ArrayList<ItemStack>(this.storedDrops);
    }

    public boolean hasEntityData() {
        return this.entityTag != null;
    }

    @Nullable
    public CompoundTag getEntityData() {
        return this.entityTag;
    }

    @Nullable
    public LivingEntity tryResurrectEntity(Level level, BlockPos pos) {
        if (this.entityTag == null || level.f_46443_) {
            return null;
        }
        try {
            this.entityTag.m_128365_("Pos", (Tag)this.newDoubleList((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5));
            this.entityTag.m_128473_("DeathTime");
            this.entityTag.m_128473_("HurtTime");
            LivingEntity entity = EntityType.m_20642_((CompoundTag)this.entityTag, (Level)level).orElse(null);
            if (entity != null) {
                entity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
                if (this.entityTag.m_128441_("ExtraPollen")) {
                    int extraPollen = this.entityTag.m_128451_("ExtraPollen");
                    entity.getPersistentData().m_128405_("ExtraPollen", extraPollen);
                }
                level.m_7967_((Entity)entity);
                this.entityTag = null;
                this.storedDrops.clear();
                this.m_6596_();
                return entity;
            }
        }
        catch (Exception e) {
            System.err.println("Failed to resurrect entity from BloatedSnowfallTaroTuber: " + e.getMessage());
        }
        return null;
    }

    private ListTag newDoubleList(double ... values) {
        ListTag list = new ListTag();
        for (double value : values) {
            list.add((Object)DoubleTag.m_128500_((double)value));
        }
        return list;
    }

    public ItemStack getItemWithBlockEntityTag() {
        ItemStack stack = new ItemStack((ItemLike)ModBlock.BLOATED_SONWFALL_TARO_TUBER.get());
        CompoundTag blockEntityTag = new CompoundTag();
        this.m_183515_(blockEntityTag);
        if (!blockEntityTag.m_128456_()) {
            stack.m_41784_().m_128365_(BLOCK_ENTITY_TAG, (Tag)blockEntityTag);
        }
        return stack;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.entityTag != null) {
            tag.m_128365_(ENTITY_TAG_KEY, (Tag)this.entityTag);
        }
        if (!this.storedDrops.isEmpty()) {
            ListTag dropsList = new ListTag();
            for (ItemStack stack : this.storedDrops) {
                dropsList.add((Object)stack.m_41739_(new CompoundTag()));
            }
            tag.m_128365_(DROPS_TAG_KEY, (Tag)dropsList);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_(ENTITY_TAG_KEY)) {
            this.entityTag = tag.m_128469_(ENTITY_TAG_KEY);
        }
        if (tag.m_128441_(DROPS_TAG_KEY)) {
            this.storedDrops.clear();
            ListTag dropsList = tag.m_128437_(DROPS_TAG_KEY, 10);
            for (int i = 0; i < dropsList.size(); ++i) {
                this.storedDrops.add(ItemStack.m_41712_((CompoundTag)dropsList.m_128728_(i)));
            }
        }
    }
}

