/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.events;

import java.util.Random;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.cryofloric_arts.hao111111111.config.ModConfig;
import org.cryofloric_arts.hao111111111.effect.ModEffects;
import org.cryofloric_arts.hao111111111.item.ModItem;
import org.cryofloric_arts.hao111111111.item.item.InspectionReportItem;
import org.cryofloric_arts.hao111111111.item.item.SamplingNeedleItem;
import org.cryofloric_arts.hao111111111.utils.DamageSourceUtil;

@Mod.EventBusSubscriber(modid="cryofloric_arts")
public class ItemUsageEventHandler {
    private static final Random RANDOM = new Random();
    private static final ResourceLocation SOUL_CRUSHING_DAMAGE = DamageSourceUtil.SOUL_CRUSHING_DAMAGE;

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        ItemStack mainHand = player.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack offHand = player.m_21120_(InteractionHand.OFF_HAND);
        if (mainHand.m_41720_() == ModItem.SAMPLING_NEEDLE.get() && offHand.m_41720_() == ModItem.VANISHING_PAPER.get()) {
            if (SamplingNeedleItem.getSamplingData(mainHand).m_128456_()) {
                return;
            }
            if (!player.m_9236_().f_46443_) {
                ItemStack reportStack = new ItemStack((ItemLike)ModItem.INSPECTION_REPORT.get());
                InspectionReportItem.setReportData(reportStack, SamplingNeedleItem.getSamplingData(mainHand));
                ItemStack newNeedle = mainHand.m_41777_();
                SamplingNeedleItem.clearSamplingData(newNeedle);
                offHand.m_41774_(1);
                player.m_21008_(InteractionHand.MAIN_HAND, newNeedle);
                if (!player.m_150109_().m_36054_(reportStack)) {
                    player.m_36176_(reportStack, false);
                }
                player.m_5661_((Component)Component.m_237115_((String)"item.cryofloric_arts.inspection_report.created"), true);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        LivingEntity attacker;
        ItemStack stack;
        Entity source = event.getSource().m_7639_();
        if (source instanceof LivingEntity && (stack = (attacker = (LivingEntity)source).m_21205_()).m_41782_() && stack.m_41783_().m_128441_("SoulCrushingBone")) {
            CompoundTag tag = stack.m_41783_();
            int soulCrushingBoneLevel = tag.m_128451_("SoulCrushingBone");
            float chance = (float)((double)(soulCrushingBoneLevel + 1) / (double)(soulCrushingBoneLevel + 10) * 0.1);
            if (RANDOM.nextFloat() < chance) {
                LivingEntity target = event.getEntity();
                if (!target.m_9236_().f_46443_) {
                    Level serverLevel;
                    target.f_20916_ = 0;
                    float extraDamage = (float)((double)event.getAmount() * (Double)ModConfig.SOUL_CRUSHING_DAMAGE_MULTIPLIER.get());
                    if (extraDamage > 0.0f) {
                        DamageSource soulCrushingDamage;
                        Level level = target.m_9236_();
                        if (level instanceof ServerLevel) {
                            serverLevel = (ServerLevel)level;
                            soulCrushingDamage = new DamageSource((Holder)serverLevel.m_9598_().m_175515_(Registries.f_268580_).m_246971_(ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)SOUL_CRUSHING_DAMAGE)));
                        } else {
                            soulCrushingDamage = target.m_269291_().m_269264_();
                        }
                        target.m_6469_(soulCrushingDamage, extraDamage);
                    }
                    target.f_20916_ = 0;
                    serverLevel = target.m_9236_();
                    if (serverLevel instanceof ServerLevel) {
                        ServerLevel serverLevel2 = (ServerLevel)serverLevel;
                        double x = target.m_20185_();
                        double y = target.m_20186_() + (double)(target.m_20206_() / 2.0f);
                        double z = target.m_20189_();
                        serverLevel2.m_8767_((ParticleOptions)ParticleTypes.f_123746_, x, y, z, 15, (double)(target.m_20205_() / 2.0f), (double)(target.m_20206_() / 3.0f), (double)(target.m_20205_() / 2.0f), 0.1);
                        serverLevel2.m_8767_((ParticleOptions)ParticleTypes.f_123746_, x, y, z, 10, (double)(target.m_20205_() / 3.0f), 0.2, (double)(target.m_20205_() / 3.0f), 0.05);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        Entity source = event.getSource().m_7639_();
        if (source instanceof LivingEntity) {
            CompoundTag tag;
            int frostAttachment;
            int frostLevel;
            LivingEntity attacker = (LivingEntity)source;
            ItemStack stack = attacker.m_21205_();
            if (stack.m_41782_() && stack.m_41783_().m_128441_("CloudSoreRush")) {
                int level = stack.m_41783_().m_128451_("CloudSoreRush");
                double probability = (double)(1 + level) / (double)(100 + level) * 100.0;
                if (Math.random() * 100.0 < probability) {
                    int effectLevel = (int)Math.round((double)(1 + level) / (30.0 + (double)level) * 5.0);
                    LivingEntity target = event.getEntity();
                    target.m_7292_(new MobEffectInstance((MobEffect)ModEffects.SORE_RUSH.get(), 1200, effectLevel));
                }
            }
            if (stack.m_41782_() && stack.m_41783_().m_128441_("FrostAttachment") && (frostLevel = (int)((1.0 + (double)(frostAttachment = (tag = stack.m_41783_()).m_128451_("FrostAttachment"))) / (10.0 + (double)frostAttachment) * 10.0)) > 0) {
                LivingEntity target = event.getEntity();
                target.m_7292_(new MobEffectInstance((MobEffect)ModEffects.FROST_POWDER.get(), 200, 0));
                target.m_7292_(new MobEffectInstance((MobEffect)ModEffects.FROSTED.get(), 200, frostLevel - 1));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        Player player;
        ItemStack stack;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player && (stack = (player = (Player)entity).m_21205_()).m_41782_() && stack.m_41783_().m_128441_("FrostedItem")) {
            CompoundTag tag = stack.m_41783_();
            if (RANDOM.nextFloat() < 0.05f) {
                int currentFrostAttachment = tag.m_128441_("FrostAttachment") ? tag.m_128451_("FrostAttachment") : 0;
                tag.m_128405_("FrostAttachment", currentFrostAttachment + 1);
            }
        }
    }
}

