/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.anvil;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.AnvilUpdateEvent;
import org.cryofloric_arts.hao111111111.anvil.AnvilRecipe;
import org.cryofloric_arts.hao111111111.anvil.AnvilRecipeRegistry;
import org.cryofloric_arts.hao111111111.item.ModItem;

public class ModAnvilRecipes {
    public static void registerRecipes() {
        AnvilRecipeRegistry.registerRecipe(new AnvilRecipe(){
            private final ResourceLocation RECIPE_ID = new ResourceLocation("cryofloric_arts", "frost_item");

            @Override
            public boolean matches(ItemStack left, ItemStack right, Player player) {
                return right.m_41720_() == ModItem.ICE_PEATL_DRYAD_BLOOM.get() && (!left.m_41782_() || !left.m_41783_().m_128441_("FrostedItem"));
            }

            @Override
            public void apply(AnvilUpdateEvent event) {
                ItemStack left = event.getLeft();
                ItemStack output = left.m_41777_();
                CompoundTag tag = output.m_41784_();
                tag.m_128379_("FrostedItem", true);
                event.setOutput(output);
            }

            @Override
            public int getCost() {
                return 1;
            }

            @Override
            public int getMaterialCost() {
                return 1;
            }

            @Override
            public ResourceLocation getRecipeId() {
                return this.RECIPE_ID;
            }
        });
        AnvilRecipeRegistry.registerRecipe(new AnvilRecipe(){
            private final ResourceLocation RECIPE_ID = new ResourceLocation("cryofloric_arts", "bind_owner");

            @Override
            public boolean matches(ItemStack left, ItemStack right, Player player) {
                return right.m_41720_() == ModItem.BLINDFROST_BEAST_SLIME.get() && left.m_41782_() && left.m_41783_().m_128441_("FrostedItem") && (!left.m_41783_().m_128441_("Owner") || player != null) && this.isOwner(left, player);
            }

            @Override
            public void apply(AnvilUpdateEvent event) {
                ItemStack left = event.getLeft();
                Player player = event.getPlayer();
                ItemStack output = left.m_41777_();
                CompoundTag tag = output.m_41784_();
                if (player != null) {
                    tag.m_128359_("Owner", player.m_7755_().getString());
                    tag.m_128362_("OwnerUUID", player.m_20148_());
                }
                event.setOutput(output);
            }

            @Override
            public int getCost() {
                return 1;
            }

            @Override
            public int getMaterialCost() {
                return 1;
            }

            @Override
            public ResourceLocation getRecipeId() {
                return this.RECIPE_ID;
            }

            private boolean isOwner(ItemStack stack, Player player) {
                if (stack.m_41782_() && stack.m_41783_().m_128441_("OwnerUUID") && player != null) {
                    UUID ownerUUID = stack.m_41783_().m_128342_("OwnerUUID");
                    return ownerUUID.equals(player.m_20148_());
                }
                return true;
            }
        });
        AnvilRecipeRegistry.registerRecipe(new AnvilRecipe(){
            private final ResourceLocation RECIPE_ID = new ResourceLocation("cryofloric_arts", "increase_residual_magic");

            @Override
            public boolean matches(ItemStack left, ItemStack right, Player player) {
                return right.m_41720_() == ModItem.DESERT_BOOK.get() && left.m_41782_() && left.m_41783_().m_128441_("FrostedItem") && this.isOwner(left, player);
            }

            @Override
            public void apply(AnvilUpdateEvent event) {
                ItemStack left = event.getLeft();
                ItemStack output = left.m_41777_();
                CompoundTag tag = output.m_41784_();
                int residualMagic = tag.m_128441_("ResidualMagic") ? tag.m_128451_("ResidualMagic") : 0;
                tag.m_128405_("ResidualMagic", ++residualMagic);
                event.setOutput(output);
            }

            @Override
            public int getCost() {
                return 5;
            }

            @Override
            public int getMaterialCost() {
                return 1;
            }

            @Override
            public ResourceLocation getRecipeId() {
                return this.RECIPE_ID;
            }

            private boolean isOwner(ItemStack stack, Player player) {
                if (stack.m_41782_() && stack.m_41783_().m_128441_("OwnerUUID") && player != null) {
                    UUID ownerUUID = stack.m_41783_().m_128342_("OwnerUUID");
                    return ownerUUID.equals(player.m_20148_());
                }
                return true;
            }
        });
        AnvilRecipeRegistry.registerRecipe(new AnvilRecipe(){
            private final ResourceLocation RECIPE_ID = new ResourceLocation("cryofloric_arts", "rooted_repair");

            @Override
            public boolean matches(ItemStack left, ItemStack right, Player player) {
                return right.m_41720_() == ModItem.BLOATED_SONWFALL_TARO_TUBER.get() && left.m_41782_() && left.m_41783_().m_128441_("FrostedItem") && this.isOwner(left, player) && left.m_41783_().m_128441_("ResidualMagic") && left.m_41783_().m_128451_("ResidualMagic") >= 5 && (!left.m_41783_().m_128441_("RootedRepair") || !left.m_41783_().m_128471_("RootedRepair"));
            }

            @Override
            public void apply(AnvilUpdateEvent event) {
                ItemStack left = event.getLeft();
                ItemStack output = left.m_41777_();
                CompoundTag tag = output.m_41784_();
                tag.m_128379_("RootedRepair", true);
                event.setOutput(output);
            }

            @Override
            public int getCost() {
                return 10;
            }

            @Override
            public int getMaterialCost() {
                return 1;
            }

            @Override
            public ResourceLocation getRecipeId() {
                return this.RECIPE_ID;
            }

            private boolean isOwner(ItemStack stack, Player player) {
                if (stack.m_41782_() && stack.m_41783_().m_128441_("OwnerUUID") && player != null) {
                    UUID ownerUUID = stack.m_41783_().m_128342_("OwnerUUID");
                    return ownerUUID.equals(player.m_20148_());
                }
                return true;
            }
        });
        AnvilRecipeRegistry.registerRecipe(new AnvilRecipe(){
            private final ResourceLocation RECIPE_ID = new ResourceLocation("cryofloric_arts", "detection_boost");

            @Override
            public boolean matches(ItemStack left, ItemStack right, Player player) {
                return right.m_41720_() == ModItem.FROST_DUST_DETECTOR.get() && left.m_41782_() && left.m_41783_().m_128441_("FrostedItem") && this.isOwner(left, player);
            }

            @Override
            public void apply(AnvilUpdateEvent event) {
                ItemStack left = event.getLeft();
                ItemStack output = left.m_41777_();
                CompoundTag tag = output.m_41784_();
                int currentBoost = tag.m_128441_("DetectionBoost") ? tag.m_128451_("DetectionBoost") : 0;
                tag.m_128405_("DetectionBoost", ++currentBoost);
                event.setOutput(output);
            }

            @Override
            public int getCost() {
                return 5;
            }

            @Override
            public int getMaterialCost() {
                return 1;
            }

            @Override
            public ResourceLocation getRecipeId() {
                return this.RECIPE_ID;
            }

            private boolean isOwner(ItemStack stack, Player player) {
                if (stack.m_41782_() && stack.m_41783_().m_128441_("OwnerUUID") && player != null) {
                    UUID ownerUUID = stack.m_41783_().m_128342_("OwnerUUID");
                    return ownerUUID.equals(player.m_20148_());
                }
                return true;
            }
        });
        AnvilRecipeRegistry.registerRecipe(new AnvilRecipe(){
            private final ResourceLocation RECIPE_ID = new ResourceLocation("cryofloric_arts", "patterned_recoating");

            @Override
            public boolean matches(ItemStack left, ItemStack right, Player player) {
                return right.m_41720_() == ModItem.PATTERNED_INGOT.get() && left.m_41782_() && left.m_41783_().m_128441_("FrostedItem") && this.isOwner(left, player);
            }

            @Override
            public void apply(AnvilUpdateEvent event) {
                ItemStack left = event.getLeft();
                ItemStack output = left.m_41777_();
                CompoundTag outputTag = output.m_41784_();
                int currentRecoating = outputTag.m_128441_("PatternedRecoating") ? outputTag.m_128451_("PatternedRecoating") : 0;
                outputTag.m_128405_("PatternedRecoating", currentRecoating + 1);
                float durabilityRatio = 1.0f - (float)output.m_41773_() / (float)output.m_41776_();
                int originalMaxDamage = output.m_41720_().m_41462_();
                int newMaxDamage = originalMaxDamage + (currentRecoating + 1) * 50;
                int newDamage = (int)((float)newMaxDamage * (1.0f - durabilityRatio));
                output.m_41721_(newDamage);
                event.setOutput(output);
            }

            @Override
            public int getCost() {
                return 5;
            }

            @Override
            public int getMaterialCost() {
                return 1;
            }

            @Override
            public ResourceLocation getRecipeId() {
                return this.RECIPE_ID;
            }

            private boolean isOwner(ItemStack stack, Player player) {
                if (stack.m_41782_() && stack.m_41783_().m_128441_("OwnerUUID") && player != null) {
                    UUID ownerUUID = stack.m_41783_().m_128342_("OwnerUUID");
                    return ownerUUID.equals(player.m_20148_());
                }
                return true;
            }
        });
        AnvilRecipeRegistry.registerRecipe(new AnvilRecipe(){
            private final ResourceLocation RECIPE_ID = new ResourceLocation("cryofloric_arts", "soul_crushing_bone");

            @Override
            public boolean matches(ItemStack left, ItemStack right, Player player) {
                return right.m_41720_() == ModItem.SOUL_CRYSTAL.get() && left.m_41782_() && left.m_41783_().m_128441_("FrostedItem") && left.m_41783_().m_128441_("ResidualMagic") && this.isOwner(left, player);
            }

            @Override
            public void apply(AnvilUpdateEvent event) {
                int currentSoulCrushing;
                ItemStack left = event.getLeft();
                int residualMagic = left.m_41783_().m_128451_("ResidualMagic");
                ItemStack output = left.m_41777_();
                CompoundTag outputTag = output.m_41784_();
                int n = currentSoulCrushing = outputTag.m_128441_("SoulCrushingBone") ? outputTag.m_128451_("SoulCrushingBone") : 0;
                if (currentSoulCrushing < residualMagic) {
                    outputTag.m_128405_("SoulCrushingBone", currentSoulCrushing + 1);
                    event.setOutput(output);
                }
            }

            @Override
            public int getCost() {
                return 5;
            }

            @Override
            public int getMaterialCost() {
                return 1;
            }

            @Override
            public ResourceLocation getRecipeId() {
                return this.RECIPE_ID;
            }

            private boolean isOwner(ItemStack stack, Player player) {
                if (stack.m_41782_() && stack.m_41783_().m_128441_("OwnerUUID") && player != null) {
                    UUID ownerUUID = stack.m_41783_().m_128342_("OwnerUUID");
                    return ownerUUID.equals(player.m_20148_());
                }
                return true;
            }
        });
        AnvilRecipeRegistry.registerRecipe(new AnvilRecipe(){
            private final ResourceLocation RECIPE_ID = new ResourceLocation("cryofloric_arts", "cloud_sore_rush");

            @Override
            public boolean matches(ItemStack left, ItemStack right, Player player) {
                boolean rightMatch = right.m_41720_() == ModItem.SORE_CLOUD_SUBSTANCE.get() && right.m_41613_() >= 5;
                boolean leftMatch = left.m_41782_() && left.m_41783_().m_128441_("FrostedItem") && left.m_41783_().m_128441_("FrostAttachment");
                boolean ownerMatch = this.isOwner(left, player);
                if (rightMatch && leftMatch && ownerMatch) {
                    int frostAttachment = left.m_41783_().m_128451_("FrostAttachment");
                    int currentLevel = left.m_41783_().m_128441_("CloudSoreRush") ? left.m_41783_().m_128451_("CloudSoreRush") : 0;
                    return frostAttachment >= currentLevel + 1;
                }
                return false;
            }

            @Override
            public void apply(AnvilUpdateEvent event) {
                ItemStack left = event.getLeft();
                ItemStack right = event.getRight();
                ItemStack output = left.m_41777_();
                CompoundTag tag = output.m_41784_();
                int currentLevel = tag.m_128441_("CloudSoreRush") ? tag.m_128451_("CloudSoreRush") : 0;
                tag.m_128405_("CloudSoreRush", currentLevel + 1);
                ItemStack newRight = right.m_41777_();
                newRight.m_41764_(right.m_41613_() - 5);
                event.setOutput(output);
            }

            @Override
            public int getCost() {
                return 1;
            }

            @Override
            public int getMaterialCost() {
                return 5;
            }

            @Override
            public ResourceLocation getRecipeId() {
                return this.RECIPE_ID;
            }

            private boolean isOwner(ItemStack stack, Player player) {
                if (stack.m_41782_() && stack.m_41783_().m_128441_("OwnerUUID") && player != null) {
                    UUID ownerUUID = stack.m_41783_().m_128342_("OwnerUUID");
                    return ownerUUID.equals(player.m_20148_());
                }
                return true;
            }
        });
    }

    private static boolean isOwner(ItemStack stack, Player player) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("OwnerUUID") && player != null) {
            UUID ownerUUID = stack.m_41783_().m_128342_("OwnerUUID");
            return ownerUUID.equals(player.m_20148_());
        }
        return true;
    }
}

