/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.cryofloric_arts.hao111111111.PlantSpreader;
import org.cryofloric_arts.hao111111111.world.biome.ModBiomes;

public class BlightSorrowLog
extends RotatedPillarBlock {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61365_;
    private static final float HORIZONTAL_SPEED_MULTIPLIER = 0.9f;
    private static final float VERTICAL_SPEED_MULTIPLIER = 1.5f;
    private static final VoxelShape FALLING_COLLISION_SHAPE = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.9f, (double)1.0);
    private static final VoxelShape COLLISION_SHAPE = Shapes.m_83144_();

    public BlightSorrowLog(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(AXIS, (Comparable)Direction.Axis.Y));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AXIS});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)context.m_43719_().m_122434_());
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.m_204166_(pos).m_203565_(ModBiomes.WHITE_BARRENS) && random.m_188501_() < 1.0f) {
            BlockPos targetPos = pos.m_7918_(random.m_188503_(3) - 1, random.m_188503_(3) - 1, random.m_188503_(3) - 1);
            PlantSpreader.convertBlock(level, targetPos);
        }
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        EntityCollisionContext entityCollision;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = (entityCollision = (EntityCollisionContext)context).m_193113_()) != null) {
            if (entity.f_19789_ > 2.5f) {
                return FALLING_COLLISION_SHAPE;
            }
            boolean fallingBlock = entity instanceof FallingBlockEntity;
            if (fallingBlock || BlightSorrowLog.canWalkOnPowderSnow(entity) && context.m_6513_(COLLISION_SHAPE, pos, false) && !context.m_6226_()) {
                return super.m_5939_(state, level, pos, context);
            }
        }
        return Shapes.m_83040_();
    }

    private static boolean canWalkOnPowderSnow(Entity entity) {
        boolean bl;
        if (entity.m_6095_().m_204039_(EntityTypeTags.f_144291_)) {
            return true;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            bl = livingEntity.m_6844_(EquipmentSlot.FEET).canWalkOnPowderedSnow(livingEntity);
        } else {
            bl = false;
        }
        return bl;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        int currentFreezeTicks;
        LivingEntity livingEntity;
        entity.m_7601_(state, new Vec3((double)0.9f, 1.5, (double)0.9f));
        if (!level.f_46443_ && entity instanceof LivingEntity && !(livingEntity = (LivingEntity)entity).m_6673_(level.m_269111_().m_269109_()) && (currentFreezeTicks = livingEntity.m_146888_()) < livingEntity.m_146891_()) {
            livingEntity.m_146917_(currentFreezeTicks + 1);
        }
        super.m_7892_(state, level, pos, entity);
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return true;
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (!(fallDistance < 4.0f) && entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            LivingEntity.Fallsounds fallsounds = livingentity.m_196493_();
            SoundEvent soundevent = fallDistance < 7.0f ? fallsounds.f_196626_() : fallsounds.f_196627_();
            entity.m_5496_(soundevent, 1.0f, 1.0f);
        }
    }
}

