/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.cryofloric_arts.hao111111111.item.item.InspectionReportItem;

public class InspectionReportScreen
extends Screen {
    private static final ResourceLocation REPORT_TEXTURE = new ResourceLocation("cryofloric_arts", "textures/gui/inspection_report.png");
    private final ItemStack reportStack;
    private int leftPos;
    private int topPos;
    private final int imageWidth = 256;
    private final int imageHeight = 256;
    private int scrollOffset = 0;

    public InspectionReportScreen(ItemStack reportStack) {
        super((Component)Component.m_237115_((String)"item.cryofloric_arts.inspection_report"));
        this.reportStack = reportStack;
    }

    protected void m_7856_() {
        super.m_7856_();
        Objects.requireNonNull(this);
        this.leftPos = (this.f_96543_ - 256) / 2;
        Objects.requireNonNull(this);
        this.topPos = (this.f_96544_ - 256) / 2;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        guiGraphics.m_280163_(REPORT_TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, 256, 256, 256, 256);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderReportContent(guiGraphics);
    }

    private void renderReportContent(GuiGraphics guiGraphics) {
        CompoundTag reportData = InspectionReportItem.getReportData(this.reportStack);
        if (reportData.m_128456_()) {
            this.renderEmptyReport(guiGraphics);
            return;
        }
        int contentLeft = this.leftPos + 16;
        int contentTop = this.topPos + 20;
        int lineHeight = 8;
        int smallLineHeight = 6;
        int currentY = contentTop;
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"item.cryofloric_arts.inspection_report.title"), contentLeft, currentY, 0, false);
        this.renderSectionTitle(guiGraphics, "entity_info", contentLeft, currentY += lineHeight + 3);
        currentY += lineHeight;
        if (reportData.m_128441_("CustomName")) {
            this.renderKeyValue(guiGraphics, "custom_name", reportData.m_128461_("CustomName"), contentLeft, currentY);
            currentY += lineHeight;
        }
        String entityType = reportData.m_128461_("EntityType");
        String localizedName = Component.m_237115_((String)("entity." + entityType.replace(":", "."))).getString();
        this.renderKeyValue(guiGraphics, "entity_type", localizedName, contentLeft, currentY);
        this.renderSectionTitle(guiGraphics, "attributes", contentLeft, currentY += lineHeight + 3);
        CompoundTag attributes = reportData.m_128469_("Attributes");
        this.renderScaledAttribute(guiGraphics, "max_health", attributes.m_128459_("MaxHealth"), contentLeft, currentY += lineHeight, 0.7f);
        this.renderScaledAttribute(guiGraphics, "attack_damage", attributes.m_128459_("AttackDamage"), contentLeft, currentY += smallLineHeight, 0.7f);
        this.renderScaledAttribute(guiGraphics, "armor", attributes.m_128459_("Armor"), contentLeft, currentY += smallLineHeight, 0.7f);
        this.renderScaledAttribute(guiGraphics, "armor_toughness", attributes.m_128459_("ArmorToughness"), contentLeft, currentY += smallLineHeight, 0.7f);
        double maxDamageRate = attributes.m_128459_("MaxDamageRate");
        String maxDamageRateText = String.format("%.1f%%", maxDamageRate * 100.0);
        this.renderScaledKeyValue(guiGraphics, "attribute.max_damage_rate", maxDamageRateText, contentLeft, currentY += smallLineHeight, 0.7f);
        currentY += smallLineHeight + 3;
        ListTag effects = reportData.m_128437_("Effects", 10);
        if (!effects.isEmpty()) {
            this.renderSectionTitle(guiGraphics, "effects", contentLeft, currentY);
            currentY += lineHeight;
            for (int i = 0; i < effects.size(); ++i) {
                CompoundTag effect = effects.m_128728_(i);
                String effectId = effect.m_128461_("Effect");
                int duration = effect.m_128451_("Duration");
                int amplifier = effect.m_128451_("Amplifier");
                MobEffect mobEffect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(effectId));
                if (mobEffect == null) continue;
                String effectName = mobEffect.m_19482_().getString();
                String effectInfo = String.format("%s (%d\u79d2, \u7b49\u7ea7%d)", effectName, duration / 20, amplifier + 1);
                this.renderScaledText(guiGraphics, effectInfo, contentLeft + 5, currentY, 0.7f, 0);
                currentY += smallLineHeight;
            }
            currentY += 3;
        }
        this.renderSectionTitle(guiGraphics, "special_systems", contentLeft, currentY);
        int extraPollen = reportData.m_128451_("ExtraPollen");
        this.renderScaledKeyValue(guiGraphics, "extra_pollen", String.valueOf(extraPollen), contentLeft, currentY += lineHeight, 0.7f);
        currentY += smallLineHeight;
        CompoundTag hyperplasia = reportData.m_128469_("Hyperplasia");
        if (hyperplasia.m_128471_("Unlocked")) {
            this.renderScaledKeyValue(guiGraphics, "hyperplasia_value", String.valueOf(hyperplasia.m_128451_("Value")), contentLeft, currentY, 0.7f);
            currentY += smallLineHeight;
            if (hyperplasia.m_128441_("Type")) {
                String type = hyperplasia.m_128461_("Type");
                String typeName = Component.m_237115_((String)("hyperplasia.type." + type)).getString();
                this.renderScaledKeyValue(guiGraphics, "hyperplasia_type", typeName, contentLeft, currentY, 0.7f);
                currentY += smallLineHeight;
            }
        } else {
            this.renderScaledKeyValue(guiGraphics, "hyperplasia", Component.m_237115_((String)"item.cryofloric_arts.inspection_report.hyperplasia.unlocked").getString(), contentLeft, currentY, 0.7f);
            currentY += smallLineHeight;
        }
        currentY += 3;
        if (reportData.m_128441_("SamplingTime")) {
            long timestamp = reportData.m_128454_("SamplingTime");
            String timeStr = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(timestamp));
            this.renderScaledKeyValue(guiGraphics, "sampling_time", timeStr, contentLeft, currentY, 0.7f);
        }
    }

    private void renderEmptyReport(GuiGraphics guiGraphics) {
        int contentLeft = this.leftPos + 16;
        int contentTop = this.topPos + 20;
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"item.cryofloric_arts.inspection_report.empty"), contentLeft, contentTop, 0, false);
    }

    private void renderSectionTitle(GuiGraphics guiGraphics, String key, int x, int y) {
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)("item.cryofloric_arts.inspection_report." + key)), x, y, 0x2F4F4F, false);
    }

    private void renderKeyValue(GuiGraphics guiGraphics, String key, String value, int x, int y) {
        String text = Component.m_237115_((String)("item.cryofloric_arts.inspection_report." + key)).getString() + ": " + value;
        guiGraphics.m_280056_(this.f_96547_, text, x + 5, y, 0, false);
    }

    private void renderAttribute(GuiGraphics guiGraphics, String attribute, double value, int x, int y) {
        this.renderKeyValue(guiGraphics, "attribute." + attribute, String.format("%.1f", value), x, y);
    }

    private void renderScaledAttribute(GuiGraphics guiGraphics, String attribute, double value, int x, int y, float scale) {
        this.renderScaledKeyValue(guiGraphics, "attribute." + attribute, String.format("%.1f", value), x, y, scale);
    }

    private void renderScaledKeyValue(GuiGraphics guiGraphics, String key, String value, int x, int y, float scale) {
        String text = Component.m_237115_((String)("item.cryofloric_arts.inspection_report." + key)).getString() + ": " + value;
        this.renderScaledText(guiGraphics, text, x + 5, y, scale, 0);
    }

    private void renderScaledText(GuiGraphics guiGraphics, String text, int x, int y, float scale, int color) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)x, (float)y, 0.0f);
        poseStack.m_85841_(scale, scale, 1.0f);
        guiGraphics.m_280056_(this.f_96547_, text, 0, 0, color, false);
        poseStack.m_85849_();
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        this.scrollOffset = (int)Math.max(0.0, (double)this.scrollOffset - delta * 5.0);
        return true;
    }
}

