/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Calendar;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import org.cryofloric_arts.hao111111111.blockentity.BlightSorrowChestBlockEntity;

public class BlightSorrowChestRenderer
implements BlockEntityRenderer<BlightSorrowChestBlockEntity> {
    public static final Material BLIGHT_SORROW_CHEST_LOCATION = new Material(Sheets.f_110740_, new ResourceLocation("cryofloric_arts", "entity/chest/blight_sorrow"));
    private final ModelPart lid;
    private final ModelPart bottom;
    private final ModelPart lock;
    private final ModelPart doubleLeftLid;
    private final ModelPart doubleLeftBottom;
    private final ModelPart doubleLeftLock;
    private final ModelPart doubleRightLid;
    private final ModelPart doubleRightBottom;
    private final ModelPart doubleRightLock;
    private boolean xmasTextures;

    public BlightSorrowChestRenderer(BlockEntityRendererProvider.Context context) {
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26) {
            this.xmasTextures = true;
        }
        ModelPart singleChest = context.m_173582_(ModelLayers.f_171275_);
        this.bottom = singleChest.m_171324_("bottom");
        this.lid = singleChest.m_171324_("lid");
        this.lock = singleChest.m_171324_("lock");
        ModelPart doubleLeftChest = context.m_173582_(ModelLayers.f_171133_);
        this.doubleLeftBottom = doubleLeftChest.m_171324_("bottom");
        this.doubleLeftLid = doubleLeftChest.m_171324_("lid");
        this.doubleLeftLock = doubleLeftChest.m_171324_("lock");
        ModelPart doubleRightChest = context.m_173582_(ModelLayers.f_171134_);
        this.doubleRightBottom = doubleRightChest.m_171324_("bottom");
        this.doubleRightLid = doubleRightChest.m_171324_("lid");
        this.doubleRightLock = doubleRightChest.m_171324_("lock");
    }

    public void render(BlightSorrowChestBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Level level = blockEntity.m_58904_();
        boolean flag = level != null;
        BlockState blockstate = flag ? blockEntity.m_58900_() : (BlockState)Blocks.f_50087_.m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)Direction.SOUTH);
        ChestType chesttype = blockstate.m_61138_((Property)ChestBlock.f_51479_) ? (ChestType)blockstate.m_61143_((Property)ChestBlock.f_51479_) : ChestType.SINGLE;
        poseStack.m_85836_();
        float rotation = ((Direction)blockstate.m_61143_((Property)ChestBlock.f_51478_)).m_122435_();
        poseStack.m_252880_(0.5f, 0.5f, 0.5f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-rotation));
        poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
        float openProgress = blockEntity.m_6683_(partialTick);
        openProgress = 1.0f - openProgress;
        openProgress = 1.0f - openProgress * openProgress * openProgress;
        Material material = this.getMaterial(blockEntity, chesttype);
        VertexConsumer vertexconsumer = material.m_119194_(bufferSource, RenderType::m_110452_);
        if (chesttype != ChestType.SINGLE) {
            if (chesttype == ChestType.LEFT) {
                this.render(poseStack, vertexconsumer, this.doubleLeftLid, this.doubleLeftLock, this.doubleLeftBottom, openProgress, packedLight, packedOverlay);
            } else {
                this.render(poseStack, vertexconsumer, this.doubleRightLid, this.doubleRightLock, this.doubleRightBottom, openProgress, packedLight, packedOverlay);
            }
        } else {
            this.render(poseStack, vertexconsumer, this.lid, this.lock, this.bottom, openProgress, packedLight, packedOverlay);
        }
        poseStack.m_85849_();
    }

    private void render(PoseStack poseStack, VertexConsumer vertexConsumer, ModelPart lidPart, ModelPart lockPart, ModelPart bottomPart, float openness, int packedLight, int packedOverlay) {
        lockPart.f_104203_ = lidPart.f_104203_ = -(openness * 1.5707964f);
        lidPart.m_104301_(poseStack, vertexConsumer, packedLight, packedOverlay);
        lockPart.m_104301_(poseStack, vertexConsumer, packedLight, packedOverlay);
        bottomPart.m_104301_(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    private Material getMaterial(BlightSorrowChestBlockEntity blockEntity, ChestType chestType) {
        switch (chestType) {
            default: 
        }
        return BLIGHT_SORROW_CHEST_LOCATION;
    }
}

