/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.inventory;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.cryofloric_arts.hao111111111.blockentity.DustAbsorberBlockEntity;
import org.cryofloric_arts.hao111111111.inventory.ModMenuTypes;
import org.cryofloric_arts.hao111111111.item.ModItem;

public class DustAbsorberMenu
extends AbstractContainerMenu {
    private final DustAbsorberBlockEntity blockEntity;
    private final ContainerData data;
    private final IItemHandler playerInventory;
    private final ItemStackHandler dummyHandler;

    public DustAbsorberMenu(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, null, (ContainerData)new SimpleContainerData(2));
    }

    public DustAbsorberMenu(int containerId, Inventory playerInventory, DustAbsorberBlockEntity blockEntity, ContainerData data) {
        super((MenuType)ModMenuTypes.DUST_ABSORBER_MENU.get(), containerId);
        this.blockEntity = blockEntity;
        this.data = data;
        this.playerInventory = new InvWrapper((Container)playerInventory);
        this.dummyHandler = new ItemStackHandler(18){

            public boolean isItemValid(int slot, ItemStack stack) {
                return stack.m_41720_() == ModItem.FROST_DUST.get();
            }
        };
        this.addCustomSlots();
        this.addPlayerInventory(playerInventory);
        this.addPlayerHotbar(playerInventory);
        if (data != null) {
            this.m_38884_(data);
        }
    }

    private void addCustomSlots() {
        ItemStackHandler handler = this.blockEntity != null ? this.blockEntity.getItemHandler() : this.dummyHandler;
        for (int row = 0; row < 2; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, col + row * 9, 8 + col * 18, 18 + row * 18){

                    public boolean m_5857_(ItemStack stack) {
                        return stack.m_41720_() == ModItem.FROST_DUST.get();
                    }

                    public boolean m_8010_(Player player) {
                        return true;
                    }
                });
            }
        }
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack stackInSlot = slot.m_7993_();
            itemstack = stackInSlot.m_41777_();
            if (index < 18 ? !this.m_38903_(stackInSlot, 18, 54, true) : (stackInSlot.m_41720_() == ModItem.FROST_DUST.get() ? !this.m_38903_(stackInSlot, 0, 18, false) : (index >= 18 && index < 45 ? !this.m_38903_(stackInSlot, 45, 54, false) : index >= 45 && index < 54 && !this.m_38903_(stackInSlot, 18, 45, false)))) {
                return ItemStack.f_41583_;
            }
            if (stackInSlot.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stackInSlot.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, stackInSlot);
        }
        return itemstack;
    }

    public boolean m_6875_(Player player) {
        if (this.blockEntity == null) {
            return true;
        }
        return (Boolean)this.blockEntity.m_58900_().m_61143_((Property)BooleanProperty.m_61465_((String)"damaged")) == false;
    }

    public int getTotalDust() {
        return this.data != null ? this.data.m_6413_(0) : 0;
    }

    public boolean isDamaged() {
        return this.data != null && this.data.m_6413_(1) == 1;
    }

    public IItemHandler getPlayerInventory() {
        return this.playerInventory;
    }
}

