/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.item.item;

import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.cryofloric_arts.hao111111111.world.storage.PollenData;

public class SnowAccumulationDetector
extends Item {
    private static final int LOW_THRESHOLD = 100;
    private static final int MEDIUM_THRESHOLD = 1000;
    private static final int HIGH_THRESHOLD = 10000;
    private static final String DETECTION_BOOST_TAG = "DetectionBoost";
    private static final int BOOST_PER_LEVEL = 10000;

    public SnowAccumulationDetector(Item.Properties p_41383_) {
        super(p_41383_);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (level.f_46443_) {
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ChunkPos playerChunk = new ChunkPos(player.m_20183_());
                PollenData data = PollenData.get(serverLevel);
                int pollenValue = data.getPollenValue(playerChunk);
                int boostLevel = this.getBoostLevel(stack);
                this.sendPollenMessage(serverPlayer, pollenValue, boostLevel);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    int getBoostLevel(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(DETECTION_BOOST_TAG)) {
            return stack.m_41783_().m_128451_(DETECTION_BOOST_TAG);
        }
        return 0;
    }

    void sendPollenMessage(ServerPlayer player, int value, int boostLevel) {
        int boostedThreshold = 10000 + boostLevel * 10000;
        String messageKey = value == 0 ? "message.cryofloric_arts.pollen_level.undetectable" : (value <= 100 ? "message.cryofloric_arts.pollen_level.low" : (value <= 1000 ? "message.cryofloric_arts.pollen_level.medium" : (value <= 10000 ? "message.cryofloric_arts.pollen_level.high" : (value <= boostedThreshold ? "message.cryofloric_arts.pollen_level.extrememore" : "message.cryofloric_arts.pollen_level.extreme"))));
        MutableComponent levelMessage = Component.m_237110_((String)messageKey, (Object[])new Object[]{value});
        player.m_213846_((Component)levelMessage);
    }
}

