/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.client.events;

import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cryofloric_arts", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TooltipEventHandler {
    private static boolean isShiftKeyDown = false;

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onKeyboardInput(InputEvent.Key event) {
        if (Minecraft.m_91087_().f_91080_ != null) {
            Minecraft minecraft = Minecraft.m_91087_();
            isShiftKeyDown = minecraft.f_91080_.m_96638_();
        }
    }

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        boolean showDetails = isShiftKeyDown;
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_();
            if (tag.m_128441_("FrostedItem") && tag.m_128471_("FrostedItem")) {
                if (showDetails) {
                    event.getToolTip().add(Component.m_237115_((String)"tooltip.cryofloric_arts.frosted_item"));
                    event.getToolTip().add(Component.m_237115_((String)"tooltip.cryofloric_arts.frosted_item.detail").m_130940_(ChatFormatting.GRAY));
                } else {
                    event.getToolTip().add(Component.m_237115_((String)"tooltip.cryofloric_arts.frosted_item"));
                }
            }
            if (tag.m_128441_("Owner")) {
                String ownerName = tag.m_128461_("Owner");
                if (showDetails) {
                    event.getToolTip().add(Component.m_237110_((String)"tooltip.cryofloric_arts.owned_by", (Object[])new Object[]{ownerName}));
                    event.getToolTip().add(Component.m_237110_((String)"tooltip.cryofloric_arts.owned_by.detail", (Object[])new Object[]{ownerName}).m_130940_(ChatFormatting.GRAY));
                } else {
                    event.getToolTip().add(Component.m_237110_((String)"tooltip.cryofloric_arts.owned_by", (Object[])new Object[]{ownerName}));
                }
            }
            if (tag.m_128441_("ResidualMagic")) {
                int residualMagic = tag.m_128451_("ResidualMagic");
                if (showDetails) {
                    event.getToolTip().add(Component.m_237110_((String)"tooltip.cryofloric_arts.residual_magic", (Object[])new Object[]{residualMagic}));
                    event.getToolTip().add(Component.m_237110_((String)"tooltip.cryofloric_arts.residual_magic.detail", (Object[])new Object[]{residualMagic}).m_130940_(ChatFormatting.GRAY));
                } else {
                    event.getToolTip().add(Component.m_237110_((String)"tooltip.cryofloric_arts.residual_magic", (Object[])new Object[]{residualMagic}));
                }
            }
            if (tag.m_128441_("RootedRepair") && tag.m_128471_("RootedRepair")) {
                if (showDetails) {
                    event.getToolTip().add(Component.m_237115_((String)"tooltip.cryofloric_arts.rooted_repair"));
                    event.getToolTip().add(Component.m_237115_((String)"tooltip.cryofloric_arts.rooted_repair.detail").m_130940_(ChatFormatting.GRAY));
                } else {
                    event.getToolTip().add(Component.m_237115_((String)"tooltip.cryofloric_arts.rooted_repair"));
                }
            }
            if (tag.m_128441_("DetectionBoost")) {
                int detectionBoost = tag.m_128451_("DetectionBoost");
                if (showDetails) {
                    int boostValue = detectionBoost * 10000;
                    event.getToolTip().add(Component.m_237110_((String)"tooltip.cryofloric_arts.detection_boost", (Object[])new Object[]{detectionBoost}));
                    event.getToolTip().add(Component.m_237110_((String)"tooltip.cryofloric_arts.detection_boost.detail", (Object[])new Object[]{boostValue}).m_130940_(ChatFormatting.GRAY));
                } else {
                    event.getToolTip().add(Component.m_237110_((String)"tooltip.cryofloric_arts.detection_boost", (Object[])new Object[]{detectionBoost}));
                }
            }
            if (tag.m_128441_("PatternedRecoating")) {
                int patternedRecoating = tag.m_128451_("PatternedRecoating");
                if (showDetails) {
                    int durabilityBonus = patternedRecoating * 50;
                    event.getToolTip().add(Component.m_237110_((String)"tooltip.cryofloric_arts.patterned_recoating", (Object[])new Object[]{patternedRecoating}));
                    event.getToolTip().add(Component.m_237110_((String)"tooltip.cryofloric_arts.patterned_recoating.detail", (Object[])new Object[]{durabilityBonus}).m_130940_(ChatFormatting.GRAY));
                } else {
                    event.getToolTip().add(Component.m_237110_((String)"tooltip.cryofloric_arts.patterned_recoating", (Object[])new Object[]{patternedRecoating}));
                }
            }
            if (tag.m_128441_("SoulCrushingBone")) {
                int soulCrushingBone = tag.m_128451_("SoulCrushingBone");
                if (showDetails) {
                    double probability = ((double)soulCrushingBone + 1.0) / ((double)soulCrushingBone + 10.0) * 10.0;
                    event.getToolTip().add(Component.m_237110_((String)"tooltip.cryofloric_arts.soul_crushing_bone", (Object[])new Object[]{soulCrushingBone}));
                    event.getToolTip().add(Component.m_237110_((String)"tooltip.cryofloric_arts.soul_crushing_bone.detail", (Object[])new Object[]{probability}).m_130940_(ChatFormatting.GRAY));
                } else {
                    event.getToolTip().add(Component.m_237110_((String)"tooltip.cryofloric_arts.soul_crushing_bone", (Object[])new Object[]{soulCrushingBone}));
                }
            }
            if (tag.m_128441_("FrostAttachment")) {
                int frostAttachment = tag.m_128451_("FrostAttachment");
                if (showDetails) {
                    int effectLevel = (int)Math.round((1.0 + (double)frostAttachment) / (10.0 + (double)frostAttachment) * 10.0);
                    event.getToolTip().add(Component.m_237110_((String)"tooltip.cryofloric_arts.frost_attachment", (Object[])new Object[]{frostAttachment}));
                    event.getToolTip().add(Component.m_237110_((String)"tooltip.cryofloric_arts.frost_attachment.detail", (Object[])new Object[]{effectLevel}).m_130940_(ChatFormatting.GRAY));
                } else {
                    event.getToolTip().add(Component.m_237110_((String)"tooltip.cryofloric_arts.frost_attachment", (Object[])new Object[]{frostAttachment}));
                }
            }
            if (tag.m_128441_("CloudSoreRush")) {
                int cloudSoreRush = tag.m_128451_("CloudSoreRush");
                if (showDetails) {
                    double probability = (double)(1 + cloudSoreRush) / (double)(100 + cloudSoreRush) * 100.0;
                    int effectLevel = (int)Math.round((double)(1 + cloudSoreRush) / (30.0 + (double)cloudSoreRush) * 5.0) + 1;
                    event.getToolTip().add(Component.m_237110_((String)"tooltip.cryofloric_arts.cloud_sore_rush", (Object[])new Object[]{cloudSoreRush}));
                    event.getToolTip().add(Component.m_237110_((String)"tooltip.cryofloric_arts.cloud_sore_rush.info", (Object[])new Object[]{String.format("%.1f", probability), effectLevel}).m_130940_(ChatFormatting.GRAY));
                } else {
                    event.getToolTip().add(Component.m_237110_((String)"tooltip.cryofloric_arts.cloud_sore_rush", (Object[])new Object[]{cloudSoreRush}));
                }
            }
        }
    }

    private static boolean hasEnchantments(ItemStack stack) {
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_();
            return tag.m_128441_("FrostedItem") || tag.m_128441_("Owner") || tag.m_128441_("ResidualMagic") || tag.m_128441_("RootedRepair") || tag.m_128441_("DetectionBoost") || tag.m_128441_("PatternedRecoating") || tag.m_128441_("SoulCrushingBone") || tag.m_128441_("FrostAttachment") || tag.m_128441_("CloudSoreRush");
        }
        return false;
    }
}

