/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.entity.custom;

import java.lang.reflect.Field;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.phys.AABB;
import org.cryofloric_arts.hao111111111.attributes.ModAttributes;
import org.cryofloric_arts.hao111111111.blocks.ModBlock;
import org.cryofloric_arts.hao111111111.effect.ModEffects;
import org.cryofloric_arts.hao111111111.entity.ModEntityTypes;
import org.cryofloric_arts.hao111111111.entity.custom.SnowfallTaroCreature;
import org.cryofloric_arts.hao111111111.item.ModItem;
import org.cryofloric_arts.hao111111111.world.biome.ModBiomes;

public class BlindfrostBeast
extends SnowfallTaroCreature {
    public static final String MARKED_CONTAINER_TAG = "BlindfrostBeastMarked";
    private int skillCooldown = 0;
    private int loveTick;
    @Nullable
    private Player causeOfLove;

    public BlindfrostBeast(EntityType<? extends Animal> type, Level level) {
        super(type, level, 0, 9);
        this.f_21364_ = 55;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_((Attribute)ModAttributes.MAX_DAMAGE_RATE.get(), 0.2);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new FindContainerGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public AgeableMob m_142606_(ServerLevel level, AgeableMob otherParent) {
        return (AgeableMob)((EntityType)ModEntityTypes.BLINDFROST_BEAST.get()).m_20615_((Level)level);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.loveTick > 0) {
            --this.loveTick;
            if (this.loveTick % 10 == 0) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
            }
        }
        if (!this.m_9236_().f_46443_ && this.m_217043_().m_188503_(100000) == 0) {
            this.tryLayEgg();
        }
        if (this.skillCooldown > 0) {
            --this.skillCooldown;
        }
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
        if (!this.m_9236_().f_46443_ && this.skillCooldown <= 0 && this.m_217043_().m_188503_(100) < 5 && this.m_5448_() != null) {
            this.releaseDefensiveAbility(null);
            this.skillCooldown = 100;
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_41720_() == ModItem.ROOTED_SNOWFALL_TARO.get() && player.m_21023_((MobEffect)ModEffects.OVER_ROOTING.get())) {
            if (!this.m_9236_().f_46443_) {
                this.m_5496_(SoundEvents.f_12388_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                if (this.f_19796_.m_188501_() < 0.3f) {
                    ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)ModItem.BLINDFROST_BEAST_SLIME.get()));
                    this.m_9236_().m_7967_((Entity)itemEntity);
                }
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        ItemStack itemstack = player.m_21120_(hand);
        if (this.m_6898_(itemstack) && this.m_146764_() == 0 && this.loveTick <= 0) {
            this.m_142075_(player, hand, itemstack);
            this.m_27595_(player);
            if (!this.m_9236_().f_46443_) {
                player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.FROZEN_EARTH_BLESSING.get(), 24000, 0));
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == ModItem.BLINDFROST_BEAST_SLIME.get();
    }

    public void m_27595_(@Nullable Player player) {
        this.loveTick = 600;
        if (player != null) {
            this.causeOfLove = player;
        }
        this.m_9236_().m_7605_((Entity)this, (byte)18);
    }

    public void m_27594_() {
        this.loveTick = 0;
    }

    public boolean m_5957_() {
        return this.loveTick <= 0;
    }

    private void tryLayEgg() {
        BlockPos eggPos;
        if (!this.m_9236_().m_204166_(this.m_20183_()).m_203565_(ModBiomes.WHITE_BARRENS)) {
            return;
        }
        AABB area = new AABB(this.m_20183_()).m_82400_(64.0);
        List otherBeasts = this.m_9236_().m_45976_(BlindfrostBeast.class, area);
        int eggCount = 0;
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)this.m_20183_().m_7918_(-16, -16, -16), (BlockPos)this.m_20183_().m_7918_(16, 16, 16))) {
            if (this.m_9236_().m_8055_(pos).m_60734_() != ModBlock.BLINDFROST_BEAST_EGG.get() || ++eggCount < 1) continue;
            return;
        }
        if (otherBeasts.size() <= 1 && (eggPos = this.findSuitableEggPosition()) != null) {
            this.m_9236_().m_7731_(eggPos, ((Block)ModBlock.BLINDFROST_BEAST_EGG.get()).m_49966_(), 3);
            this.m_5496_(SoundEvents.f_12486_, 1.0f, 0.8f + this.f_19796_.m_188501_() * 0.2f);
        }
    }

    private BlockPos findSuitableEggPosition() {
        BlockPos currentPos = this.m_20183_();
        if (this.m_9236_().m_46859_(currentPos)) {
            return currentPos;
        }
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (x == 0 && z == 0) continue;
                BlockPos checkPos = currentPos.m_7918_(x, 0, z);
                if (this.m_9236_().m_8055_(checkPos.m_7495_()).m_60734_() != ModBlock.BLOATED_SONWFALL_TARO_TUBER.get() || !this.m_9236_().m_46859_(checkPos)) continue;
                return checkPos;
            }
        }
        return null;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        Entity entity;
        boolean hurt = super.m_6469_(source, amount);
        if (hurt && !this.m_9236_().f_46443_ && (entity = source.m_7639_()) instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            if (this.skillCooldown <= 0 && this.m_5448_() != null) {
                this.releaseDefensiveAbility(attacker);
                this.skillCooldown = 100;
            }
        }
        return hurt;
    }

    private void releaseDefensiveAbility(@Nullable LivingEntity attacker) {
        LivingEntity target;
        AABB area = new AABB(this.m_20183_()).m_82400_(10.0);
        List entities = this.m_9236_().m_45976_(LivingEntity.class, area);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 30; ++i) {
                double x = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 5.0;
                double y = this.m_20186_() + this.f_19796_.m_188500_() * 3.0;
                double z = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 5.0;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175821_, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
            this.m_5496_(SoundEvents.f_144205_, 1.0f, 0.8f + this.f_19796_.m_188501_() * 0.2f);
        }
        if ((target = attacker) == null) {
            target = this.m_5448_();
        }
        if (target == null) {
            return;
        }
        for (LivingEntity entity : entities) {
            ServerLevel serverLevel;
            Level level2;
            Player player;
            NeutralMob neutralMob;
            if (entity == this) continue;
            boolean shouldAffect = false;
            if (entity == target) {
                shouldAffect = true;
            } else if (entity instanceof Monster) {
                shouldAffect = true;
            } else if (entity instanceof NeutralMob && (neutralMob = (NeutralMob)entity).m_5448_() == this) {
                shouldAffect = true;
            } else if (entity instanceof Player && ((player = (Player)entity).m_21214_() == this || player.m_21188_() == this)) {
                shouldAffect = true;
            }
            if (shouldAffect) {
                entity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.FROSTED.get(), 200, 2));
                level2 = this.m_9236_();
                if (level2 instanceof ServerLevel) {
                    serverLevel = (ServerLevel)level2;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175821_, entity.m_20185_(), entity.m_20186_() + (double)entity.m_20206_() * 0.5, entity.m_20189_(), 5, 0.3, 0.3, 0.3, 0.0);
                }
            }
            if (!entity.m_21023_((MobEffect)ModEffects.OVER_ROOTING.get()) || target == null) continue;
            entity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.FROZEN_EARTH_BLESSING.get(), 500, 3));
            level2 = this.m_9236_();
            if (!(level2 instanceof ServerLevel)) continue;
            serverLevel = (ServerLevel)level2;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123810_, entity.m_20185_(), entity.m_20186_() + (double)entity.m_20206_() * 0.5, entity.m_20189_(), 3, 0.2, 0.2, 0.2, 0.0);
        }
    }

    public void m_146924_(boolean isInPowderSnow) {
    }

    public boolean m_203117_() {
        return false;
    }

    @Nullable
    public Player getCauseOfLove() {
        return this.causeOfLove;
    }

    static class FindContainerGoal
    extends Goal {
        private final BlindfrostBeast beast;
        private BlockPos targetContainer;
        private int cooldown;

        public FindContainerGoal(BlindfrostBeast beast) {
            this.beast = beast;
            this.cooldown = 0;
        }

        public boolean m_8036_() {
            if (this.cooldown > 0) {
                --this.cooldown;
                return false;
            }
            if (this.beast.m_217043_().m_188503_(100) != 0) {
                return false;
            }
            this.targetContainer = this.findUnmarkedContainer();
            return this.targetContainer != null;
        }

        public boolean m_8045_() {
            return this.targetContainer != null && !this.beast.m_9236_().m_8055_(this.targetContainer).m_60795_() && !this.isContainerMarked(this.targetContainer);
        }

        public void m_8056_() {
            if (this.targetContainer != null) {
                this.beast.m_21573_().m_26519_((double)this.targetContainer.m_123341_() + 0.5, (double)this.targetContainer.m_123342_(), (double)this.targetContainer.m_123343_() + 0.5, 1.0);
            }
        }

        public void m_8037_() {
            if (this.targetContainer != null && this.beast.m_20275_((double)this.targetContainer.m_123341_() + 0.5, this.targetContainer.m_123342_(), (double)this.targetContainer.m_123343_() + 0.5) < 4.0) {
                this.markContainer(this.targetContainer);
                this.cooldown = 200;
                this.m_8041_();
            }
        }

        @Nullable
        private BlockPos findUnmarkedContainer() {
            BlockPos beastPos = this.beast.m_20183_();
            int range = 16;
            for (int x = -range; x <= range; ++x) {
                for (int y = -range; y <= range; ++y) {
                    for (int z = -range; z <= range; ++z) {
                        BlockPos pos = beastPos.m_7918_(x, y, z);
                        BlockEntity blockEntity = this.beast.m_9236_().m_7702_(pos);
                        if (!(blockEntity instanceof RandomizableContainerBlockEntity) || this.isContainerMarked(pos) || !this.hasLootTable((RandomizableContainerBlockEntity)blockEntity)) continue;
                        return pos;
                    }
                }
            }
            return null;
        }

        private boolean hasLootTable(RandomizableContainerBlockEntity container) {
            try {
                Field lootTableField = RandomizableContainerBlockEntity.class.getDeclaredField("lootTable");
                lootTableField.setAccessible(true);
                ResourceLocation lootTable = (ResourceLocation)lootTableField.get(container);
                return lootTable != null;
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                CompoundTag nbtData = container.serializeNBT();
                return nbtData.m_128425_("LootTable", 8);
            }
        }

        private boolean isContainerMarked(BlockPos pos) {
            BlockEntity blockEntity = this.beast.m_9236_().m_7702_(pos);
            if (blockEntity instanceof RandomizableContainerBlockEntity) {
                RandomizableContainerBlockEntity container = (RandomizableContainerBlockEntity)blockEntity;
                return container.getPersistentData().m_128471_(BlindfrostBeast.MARKED_CONTAINER_TAG);
            }
            return false;
        }

        private void markContainer(BlockPos pos) {
            BlockEntity blockEntity = this.beast.m_9236_().m_7702_(pos);
            if (blockEntity instanceof RandomizableContainerBlockEntity) {
                RandomizableContainerBlockEntity container = (RandomizableContainerBlockEntity)blockEntity;
                container.getPersistentData().m_128379_(BlindfrostBeast.MARKED_CONTAINER_TAG, true);
                container.m_6596_();
                Level level = this.beast.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    for (int i = 0; i < 15; ++i) {
                        double x = (double)pos.m_123341_() + 0.5 + (serverLevel.f_46441_.m_188500_() - 0.5) * 2.0;
                        double y = (double)pos.m_123342_() + 0.5 + serverLevel.f_46441_.m_188500_() * 1.5;
                        double z = (double)pos.m_123343_() + 0.5 + (serverLevel.f_46441_.m_188500_() - 0.5) * 2.0;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175821_, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                    serverLevel.m_5594_(null, pos, SoundEvents.f_12483_, SoundSource.NEUTRAL, 0.5f, 0.8f + serverLevel.f_46441_.m_188501_() * 0.2f);
                }
            }
        }
    }
}

