/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.loot.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.cryofloric_arts.hao111111111.loot.ModLootFunctions;
import org.cryofloric_arts.hao111111111.tags.ModNbtTags;

public class RandomNbtFunction
extends LootItemConditionalFunction {
    private final float chance;
    private final int minTags;
    private final int maxTags;
    private static final Map<String, Integer> TAG_TIERS = new HashMap<String, Integer>();

    protected RandomNbtFunction(LootItemCondition[] conditions, float chance, int minTags, int maxTags) {
        super(conditions);
        this.chance = chance;
        this.minTags = minTags;
        this.maxTags = maxTags;
    }

    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)ModLootFunctions.RANDOM_NBT.get();
    }

    protected ItemStack m_7372_(ItemStack stack, LootContext context) {
        RandomSource random = context.m_230907_();
        if (random.m_188501_() > this.chance) {
            return stack;
        }
        CompoundTag tag = stack.m_41784_();
        int tagsToAdd = this.minTags + random.m_188503_(this.maxTags - this.minTags + 1);
        List<String> possibleTags = this.getApplicableTagsForItem(stack);
        possibleTags.sort(Comparator.comparingInt(tagName -> TAG_TIERS.getOrDefault(tagName, 0)));
        if (possibleTags.isEmpty()) {
            return stack;
        }
        int addedTags = 0;
        for (String tagName2 : possibleTags) {
            if (addedTags >= tagsToAdd) break;
            if (!this.canAddTag(tag, tagName2) || tag.m_128441_(tagName2)) continue;
            this.addRandomTagValue(tag, tagName2, random);
            ++addedTags;
        }
        return stack;
    }

    private List<String> getApplicableTagsForItem(ItemStack stack) {
        ArrayList<String> applicableTags = new ArrayList<String>();
        applicableTags.addAll(Arrays.asList(ModNbtTags.GENERAL_TAGS));
        if (stack.m_41763_()) {
            applicableTags.addAll(Arrays.asList(ModNbtTags.DURABILITY_TAGS));
        }
        if (this.isWeapon(stack)) {
            applicableTags.addAll(Arrays.asList(ModNbtTags.WEAPON_TAGS));
        }
        if (this.isDetector(stack)) {
            applicableTags.addAll(Arrays.asList(ModNbtTags.DETECTOR_TAGS));
        }
        return applicableTags;
    }

    private boolean isWeapon(ItemStack stack) {
        return stack.m_41720_() instanceof SwordItem || stack.m_41720_() instanceof AxeItem || stack.m_41720_() instanceof TridentItem;
    }

    private boolean isDetector(ItemStack stack) {
        try {
            Class<?> frostDustDetectorClass = Class.forName("org.cryofloric_arts.hao111111111.item.item.FrostDustDetector");
            Class<?> snowAccumulationDetectorClass = Class.forName("org.cryofloric_arts.hao111111111.item.item.SnowAccumulationDetector");
            return frostDustDetectorClass.isInstance(stack.m_41720_()) || snowAccumulationDetectorClass.isInstance(stack.m_41720_());
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private boolean canAddTag(CompoundTag existingTags, String tagName) {
        switch (tagName) {
            case "RootedRepair": {
                return existingTags.m_128441_("ResidualMagic") && existingTags.m_128451_("ResidualMagic") >= 5;
            }
            case "PatternedRecoating": 
            case "SoulCrushingBone": {
                return existingTags.m_128441_("ResidualMagic");
            }
            case "FrostAttachment": 
            case "ResidualMagic": 
            case "DetectionBoost": {
                return existingTags.m_128441_("FrostedItem");
            }
            case "CloudSoreRush": {
                return existingTags.m_128441_("FrostAttachment");
            }
        }
        return true;
    }

    private void addRandomTagValue(CompoundTag tag, String tagName, RandomSource random) {
        switch (tagName) {
            case "FrostedItem": {
                tag.m_128379_("FrostedItem", true);
                break;
            }
            case "Owner": {
                tag.m_128359_("Owner", "RandomOwner_" + random.m_188503_(1000));
                if (tag.m_128441_("OwnerUUID")) break;
                tag.m_128362_("OwnerUUID", UUID.randomUUID());
                break;
            }
            case "OwnerUUID": {
                tag.m_128362_("OwnerUUID", UUID.randomUUID());
                if (tag.m_128441_("Owner")) break;
                tag.m_128359_("Owner", "RandomOwner_" + random.m_188503_(1000));
                break;
            }
            case "ResidualMagic": {
                tag.m_128405_("ResidualMagic", 1 + random.m_188503_(10));
                break;
            }
            case "RootedRepair": {
                tag.m_128379_("RootedRepair", true);
                break;
            }
            case "DetectionBoost": {
                tag.m_128405_("DetectionBoost", 1 + random.m_188503_(5));
                break;
            }
            case "PatternedRecoating": {
                tag.m_128405_("PatternedRecoating", 1 + random.m_188503_(5));
                break;
            }
            case "SoulCrushingBone": {
                int residualMagic = tag.m_128441_("ResidualMagic") ? tag.m_128451_("ResidualMagic") : 1;
                tag.m_128405_("SoulCrushingBone", 1 + random.m_188503_(residualMagic));
                break;
            }
            case "FrostAttachment": {
                tag.m_128405_("FrostAttachment", 1 + random.m_188503_(3));
                break;
            }
            case "CloudSoreRush": {
                int frostAttachment = tag.m_128441_("FrostAttachment") ? tag.m_128451_("FrostAttachment") : 1;
                tag.m_128405_("CloudSoreRush", 1 + random.m_188503_(frostAttachment));
            }
        }
    }

    public static void addPatternedArmorTags(ItemStack stack, Mob mob) {
        String ownerName;
        if (stack.m_41619_()) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        tag.m_128379_("FrostedItem", true);
        tag.m_128362_("OwnerUUID", mob.m_20148_());
        if (mob.m_8077_()) {
            ownerName = mob.m_7770_().getString();
        } else {
            ownerName = mob.m_5446_().getString();
            if (ownerName.startsWith("entity.")) {
                String entityId = mob.m_6095_().toString();
                if (entityId.contains(".")) {
                    entityId = entityId.substring(entityId.lastIndexOf(".") + 1);
                }
                ownerName = Arrays.stream(entityId.split("_")).map(word -> word.substring(0, 1).toUpperCase() + word.substring(1).toLowerCase()).collect(Collectors.joining(" "));
            }
        }
        tag.m_128359_("Owner", ownerName);
        RandomSource random = mob.m_217043_();
        tag.m_128405_("ResidualMagic", 1 + random.m_188503_(5));
        String itemName = stack.m_41720_().m_5524_();
        if ((itemName.contains("helmet") || itemName.contains("chestplate") || itemName.contains("leggings") || itemName.contains("boots")) && random.m_188501_() < 0.7f) {
            tag.m_128405_("FrostAttachment", 1 + random.m_188503_(2));
        }
        if (random.m_188501_() < 0.3f) {
            int randomEffect = random.m_188503_(3);
            switch (randomEffect) {
                case 0: {
                    tag.m_128379_("RootedRepair", true);
                    break;
                }
                case 1: {
                    tag.m_128405_("PatternedRecoating", 1 + random.m_188503_(3));
                    break;
                }
                case 2: {
                    tag.m_128405_("SoulCrushingBone", 1 + random.m_188503_(2));
                }
            }
        }
    }

    public static boolean hasOwnerTags(ItemStack stack) {
        if (stack.m_41619_() || !stack.m_41782_()) {
            return false;
        }
        CompoundTag tag = stack.m_41783_();
        return tag.m_128441_("OwnerUUID") && tag.m_128441_("FrostedItem");
    }

    static {
        TAG_TIERS.put("FrostedItem", 0);
        TAG_TIERS.put("Owner", 0);
        TAG_TIERS.put("OwnerUUID", 0);
        TAG_TIERS.put("ResidualMagic", 1);
        TAG_TIERS.put("DetectionBoost", 1);
        TAG_TIERS.put("RootedRepair", 2);
        TAG_TIERS.put("PatternedRecoating", 2);
        TAG_TIERS.put("SoulCrushingBone", 2);
        TAG_TIERS.put("FrostAttachment", 2);
        TAG_TIERS.put("CloudSoreRush", 3);
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<RandomNbtFunction> {
        public void serialize(JsonObject json, RandomNbtFunction function, JsonSerializationContext context) {
            super.m_6170_(json, (LootItemConditionalFunction)function, context);
            json.addProperty("chance", (Number)Float.valueOf(function.chance));
            json.addProperty("minTags", (Number)function.minTags);
            json.addProperty("maxTags", (Number)function.maxTags);
        }

        public RandomNbtFunction deserialize(JsonObject json, JsonDeserializationContext context, LootItemCondition[] conditions) {
            float chance = GsonHelper.m_13820_((JsonObject)json, (String)"chance", (float)1.0f);
            int minTags = GsonHelper.m_13824_((JsonObject)json, (String)"minTags", (int)1);
            int maxTags = GsonHelper.m_13824_((JsonObject)json, (String)"maxTags", (int)3);
            return new RandomNbtFunction(conditions, chance, minTags, maxTags);
        }
    }
}

