/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.world.storage;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.apache.commons.lang3.mutable.MutableInt;
import org.cryofloric_arts.hao111111111.config.ModConfig;
import org.cryofloric_arts.hao111111111.world.biome.ModBiomes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollenData
extends SavedData {
    private static final Logger LOGGER = LoggerFactory.getLogger(PollenData.class);
    private final Map<ChunkPos, Integer> pollenMap = new HashMap<ChunkPos, Integer>();
    private final Set<ChunkPos> convertedChunks = new HashSet<ChunkPos>();

    public static PollenData get(ServerLevel level) {
        DimensionDataStorage storage = level.m_8895_();
        return (PollenData)storage.m_164861_(PollenData::load, PollenData::new, "cryofloric_pollen_data");
    }

    public int getPollenValue(ChunkPos chunkPos) {
        if (!this.pollenMap.containsKey(chunkPos)) {
            return 0;
        }
        return this.pollenMap.get(chunkPos);
    }

    public void addPollen(ServerLevel level, ChunkPos chunkPos, int amount) {
        int current = this.getPollenValue(chunkPos);
        int newValue = current + amount;
        this.pollenMap.put(chunkPos, newValue);
        this.m_77762_();
        if (newValue >= (Integer)ModConfig.POLLEN_BIOME_CONVERSION_THRESHOLD.get() && !this.convertedChunks.contains(chunkPos) && this.tryConvertToWhiteBarrens(level, chunkPos)) {
            this.convertedChunks.add(chunkPos);
            this.m_77762_();
        }
    }

    public void removePollen(ChunkPos chunkPos, int amount) {
        int current = this.getPollenValue(chunkPos);
        int newValue = Math.max(0, current - amount);
        if (newValue == 0) {
            this.pollenMap.remove(chunkPos);
        } else {
            this.pollenMap.put(chunkPos, newValue);
        }
        this.m_77762_();
    }

    public int getPollenValueAt(BlockPos blockPos) {
        return this.getPollenValue(new ChunkPos(blockPos));
    }

    private boolean tryConvertToWhiteBarrens(ServerLevel level, ChunkPos chunkPos) {
        Holder whiteBarrensHolder = level.m_9598_().m_175515_(Registries.f_256952_).m_203636_(ModBiomes.WHITE_BARRENS).orElse(null);
        if (whiteBarrensHolder == null) {
            LOGGER.error("\u767d\u8352\u6f20\u751f\u7269\u7fa4\u7cfb\u672a\u6ce8\u518c!");
            return false;
        }
        int minY = level.m_141937_();
        int maxY = level.m_151558_();
        BoundingBox boundingBox = BoundingBox.m_162375_((Vec3i)new BlockPos(chunkPos.m_45604_(), minY, chunkPos.m_45605_()), (Vec3i)new BlockPos(chunkPos.m_45608_(), maxY, chunkPos.m_45609_()));
        ChunkAccess chunkAccess = level.m_6522_(chunkPos.f_45578_, chunkPos.f_45579_, ChunkStatus.f_62326_, false);
        if (chunkAccess == null) {
            return false;
        }
        MutableInt count = new MutableInt(0);
        BiomeResolver resolver = (x, y, z, climateSampler) -> {
            Holder currentBiome;
            int blockZ;
            int blockY;
            int blockX = QuartPos.m_175402_((int)x);
            if (boundingBox.m_260866_(blockX, blockY = QuartPos.m_175402_((int)y), blockZ = QuartPos.m_175402_((int)z)) && !(currentBiome = chunkAccess.m_203495_(x, y, z)).m_203565_(ModBiomes.WHITE_BARRENS)) {
                count.increment();
                return whiteBarrensHolder;
            }
            return chunkAccess.m_203495_(x, y, z);
        };
        chunkAccess.m_183442_(resolver, level.m_7726_().m_214994_().m_224579_());
        chunkAccess.m_8092_(true);
        if (chunkAccess instanceof LevelChunk) {
            LevelChunk levelChunk = (LevelChunk)chunkAccess;
            level.m_7726_().f_8325_.m_274524_(Collections.singletonList(levelChunk));
        }
        return count.getValue() > 0;
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag list = new ListTag();
        for (Map.Entry<ChunkPos, Integer> entry : this.pollenMap.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            ChunkPos chunkPos = entry.getKey();
            entryTag.m_128405_("x", chunkPos.f_45578_);
            entryTag.m_128405_("z", chunkPos.f_45579_);
            entryTag.m_128405_("value", entry.getValue().intValue());
            list.add((Object)entryTag);
        }
        nbt.m_128365_("PollenMap", (Tag)list);
        ListTag convertedList = new ListTag();
        for (ChunkPos pos : this.convertedChunks) {
            CompoundTag posTag = new CompoundTag();
            posTag.m_128405_("x", pos.f_45578_);
            posTag.m_128405_("z", pos.f_45579_);
            convertedList.add((Object)posTag);
        }
        nbt.m_128365_("ConvertedChunks", (Tag)convertedList);
        return nbt;
    }

    public static PollenData load(CompoundTag nbt) {
        PollenData data = new PollenData();
        ListTag list = nbt.m_128437_("PollenMap", 10);
        for (Tag tag : list) {
            CompoundTag entryTag = (CompoundTag)tag;
            int x = entryTag.m_128451_("x");
            int z = entryTag.m_128451_("z");
            ChunkPos chunkPos = new ChunkPos(x, z);
            int value = entryTag.m_128451_("value");
            data.pollenMap.put(chunkPos, value);
        }
        if (nbt.m_128425_("ConvertedChunks", 9)) {
            ListTag convertedList = nbt.m_128437_("ConvertedChunks", 10);
            for (Tag tag : convertedList) {
                CompoundTag posTag = (CompoundTag)tag;
                int x = posTag.m_128451_("x");
                int z = posTag.m_128451_("z");
                data.convertedChunks.add(new ChunkPos(x, z));
            }
        }
        return data;
    }

    public static int getExtraPollenValue(LivingEntity entity) {
        if (entity != null) {
            return entity.getPersistentData().m_128451_("ExtraPollen");
        }
        return 0;
    }

    public void forceConvertToWhiteBarrens(ServerLevel level, BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        if (this.tryConvertToWhiteBarrens(level, chunkPos)) {
            this.convertedChunks.add(chunkPos);
            this.m_77762_();
        }
    }

    public int getPollenValueAtWithExtra(BlockPos blockPos, LivingEntity entity) {
        int basePollen = this.getPollenValueAt(blockPos);
        int extraPollen = PollenData.getExtraPollenValue(entity);
        return basePollen + extraPollen;
    }
}

