/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.anvil;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.AnvilUpdateEvent;
import org.cryofloric_arts.hao111111111.advancement.AnvilCraftingTrigger;
import org.cryofloric_arts.hao111111111.anvil.AnvilRecipe;

public class AnvilRecipeRegistry {
    private static final List<AnvilRecipe> RECIPES = new ArrayList<AnvilRecipe>();
    public static final AnvilCraftingTrigger ANVIL_CRAFTING_TRIGGER = new AnvilCraftingTrigger();

    public static void registerRecipe(AnvilRecipe recipe) {
        RECIPES.add(recipe);
    }

    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        Player player = event.getPlayer();
        for (AnvilRecipe recipe : RECIPES) {
            if (!recipe.matches(left, right, player)) continue;
            recipe.apply(event);
            event.setCost(recipe.getCost());
            event.setMaterialCost(recipe.getMaterialCost());
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ANVIL_CRAFTING_TRIGGER.trigger(serverPlayer, recipe.getRecipeId());
            }
            return;
        }
    }
}

