/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.effect.debuff;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.cryofloric_arts.hao111111111.Cryofloric_arts;
import org.cryofloric_arts.hao111111111.blocks.AquaticFrigidGrass;
import org.cryofloric_arts.hao111111111.blocks.ModBlock;
import org.cryofloric_arts.hao111111111.effect.ModEffects;
import org.cryofloric_arts.hao111111111.world.storage.PollenData;

public class FrostPowder
extends MobEffect {
    private static final Random RANDOM = new Random();

    public FrostPowder() {
        super(MobEffectCategory.NEUTRAL, 7844863);
    }

    public static void handleEntityDeath(LivingEntity entity) {
        if (entity.m_21023_((MobEffect)ModEffects.FROST_POWDER.get())) {
            FrostPowder.spawnBloom(entity.m_9236_(), entity.m_20183_());
        }
    }

    public static void handleKill(LivingEntity killer, LivingEntity victim) {
        MobEffectInstance effect;
        if (killer.m_21023_((MobEffect)ModEffects.FROST_POWDER.get()) && (effect = killer.m_21124_((MobEffect)ModEffects.FROST_POWDER.get())) != null) {
            int currentAmplifier = effect.m_19564_();
            int currentDuration = effect.m_19557_();
            if (RANDOM.nextFloat() < 0.5f) {
                int newAmplifier = Math.min(currentAmplifier + 1, 9);
                int newDuration = currentDuration + 3600;
                killer.m_7292_(new MobEffectInstance((MobEffect)ModEffects.FROST_POWDER.get(), newDuration, newAmplifier));
                if (newAmplifier > 3) {
                    killer.m_7292_(new MobEffectInstance((MobEffect)ModEffects.OVER_ROOTING.get(), newDuration, 0));
                }
                if (currentAmplifier >= 9 && RANDOM.nextFloat() < 0.3f) {
                    FrostPowder.addExtraPollenValue(killer, 1);
                }
            }
            FrostPowder.spawnBloom(killer.m_9236_(), victim.m_20183_());
        }
    }

    public static void addExtraPollenValue(LivingEntity entity, int amount) {
        if (entity != null) {
            int currentExtra = entity.getPersistentData().m_128451_("ExtraPollen");
            int newExtra = currentExtra + amount;
            entity.getPersistentData().m_128405_("ExtraPollen", newExtra);
            Cryofloric_arts.LOGGER.debug("\u5b9e\u4f53 {} \u83b7\u5f97 {} \u70b9\u989d\u5916\u82b1\u7c89\u503c\uff0c\u5f53\u524d\u603b\u8ba1: {}", new Object[]{entity.m_7755_().getString(), amount, newExtra});
        }
    }

    private static void spawnBloom(Level level, BlockPos pos) {
        if (!level.f_46443_) {
            BlockPos flowerPos = FrostPowder.findSuitablePosition(level, pos);
            boolean isWater = level.m_6425_(flowerPos).m_192917_((Fluid)Fluids.f_76193_);
            PollenData data = PollenData.get((ServerLevel)level);
            ChunkPos chunkPos = new ChunkPos(pos);
            data.addPollen((ServerLevel)level, chunkPos, 1);
            BlockState flowerState = isWater ? (BlockState)((Block)ModBlock.AQUATIC_FRIGID_GRASS.get()).m_49966_().m_61124_((Property)AquaticFrigidGrass.WATERLOGGED, (Comparable)Boolean.valueOf(true)) : ((Block)ModBlock.ICE_PETAL_DRYAD_BLOOM.get()).m_49966_();
            if (flowerState.m_60710_((LevelReader)level, flowerPos)) {
                level.m_7731_(flowerPos, flowerState, 3);
            }
        }
    }

    private static BlockPos findSuitablePosition(Level level, BlockPos pos) {
        if (level.m_46859_(pos) || level.m_6425_(pos).m_192917_((Fluid)Fluids.f_76193_)) {
            return pos;
        }
        for (BlockPos candidate : BlockPos.m_121925_((BlockPos)pos, (int)2, (int)2, (int)2)) {
            if (!level.m_46859_(candidate) && !level.m_6425_(candidate).m_192917_((Fluid)Fluids.f_76193_)) continue;
            return candidate;
        }
        if (level.m_46859_(pos.m_7494_()) || level.m_6425_(pos.m_7494_()).m_192917_((Fluid)Fluids.f_76193_)) {
            return pos.m_7494_();
        }
        return pos;
    }
}

