/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.item.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.cryofloric_arts.hao111111111.blocks.ModBlock;
import org.cryofloric_arts.hao111111111.effect.ModEffects;
import org.cryofloric_arts.hao111111111.world.storage.PollenData;

public class SoreCloudSubstanceItem
extends Item {
    private static final String GROUND_TIME_KEY = "GroundTime";
    public static final TagKey<Block> CAN_PLANT = BlockTags.create((ResourceLocation)new ResourceLocation("cryofloric_arts", "can_plant"));

    public SoreCloudSubstanceItem(Item.Properties properties) {
        super(properties);
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        Level level = entity.m_9236_();
        if (!level.f_46443_ && entity.m_6084_()) {
            CompoundTag data = entity.getPersistentData();
            int groundTime = data.m_128451_(GROUND_TIME_KEY);
            data.m_128405_(GROUND_TIME_KEY, ++groundTime);
            if (groundTime >= 100) {
                this.explode(entity, stack.m_41613_());
                entity.m_146870_();
                return true;
            }
        }
        return false;
    }

    private void explode(ItemEntity entity, int count) {
        ServerLevel level = (ServerLevel)entity.m_9236_();
        level.m_8767_((ParticleOptions)ParticleTypes.f_123759_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 10 * count, 0.5, 0.5, 0.5, 0.1);
        AABB area = new AABB(entity.m_20183_()).m_82400_(2.0 + (double)count * 0.5);
        level.m_45976_(LivingEntity.class, area).forEach(target -> {
            if (target.m_21023_((MobEffect)ModEffects.SORE_RUSH.get())) {
                MobEffectInstance currentEffect = target.m_21124_((MobEffect)ModEffects.SORE_RUSH.get());
                target.m_7292_(new MobEffectInstance((MobEffect)ModEffects.SORE_RUSH.get(), currentEffect.m_19557_() + 500 * count, currentEffect.m_19564_(), false, false, true));
            } else {
                target.m_7292_(new MobEffectInstance((MobEffect)ModEffects.SORE_RUSH.get(), 500 * count, 0, false, false, true));
            }
            target.m_7292_(new MobEffectInstance((MobEffect)ModEffects.FROST_POWDER.get(), 300, 0, false, false, true));
            target.m_6469_(target.m_269291_().m_269109_(), 5.0f * (float)count);
        });
        BlockPos centerPos = entity.m_20183_();
        for (int i = 0; i < count * 3; ++i) {
            int offsetX = level.f_46441_.m_188503_(5) - 2;
            int offsetZ = level.f_46441_.m_188503_(5) - 2;
            BlockPos plantPos = centerPos.m_7918_(offsetX, 0, offsetZ);
            BlockState belowState = level.m_8055_(plantPos.m_7495_());
            if ((!level.m_46859_(plantPos) || !belowState.m_60713_(Blocks.f_152499_)) && !belowState.m_204336_(BlockTags.f_144274_) && !belowState.m_204336_(CAN_PLANT)) continue;
            level.m_7731_(plantPos, ((Block)ModBlock.SORE_GRASS.get()).m_49966_(), 3);
        }
        PollenData pollenData = PollenData.get(level);
        pollenData.addPollen(level, new ChunkPos(entity.m_20183_()), 10 * count);
    }
}

