/*
 * Decompiled with CFR 0.152.
 */
package net.javaserver.techniphilia.core.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.javaserver.techniphilia.core.common.ModRegistry;
import net.javaserver.techniphilia.core.crafting.CrucibleRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;

public class CrucibleRecipeFactory
implements IRecipeFactory {
    public IRecipe parse(JsonContext jc, JsonObject jo) {
        ItemStack result;
        Ingredient cat;
        Ingredient obj;
        ModRegistry.logger.debug("Resolving techniphilia:crucible recipe");
        JsonElement object = jo.get("object");
        if (object == null) {
            throw new JsonParseException("Recipe must include an object");
        }
        if (object.isJsonPrimitive()) {
            Item resultItem = Item.func_111206_d((String)object.getAsString());
            if (resultItem == null) {
                throw new JsonParseException("Recipe object did not resolve to valid item");
            }
            obj = Ingredient.func_193367_a((Item)resultItem);
        } else if (object.isJsonObject()) {
            obj = CraftingHelper.getIngredient((JsonElement)object.getAsJsonObject(), (JsonContext)jc);
        } else {
            throw new JsonParseException("Recipe object was not of valid JSON type");
        }
        JsonElement catalyst = jo.get("catalyst");
        if (object == null) {
            throw new JsonParseException("Recipe must have a catalyst; otherwise it's a furnace recipe");
        }
        if (catalyst.isJsonPrimitive()) {
            Item resultItem = Item.func_111206_d((String)catalyst.getAsString());
            if (resultItem == null) {
                throw new JsonParseException("Recipe catalyst did not resolve to valid item");
            }
            cat = Ingredient.func_193367_a((Item)resultItem);
        } else if (catalyst.isJsonObject()) {
            cat = CraftingHelper.getIngredient((JsonElement)catalyst.getAsJsonObject(), (JsonContext)jc);
        } else {
            throw new JsonParseException("Recipe catalyst was not of valid JSON type");
        }
        JsonElement resultJson = jo.get("result");
        if (resultJson == null) {
            throw new JsonParseException("Recipe must include result");
        }
        if (resultJson.isJsonPrimitive()) {
            Item resultItem = Item.func_111206_d((String)resultJson.getAsString());
            if (resultItem == null) {
                throw new JsonParseException("Recipe result did not resolve to valid item");
            }
            result = new ItemStack(resultItem);
        } else if (resultJson.isJsonObject()) {
            result = CraftingHelper.getItemStack((JsonObject)resultJson.getAsJsonObject(), (JsonContext)jc);
        } else {
            throw new JsonParseException("Recipe result was not of valid JSON type");
        }
        int reactionTime = 25600;
        JsonElement reacTime = jo.get("time");
        if (reacTime != null) {
            if (!reacTime.isJsonPrimitive()) {
                throw new JsonParseException("Reaction time must be a number");
            }
            reactionTime = reacTime.getAsInt();
            if (reactionTime < 1) {
                throw new JsonParseException("Reaction time must be a positive integer");
            }
        }
        return new CrucibleRecipe(obj, cat, result, reactionTime);
    }
}

