/*
 * Decompiled with CFR 0.152.
 */
package net.javaserver.techniphilia.core.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.javaserver.techniphilia.core.common.ModRegistry;
import net.javaserver.techniphilia.core.crafting.GrindingRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;

public class GrindingRecipeFactory
implements IRecipeFactory {
    public IRecipe parse(JsonContext jc, JsonObject jo) {
        ItemStack result;
        Ingredient input;
        ModRegistry.logger.debug("Resolving techniphilia:grinding recipe");
        JsonElement ingredient = jo.get("ingredient");
        if (ingredient == null) {
            throw new JsonParseException("Recipe must include ingredient");
        }
        if (ingredient.isJsonPrimitive()) {
            Item resultItem = Item.func_111206_d((String)ingredient.getAsString());
            if (resultItem == null) {
                throw new JsonParseException("Recipe ingredient did not resolve to valid item");
            }
            input = Ingredient.func_193367_a((Item)resultItem);
        } else if (ingredient.isJsonObject()) {
            input = CraftingHelper.getIngredient((JsonElement)ingredient.getAsJsonObject(), (JsonContext)jc);
        } else {
            throw new JsonParseException("Recipe ingredient was not of valid JSON type");
        }
        JsonElement resultJson = jo.get("result");
        if (resultJson == null) {
            throw new JsonParseException("Recipe must include grinding result");
        }
        if (resultJson.isJsonPrimitive()) {
            Item resultItem = Item.func_111206_d((String)resultJson.getAsString());
            if (resultItem == null) {
                throw new JsonParseException("Recipe result did not resolve to valid item");
            }
            result = new ItemStack(resultItem);
        } else if (resultJson.isJsonObject()) {
            result = CraftingHelper.getItemStack((JsonObject)resultJson.getAsJsonObject(), (JsonContext)jc);
        } else {
            throw new JsonParseException("Recipe result was not of valid JSON type");
        }
        return new GrindingRecipe(input, result);
    }
}

