/*
 * Decompiled with CFR 0.152.
 */
package net.javaserver.techniphilia.core;

import com.google.common.base.Predicate;
import java.util.Random;
import net.javaserver.techniphilia.core.common.BlockCopperOre;
import net.javaserver.techniphilia.core.config.TechniphiliaCoreConfig;
import net.javaserver.techniphilia.core.config.WorldGenConfig;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;

@Mod(modid="techniphilia-core", name="Techniphilia Core", version="0.3.3.1")
@Mod.EventBusSubscriber
public class ComponentCoreLoader
implements IWorldGenerator {
    private static Logger logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        logger.info("TechniphiliaCore: preinit");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        logger.info("Hello blocky world!");
        GameRegistry.registerWorldGenerator((IWorldGenerator)this, (int)3);
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{BlockCopperOre.instance()});
        OreDictionary.registerOre((String)"oreCopper", (Block)BlockCopperOre.instance());
        OreDictionary.registerOre((String)"oreCopper", (Item)BlockCopperOre.itemBlock());
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{BlockCopperOre.itemBlock()});
    }

    @SubscribeEvent
    public static void registerRenders(ModelRegistryEvent event) {
        ComponentCoreLoader.registerRender((Item)BlockCopperOre.itemBlock());
    }

    private static void registerRender(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "normal"));
    }

    public void generate(Random random, int cx, int cz, World world, IChunkGenerator icg, IChunkProvider icp) {
        int dimension = world.field_73011_w.getDimension();
        for (int bldim : TechniphiliaCoreConfig.worldgen.blacklistedOreDims) {
            if (dimension != bldim) continue;
            return;
        }
        WorldGenMinable ore = new WorldGenMinable(BlockCopperOre.instance().func_176223_P(), WorldGenConfig.copperVeinSizeMin + random.nextInt(WorldGenConfig.copperVeinSizeMax - WorldGenConfig.copperVeinSizeMin), (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
        for (int i = 0; i < WorldGenConfig.copperVeinsPerChunk; ++i) {
            int x = cx * 16 + random.nextInt(16);
            int y = WorldGenConfig.copperVeinMinY + random.nextInt(WorldGenConfig.copperVeinMaxY - WorldGenConfig.copperVeinMinY);
            int z = cz * 16 + random.nextInt(16);
            ore.func_180709_b(world, random, new BlockPos(x, y, z));
        }
    }
}

