/*
 * Decompiled with CFR 0.152.
 */
package net.javaserver.techniphilia.core;

import com.google.common.base.Predicate;
import java.util.Random;
import net.javaserver.techniphilia.core.common.BlockCopper;
import net.javaserver.techniphilia.core.common.BlockCopperOre;
import net.javaserver.techniphilia.core.common.BlockTin;
import net.javaserver.techniphilia.core.common.BlockTinOre;
import net.javaserver.techniphilia.core.common.ItemCopperDust;
import net.javaserver.techniphilia.core.common.ItemCopperIngot;
import net.javaserver.techniphilia.core.common.ItemCopperNugget;
import net.javaserver.techniphilia.core.common.ItemTinDust;
import net.javaserver.techniphilia.core.common.ItemTinIngot;
import net.javaserver.techniphilia.core.common.ItemTinNugget;
import net.javaserver.techniphilia.core.common.ModRegistry;
import net.javaserver.techniphilia.core.config.TechniphiliaCoreConfig;
import net.javaserver.techniphilia.core.config.WorldGenConfig;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="techniphilia-core", name="Techniphilia Core", version="0.5.10.2")
@Mod.EventBusSubscriber
public class ComponentCoreLoader
implements IWorldGenerator {
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ModRegistry.logger = event.getModLog();
        ModRegistry.logger.info("TechniphiliaCore: preinit");
        GameRegistry.addSmelting((Item)BlockCopperOre.itemBlock(), (ItemStack)new ItemStack((Item)ItemCopperIngot.instance()), (float)0.8f);
        GameRegistry.addSmelting((Item)BlockTinOre.itemBlock(), (ItemStack)new ItemStack((Item)ItemTinIngot.instance()), (float)0.9f);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ModRegistry.logger.info("Hello blocky world!");
        GameRegistry.registerWorldGenerator((IWorldGenerator)this, (int)3);
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)BlockCopperOre.instance());
        OreDictionary.registerOre((String)"oreCopper", (Block)BlockCopperOre.instance());
        registry.register((IForgeRegistryEntry)BlockTinOre.instance());
        OreDictionary.registerOre((String)"oreTin", (Block)BlockTinOre.instance());
        registry.register((IForgeRegistryEntry)BlockCopper.instance());
        OreDictionary.registerOre((String)"blockCopper", (Block)BlockCopper.instance());
        registry.register((IForgeRegistryEntry)BlockTin.instance());
        OreDictionary.registerOre((String)"blockTin", (Block)BlockTin.instance());
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)BlockCopperOre.itemBlock());
        OreDictionary.registerOre((String)"oreCopper", (Item)BlockCopperOre.itemBlock());
        registry.register((IForgeRegistryEntry)BlockTinOre.itemBlock());
        OreDictionary.registerOre((String)"oreTin", (Item)BlockTinOre.itemBlock());
        registry.register((IForgeRegistryEntry)ItemCopperIngot.instance());
        OreDictionary.registerOre((String)"ingotCopper", (Item)ItemCopperIngot.instance());
        registry.register((IForgeRegistryEntry)ItemTinIngot.instance());
        OreDictionary.registerOre((String)"ingotTin", (Item)ItemTinIngot.instance());
        registry.register((IForgeRegistryEntry)ItemCopperNugget.instance());
        OreDictionary.registerOre((String)"nuggetCopper", (Item)ItemCopperNugget.instance());
        registry.register((IForgeRegistryEntry)ItemTinNugget.instance());
        OreDictionary.registerOre((String)"nuggetTin", (Item)ItemTinNugget.instance());
        registry.register((IForgeRegistryEntry)BlockCopper.itemBlock());
        OreDictionary.registerOre((String)"blockCopper", (Item)BlockCopper.itemBlock());
        registry.register((IForgeRegistryEntry)BlockTin.itemBlock());
        OreDictionary.registerOre((String)"blockTin", (Item)BlockTin.itemBlock());
        registry.register((IForgeRegistryEntry)ItemCopperDust.instance());
        OreDictionary.registerOre((String)"dustCopper", (Item)ItemCopperDust.instance());
        registry.register((IForgeRegistryEntry)ItemTinDust.instance());
        OreDictionary.registerOre((String)"dustTin", (Item)ItemTinDust.instance());
    }

    @SubscribeEvent
    public static void registerRenders(ModelRegistryEvent event) {
        ComponentCoreLoader.registerRender((Item)BlockCopperOre.itemBlock());
        ComponentCoreLoader.registerRender((Item)BlockTinOre.itemBlock());
        ComponentCoreLoader.registerRender(ItemCopperIngot.instance());
        ComponentCoreLoader.registerRender(ItemTinIngot.instance());
        ComponentCoreLoader.registerRender(ItemCopperNugget.instance());
        ComponentCoreLoader.registerRender(ItemTinNugget.instance());
        ComponentCoreLoader.registerRender((Item)BlockCopper.itemBlock());
        ComponentCoreLoader.registerRender((Item)BlockTin.itemBlock());
        ComponentCoreLoader.registerRender(ItemCopperDust.instance());
        ComponentCoreLoader.registerRender(ItemTinDust.instance());
    }

    private static void registerRender(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "normal"));
    }

    public void generate(Random random, int cx, int cz, World world, IChunkGenerator icg, IChunkProvider icp) {
        int z;
        int y;
        int x;
        int i;
        if (!TechniphiliaCoreConfig.worldgen.enableWorldGen) {
            return;
        }
        int dimension = world.field_73011_w.getDimension();
        for (int bldim : TechniphiliaCoreConfig.worldgen.blacklistedOreDims) {
            if (dimension != bldim) continue;
            return;
        }
        WorldGenMinable ore = new WorldGenMinable(BlockCopperOre.instance().func_176223_P(), WorldGenConfig.copperVeinSizeMin + random.nextInt(WorldGenConfig.copperVeinSizeMax - WorldGenConfig.copperVeinSizeMin), (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
        for (i = 0; i < WorldGenConfig.copperVeinsPerChunk; ++i) {
            x = cx * 16 + random.nextInt(16);
            y = WorldGenConfig.copperVeinMinY + random.nextInt(WorldGenConfig.copperVeinMaxY - WorldGenConfig.copperVeinMinY);
            z = cz * 16 + random.nextInt(16);
            ore.func_180709_b(world, random, new BlockPos(x, y, z));
        }
        ore = new WorldGenMinable(BlockTinOre.instance().func_176223_P(), WorldGenConfig.tinVeinSizeMin + random.nextInt(WorldGenConfig.tinVeinSizeMax - WorldGenConfig.tinVeinSizeMin), (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
        for (i = 0; i < WorldGenConfig.tinVeinsPerChunk; ++i) {
            x = cx * 16 + random.nextInt(16);
            y = WorldGenConfig.tinVeinMinY + random.nextInt(WorldGenConfig.tinVeinMaxY - WorldGenConfig.tinVeinMinY);
            z = cz * 16 + random.nextInt(16);
            ore.func_180709_b(world, random, new BlockPos(x, y, z));
        }
    }
}

