/*
 * Decompiled with CFR 0.152.
 */
package com.maximde.passengerapi;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.PacketEventsAPI;
import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.manager.player.PlayerManager;
import com.github.retrooper.packetevents.manager.protocol.ProtocolManager;
import com.maximde.passengerapi.PassengerActions;
import com.maximde.passengerapi.PassengerManager;
import com.maximde.passengerapi.command.PassengerCommand;
import com.maximde.passengerapi.command.PassengerTabCompleter;
import com.maximde.passengerapi.debugger.DebugEvents;
import com.maximde.passengerapi.listeners.EntityMountListener;
import com.maximde.passengerapi.listeners.EntityUnMountListener;
import com.maximde.passengerapi.listeners.PacketReceiveListener;
import com.maximde.passengerapi.listeners.PacketSendListener;
import com.maximde.passengerapi.listeners.PlayerQuitListener;
import com.maximde.passengerapi.utils.Config;
import com.maximde.passengerapi.utils.Metrics;
import io.github.retrooper.packetevents.factory.spigot.SpigotPacketEventsBuilder;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class PassengerAPI
extends JavaPlugin {
    private PlayerManager playerManager;
    private ProtocolManager protocolManager;
    private static PassengerAPI instance;
    private DebugEvents debugEvents;
    private PassengerManager passengerManager;
    private Config passengerConfig;
    private final ConcurrentHashMap<Player, Integer> vehicles = new ConcurrentHashMap();

    public void onLoad() {
        PacketEvents.setAPI((PacketEventsAPI)SpigotPacketEventsBuilder.build((Plugin)this));
        PacketEvents.getAPI().getSettings().reEncodeByDefault(false).checkForUpdates(false).bStats(true);
        this.playerManager = PacketEvents.getAPI().getPlayerManager();
        this.protocolManager = PacketEvents.getAPI().getProtocolManager();
        PacketEvents.getAPI().getEventManager().registerListener((PacketListener)new PacketSendListener(this), PacketListenerPriority.HIGHEST);
        PacketEvents.getAPI().getEventManager().registerListener((PacketListener)new PacketReceiveListener(this), PacketListenerPriority.HIGHEST);
        PacketEvents.getAPI().load();
    }

    public void onEnable() {
        instance = this;
        PacketEvents.getAPI().init();
        this.passengerConfig = new Config(this.getDataFolder());
        this.passengerManager = new PassengerManager(this.playerManager, this);
        this.debugEvents = new DebugEvents(this);
        this.getCommand("passengerapi").setExecutor((CommandExecutor)new PassengerCommand(this));
        this.getCommand("passengerapi").setTabCompleter((TabCompleter)new PassengerTabCompleter(this));
        this.getServer().getPluginManager().registerEvents((Listener)new EntityUnMountListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EntityMountListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerQuitListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.debugEvents, (Plugin)this);
        new Metrics((Plugin)this, 22033);
    }

    public static PassengerActions getAPI(JavaPlugin plugin) {
        if (instance == null) {
            throw new NullPointerException("The plugin: " + plugin.getDescription().getName() + " Tried to access the passenger api before it has been initialized (Use getAPI in your onEnable() not earlier). Either the depend PassengerAPI in the plugin.yml is missing or the plugin: " + plugin.getDescription().getName() + " shaded the passenger API into the own jar which should never happen!");
        }
        return PassengerAPI.instance.passengerManager.initActions(plugin);
    }

    public void onDisable() {
        PacketEvents.getAPI().terminate();
    }

    public PlayerManager getPlayerManager() {
        return this.playerManager;
    }

    public DebugEvents getDebugEvents() {
        return this.debugEvents;
    }

    public PassengerManager getPassengerManager() {
        return this.passengerManager;
    }

    public Config getPassengerConfig() {
        return this.passengerConfig;
    }

    public ConcurrentHashMap<Player, Integer> getVehicles() {
        return this.vehicles;
    }
}

