/*
 * Decompiled with CFR 0.152.
 */
package com.maximde.passengerapi;

import com.github.retrooper.packetevents.manager.player.PlayerManager;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSetPassengers;
import com.maximde.passengerapi.PassengerAPI;
import com.maximde.passengerapi.PassengerActions;
import com.maximde.passengerapi.events.AsyncAddPassengerEvent;
import com.maximde.passengerapi.events.AsyncPassengerPacketEvent;
import com.maximde.passengerapi.events.AsyncRemovePassengerEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class PassengerManager {
    private final Map<String, Map<Integer, Set<Integer>>> passengersHashmap = new ConcurrentHashMap<String, Map<Integer, Set<Integer>>>();
    private final PlayerManager playerManager;
    private final String PLUGIN_NAME = "PassengerAPI (Internal)";
    private final PassengerAPI passengerAPI;

    public PassengerManager(PlayerManager playerManager, PassengerAPI passengerAPI) {
        this.playerManager = playerManager;
        this.passengerAPI = passengerAPI;
    }

    public PassengerActions initActions(JavaPlugin plugin) {
        String pluginName = plugin.getDescription().getName();
        return new PassengerActionsImpl(pluginName);
    }

    public int getTotalPassengersCount() {
        return this.passengersHashmap.values().stream().flatMap(map -> map.values().stream()).mapToInt(Set::size).sum();
    }

    public int getTotalTargetEntitiesCount() {
        return this.passengersHashmap.values().stream().flatMap(map -> map.keySet().stream()).collect(Collectors.toSet()).size();
    }

    public void removePassenger(boolean async, int targetEntity, int passengerID, boolean sendPackets) {
        AsyncRemovePassengerEvent removePassengerEvent = new AsyncRemovePassengerEvent(async, targetEntity, Set.of(Integer.valueOf(passengerID)), "PassengerAPI (Internal)");
        Bukkit.getPluginManager().callEvent((Event)removePassengerEvent);
        if (removePassengerEvent.isCancelled()) {
            return;
        }
        for (Map<Integer, Set<Integer>> pluginPassengers : this.passengersHashmap.values()) {
            if (pluginPassengers == null) continue;
            Set<Integer> passengers = pluginPassengers.get(targetEntity);
            if (passengers == null) {
                return;
            }
            passengers.remove(passengerID);
            if (!passengers.isEmpty()) continue;
            pluginPassengers.remove(targetEntity);
        }
        if (sendPackets) {
            this.sendPassengerPacket(async, targetEntity);
        }
    }

    public void removePassengers(boolean async, int[] passengerIDs, boolean sendPackets) {
        Set<Integer> passengerSet = Arrays.stream(passengerIDs).boxed().collect(Collectors.toSet());
        AsyncRemovePassengerEvent removePassengerEvent = new AsyncRemovePassengerEvent(async, -1, passengerSet, "PassengerAPI (Internal)");
        Bukkit.getPluginManager().callEvent((Event)removePassengerEvent);
        if (removePassengerEvent.isCancelled()) {
            return;
        }
        HashMap<String, Map<Integer, Set<Integer>>> tempHashmap = new HashMap<String, Map<Integer, Set<Integer>>>(this.passengersHashmap);
        for (Map.Entry entry : tempHashmap.entrySet()) {
            Map pluginMap = (Map)entry.getValue();
            HashMap newPluginMap = new HashMap();
            for (Map.Entry pluginEntry : pluginMap.entrySet()) {
                int targetEntity = (Integer)pluginEntry.getKey();
                HashSet passengers = new HashSet((Collection)pluginEntry.getValue());
                passengers.removeAll(passengerSet);
                if (passengers.isEmpty()) continue;
                newPluginMap.put(targetEntity, passengers);
            }
            if (!newPluginMap.isEmpty()) {
                this.passengersHashmap.put((String)entry.getKey(), newPluginMap);
                continue;
            }
            this.passengersHashmap.remove(entry.getKey());
        }
        if (sendPackets) {
            this.sendPassengerPackets(false);
        }
    }

    public void addPassengers(boolean async, int targetEntity, int[] passengerIDs, boolean sendPackets) {
        Set<Integer> passengerSet = Arrays.stream(passengerIDs).boxed().collect(Collectors.toSet());
        AsyncAddPassengerEvent addPassengerEvent = new AsyncAddPassengerEvent(async, targetEntity, passengerSet, "PassengerAPI (Internal)");
        Bukkit.getPluginManager().callEvent((Event)addPassengerEvent);
        if (addPassengerEvent.isCancelled()) {
            return;
        }
        this.passengersHashmap.computeIfAbsent("PassengerAPI (Internal)", k -> new HashMap()).computeIfAbsent(targetEntity, k -> new HashSet()).addAll(passengerSet);
        if (sendPackets) {
            this.sendPassengerPacket(async, targetEntity);
        }
    }

    private void sendPassengerPackets(boolean async) {
        this.passengersHashmap.keySet().forEach(key -> this.sendPassengerPackets(async, (String)key));
    }

    private void sendPassengerPackets(boolean async, String pluginName) {
        this.passengersHashmap.get(pluginName).keySet().forEach(entity -> this.sendPassengerPacket(async, (int)entity));
    }

    private void sendPassengerPacket(boolean async, int targetEntity) {
        Set<Integer> allPassengersList = this.passengersHashmap.values().stream().filter(map -> map.get(targetEntity) != null).flatMap(map -> ((Set)map.get(targetEntity)).stream().filter(Objects::nonNull)).collect(Collectors.toSet());
        int[] allPassengersArray = allPassengersList.stream().mapToInt(Integer::intValue).toArray();
        ArrayList<Player> receivers = new ArrayList<Player>(Bukkit.getOnlinePlayers());
        AsyncPassengerPacketEvent passengerPacketEvent = new AsyncPassengerPacketEvent(async, targetEntity, allPassengersList, receivers);
        WrapperPlayServerSetPassengers packet = new WrapperPlayServerSetPassengers(targetEntity, allPassengersArray);
        Bukkit.getPluginManager().callEvent((Event)passengerPacketEvent);
        passengerPacketEvent.getPacketReceivers().forEach(player -> this.playerManager.sendPacketSilently(player, (PacketWrapper)packet));
    }

    public Map<String, Map<Integer, Set<Integer>>> getPassengersHashmap() {
        return this.passengersHashmap;
    }

    private class PassengerActionsImpl
    implements PassengerActions {
        private final String pluginName;

        PassengerActionsImpl(String pluginName) {
            this.pluginName = pluginName;
        }

        @Override
        public void addPassenger(boolean async, int targetEntity, int passengerEntity) {
            AsyncAddPassengerEvent addPassengerEvent = new AsyncAddPassengerEvent(async, targetEntity, Set.of(Integer.valueOf(passengerEntity)), this.pluginName);
            Bukkit.getPluginManager().callEvent((Event)addPassengerEvent);
            if (addPassengerEvent.isCancelled()) {
                return;
            }
            PassengerManager.this.passengersHashmap.computeIfAbsent(this.pluginName, k -> new HashMap()).computeIfAbsent(targetEntity, k -> new HashSet()).add(passengerEntity);
            PassengerManager.this.sendPassengerPacket(async, targetEntity);
        }

        @Override
        public void addPassengers(boolean async, int targetEntity, @NotNull Set<Integer> passengerIDs) {
            AsyncAddPassengerEvent addPassengerEvent = new AsyncAddPassengerEvent(async, targetEntity, passengerIDs, this.pluginName);
            Bukkit.getPluginManager().callEvent((Event)addPassengerEvent);
            if (addPassengerEvent.isCancelled()) {
                return;
            }
            PassengerManager.this.passengersHashmap.computeIfAbsent(this.pluginName, k -> new HashMap()).computeIfAbsent(targetEntity, k -> new HashSet()).addAll(passengerIDs);
            PassengerManager.this.sendPassengerPacket(async, targetEntity);
        }

        @Override
        public void addPassengers(boolean async, int targetEntity, int[] passengerIDs) {
            Set<Integer> passengerSet = Arrays.stream(passengerIDs).boxed().collect(Collectors.toSet());
            AsyncAddPassengerEvent addPassengerEvent = new AsyncAddPassengerEvent(async, targetEntity, passengerSet, this.pluginName);
            Bukkit.getPluginManager().callEvent((Event)addPassengerEvent);
            if (addPassengerEvent.isCancelled()) {
                return;
            }
            PassengerManager.this.passengersHashmap.computeIfAbsent(this.pluginName, k -> new HashMap()).computeIfAbsent(targetEntity, k -> new HashSet()).addAll(passengerSet);
            PassengerManager.this.sendPassengerPacket(async, targetEntity);
        }

        @Override
        public void removePassenger(boolean async, int targetEntity, int passengerID) {
            AsyncRemovePassengerEvent removePassengerEvent = new AsyncRemovePassengerEvent(async, targetEntity, Set.of(Integer.valueOf(passengerID)), this.pluginName);
            Bukkit.getPluginManager().callEvent((Event)removePassengerEvent);
            if (removePassengerEvent.isCancelled()) {
                return;
            }
            Map<Integer, Set<Integer>> pluginPassengers = PassengerManager.this.passengersHashmap.get(this.pluginName);
            if (pluginPassengers == null) {
                return;
            }
            Set<Integer> passengers = pluginPassengers.get(targetEntity);
            if (passengers == null) {
                return;
            }
            passengers.remove(passengerID);
            if (passengers.isEmpty()) {
                pluginPassengers.remove(targetEntity);
            }
            PassengerManager.this.sendPassengerPacket(async, targetEntity);
        }

        @Override
        public void removePassenger(boolean async, int passengerID) {
            AsyncRemovePassengerEvent removePassengerEvent = new AsyncRemovePassengerEvent(async, -1, Set.of(Integer.valueOf(passengerID)), this.pluginName);
            Bukkit.getPluginManager().callEvent((Event)removePassengerEvent);
            if (removePassengerEvent.isCancelled()) {
                return;
            }
            PassengerManager.this.passengersHashmap.get(this.pluginName).values().forEach(passengers -> passengers.remove(passengerID));
            PassengerManager.this.sendPassengerPackets(async, this.pluginName);
        }

        @Override
        public void removePassengers(boolean async, int targetEntity, @NotNull Set<Integer> passengerIDs) {
            AsyncRemovePassengerEvent removePassengerEvent = new AsyncRemovePassengerEvent(async, targetEntity, passengerIDs, this.pluginName);
            Bukkit.getPluginManager().callEvent((Event)removePassengerEvent);
            if (removePassengerEvent.isCancelled()) {
                return;
            }
            Map<Integer, Set<Integer>> pluginPassengers = PassengerManager.this.passengersHashmap.get(this.pluginName);
            if (pluginPassengers == null) {
                return;
            }
            Set<Integer> passengers = pluginPassengers.get(targetEntity);
            if (passengers == null) {
                return;
            }
            passengers.removeAll(passengerIDs);
            if (passengers.isEmpty()) {
                pluginPassengers.remove(targetEntity);
            }
            PassengerManager.this.sendPassengerPacket(async, targetEntity);
        }

        @Override
        public void removePassengers(boolean async, int targetEntity, int[] passengerIDs) {
            Set<Integer> passengerSet = Arrays.stream(passengerIDs).boxed().collect(Collectors.toSet());
            AsyncRemovePassengerEvent removePassengerEvent = new AsyncRemovePassengerEvent(async, targetEntity, passengerSet, this.pluginName);
            Bukkit.getPluginManager().callEvent((Event)removePassengerEvent);
            if (removePassengerEvent.isCancelled()) {
                return;
            }
            Map<Integer, Set<Integer>> pluginPassengers = PassengerManager.this.passengersHashmap.get(this.pluginName);
            if (pluginPassengers == null) {
                return;
            }
            Set<Integer> passengers = pluginPassengers.get(targetEntity);
            if (passengers == null) {
                return;
            }
            passengers.removeAll(passengerSet);
            if (passengers.isEmpty()) {
                pluginPassengers.remove(targetEntity);
            }
            PassengerManager.this.sendPassengerPacket(async, targetEntity);
        }

        @Override
        public void removePassengers(boolean async, int[] passengerIDs) {
            Set<Integer> passengerSet = Arrays.stream(passengerIDs).boxed().collect(Collectors.toSet());
            this.removePassengers(async, passengerSet);
        }

        @Override
        public void removePassengers(boolean async, @NotNull Set<Integer> passengerIDs) {
            AsyncRemovePassengerEvent removePassengerEvent = new AsyncRemovePassengerEvent(async, -1, passengerIDs, this.pluginName);
            Bukkit.getPluginManager().callEvent((Event)removePassengerEvent);
            if (removePassengerEvent.isCancelled()) {
                return;
            }
            PassengerManager.this.passengersHashmap.keySet().forEach(key -> {
                PassengerManager.this.passengersHashmap.get(key).values().forEach(passengers -> passengers.removeAll(passengerIDs));
                PassengerManager.this.passengersHashmap.get(key).forEach((target, passengers) -> {
                    passengers.removeAll(passengerIDs);
                    if (PassengerManager.this.passengersHashmap.get(key).get(target).isEmpty()) {
                        PassengerManager.this.passengersHashmap.get(key).remove(target);
                    }
                });
                if (PassengerManager.this.passengersHashmap.get(key).isEmpty()) {
                    PassengerManager.this.passengersHashmap.remove(key);
                }
            });
            PassengerManager.this.sendPassengerPackets(async, this.pluginName);
        }

        @Override
        public void removeAllPassengers(boolean async, int targetEntity) {
            Map<Integer, Set<Integer>> pluginPassengers = PassengerManager.this.passengersHashmap.get(this.pluginName);
            if (pluginPassengers == null) {
                return;
            }
            AsyncRemovePassengerEvent removePassengerEvent = new AsyncRemovePassengerEvent(async, targetEntity, pluginPassengers.get(targetEntity), this.pluginName);
            Bukkit.getPluginManager().callEvent((Event)removePassengerEvent);
            if (removePassengerEvent.isCancelled()) {
                return;
            }
            pluginPassengers.remove(targetEntity, null);
            PassengerManager.this.sendPassengerPacket(async, targetEntity);
        }

        @Override
        public Set<Integer> getPassengers(boolean async, int targetEntity) {
            Map<Integer, Set<Integer>> pluginPassengers = PassengerManager.this.passengersHashmap.get(this.pluginName);
            if (pluginPassengers == null) {
                return Set.of();
            }
            Set<Integer> passengers = pluginPassengers.get(targetEntity);
            return passengers != null ? new HashSet<Integer>(passengers) : Set.of();
        }

        @Override
        public void removeGlobalPassengers(boolean async, int targetEntity, @NotNull Set<Integer> passengerIDs) {
            PassengerManager.this.passengersHashmap.values().forEach(map -> {
                Set passengers = (Set)map.get(targetEntity);
                if (passengers != null) {
                    passengers.removeAll(passengerIDs);
                }
            });
            PassengerManager.this.sendPassengerPacket(async, targetEntity);
        }

        @Override
        public void removeAllGlobalPassengers(boolean async, int targetEntity) {
            PassengerManager.this.passengersHashmap.values().forEach(map -> map.remove(targetEntity));
            PassengerManager.this.sendPassengerPacket(async, targetEntity);
        }

        @Override
        public Set<Integer> getGlobalPassengers(boolean async, int targetEntity) {
            HashSet<Integer> allPassengers = new HashSet<Integer>();
            PassengerManager.this.passengersHashmap.values().forEach(map -> {
                Set passengers = (Set)map.get(targetEntity);
                if (passengers != null) {
                    allPassengers.addAll(passengers);
                }
            });
            return allPassengers;
        }
    }
}

