/*
 * Decompiled with CFR 0.152.
 */
package com.maximde.passengerapi.listeners;

import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientSteerVehicle;
import com.maximde.passengerapi.PassengerAPI;
import com.maximde.passengerapi.events.AsyncPacketBasedVehicleExitEvent;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class PacketReceiveListener
implements PacketListener {
    private final PassengerAPI passengerAPI;

    public PacketReceiveListener(PassengerAPI passengerAPI) {
        this.passengerAPI = passengerAPI;
    }

    public void onPacketReceive(PacketReceiveEvent event) {
        WrapperPlayClientSteerVehicle packet;
        if (event.getPacketType() == PacketType.Play.Client.STEER_VEHICLE && (packet = new WrapperPlayClientSteerVehicle(event)).getFlags() == 2) {
            Player player = (Player)event.getPlayer();
            if (player == null || !this.passengerAPI.getVehicles().containsKey(player)) {
                return;
            }
            int vehicle = this.passengerAPI.getVehicles().get(player);
            AsyncPacketBasedVehicleExitEvent vehicleExitEvent = new AsyncPacketBasedVehicleExitEvent(true, vehicle, player);
            this.passengerAPI.getServer().getPluginManager().callEvent((Event)vehicleExitEvent);
            if (vehicleExitEvent.isCancelled()) {
                return;
            }
            this.passengerAPI.getPassengerManager().removePassenger(true, vehicle, player.getEntityId(), true);
        }
    }
}

