/*
 * Decompiled with CFR 0.152.
 */
package com.maximde.passengerapi.listeners;

import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerDestroyEntities;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSetPassengers;
import com.maximde.passengerapi.PassengerAPI;
import io.github.retrooper.packetevents.util.SpigotConversionUtil;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PacketSendListener
implements PacketListener {
    private final PassengerAPI passengerAPI;

    public PacketSendListener(PassengerAPI passengerAPI) {
        this.passengerAPI = passengerAPI;
    }

    public void onPacketSend(PacketSendEvent event) {
        WrapperPlayServerSetPassengers packet;
        if (event.getPlayer() != null && event.getPacketType() == PacketType.Play.Server.SET_PASSENGERS && this.passengerAPI.getPassengerConfig().isListenToPassengerSet()) {
            packet = new WrapperPlayServerSetPassengers(event);
            for (int passenger : packet.getPassengers()) {
                this.isPlayer(passenger, ((Player)event.getPlayer()).getWorld()).map(player -> this.passengerAPI.getVehicles().put((Player)player, passenger));
            }
            this.passengerAPI.getPassengerManager().addPassengers(true, packet.getEntityId(), packet.getPassengers(), true);
            event.setCancelled(true);
        }
        if (event.getPacketType() == PacketType.Play.Server.DESTROY_ENTITIES && this.passengerAPI.getPassengerConfig().isListenToEntityDestroy()) {
            packet = new WrapperPlayServerDestroyEntities(event);
            this.passengerAPI.getPassengerManager().removePassengers(true, packet.getEntityIds(), false);
        }
    }

    public boolean doesEntityExist(int entityId, World world) {
        return SpigotConversionUtil.getEntityById((World)world, (int)entityId) != null;
    }

    public Optional<Player> isPlayer(int entityId, World world) {
        Entity entity = SpigotConversionUtil.getEntityById((World)world, (int)entityId);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return Optional.of(player);
        }
        return Optional.empty();
    }

    @Deprecated
    private void debugPacket(WrapperPlayServerSetPassengers packet) {
        AtomicReference entity = new AtomicReference();
        Bukkit.getScheduler().runTask((Plugin)this.passengerAPI, t -> {
            Bukkit.getWorld((String)"world").getEntities().forEach(e -> {
                if (e.getEntityId() == packet.getEntityId()) {
                    entity.set(e);
                }
            });
            StringBuilder entityIDs = new StringBuilder();
            for (int passenger : packet.getPassengers()) {
                entityIDs.append(passenger + ", ");
            }
            Bukkit.broadcastMessage((String)(ChatColor.RED + ((Entity)entity.get()).getName() + "  -> " + entityIDs.toString()));
        });
    }
}

