/*
 * Decompiled with CFR 0.152.
 */
package com.maximde.passengerapi.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.bukkit.configuration.file.YamlConfiguration;

public class Config {
    private File file;
    private YamlConfiguration cfg;
    private final File dataFolder;
    private boolean listenToPassengerSet;
    private boolean listenToEntityDestroy;
    private boolean vehicleExitEvent;
    private boolean vehicleExitPacket;

    public Config(File dataFolder) {
        this.dataFolder = dataFolder;
        this.checkConfigs();
        this.loadConfig();
        this.initDefaults();
        this.initValues();
    }

    private void initDefaults() {
        this.setIfNot("AutoPassengerDetection.SetPassengerPacket", true);
        this.setIfNot("AutoPassengerDetection.EntityDestroyPacket", true);
        this.setIfNot("AutoPassengerDetection.VehicleExitEvent", true);
        this.setIfNot("AutoPassengerDetection.VehicleExitPacket", true);
    }

    private void initValues() {
        this.listenToPassengerSet = this.cfg.getBoolean("AutoPassengerDetection.SetPassengerPacket");
        this.listenToEntityDestroy = this.cfg.getBoolean("AutoPassengerDetection.EntityDestroyPacket");
        this.vehicleExitEvent = this.cfg.getBoolean("AutoPassengerDetection.EntityDestroyPacket");
        this.vehicleExitPacket = this.cfg.getBoolean("AutoPassengerDetection.VehicleExitPacket");
    }

    public boolean isConfigEmpty() {
        return this.cfg.getKeys(false).isEmpty();
    }

    private void checkConfigs() {
        File file = new File("plugins/PassengerAPI", "config.yml");
        if (file.exists()) {
            return;
        }
        file.getParentFile().mkdirs();
        try (InputStream inputStream = this.getClass().getResourceAsStream("/config.yml");){
            Files.copy(inputStream, file.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadConfig() {
        this.file = new File("plugins/PassengerAPI", "config.yml");
        this.cfg = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public void reload() {
        this.cfg = YamlConfiguration.loadConfiguration((File)this.file);
        this.initValues();
    }

    public void saveConfig() {
        try {
            this.cfg.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void setIfNot(String path, Object value) {
        if (!this.cfg.isSet(path)) {
            this.setValue(path, value);
        }
    }

    public void setValue(String path, Object value) {
        this.cfg.set(path, value);
    }

    public Object getValue(String path) {
        return this.cfg.get(path);
    }

    public File getFile() {
        return this.file;
    }

    public YamlConfiguration getCfg() {
        return this.cfg;
    }

    public File getDataFolder() {
        return this.dataFolder;
    }

    public boolean isListenToPassengerSet() {
        return this.listenToPassengerSet;
    }

    public boolean isListenToEntityDestroy() {
        return this.listenToEntityDestroy;
    }

    public boolean isVehicleExitEvent() {
        return this.vehicleExitEvent;
    }

    public boolean isVehicleExitPacket() {
        return this.vehicleExitPacket;
    }
}

