/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.yet_another_industrialization.client.component;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.machines.gui.GuiComponentClient;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import aztech.modern_industrialization.machines.guicomponents.ShapeSelection;
import aztech.modern_industrialization.util.Rectangle;
import aztech.modern_industrialization.util.TextHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.luligabi.yet_another_industrialization.common.misc.network.SuppliedShapeSelect;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\rR\u00020\u0000X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lme/luligabi/yet_another_industrialization/client/component/SuppliedShapeSelectionClient;", "Laztech/modern_industrialization/machines/gui/GuiComponentClient;", "buf", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "<init>", "(Lnet/minecraft/network/RegistryFriendlyByteBuf;)V", "lines", "", "Laztech/modern_industrialization/machines/guicomponents/ShapeSelection$LineInfo;", "[Laztech/modern_industrialization/machines/guicomponents/ShapeSelection$LineInfo;", "currentData", "", "renderer", "Lme/luligabi/yet_another_industrialization/client/component/SuppliedShapeSelectionClient$Renderer;", "readCurrentData", "", "createRenderer", "Laztech/modern_industrialization/machines/gui/ClientComponentRenderer;", "machineScreen", "Laztech/modern_industrialization/machines/gui/MachineScreen;", "Renderer", "yet_another_industrialization"})
@SourceDebugExtension(value={"SMAP\nSuppliedShapeSelectionClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SuppliedShapeSelectionClient.kt\nme/luligabi/yet_another_industrialization/client/component/SuppliedShapeSelectionClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,182:1\n1#2:183\n*E\n"})
public final class SuppliedShapeSelectionClient
implements GuiComponentClient {
    @NotNull
    private ShapeSelection.LineInfo[] lines;
    @NotNull
    private int[] currentData;
    private Renderer renderer;

    public SuppliedShapeSelectionClient(@NotNull RegistryFriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        int n = 0;
        int n2 = buf.readVarInt();
        ShapeSelection.LineInfo[] lineInfoArray = new ShapeSelection.LineInfo[n2];
        SuppliedShapeSelectionClient suppliedShapeSelectionClient = this;
        while (n < n2) {
            int n3 = n++;
            lineInfoArray[n3] = new ShapeSelection.LineInfo(0, CollectionsKt.emptyList(), false);
        }
        suppliedShapeSelectionClient.lines = lineInfoArray;
        n2 = this.lines.length;
        for (int i = 0; i < n2; ++i) {
            int numValues = buf.readVarInt();
            List components = new ArrayList();
            for (int j = 0; j < numValues; ++j) {
                Object object = ComponentSerialization.STREAM_CODEC.decode((Object)buf);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.minecraft.network.chat.Component");
                components.add((Component)object);
            }
            this.lines[i] = new ShapeSelection.LineInfo(numValues, components, buf.readBoolean());
        }
        this.currentData = new int[this.lines.length];
        this.readCurrentData(buf);
    }

    public void readCurrentData(@NotNull RegistryFriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        int n = this.currentData.length;
        for (int i = 0; i < n; ++i) {
            this.currentData[i] = buf.readVarInt();
        }
    }

    @NotNull
    public ClientComponentRenderer createRenderer(@Nullable MachineScreen machineScreen) {
        int maxWidth = 1;
        Object object = this.lines;
        int n = ((ShapeSelection.LineInfo[])object).length;
        for (int i = 0; i < n; ++i) {
            ShapeSelection.LineInfo line = object[i];
            for (Component tooltip : line.translations()) {
                maxWidth = Math.max(maxWidth, Minecraft.getInstance().font.width((FormattedText)tooltip));
            }
        }
        Object it = object = new Renderer(maxWidth);
        boolean bl = false;
        this.renderer = it;
        return (ClientComponentRenderer)object;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003J(\u0010\u001b\u001a\u00020\u00112\u000e\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u001d2\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\u0010\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lme/luligabi/yet_another_industrialization/client/component/SuppliedShapeSelectionClient$Renderer;", "Laztech/modern_industrialization/machines/gui/ClientComponentRenderer;", "textMaxWidth", "", "<init>", "(Lme/luligabi/yet_another_industrialization/client/component/SuppliedShapeSelectionClient;I)V", "isPanelOpen", "", "()Z", "setPanelOpen", "(Z)V", "btnSize", "borderSize", "outerPadding", "innerPadding", "panelWidth", "addButtons", "", "container", "Laztech/modern_industrialization/machines/gui/ClientComponentRenderer$ButtonContainer;", "renderBackground", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "leftPos", "topPos", "getBox", "Laztech/modern_industrialization/util/Rectangle;", "addExtraBoxes", "rectangles", "", "getVerticalPos", "lineId", "yet_another_industrialization"})
    public final class Renderer
    implements ClientComponentRenderer {
        private final int textMaxWidth;
        private boolean isPanelOpen;
        private final int btnSize;
        private final int borderSize;
        private final int outerPadding;
        private final int innerPadding;
        private final int panelWidth;

        public Renderer(int textMaxWidth) {
            this.textMaxWidth = textMaxWidth;
            this.btnSize = 12;
            this.borderSize = 3;
            this.outerPadding = 5;
            this.innerPadding = 5;
            this.panelWidth = 25 + this.textMaxWidth + 5 + 12 + 5;
        }

        public final boolean isPanelOpen() {
            return this.isPanelOpen;
        }

        public final void setPanelOpen(boolean bl) {
            this.isPanelOpen = bl;
        }

        public void addButtons(@NotNull ClientComponentRenderer.ButtonContainer container) {
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            int n = SuppliedShapeSelectionClient.this.lines.length;
            for (int i = 0; i < n; ++i) {
                ShapeSelection.LineInfo line = SuppliedShapeSelectionClient.this.lines[i];
                int baseU = line.useArrows() ? 174 : 150;
                int v = 58;
                container.addButton(-this.panelWidth + 3 + 5, this.getVerticalPos(i), 12, 12, arg_0 -> Renderer.addButtons$lambda$0(i, arg_0), Renderer::addButtons$lambda$1, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> Renderer.addButtons$lambda$2(SuppliedShapeSelectionClient.this, i, baseU, v, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5), () -> Renderer.addButtons$lambda$3(this));
                container.addButton(-17, this.getVerticalPos(i), 12, 12, arg_0 -> Renderer.addButtons$lambda$4(i, arg_0), Renderer::addButtons$lambda$5, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> Renderer.addButtons$lambda$6(SuppliedShapeSelectionClient.this, i, line, baseU, v, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5), () -> Renderer.addButtons$lambda$7(this));
            }
            container.addButton(-24, 17, 20, 20, arg_0 -> Renderer.addButtons$lambda$8(this, arg_0), Renderer::addButtons$lambda$9, Renderer::addButtons$lambda$10);
        }

        public void renderBackground(@NotNull GuiGraphics guiGraphics, int leftPos, int topPos) {
            Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
            Rectangle box = this.getBox(leftPos, topPos);
            guiGraphics.blit(MachineScreen.BACKGROUND, box.x(), box.y(), 0, 0, box.w(), box.h() - 4);
            guiGraphics.blit(MachineScreen.BACKGROUND, box.x(), box.y() + box.h() - 4, 0, 252, box.w(), 4);
            if (this.isPanelOpen) {
                RenderSystem.disableDepthTest();
                int n = SuppliedShapeSelectionClient.this.lines.length;
                for (int i = 0; i < n; ++i) {
                    ShapeSelection.LineInfo line = SuppliedShapeSelectionClient.this.lines[i];
                    Object e = line.translations().get(SuppliedShapeSelectionClient.this.currentData[i]);
                    Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type net.minecraft.network.chat.Component");
                    Component tooltip = (Component)e;
                    int width = Minecraft.getInstance().font.width((FormattedText)tooltip);
                    guiGraphics.drawString(Minecraft.getInstance().font, tooltip, box.x() + 3 + 5 + 12 + 5 + (this.textMaxWidth - width) / 2, topPos + this.getVerticalPos(i) + 2, 0x404040, false);
                }
                RenderSystem.enableDepthTest();
            }
        }

        @NotNull
        public final Rectangle getBox(int leftPos, int topPos) {
            if (this.isPanelOpen) {
                int topOffset = 10;
                return new Rectangle(leftPos - this.panelWidth, topPos + topOffset, this.panelWidth, this.getVerticalPos(SuppliedShapeSelectionClient.this.lines.length - 1) - topOffset + 12 + 5 + 3);
            }
            return new Rectangle(leftPos - 31, topPos + 10, 31, 34);
        }

        public void addExtraBoxes(@NotNull List<Rectangle> rectangles, int leftPos, int topPos) {
            Intrinsics.checkNotNullParameter(rectangles, (String)"rectangles");
            rectangles.add(this.getBox(leftPos, topPos));
        }

        private final int getVerticalPos(int lineId) {
            return 46 + 16 * lineId;
        }

        private static final void addButtons$lambda$0(int $i, Integer syncId) {
            Intrinsics.checkNotNull((Object)syncId);
            new SuppliedShapeSelect(syncId, $i, true).sendToServer();
        }

        private static final List addButtons$lambda$1() {
            return new ArrayList();
        }

        private static final void addButtons$lambda$2(SuppliedShapeSelectionClient this$0, int $i, int $baseU, int $v, MachineScreen screen, MachineScreen.MachineButton button, GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
            if (this$0.currentData[$i] == 0) {
                MachineScreen machineScreen = screen;
                Intrinsics.checkNotNull((Object)machineScreen);
                machineScreen.blitButtonNoHighlight((Button)button, guiGraphics, $baseU, $v + 12);
            } else {
                MachineScreen machineScreen = screen;
                Intrinsics.checkNotNull((Object)machineScreen);
                machineScreen.blitButtonSmall((Button)button, guiGraphics, $baseU, $v);
            }
        }

        private static final Boolean addButtons$lambda$3(Renderer this$0) {
            return this$0.isPanelOpen;
        }

        private static final void addButtons$lambda$4(int $i, Integer syncId) {
            Intrinsics.checkNotNull((Object)syncId);
            new SuppliedShapeSelect(syncId, $i, false).sendToServer();
        }

        private static final List addButtons$lambda$5() {
            return new ArrayList();
        }

        private static final void addButtons$lambda$6(SuppliedShapeSelectionClient this$0, int $i, ShapeSelection.LineInfo $line, int $baseU, int $v, MachineScreen screen, MachineScreen.MachineButton button, GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
            if (this$0.currentData[$i] == $line.numValues() - 1) {
                MachineScreen machineScreen = screen;
                Intrinsics.checkNotNull((Object)machineScreen);
                machineScreen.blitButtonNoHighlight((Button)button, guiGraphics, $baseU + 12, $v + 12);
            } else {
                MachineScreen machineScreen = screen;
                Intrinsics.checkNotNull((Object)machineScreen);
                machineScreen.blitButtonSmall((Button)button, guiGraphics, $baseU + 12, $v);
            }
        }

        private static final Boolean addButtons$lambda$7(Renderer this$0) {
            return this$0.isPanelOpen;
        }

        private static final void addButtons$lambda$8(Renderer this$0, Integer n) {
            this$0.isPanelOpen = !this$0.isPanelOpen;
        }

        private static final List addButtons$lambda$9() {
            Object[] objectArray = new MutableComponent[]{MIText.ShapeSelectionTitle.text(), MIText.ShapeSelectionDescription.text().setStyle(TextHelper.GRAY_TEXT)};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        private static final void addButtons$lambda$10(MachineScreen screen, MachineScreen.MachineButton button, GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
            MachineScreen machineScreen = screen;
            Intrinsics.checkNotNull((Object)machineScreen);
            machineScreen.blitButton((Button)button, guiGraphics, 138, 38);
        }
    }
}

