/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.yet_another_industrialization.common.model.multiblock;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty1;
import kotlin.text.StringsKt;
import me.luligabi.yet_another_industrialization.common.model.multiblock.MultiBlockGeometryBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0016\u0018\u0000 -2\u00020\u0001:\u0002-.BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\t0\t\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0004\b\f\u0010\rB5\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0004\b\f\u0010\u0011J\u0006\u0010\u001f\u001a\u00020\u0003J\u0006\u0010 \u001a\u00020\u0003J\b\u0010!\u001a\u00020\u000fH\u0002J\u0014\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u0005H\u0002J\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020\u0003J\u0006\u0010&\u001a\u00020\u0003J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010*\u001a\u00020\u0003H\u0016J\b\u0010+\u001a\u00020\u0006H\u0016J\u0006\u0010,\u001a\u00020\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0013R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013R\u001d\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0015R\u0011\u0010\u001c\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006/"}, d2={"Lme/luligabi/yet_another_industrialization/common/model/multiblock/MultiBlockGeometryBase;", "", "version", "", "ref", "", "", "Lnet/minecraft/world/level/block/state/BlockState;", "shape", "", "scaleToBlocks", "lightEmission", "<init>", "(ILjava/util/Map;Ljava/util/List;II)V", "blocks", "Lnet/minecraft/core/BlockPos;", "Lme/luligabi/yet_another_industrialization/common/model/multiblock/MultiBlockGeometryBase$Voxel;", "(IILjava/util/Map;I)V", "getVersion", "()I", "getRef", "()Ljava/util/Map;", "getShape", "()Ljava/util/List;", "getScaleToBlocks", "getLightEmission", "voxels", "getVoxels", "trunkPos", "getTrunkPos", "()Lnet/minecraft/core/BlockPos;", "getBlockCount", "getStateCount", "getTrunkPosition", "getBlocks", "getSize", "Lnet/minecraft/core/Vec3i;", "getMaxDimension", "getMinDimension", "equals", "", "other", "hashCode", "toString", "serializePretty", "Companion", "Voxel", "yet_another_industrialization"})
@SourceDebugExtension(value={"SMAP\nMultiBlockGeometryBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiBlockGeometryBase.kt\nme/luligabi/yet_another_industrialization/common/model/multiblock/MultiBlockGeometryBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,362:1\n1053#2:363\n1053#2:364\n11165#3:365\n11500#3,3:366\n*S KotlinDebug\n*F\n+ 1 MultiBlockGeometryBase.kt\nme/luligabi/yet_another_industrialization/common/model/multiblock/MultiBlockGeometryBase\n*L\n105#1:363\n149#1:364\n163#1:365\n163#1:366,3\n*E\n"})
public class MultiBlockGeometryBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int version;
    @NotNull
    private final Map<String, BlockState> ref;
    @NotNull
    private final List<List<String>> shape;
    private final int scaleToBlocks;
    private final int lightEmission;
    @NotNull
    private final Map<BlockPos, Voxel> voxels;
    @NotNull
    private final BlockPos trunkPos;
    @NotNull
    private static final MultiBlockGeometryBase EMPTY = new MultiBlockGeometryBase(4, MapsKt.emptyMap(), CollectionsKt.emptyList(), 1, 0);
    @NotNull
    private static final MapCodec<MultiBlockGeometryBase> CODEC;
    @NotNull
    private static final StreamCodec<RegistryFriendlyByteBuf, MultiBlockGeometryBase> STREAM_CODEC;

    public MultiBlockGeometryBase(int version, @NotNull Map<String, ? extends BlockState> ref, @NotNull List<? extends List<String>> shape, int scaleToBlocks, int lightEmission) {
        Intrinsics.checkNotNullParameter(ref, (String)"ref");
        Intrinsics.checkNotNullParameter(shape, (String)"shape");
        this.version = version;
        this.ref = ref;
        this.shape = shape;
        this.scaleToBlocks = scaleToBlocks;
        this.lightEmission = lightEmission;
        this.voxels = this.getBlocks();
        this.trunkPos = this.getTrunkPosition();
    }

    public final int getVersion() {
        return this.version;
    }

    @NotNull
    public final Map<String, BlockState> getRef() {
        return this.ref;
    }

    @NotNull
    public final List<List<String>> getShape() {
        return this.shape;
    }

    public final int getScaleToBlocks() {
        return this.scaleToBlocks;
    }

    public final int getLightEmission() {
        return this.lightEmission;
    }

    @NotNull
    public final Map<BlockPos, Voxel> getVoxels() {
        return this.voxels;
    }

    @NotNull
    public final BlockPos getTrunkPos() {
        return this.trunkPos;
    }

    /*
     * WARNING - void declaration
     */
    public MultiBlockGeometryBase(int scaleToBlocks, int version, @NotNull Map<BlockPos, Voxel> blocks, int lightEmission) {
        void $this$mapTo$iv$iv;
        int stateChar2;
        Map it;
        int n;
        Object object;
        int n2;
        Object object2;
        int n3;
        int n4;
        Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
        Map map = new LinkedHashMap();
        int n5 = version;
        MultiBlockGeometryBase multiBlockGeometryBase = this;
        boolean bl = false;
        int width = 0;
        int height = 0;
        int depth = 0;
        for (BlockPos pos : blocks.keySet()) {
            if (pos.getX() > width) {
                width = pos.getX();
            }
            if (pos.getY() > height) {
                height = pos.getY();
            }
            if (pos.getZ() <= depth) continue;
            depth = pos.getZ();
        }
        HashMap refMap = new HashMap();
        int refChar = 97;
        int n6 = width + 1;
        char[][][] cArrayArray = new char[n6][][];
        for (int i = 0; i < n6; ++i) {
            n4 = i;
            int n7 = 0;
            n3 = height + 1;
            object2 = new char[n3][];
            n2 = n4;
            object = cArrayArray;
            while (n7 < n3) {
                n = n7++;
                object2[n] = new char[depth + 1];
            }
            object[n2] = object2;
        }
        Object blocksAsArray = cArrayArray;
        int x = 0;
        n6 = width;
        if (x <= n6) {
            while (true) {
                int y;
                if ((y = 0) <= (n4 = height)) {
                    while (true) {
                        int z;
                        if ((z = 0) <= (n3 = depth)) {
                            while (true) {
                                blocksAsArray[x][y][z] = 32;
                                if (z == n3) break;
                                ++z;
                            }
                        }
                        if (y == n4) break;
                        ++y;
                    }
                }
                if (x == n6) break;
                ++x;
            }
        }
        Object $this$sortedBy$iv22 = blocks.entrySet();
        boolean $i$f$sortedBy = false;
        for (Object $this$sortedBy$iv22 : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv22, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((BlockPos)it.getKey());
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((BlockPos)it.getKey())));
            }
        })) {
            BlockPos pos = (BlockPos)$this$sortedBy$iv22.getKey();
            Voxel voxel = (Voxel)$this$sortedBy$iv22.getValue();
            BlockState state = voxel.getState();
            if (!refMap.containsKey(state)) {
                Map map2 = refMap;
                int n8 = refChar;
                refChar = (char)(n8 + 1);
                object2 = Character.valueOf((char)n8);
                map2.put(state, object2);
                it.put(String.valueOf((char)refChar), state);
                if (refChar == 123) {
                    refChar = 65;
                }
            }
            Object v = refMap.get(state);
            Intrinsics.checkNotNull(v);
            blocksAsArray[pos.getX()][pos.getY()][pos.getZ()] = stateChar2 = ((Character)v).charValue();
        }
        void var37_61 = it;
        it = new LinkedHashMap();
        boolean bl2 = false;
        width = 0;
        height = 0;
        depth = 0;
        for (BlockPos pos : blocks.keySet()) {
            if (pos.getX() > width) {
                width = pos.getX();
            }
            if (pos.getY() > height) {
                height = pos.getY();
            }
            if (pos.getZ() <= depth) continue;
            depth = pos.getZ();
        }
        int refChar2 = 97;
        int $this$sortedBy$iv22 = width + 1;
        char[][][] pos = new char[$this$sortedBy$iv22][][];
        for (x = 0; x < $this$sortedBy$iv22; ++x) {
            int voxel = x;
            int state = 0;
            stateChar2 = height + 1;
            object2 = new char[stateChar2][];
            n2 = voxel;
            object = pos;
            while (state < stateChar2) {
                n = state++;
                object2[n] = new char[depth + 1];
            }
            object[n2] = object2;
        }
        char[][][] blocksAsArray2 = pos;
        x = 0;
        $this$sortedBy$iv22 = width;
        if (x <= $this$sortedBy$iv22) {
            while (true) {
                int voxel;
                int y;
                if ((y = 0) <= (voxel = height)) {
                    while (true) {
                        int z;
                        if ((z = 0) <= (stateChar2 = depth)) {
                            while (true) {
                                blocksAsArray2[x][y][z] = 32;
                                if (z == stateChar2) break;
                                ++z;
                            }
                        }
                        if (y == voxel) break;
                        ++y;
                    }
                }
                if (x == $this$sortedBy$iv22) break;
                ++x;
            }
        }
        Object $this$sortedBy$iv3 = blocks.entrySet();
        $i$f$sortedBy = false;
        for (Object $this$sortedBy$iv3 : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv3, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((BlockPos)it.getKey());
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((BlockPos)it.getKey())));
            }
        })) {
            BlockPos pos2 = (BlockPos)$this$sortedBy$iv3.getKey();
            Voxel voxel = (Voxel)$this$sortedBy$iv3.getValue();
            BlockState state = voxel.getState();
            if (!it.containsKey(state)) {
                Map stateChar2 = it;
                int n9 = refChar2;
                refChar2 = (char)(n9 + 1);
                object2 = Character.valueOf((char)n9);
                stateChar2.put(state, object2);
                if (refChar2 == 123) {
                    refChar2 = 65;
                }
            }
            Object v = it.get(state);
            Intrinsics.checkNotNull(v);
            blocksAsArray2[pos2.getX()][pos2.getY()][pos2.getZ()] = stateChar2 = (int)((Character)v).charValue();
        }
        Object[] $this$map$iv = (Object[])blocksAsArray2;
        boolean $i$f$map = false;
        Object[] pos2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void x2;
            blocksAsArray = (char[][])item$iv$iv;
            object = destination$iv$iv;
            boolean bl3 = false;
            Object[] $this$map$iv2 = (Object[])x2;
            boolean $i$f$map2 = false;
            Object[] objectArray = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv2.length);
            boolean $i$f$mapTo2 = false;
            for (void item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it2;
                char[] cArray = (char[])item$iv$iv2;
                Collection collection = destination$iv$iv2;
                boolean bl4 = false;
                collection.add(StringsKt.concatToString((char[])it2));
            }
            object.add((List)destination$iv$iv2);
        }
        List list = (List)destination$iv$iv;
        multiBlockGeometryBase(n5, (Map<String, ? extends BlockState>)var37_61, list, scaleToBlocks, lightEmission);
    }

    public final int getBlockCount() {
        return this.voxels.keySet().size();
    }

    public final int getStateCount() {
        return this.ref.keySet().size();
    }

    private final BlockPos getTrunkPosition() {
        Vec3i size = this.getSize();
        BlockPos center = new BlockPos(size.getX() / 2, 0, size.getZ() / 2);
        List roots = new ArrayList();
        if (this.voxels.containsKey(center)) {
            roots.add(center);
        }
        for (BlockPos.MutableBlockPos testPos : BlockPos.spiralAround((BlockPos)center, (int)3, (Direction)Direction.EAST, (Direction)Direction.NORTH)) {
            if (!this.voxels.containsKey(testPos)) continue;
            Voxel voxel = this.voxels.get(testPos);
            Intrinsics.checkNotNull((Object)voxel);
            BlockState state = voxel.getState();
            if (state.isAir() || state.is(Blocks.WATER) || state.is(BlockTags.LEAVES)) continue;
            roots.add(new BlockPos(testPos.getX(), 0, testPos.getZ()));
        }
        if (roots.isEmpty()) {
            return center;
        }
        if (roots.size() == 1) {
            return (BlockPos)CollectionsKt.first((List)roots);
        }
        if (roots.size() >= 4) {
            return center;
        }
        int x = 0;
        int z = 0;
        for (BlockPos root : roots) {
            x += root.getX();
            z += root.getZ();
        }
        BlockPos newCenter = new BlockPos(x / roots.size(), 0, z / roots.size());
        return newCenter;
    }

    private final Map<BlockPos, Voxel> getBlocks() {
        HashMap blocks = new HashMap();
        int n = ((Collection)this.shape).size();
        for (int x = 0; x < n; ++x) {
            List<String> slice = this.shape.get(x);
            for (int y = slice.size() - 1; -1 < y; --y) {
                String row = slice.get(y);
                int n2 = ((CharSequence)row).length();
                for (int z = 0; z < n2; ++z) {
                    BlockState state;
                    String key;
                    Intrinsics.checkNotNullExpressionValue((Object)row.substring(z, z + 1), (String)"substring(...)");
                    if (Intrinsics.areEqual((Object)key, (Object)" ") || (state = this.ref.get(key)) == null) continue;
                    BlockPos pos = new BlockPos(this.shape.size() - 1 - x, slice.size() - 1 - y, z);
                    ((Map)blocks).put(pos, new Voxel(pos, state));
                }
            }
        }
        return blocks;
    }

    @NotNull
    public final Vec3i getSize() {
        int maxX = 0;
        int maxY = 0;
        int maxZ = 0;
        for (Voxel voxel : this.voxels.values()) {
            BlockPos pos = voxel.getPos();
            maxX = Math.max(maxX, pos.getX());
            maxY = Math.max(maxY, pos.getY());
            maxZ = Math.max(maxZ, pos.getZ());
        }
        return new Vec3i(maxX, maxY, maxZ);
    }

    public final int getMaxDimension() {
        Vec3i size = this.getSize();
        return Math.max(size.getX(), Math.max(size.getY(), size.getZ()));
    }

    public final int getMinDimension() {
        Vec3i size = this.getSize();
        return Math.min(size.getX(), Math.min(size.getY(), size.getZ()));
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(other.getClass(), this.getClass())) {
            return false;
        }
        MultiBlockGeometryBase that = (MultiBlockGeometryBase)other;
        return this.version == that.version && Intrinsics.areEqual(this.ref, that.ref) && Intrinsics.areEqual(this.shape, that.shape) && this.scaleToBlocks == that.scaleToBlocks;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.version, this.ref, this.shape, this.scaleToBlocks};
        return Objects.hash(objectArray);
    }

    @NotNull
    public String toString() {
        return "MultiBlockModelGeometry[version=" + this.version + ", ref=" + this.ref + ", shape=" + this.shape + ", scaleToBlocks=" + this.scaleToBlocks + "]";
    }

    @NotNull
    public final String serializePretty() {
        if (this.getSize().getX() + 1 == 0 || this.getSize().getY() + 1 == 0 || this.getSize().getZ() + 1 == 0) {
            return "";
        }
        int n = this.getSize().getX() + 1;
        char[][][] cArrayArray = new char[n][][];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            int n3 = 0;
            int n4 = this.getSize().getY() + 1;
            char[][] cArrayArray2 = new char[n4][];
            int n5 = n2;
            char[][][] cArrayArray3 = cArrayArray;
            while (n3 < n4) {
                int n6 = n3++;
                cArrayArray2[n6] = new char[this.getSize().getZ() + 1];
            }
            cArrayArray3[n5] = cArrayArray2;
        }
        char[][][] map = cArrayArray;
        StringBuilder refMapBuilder = new StringBuilder();
        refMapBuilder.append("  \"ref\": {\n");
        char nextRef = 'a';
        HashMap refMap = new HashMap();
        for (Map.Entry<BlockPos, Voxel> entry : this.voxels.entrySet()) {
            String jsonString;
            BlockPos pos = entry.getKey();
            Voxel voxel = entry.getValue();
            BlockState state = voxel.getState();
            Intrinsics.checkNotNullExpressionValue((Object)((JsonElement)BlockState.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)state).result().get()).toString(), (String)"toString(...)");
            char thisRef = '\u0000';
            if (refMap.containsKey(jsonString)) {
                Object v = refMap.get(jsonString);
                Intrinsics.checkNotNull(v);
                thisRef = ((Character)v).charValue();
            } else {
                char c = nextRef;
                nextRef = (char)(c + 1);
                thisRef = c;
                if (nextRef == '{') {
                    nextRef = 'A';
                }
                Character c2 = Character.valueOf(thisRef);
                ((Map)refMap).put(jsonString, c2);
                refMapBuilder.append("    \"" + thisRef + "\": " + jsonString + ",\n");
            }
            map[pos.getX()][pos.getY()][pos.getZ()] = thisRef;
        }
        refMapBuilder.deleteCharAt(refMapBuilder.length() - 2);
        refMapBuilder.append("  },\n");
        StringBuilder output = new StringBuilder("{\n");
        output.append("  \"loader\": \"bonsaitrees4:multiblockmodel\",\n");
        output.append("  \"version\": 4,\n");
        output.append((CharSequence)refMapBuilder);
        output.append("  \"shape\": [\n");
        for (int x = ((Object[])map).length - 1; -1 < x; --x) {
            output.append("    [\n");
            for (int y = ((Object[])map[x]).length - 1; -1 < y; --y) {
                StringBuilder builder = new StringBuilder();
                int n7 = map[x][y].length;
                for (int z = 0; z < n7; ++z) {
                    char chr = ' ';
                    if (map[x][y][z] != '\u0000') {
                        chr = map[x][y][z];
                    }
                    builder.append(chr);
                }
                output.append("      \"" + builder + "\",\n");
            }
            output.deleteCharAt(output.length() - 2);
            output.append("    ],\n");
        }
        output.deleteCharAt(output.length() - 2);
        output.append("  ]\n}\n");
        String string = output.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final Integer CODEC$lambda$11$lambda$6(KProperty1 $tmp0, MultiBlockGeometryBase p0) {
        return (Integer)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Map CODEC$lambda$11$lambda$7(KProperty1 $tmp0, MultiBlockGeometryBase p0) {
        return (Map)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final List CODEC$lambda$11$lambda$8(KProperty1 $tmp0, MultiBlockGeometryBase p0) {
        return (List)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Integer CODEC$lambda$11$lambda$9(KProperty1 $tmp0, MultiBlockGeometryBase p0) {
        return (Integer)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Integer CODEC$lambda$11$lambda$10(KProperty1 $tmp0, MultiBlockGeometryBase p0) {
        return (Integer)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final App CODEC$lambda$11(RecordCodecBuilder.Instance instance) {
        return instance.group((App)Codec.INT.fieldOf("version").forGetter(arg_0 -> MultiBlockGeometryBase.CODEC$lambda$11$lambda$6((KProperty1)Companion.CODEC.1.1.INSTANCE, arg_0)), (App)Codec.unboundedMap((Codec)((Codec)Codec.STRING), (Codec)BlockState.CODEC).fieldOf("ref").forGetter(arg_0 -> MultiBlockGeometryBase.CODEC$lambda$11$lambda$7((KProperty1)Companion.CODEC.1.2.INSTANCE, arg_0)), (App)Codec.list((Codec)Codec.list((Codec)((Codec)Codec.STRING))).fieldOf("shape").forGetter(arg_0 -> MultiBlockGeometryBase.CODEC$lambda$11$lambda$8((KProperty1)Companion.CODEC.1.3.INSTANCE, arg_0)), (App)Codec.INT.optionalFieldOf("scaleToBlocks", (Object)1).forGetter(arg_0 -> MultiBlockGeometryBase.CODEC$lambda$11$lambda$9((KProperty1)Companion.CODEC.1.4.INSTANCE, arg_0)), (App)Codec.INT.optionalFieldOf("lightEmission", (Object)0).forGetter(arg_0 -> MultiBlockGeometryBase.CODEC$lambda$11$lambda$10((KProperty1)Companion.CODEC.1.5.INSTANCE, arg_0))).apply((Applicative)instance, MultiBlockGeometryBase::new);
    }

    private static final Integer STREAM_CODEC$lambda$12(KProperty1 $tmp0, MultiBlockGeometryBase p0) {
        return (Integer)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Map STREAM_CODEC$lambda$13(KProperty1 $tmp0, MultiBlockGeometryBase p0) {
        return (Map)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final List STREAM_CODEC$lambda$14(KProperty1 $tmp0, MultiBlockGeometryBase p0) {
        return (List)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Integer STREAM_CODEC$lambda$15(KProperty1 $tmp0, MultiBlockGeometryBase p0) {
        return (Integer)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Integer STREAM_CODEC$lambda$16(KProperty1 $tmp0, MultiBlockGeometryBase p0) {
        return (Integer)((Function1)$tmp0).invoke((Object)p0);
    }

    static {
        MapCodec mapCodec = RecordCodecBuilder.mapCodec(MultiBlockGeometryBase::CODEC$lambda$11);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"mapCodec(...)");
        CODEC = mapCodec;
        StreamCodec streamCodec = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, arg_0 -> MultiBlockGeometryBase.STREAM_CODEC$lambda$12((KProperty1)Companion.STREAM_CODEC.1.INSTANCE, arg_0), (StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.STRING_UTF8, (StreamCodec)ByteBufCodecs.fromCodecWithRegistries((Codec)BlockState.CODEC)), arg_0 -> MultiBlockGeometryBase.STREAM_CODEC$lambda$13((KProperty1)Companion.STREAM_CODEC.3.INSTANCE, arg_0), (StreamCodec)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs.list()).apply(ByteBufCodecs.list()), arg_0 -> MultiBlockGeometryBase.STREAM_CODEC$lambda$14((KProperty1)Companion.STREAM_CODEC.4.INSTANCE, arg_0), (StreamCodec)ByteBufCodecs.INT, arg_0 -> MultiBlockGeometryBase.STREAM_CODEC$lambda$15((KProperty1)Companion.STREAM_CODEC.5.INSTANCE, arg_0), (StreamCodec)ByteBufCodecs.INT, arg_0 -> MultiBlockGeometryBase.STREAM_CODEC$lambda$16((KProperty1)Companion.STREAM_CODEC.6.INSTANCE, arg_0), MultiBlockGeometryBase::new);
        Intrinsics.checkNotNullExpressionValue((Object)streamCodec, (String)"composite(...)");
        STREAM_CODEC = streamCodec;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00160\u0012J\"\u0010\u0017\u001a\u00020\u00052\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00160\u00122\u0006\u0010\u0018\u001a\u00020\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00050\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lme/luligabi/yet_another_industrialization/common/model/multiblock/MultiBlockGeometryBase$Companion;", "", "<init>", "()V", "EMPTY", "Lme/luligabi/yet_another_industrialization/common/model/multiblock/MultiBlockGeometryBase;", "getEMPTY", "()Lme/luligabi/yet_another_industrialization/common/model/multiblock/MultiBlockGeometryBase;", "CODEC", "Lcom/mojang/serialization/MapCodec;", "getCODEC", "()Lcom/mojang/serialization/MapCodec;", "STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "getSTREAM_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "castVoxelMap", "", "Lnet/minecraft/core/BlockPos;", "Lme/luligabi/yet_another_industrialization/common/model/multiblock/MultiBlockGeometryBase$Voxel;", "blocks", "Lnet/minecraft/world/level/block/state/BlockState;", "forDataGen", "lightEmission", "", "yet_another_industrialization"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MultiBlockGeometryBase getEMPTY() {
            return EMPTY;
        }

        @NotNull
        public final MapCodec<MultiBlockGeometryBase> getCODEC() {
            return CODEC;
        }

        @NotNull
        public final StreamCodec<RegistryFriendlyByteBuf, MultiBlockGeometryBase> getSTREAM_CODEC() {
            return STREAM_CODEC;
        }

        @NotNull
        public final Map<BlockPos, Voxel> castVoxelMap(@NotNull Map<BlockPos, ? extends BlockState> blocks) {
            Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
            HashMap voxels = new HashMap();
            for (Map.Entry<BlockPos, ? extends BlockState> entry : blocks.entrySet()) {
                BlockPos pos = entry.getKey();
                BlockState state = entry.getValue();
                ((Map)voxels).put(pos, new Voxel(pos, state));
            }
            return voxels;
        }

        @NotNull
        public final MultiBlockGeometryBase forDataGen(@NotNull Map<BlockPos, ? extends BlockState> blocks, int lightEmission) {
            Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
            return new MultiBlockGeometryBase(1, 4, this.castVoxelMap(blocks), lightEmission);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\f\u001a\u00020\rJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lme/luligabi/yet_another_industrialization/common/model/multiblock/MultiBlockGeometryBase$Voxel;", "", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "getPos", "()Lnet/minecraft/core/BlockPos;", "getState", "()Lnet/minecraft/world/level/block/state/BlockState;", "model", "Lnet/minecraft/client/resources/model/BakedModel;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "yet_another_industrialization"})
    public static final class Voxel {
        @NotNull
        private final BlockPos pos;
        @NotNull
        private final BlockState state;

        public Voxel(@NotNull BlockPos pos, @NotNull BlockState state) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            this.pos = pos;
            this.state = state;
        }

        @NotNull
        public final BlockPos getPos() {
            return this.pos;
        }

        @NotNull
        public final BlockState getState() {
            return this.state;
        }

        @NotNull
        public final BakedModel model() {
            BakedModel bakedModel = Minecraft.getInstance().getModelManager().getBlockModelShaper().getBlockModel(this.state);
            Intrinsics.checkNotNullExpressionValue((Object)bakedModel, (String)"getBlockModel(...)");
            return bakedModel;
        }

        @NotNull
        public final BlockPos component1() {
            return this.pos;
        }

        @NotNull
        public final BlockState component2() {
            return this.state;
        }

        @NotNull
        public final Voxel copy(@NotNull BlockPos pos, @NotNull BlockState state) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            return new Voxel(pos, state);
        }

        public static /* synthetic */ Voxel copy$default(Voxel voxel, BlockPos blockPos, BlockState blockState, int n, Object object) {
            if ((n & 1) != 0) {
                blockPos = voxel.pos;
            }
            if ((n & 2) != 0) {
                blockState = voxel.state;
            }
            return voxel.copy(blockPos, blockState);
        }

        @NotNull
        public String toString() {
            return "Voxel(pos=" + this.pos + ", state=" + this.state + ")";
        }

        public int hashCode() {
            int result = this.pos.hashCode();
            result = result * 31 + this.state.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Voxel)) {
                return false;
            }
            Voxel voxel = (Voxel)other;
            if (!Intrinsics.areEqual((Object)this.pos, (Object)voxel.pos)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.state, (Object)voxel.state);
        }
    }
}

