/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.yet_another_industrialization.datagen.server.provider.recipe;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.definition.FluidLike;
import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.machines.recipe.condition.MachineProcessCondition;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import me.luligabi.yet_another_industrialization.common.YAI;
import me.luligabi.yet_another_industrialization.common.block.YAIBlocks;
import me.luligabi.yet_another_industrialization.common.block.machine.YAIMachines;
import me.luligabi.yet_another_industrialization.common.block.machine.arboreous_greenhouse.ArboreousGreenhouseTierCondition;
import me.luligabi.yet_another_industrialization.common.block.machine.dragon_siphon.EnergyGenerationCondition;
import me.luligabi.yet_another_industrialization.common.item.MachineDiagnoserItem;
import me.luligabi.yet_another_industrialization.common.item.YAIItems;
import me.luligabi.yet_another_industrialization.common.misc.YAIFluids;
import me.luligabi.yet_another_industrialization.common.misc.YAITags;
import me.luligabi.yet_another_industrialization.common.misc.material.YAIMaterialRegistry;
import me.luligabi.yet_another_industrialization.common.misc.material.YAIMaterials;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.swedz.tesseract.neoforge.compat.mi.material.MIMaterials;
import net.swedz.tesseract.neoforge.compat.mi.material.part.MIMaterialParts;
import net.swedz.tesseract.neoforge.compat.mi.recipe.MIMachineRecipeBuilder;
import net.swedz.tesseract.neoforge.compat.vanilla.recipe.ShapedRecipeBuilder;
import net.swedz.tesseract.neoforge.compat.vanilla.recipe.ShapelessRecipeBuilder;
import net.swedz.tesseract.neoforge.material.Material;
import net.swedz.tesseract.neoforge.registry.holder.ItemHolder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 42\u00020\u0001:\u00014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002Jd\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u001e\u0010\b\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u00180\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\tH\u0002J\u0018\u0010\u001f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J@\u0010 \u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\tH\u0002J\u0018\u0010$\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010%\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010&\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J<\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u00112\u0006\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\u00192\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020\u00070,2\u0006\u0010\b\u001a\u00020\tH\u0002JF\u0010.\u001a\u00020\u00072\u0006\u0010/\u001a\u00020\u00112\u0006\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\u00192\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\u00070,2\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u00101\u001a\u000202H\u0002J<\u00103\u001a\u00020\u00072\u0006\u0010/\u001a\u00020\u00112\u0006\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\u00192\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\u00070,2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u00065"}, d2={"Lme/luligabi/yet_another_industrialization/datagen/server/provider/recipe/RecipeProvider;", "Lnet/minecraft/data/recipes/RecipeProvider;", "event", "Lnet/neoforged/neoforge/data/event/GatherDataEvent;", "<init>", "(Lnet/neoforged/neoforge/data/event/GatherDataEvent;)V", "buildRecipes", "", "output", "Lnet/minecraft/data/recipes/RecipeOutput;", "lookup", "Lnet/minecraft/core/HolderLookup$Provider;", "buildItemRecipes", "buildMachineRecipes", "buildManualArboreousGreenhouseRecipes", "addArboreousGreenhouseRecipe", "id", "", "input", "Lnet/minecraft/world/level/ItemLike;", "fluid", "Lnet/minecraft/world/level/material/Fluid;", "nutrientFluid", "", "Lkotlin/Triple;", "", "", "tier", "Lnet/minecraft/resources/ResourceLocation;", "model", "recipeOutput", "buildCryogenicPrecipitatorRecipes", "addCryogenicPrecipitatorRecipe", "fluidAmount", "cryofluidAmount", "outputAmount", "buildDragonSiphonRecipes", "buildPartRecipes", "buildFluidRecipes", "shapeless", "name", "result", "resultCount", "crafting", "Lkotlin/Function1;", "Lnet/swedz/tesseract/neoforge/compat/vanilla/recipe/ShapelessRecipeBuilder;", "shaped", "path", "Lnet/swedz/tesseract/neoforge/compat/vanilla/recipe/ShapedRecipeBuilder;", "registerForAssembler", "", "assembler", "Companion", "yet_another_industrialization"})
@SourceDebugExtension(value={"SMAP\nRecipeProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecipeProvider.kt\nme/luligabi/yet_another_industrialization/datagen/server/provider/recipe/RecipeProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,779:1\n1863#2,2:780\n1863#2,2:782\n*S KotlinDebug\n*F\n+ 1 RecipeProvider.kt\nme/luligabi/yet_another_industrialization/datagen/server/provider/recipe/RecipeProvider\n*L\n348#1:780,2\n369#1:782,2\n*E\n"})
public final class RecipeProvider
extends net.minecraft.data.recipes.RecipeProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public RecipeProvider(@NotNull GatherDataEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        super(event.getGenerator().getPackOutput(), event.getLookupProvider());
    }

    protected void buildRecipes(@NotNull RecipeOutput output, @NotNull HolderLookup.Provider lookup) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        this.buildItemRecipes(output, lookup);
        this.buildMachineRecipes(output, lookup);
        this.buildPartRecipes(output, lookup);
        this.buildFluidRecipes(output, lookup);
        for (Material material : YAIMaterials.INSTANCE.values()) {
            YAIMaterialRegistry.INSTANCE.createRecipesFor(material, output);
        }
    }

    private final void buildItemRecipes(RecipeOutput output, HolderLookup.Provider lookup) {
        Item item = YAIItems.INSTANCE.getGUIDEBOOK().get();
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"get(...)");
        this.shapeless("guidebook", (ItemLike)item, 1, (Function1<? super ShapelessRecipeBuilder, Unit>)((Function1)RecipeProvider::buildItemRecipes$lambda$0), output);
        ItemHolder<MachineDiagnoserItem> itemHolder = YAIItems.INSTANCE.getMACHINE_DIAGNOSER();
        Intrinsics.checkNotNullExpressionValue(itemHolder, (String)"<get-MACHINE_DIAGNOSER>(...)");
        RecipeProvider.shaped$default(this, "machine_diagnoser", (ItemLike)itemHolder, 1, RecipeProvider::buildItemRecipes$lambda$1, output, false, 32, null);
        MachineRecipeType machineRecipeType = MIMachineRecipeTypes.ASSEMBLER;
        Intrinsics.checkNotNullExpressionValue((Object)machineRecipeType, (String)"ASSEMBLER");
        Companion.addMachineRecipe("assembler/storage_slot_locker", machineRecipeType, 8, 200, (Function1<? super MIMachineRecipeBuilder, Unit>)((Function1)RecipeProvider::buildItemRecipes$lambda$2), output);
        MachineRecipeType machineRecipeType2 = MIMachineRecipeTypes.ASSEMBLER;
        Intrinsics.checkNotNullExpressionValue((Object)machineRecipeType2, (String)"ASSEMBLER");
        Companion.addMachineRecipe("assembler/machine_remover", machineRecipeType2, 8, 200, (Function1<? super MIMachineRecipeBuilder, Unit>)((Function1)RecipeProvider::buildItemRecipes$lambda$3), output);
        MachineRecipeType machineRecipeType3 = MIMachineRecipeTypes.CHEMICAL_REACTOR;
        Intrinsics.checkNotNullExpressionValue((Object)machineRecipeType3, (String)"CHEMICAL_REACTOR");
        Companion.addMachineRecipe("chemical_reactor/cachaca", machineRecipeType3, 6, 140, (Function1<? super MIMachineRecipeBuilder, Unit>)((Function1)RecipeProvider::buildItemRecipes$lambda$4), output);
        MachineRecipeType machineRecipeType4 = MIMachineRecipeTypes.CHEMICAL_REACTOR;
        Intrinsics.checkNotNullExpressionValue((Object)machineRecipeType4, (String)"CHEMICAL_REACTOR");
        Companion.addMachineRecipe("chemical_reactor/ai_slop", machineRecipeType4, 256, 140, (Function1<? super MIMachineRecipeBuilder, Unit>)((Function1)RecipeProvider::buildItemRecipes$lambda$5), output);
        MachineRecipeType machineRecipeType5 = MIMachineRecipeTypes.PACKER;
        Intrinsics.checkNotNullExpressionValue((Object)machineRecipeType5, (String)"PACKER");
        Companion.addMachineRecipe("packer/ultradense_metal_ball_burger", machineRecipeType5, 2, 100, (Function1<? super MIMachineRecipeBuilder, Unit>)((Function1)RecipeProvider::buildItemRecipes$lambda$6), output);
    }

    private final void buildMachineRecipes(RecipeOutput output, HolderLookup.Provider lookup) {
        RecipeProvider.shaped$default(this, "arboreous_greenhouse", (ItemLike)YAIMachines.INSTANCE.getMachineFromId("arboreous_greenhouse"), 1, RecipeProvider::buildMachineRecipes$lambda$7, output, false, 32, null);
        this.buildManualArboreousGreenhouseRecipes(output, lookup);
        RecipeProvider.shaped$default(this, "cryogenic_precipitator", (ItemLike)YAIMachines.INSTANCE.getMachineFromId("cryogenic_precipitator"), 1, RecipeProvider::buildMachineRecipes$lambda$8, output, false, 32, null);
        this.buildCryogenicPrecipitatorRecipes(output, lookup);
        RecipeProvider.shaped$default(this, "dragon_egg_energy_siphon", (ItemLike)YAIMachines.INSTANCE.getMachineFromId("dragon_egg_energy_siphon"), 1, RecipeProvider::buildMachineRecipes$lambda$9, output, false, 32, null);
        this.buildDragonSiphonRecipes(output, lookup);
        RecipeProvider.shaped$default(this, "large_storage_unit", (ItemLike)YAIMachines.INSTANCE.getMachineFromId("large_storage_unit"), 1, RecipeProvider::buildMachineRecipes$lambda$10, output, false, 32, null);
        RecipeProvider.shaped$default(this, "large_storage_unit_input_hatch", (ItemLike)YAIMachines.INSTANCE.getMachineFromId("large_storage_unit_input_hatch"), 1, RecipeProvider::buildMachineRecipes$lambda$11, output, false, 32, null);
        RecipeProvider.shaped$default(this, "large_storage_unit_output_hatch", (ItemLike)YAIMachines.INSTANCE.getMachineFromId("large_storage_unit_output_hatch"), 1, RecipeProvider::buildMachineRecipes$lambda$12, output, false, 32, null);
        this.shapeless("large_storage_unit_input_hatch_convert", (ItemLike)YAIMachines.INSTANCE.getMachineFromId("large_storage_unit_input_hatch"), 1, (Function1<? super ShapelessRecipeBuilder, Unit>)((Function1)RecipeProvider::buildMachineRecipes$lambda$13), output);
        this.shapeless("large_storage_unit_output_hatch_convert", (ItemLike)YAIMachines.INSTANCE.getMachineFromId("large_storage_unit_output_hatch"), 1, (Function1<? super ShapelessRecipeBuilder, Unit>)((Function1)RecipeProvider::buildMachineRecipes$lambda$14), output);
        RecipeProvider.shaped$default(this, "configurable_mixed_storage", (ItemLike)YAIMachines.INSTANCE.getMachineFromId("configurable_mixed_storage"), 4, RecipeProvider::buildMachineRecipes$lambda$15, output, false, 32, null);
        this.shaped("configurable_mixed_storage_alt", (ItemLike)YAIMachines.INSTANCE.getMachineFromId("configurable_mixed_storage"), 4, (Function1<? super ShapedRecipeBuilder, Unit>)((Function1)RecipeProvider::buildMachineRecipes$lambda$16), output, false);
        this.shapeless("configurable_mixed_storage_upgrade", (ItemLike)YAIMachines.INSTANCE.getMachineFromId("configurable_mixed_storage"), 2, (Function1<? super ShapelessRecipeBuilder, Unit>)((Function1)RecipeProvider::buildMachineRecipes$lambda$17), output);
        this.assembler("configurable_mixed_storage_upgrade", (ItemLike)YAIMachines.INSTANCE.getMachineFromId("configurable_mixed_storage"), 2, (Function1<? super ShapedRecipeBuilder, Unit>)((Function1)RecipeProvider::buildMachineRecipes$lambda$18), output);
    }

    private final void buildManualArboreousGreenhouseRecipes(RecipeOutput output, HolderLookup.Provider lookup) {
        Item item = Items.CHORUS_FRUIT;
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"CHORUS_FRUIT");
        ItemLike itemLike = (ItemLike)item;
        Fluid fluid = YAIFluids.INSTANCE.getDRAGONS_BREATH().asFluid();
        Fluid fluid2 = YAIFluids.INSTANCE.getNUTRIENT_RICH_DRAGONS_BREATH().asFluid();
        Object[] objectArray = new Triple[]{new Triple((Object)Items.CHORUS_FRUIT, (Object)8, (Object)Float.valueOf(1.0f)), new Triple((Object)Items.CHORUS_FLOWER, (Object)1, (Object)Float.valueOf(1.0f))};
        List list = CollectionsKt.listOf((Object[])objectArray);
        ResourceLocation resourceLocation = YAI.Companion.id("end_stone");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
        ResourceLocation resourceLocation2 = ResourceLocation.withDefaultNamespace((String)"chorus_flower");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"withDefaultNamespace(...)");
        this.addArboreousGreenhouseRecipe("chorus_fruit", itemLike, fluid, fluid2, list, resourceLocation, resourceLocation2, output);
    }

    private final void addArboreousGreenhouseRecipe(String id, ItemLike input, Fluid fluid, Fluid nutrientFluid, List<? extends Triple<? extends ItemLike, Integer, Float>> output, ResourceLocation tier, ResourceLocation model, RecipeOutput recipeOutput) {
        if (fluid != null) {
            Companion.addMachineRecipe("arboreous_greenhouse/" + id, YAIMachines.RecipeTypes.INSTANCE.getARBOREOUS_GREENHOUSE(), 15, 1200, (Function1<? super MIMachineRecipeBuilder, Unit>)((Function1)arg_0 -> RecipeProvider.addArboreousGreenhouseRecipe$lambda$20(input, fluid, output, tier, model, arg_0)), recipeOutput);
        }
        if (nutrientFluid == null) {
            return;
        }
        Companion.addMachineRecipe("arboreous_greenhouse/" + id + "_nutrient", YAIMachines.RecipeTypes.INSTANCE.getARBOREOUS_GREENHOUSE(), 15, 1200, (Function1<? super MIMachineRecipeBuilder, Unit>)((Function1)arg_0 -> RecipeProvider.addArboreousGreenhouseRecipe$lambda$22(input, nutrientFluid, output, tier, model, arg_0)), recipeOutput);
    }

    private final void buildCryogenicPrecipitatorRecipes(RecipeOutput output, HolderLookup.Provider lookup) {
        FlowingFluid flowingFluid = Fluids.WATER;
        Intrinsics.checkNotNullExpressionValue((Object)flowingFluid, (String)"WATER");
        Fluid fluid = (Fluid)flowingFluid;
        Item item = Items.SNOWBALL;
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"SNOWBALL");
        this.addCryogenicPrecipitatorRecipe("snowball", fluid, 400, 2, (ItemLike)item, 4, output);
        FlowingFluid flowingFluid2 = Fluids.WATER;
        Intrinsics.checkNotNullExpressionValue((Object)flowingFluid2, (String)"WATER");
        Fluid fluid2 = (Fluid)flowingFluid2;
        Block block = Blocks.SNOW_BLOCK;
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"SNOW_BLOCK");
        this.addCryogenicPrecipitatorRecipe("snow_block", fluid2, 1000, 8, (ItemLike)block, 4, output);
        FlowingFluid flowingFluid3 = Fluids.WATER;
        Intrinsics.checkNotNullExpressionValue((Object)flowingFluid3, (String)"WATER");
        Fluid fluid3 = (Fluid)flowingFluid3;
        Block block2 = Blocks.SNOW;
        Intrinsics.checkNotNullExpressionValue((Object)block2, (String)"SNOW");
        this.addCryogenicPrecipitatorRecipe("snow", fluid3, 1000, 2, (ItemLike)block2, 6, output);
        Companion.addMachineRecipe("cryogenic_precipitator/powder_snow_bucket", YAIMachines.RecipeTypes.INSTANCE.getCRYOGENIC_PRECIPITATOR(), 8, 30, (Function1<? super MIMachineRecipeBuilder, Unit>)((Function1)RecipeProvider::buildCryogenicPrecipitatorRecipes$lambda$23), output);
        Companion.addMachineRecipe("cryogenic_precipitator/powder_snow_bucket_nutrient", YAIMachines.RecipeTypes.INSTANCE.getCRYOGENIC_PRECIPITATOR(), 8, 30, (Function1<? super MIMachineRecipeBuilder, Unit>)((Function1)RecipeProvider::buildCryogenicPrecipitatorRecipes$lambda$24), output);
        FlowingFluid flowingFluid4 = Fluids.WATER;
        Intrinsics.checkNotNullExpressionValue((Object)flowingFluid4, (String)"WATER");
        Fluid fluid4 = (Fluid)flowingFluid4;
        Block block3 = Blocks.ICE;
        Intrinsics.checkNotNullExpressionValue((Object)block3, (String)"ICE");
        this.addCryogenicPrecipitatorRecipe("ice", fluid4, 1000, 1, (ItemLike)block3, 1, output);
        FlowingFluid flowingFluid5 = Fluids.WATER;
        Intrinsics.checkNotNullExpressionValue((Object)flowingFluid5, (String)"WATER");
        Fluid fluid5 = (Fluid)flowingFluid5;
        Block block4 = Blocks.PACKED_ICE;
        Intrinsics.checkNotNullExpressionValue((Object)block4, (String)"PACKED_ICE");
        this.addCryogenicPrecipitatorRecipe("packed_ice", fluid5, 4000, 8, (ItemLike)block4, 1, output);
        FlowingFluid flowingFluid6 = Fluids.WATER;
        Intrinsics.checkNotNullExpressionValue((Object)flowingFluid6, (String)"WATER");
        Fluid fluid6 = (Fluid)flowingFluid6;
        Block block5 = Blocks.BLUE_ICE;
        Intrinsics.checkNotNullExpressionValue((Object)block5, (String)"BLUE_ICE");
        this.addCryogenicPrecipitatorRecipe("blue_ice", fluid6, 4000, 64, (ItemLike)block5, 1, output);
        FlowingFluid flowingFluid7 = Fluids.LAVA;
        Intrinsics.checkNotNullExpressionValue((Object)flowingFluid7, (String)"LAVA");
        Fluid fluid7 = (Fluid)flowingFluid7;
        Block block6 = Blocks.OBSIDIAN;
        Intrinsics.checkNotNullExpressionValue((Object)block6, (String)"OBSIDIAN");
        this.addCryogenicPrecipitatorRecipe("obsidian", fluid7, 1000, 2, (ItemLike)block6, 4, output);
        FlowingFluid flowingFluid8 = Fluids.LAVA;
        Intrinsics.checkNotNullExpressionValue((Object)flowingFluid8, (String)"LAVA");
        Fluid fluid8 = (Fluid)flowingFluid8;
        Block block7 = Blocks.CRYING_OBSIDIAN;
        Intrinsics.checkNotNullExpressionValue((Object)block7, (String)"CRYING_OBSIDIAN");
        this.addCryogenicPrecipitatorRecipe("crying_obsidian", fluid8, 1000, 2, (ItemLike)block7, 4, output);
        FlowingFluid flowingFluid9 = Fluids.LAVA;
        Intrinsics.checkNotNullExpressionValue((Object)flowingFluid9, (String)"LAVA");
        Fluid fluid9 = (Fluid)flowingFluid9;
        Block block8 = Blocks.BASALT;
        Intrinsics.checkNotNullExpressionValue((Object)block8, (String)"BASALT");
        this.addCryogenicPrecipitatorRecipe("basalt", fluid9, 500, 4, (ItemLike)block8, 8, output);
    }

    private final void addCryogenicPrecipitatorRecipe(String id, Fluid fluid, int fluidAmount, int cryofluidAmount, ItemLike output, int outputAmount, RecipeOutput recipeOutput) {
        Fluid fluid2;
        int argonAmount = (int)((double)cryofluidAmount * 0.65);
        int heliumAmount = (int)((double)cryofluidAmount * 0.25);
        Companion.addMachineRecipe("cryogenic_precipitator/" + id, YAIMachines.RecipeTypes.INSTANCE.getCRYOGENIC_PRECIPITATOR(), 8, 30, (Function1<? super MIMachineRecipeBuilder, Unit>)((Function1)arg_0 -> RecipeProvider.addCryogenicPrecipitatorRecipe$lambda$25(fluid, fluidAmount, cryofluidAmount, output, outputAmount, argonAmount, heliumAmount, arg_0)), recipeOutput);
        Fluid fluid3 = fluid;
        if (Intrinsics.areEqual((Object)fluid3, (Object)Fluids.WATER)) {
            fluid2 = YAIFluids.INSTANCE.getNUTRIENT_RICH_WATER().asFluid();
        } else if (Intrinsics.areEqual((Object)fluid3, (Object)Fluids.LAVA)) {
            fluid2 = YAIFluids.INSTANCE.getNUTRIENT_RICH_LAVA().asFluid();
        } else {
            return;
        }
        Fluid nutrientFluid = fluid2;
        Companion.addMachineRecipe("cryogenic_precipitator/" + id + "_nutrient", YAIMachines.RecipeTypes.INSTANCE.getCRYOGENIC_PRECIPITATOR(), 8, 30, (Function1<? super MIMachineRecipeBuilder, Unit>)((Function1)arg_0 -> RecipeProvider.addCryogenicPrecipitatorRecipe$lambda$26(nutrientFluid, fluidAmount, cryofluidAmount, output, outputAmount, argonAmount, heliumAmount, arg_0)), recipeOutput);
    }

    private final void buildDragonSiphonRecipes(RecipeOutput output, HolderLookup.Provider lookup) {
        Companion.addMachineRecipe("dragon_egg_energy_siphon/dragon_breath", YAIMachines.RecipeTypes.INSTANCE.getDRAGON_SIPHON(), 1, 160, (Function1<? super MIMachineRecipeBuilder, Unit>)((Function1)RecipeProvider::buildDragonSiphonRecipes$lambda$27), output);
        Companion.addMachineRecipe("dragon_egg_energy_siphon/nutrient_dragon_breath", YAIMachines.RecipeTypes.INSTANCE.getDRAGON_SIPHON(), 1, 400, (Function1<? super MIMachineRecipeBuilder, Unit>)((Function1)RecipeProvider::buildDragonSiphonRecipes$lambda$28), output);
    }

    private final void buildPartRecipes(RecipeOutput output, HolderLookup.Provider lookup) {
        MachineRecipeType machineRecipeType = MIMachineRecipeTypes.ASSEMBLER;
        Intrinsics.checkNotNullExpressionValue((Object)machineRecipeType, (String)"ASSEMBLER");
        Companion.addMachineRecipe("assembler/dragon_egg_siphon_catalyst/dragon_breath", machineRecipeType, 8, 200, (Function1<? super MIMachineRecipeBuilder, Unit>)((Function1)RecipeProvider::buildPartRecipes$lambda$29), output);
        MachineRecipeType machineRecipeType2 = MIMachineRecipeTypes.ASSEMBLER;
        Intrinsics.checkNotNullExpressionValue((Object)machineRecipeType2, (String)"ASSEMBLER");
        Companion.addMachineRecipe("assembler/dragon_egg_siphon_catalyst/nutrient_rich_dragon_breath", machineRecipeType2, 8, 200, (Function1<? super MIMachineRecipeBuilder, Unit>)((Function1)RecipeProvider::buildPartRecipes$lambda$30), output);
        Block block = YAIBlocks.INSTANCE.getSTEEL_PLATED_END_STONE_BRICKS().get();
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"get(...)");
        RecipeProvider.shaped$default(this, "steel_plated_end_stone_bricks", (ItemLike)block, 1, RecipeProvider::buildPartRecipes$lambda$31, output, false, 32, null);
    }

    private final void buildFluidRecipes(RecipeOutput output, HolderLookup.Provider lookup) {
        MachineRecipeType machineRecipeType = MIMachineRecipeTypes.CENTRIFUGE;
        Intrinsics.checkNotNullExpressionValue((Object)machineRecipeType, (String)"CENTRIFUGE");
        Companion.addMachineRecipe("centrifuge/nutrient_rich_water", machineRecipeType, 8, 200, (Function1<? super MIMachineRecipeBuilder, Unit>)((Function1)RecipeProvider::buildFluidRecipes$lambda$32), output);
        MachineRecipeType machineRecipeType2 = MIMachineRecipeTypes.CENTRIFUGE;
        Intrinsics.checkNotNullExpressionValue((Object)machineRecipeType2, (String)"CENTRIFUGE");
        Companion.addMachineRecipe("centrifuge/nutrient_rich_lava", machineRecipeType2, 8, 200, (Function1<? super MIMachineRecipeBuilder, Unit>)((Function1)RecipeProvider::buildFluidRecipes$lambda$33), output);
        MachineRecipeType machineRecipeType3 = MIMachineRecipeTypes.CENTRIFUGE;
        Intrinsics.checkNotNullExpressionValue((Object)machineRecipeType3, (String)"CENTRIFUGE");
        Companion.addMachineRecipe("centrifuge/dragon_breath", machineRecipeType3, 8, 200, (Function1<? super MIMachineRecipeBuilder, Unit>)((Function1)RecipeProvider::buildFluidRecipes$lambda$34), output);
        MachineRecipeType machineRecipeType4 = MIMachineRecipeTypes.CENTRIFUGE;
        Intrinsics.checkNotNullExpressionValue((Object)machineRecipeType4, (String)"CENTRIFUGE");
        Companion.addMachineRecipe("centrifuge/nutrient_rich_dragon_breath", machineRecipeType4, 8, 200, (Function1<? super MIMachineRecipeBuilder, Unit>)((Function1)RecipeProvider::buildFluidRecipes$lambda$35), output);
        MachineRecipeType machineRecipeType5 = MIMachineRecipeTypes.CENTRIFUGE;
        Intrinsics.checkNotNullExpressionValue((Object)machineRecipeType5, (String)"CENTRIFUGE");
        Companion.addMachineRecipe("centrifuge/nutrient_rich_dragon_breath_dragon_egg", machineRecipeType5, 64, 2400, (Function1<? super MIMachineRecipeBuilder, Unit>)((Function1)RecipeProvider::buildFluidRecipes$lambda$36), output);
        MachineRecipeType machineRecipeType6 = MIMachineRecipeTypes.CENTRIFUGE;
        Intrinsics.checkNotNullExpressionValue((Object)machineRecipeType6, (String)"CENTRIFUGE");
        Companion.addMachineRecipe("centrifuge/impure_dragon_breath_purify", machineRecipeType6, 8, 140, (Function1<? super MIMachineRecipeBuilder, Unit>)((Function1)RecipeProvider::buildFluidRecipes$lambda$37), output);
        MachineRecipeType machineRecipeType7 = MIMachineRecipeTypes.CENTRIFUGE;
        Intrinsics.checkNotNullExpressionValue((Object)machineRecipeType7, (String)"CENTRIFUGE");
        Companion.addMachineRecipe("centrifuge/impure_dragon_breath_purify_nutrient", machineRecipeType7, 8, 240, (Function1<? super MIMachineRecipeBuilder, Unit>)((Function1)RecipeProvider::buildFluidRecipes$lambda$38), output);
    }

    private final void shapeless(String name, ItemLike result, int resultCount, Function1<? super ShapelessRecipeBuilder, Unit> crafting, RecipeOutput output) {
        ShapelessRecipeBuilder shapelessRecipeBuilder;
        ShapelessRecipeBuilder $this$shapeless_u24lambda_u2439 = shapelessRecipeBuilder = new ShapelessRecipeBuilder();
        boolean bl = false;
        crafting.invoke((Object)$this$shapeless_u24lambda_u2439);
        $this$shapeless_u24lambda_u2439.output(result, resultCount);
        $this$shapeless_u24lambda_u2439.offerTo(output, YAI.Companion.id("craft/" + name));
    }

    private final void shaped(String path, ItemLike result, int resultCount, Function1<? super ShapedRecipeBuilder, Unit> crafting, RecipeOutput output, boolean registerForAssembler) {
        ShapedRecipeBuilder shapedRecipeBuilder;
        ShapedRecipeBuilder $this$shaped_u24lambda_u2440 = shapedRecipeBuilder = new ShapedRecipeBuilder();
        boolean bl = false;
        crafting.invoke((Object)$this$shaped_u24lambda_u2440);
        $this$shaped_u24lambda_u2440.output(result, resultCount);
        $this$shaped_u24lambda_u2440.offerTo(output, YAI.Companion.id("craft/" + path));
        ShapedRecipeBuilder builder = shapedRecipeBuilder;
        if (registerForAssembler) {
            MIMachineRecipeBuilder.fromShapedToAssembler((ShapedRecipeBuilder)builder).offerTo(output, YAI.Companion.id("assembler/" + path));
        }
    }

    static /* synthetic */ void shaped$default(RecipeProvider recipeProvider, String string, ItemLike itemLike, int n, Function1 function1, RecipeOutput recipeOutput, boolean bl, int n2, Object object) {
        if ((n2 & 0x20) != 0) {
            bl = true;
        }
        recipeProvider.shaped(string, itemLike, n, (Function1<? super ShapedRecipeBuilder, Unit>)function1, recipeOutput, bl);
    }

    private final void assembler(String path, ItemLike result, int resultCount, Function1<? super ShapedRecipeBuilder, Unit> crafting, RecipeOutput output) {
        ShapedRecipeBuilder shapedRecipeBuilder;
        ShapedRecipeBuilder $this$assembler_u24lambda_u2441 = shapedRecipeBuilder = new ShapedRecipeBuilder();
        boolean bl = false;
        crafting.invoke((Object)$this$assembler_u24lambda_u2441);
        $this$assembler_u24lambda_u2441.output(result, resultCount);
        ShapedRecipeBuilder builder = shapedRecipeBuilder;
        MIMachineRecipeBuilder.fromShapedToAssembler((ShapedRecipeBuilder)builder).offerTo(output, YAI.Companion.id("assembler/" + path));
    }

    private static final Unit buildItemRecipes$lambda$0(ShapelessRecipeBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ItemLike[] itemLikeArray = new ItemLike[]{MIItem.GUIDE_BOOK.asItem()};
        it.with(itemLikeArray).with(Tags.Items.DYES_MAGENTA);
        return Unit.INSTANCE;
    }

    private static final Unit buildItemRecipes$lambda$1(ShapedRecipeBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ItemLike[] itemLikeArray = new ItemLike[]{MIMaterials.BRONZE.get(MIMaterialParts.GEAR).asItem()};
        ShapedRecipeBuilder shapedRecipeBuilder = it.define('B', YAITags.INSTANCE.getMI_GUIDE_BOOKS()).define('G', itemLikeArray);
        itemLikeArray = new ItemLike[]{MIMaterials.IRON.get(MIMaterialParts.PLATE).asItem()};
        shapedRecipeBuilder.define('P', itemLikeArray).pattern("PPP").pattern("GBG").pattern("PPP");
        return Unit.INSTANCE;
    }

    private static final Unit buildItemRecipes$lambda$2(MIMachineRecipeBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.addItemInput((ItemLike)MIItem.CONFIG_CARD, 1, 1.0f);
        it.addItemInput(Tags.Items.CHESTS, 1, 1.0f);
        it.addItemInput(Tags.Items.BUCKETS_EMPTY, 1, 1.0f);
        it.addFluidInput((FluidLike)MIFluids.MOLTEN_REDSTONE, 990, 1.0f);
        it.addItemOutput((ItemLike)YAIItems.INSTANCE.getSTORAGE_SLOT_LOCKER().get(), 1, 1.0f);
        return Unit.INSTANCE;
    }

    private static final Unit buildItemRecipes$lambda$3(MIMachineRecipeBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.addItemInput((ItemLike)MIItem.WRENCH, 1, 1.0f);
        it.addItemInput((ItemLike)MIItem.ROBOT_ARM, 4, 1.0f);
        it.addItemInput((ItemLike)MIItem.ELECTRONIC_CIRCUIT, 2, 1.0f);
        it.addFluidInput((FluidLike)MIFluids.MOLTEN_REDSTONE, 1980, 1.0f);
        it.addFluidInput((FluidLike)MIFluids.POLYETHYLENE, 500, 1.0f);
        it.addItemOutput((ItemLike)YAIItems.INSTANCE.getMACHINE_REMOVER().get(), 1, 1.0f);
        return Unit.INSTANCE;
    }

    private static final Unit buildItemRecipes$lambda$4(MIMachineRecipeBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.addItemInput((ItemLike)Items.GLASS_BOTTLE, 3, 1.0f);
        it.addFluidInput((FluidLike)MIFluids.SUGAR_SOLUTION, 1000, 1.0f);
        it.addFluidInput((FluidLike)MIFluids.ETHANOL, 51, 1.0f);
        it.addItemOutput((ItemLike)YAIItems.INSTANCE.getCACHACA().get(), 3, 1.0f);
        return Unit.INSTANCE;
    }

    private static final Unit buildItemRecipes$lambda$5(MIMachineRecipeBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.addItemInput((ItemLike)MIItem.QUANTUM_CIRCUIT, 1, 0.02f);
        it.addFluidInput((Fluid)Fluids.WATER, 16000, 1.0f);
        it.addItemOutput((ItemLike)YAIItems.INSTANCE.getAI_SLOP().get(), 1, 1.0f);
        return Unit.INSTANCE;
    }

    private static final Unit buildItemRecipes$lambda$6(MIMachineRecipeBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.addItemInput((ItemLike)Items.BREAD, 1, 1.0f);
        it.addItemInput((ItemLike)MIItem.ULTRADENSE_METAL_BALL, 1, 1.0f);
        it.addItemInput((ItemLike)Items.BREAD, 1, 1.0f);
        it.addItemOutput((ItemLike)YAIItems.INSTANCE.getULTRADENSE_METAL_BALL_BURGER().get(), 1, 1.0f);
        return Unit.INSTANCE;
    }

    private static final Unit buildMachineRecipes$lambda$7(ShapedRecipeBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ItemLike[] itemLikeArray = new ItemLike[]{MIBlock.BASIC_MACHINE_HULL};
        ShapedRecipeBuilder shapedRecipeBuilder = it.define('H', itemLikeArray);
        itemLikeArray = new ItemLike[]{MIItem.ANALOG_CIRCUIT};
        ShapedRecipeBuilder shapedRecipeBuilder2 = shapedRecipeBuilder.define('C', itemLikeArray);
        itemLikeArray = new ItemLike[]{MIItem.PUMP};
        ShapedRecipeBuilder shapedRecipeBuilder3 = shapedRecipeBuilder2.define('P', itemLikeArray).define('D', ItemTags.DIRT);
        itemLikeArray = new ItemLike[]{MIMaterials.INVAR.get(MIMaterialParts.MACHINE_CASING_SPECIAL).asBlock()};
        shapedRecipeBuilder3.define('I', itemLikeArray).pattern("CIC").pattern("PHP").pattern("CDC");
        return Unit.INSTANCE;
    }

    private static final Unit buildMachineRecipes$lambda$8(ShapedRecipeBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ItemLike[] itemLikeArray = new ItemLike[]{MIMaterials.ALUMINUM.get(MIMaterialParts.LARGE_PLATE).asItem()};
        ShapedRecipeBuilder shapedRecipeBuilder = it.define('P', itemLikeArray);
        itemLikeArray = new ItemLike[]{MIItem.ELECTRONIC_CIRCUIT};
        ShapedRecipeBuilder shapedRecipeBuilder2 = shapedRecipeBuilder.define('C', itemLikeArray);
        itemLikeArray = new ItemLike[]{MIMaterials.TIN.get(MIMaterialParts.CABLE).asItem()};
        ShapedRecipeBuilder shapedRecipeBuilder3 = shapedRecipeBuilder2.define('T', itemLikeArray);
        itemLikeArray = new ItemLike[]{MIBlock.BASIC_MACHINE_HULL};
        shapedRecipeBuilder3.define('H', itemLikeArray).pattern("PCP").pattern("THT").pattern("PCP");
        return Unit.INSTANCE;
    }

    private static final Unit buildMachineRecipes$lambda$9(ShapedRecipeBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ItemLike[] itemLikeArray = new ItemLike[]{MIItem.LARGE_PUMP};
        ShapedRecipeBuilder shapedRecipeBuilder = it.define('P', itemLikeArray);
        itemLikeArray = new ItemLike[]{Items.DRAGON_BREATH};
        ShapedRecipeBuilder shapedRecipeBuilder2 = shapedRecipeBuilder.define('D', itemLikeArray);
        itemLikeArray = new ItemLike[]{MIMaterials.STEEL.get(MIMaterialParts.GEAR).asItem()};
        ShapedRecipeBuilder shapedRecipeBuilder3 = shapedRecipeBuilder2.define('G', itemLikeArray);
        itemLikeArray = new ItemLike[]{MIBlock.ADVANCED_MACHINE_HULL};
        shapedRecipeBuilder3.define('H', itemLikeArray).pattern("PDP").pattern("GHG").pattern("PDP");
        return Unit.INSTANCE;
    }

    private static final Unit buildMachineRecipes$lambda$10(ShapedRecipeBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ItemLike[] itemLikeArray = new ItemLike[]{YAIMaterials.INSTANCE.getBATTERY_ALLOY().get(MIMaterialParts.MACHINE_CASING_SPECIAL).asBlock()};
        ShapedRecipeBuilder shapedRecipeBuilder = it.define('M', itemLikeArray);
        itemLikeArray = new ItemLike[]{MIItem.ELECTRONIC_CIRCUIT};
        ShapedRecipeBuilder shapedRecipeBuilder2 = shapedRecipeBuilder.define('C', itemLikeArray);
        itemLikeArray = new ItemLike[]{MIMaterials.REDSTONE.get(MIMaterialParts.BATTERY).asItem()};
        ShapedRecipeBuilder shapedRecipeBuilder3 = shapedRecipeBuilder2.define('B', itemLikeArray);
        itemLikeArray = new ItemLike[]{MIItem.PORTABLE_STORAGE_UNIT};
        shapedRecipeBuilder3.define('P', itemLikeArray).pattern("PCP").pattern("BMB").pattern("PBP");
        return Unit.INSTANCE;
    }

    private static final Unit buildMachineRecipes$lambda$11(ShapedRecipeBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ItemLike[] itemLikeArray = new ItemLike[]{YAIMaterials.INSTANCE.getBATTERY_ALLOY().get(MIMaterialParts.MACHINE_CASING_SPECIAL).asBlock()};
        ShapedRecipeBuilder shapedRecipeBuilder = it.define('M', itemLikeArray);
        itemLikeArray = new ItemLike[]{MIMaterials.REDSTONE.get(MIMaterialParts.BATTERY).asItem()};
        shapedRecipeBuilder.define('R', itemLikeArray).pattern("R").pattern("M");
        return Unit.INSTANCE;
    }

    private static final Unit buildMachineRecipes$lambda$12(ShapedRecipeBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ItemLike[] itemLikeArray = new ItemLike[]{YAIMaterials.INSTANCE.getBATTERY_ALLOY().get(MIMaterialParts.MACHINE_CASING_SPECIAL).asBlock()};
        ShapedRecipeBuilder shapedRecipeBuilder = it.define('M', itemLikeArray);
        itemLikeArray = new ItemLike[]{MIMaterials.REDSTONE.get(MIMaterialParts.BATTERY).asItem()};
        shapedRecipeBuilder.define('R', itemLikeArray).pattern("M").pattern("R");
        return Unit.INSTANCE;
    }

    private static final Unit buildMachineRecipes$lambda$13(ShapelessRecipeBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ItemLike[] itemLikeArray = new ItemLike[]{YAIMachines.INSTANCE.getMachineFromId("large_storage_unit_output_hatch")};
        it.with(itemLikeArray);
        return Unit.INSTANCE;
    }

    private static final Unit buildMachineRecipes$lambda$14(ShapelessRecipeBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ItemLike[] itemLikeArray = new ItemLike[]{YAIMachines.INSTANCE.getMachineFromId("large_storage_unit_input_hatch")};
        it.with(itemLikeArray);
        return Unit.INSTANCE;
    }

    private static final Unit buildMachineRecipes$lambda$15(ShapedRecipeBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ItemLike[] itemLikeArray = new ItemLike[]{MIItem.ELECTRONIC_CIRCUIT};
        ShapedRecipeBuilder shapedRecipeBuilder = it.define('C', itemLikeArray);
        itemLikeArray = new ItemLike[]{Items.HOPPER};
        ShapedRecipeBuilder shapedRecipeBuilder2 = shapedRecipeBuilder.define('H', itemLikeArray);
        itemLikeArray = new ItemLike[]{MIMaterials.STAINLESS_STEEL.get(MIMaterialParts.TANK).asBlock()};
        ShapedRecipeBuilder shapedRecipeBuilder3 = shapedRecipeBuilder2.define('T', itemLikeArray);
        itemLikeArray = new ItemLike[]{MIMaterials.STAINLESS_STEEL.get(MIMaterialParts.CLEAN_MACHINE_CASING).asBlock()};
        shapedRecipeBuilder3.define('S', itemLikeArray).pattern("CTC").pattern("HSH").pattern("CTC");
        return Unit.INSTANCE;
    }

    private static final Unit buildMachineRecipes$lambda$16(ShapedRecipeBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ItemLike[] itemLikeArray = new ItemLike[]{MIItem.ELECTRONIC_CIRCUIT};
        ShapedRecipeBuilder shapedRecipeBuilder = it.define('C', itemLikeArray);
        itemLikeArray = new ItemLike[]{Items.HOPPER};
        ShapedRecipeBuilder shapedRecipeBuilder2 = shapedRecipeBuilder.define('H', itemLikeArray);
        itemLikeArray = new ItemLike[]{MIMaterials.STAINLESS_STEEL.get(MIMaterialParts.TANK).asBlock()};
        ShapedRecipeBuilder shapedRecipeBuilder3 = shapedRecipeBuilder2.define('T', itemLikeArray);
        itemLikeArray = new ItemLike[]{MIMaterials.STAINLESS_STEEL.get(MIMaterialParts.CLEAN_MACHINE_CASING).asBlock()};
        shapedRecipeBuilder3.define('S', itemLikeArray).pattern("CHC").pattern("TST").pattern("CHC");
        return Unit.INSTANCE;
    }

    private static final Unit buildMachineRecipes$lambda$17(ShapelessRecipeBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ResourceLocation[] resourceLocationArray = new ResourceLocation[]{MI.id((String)"configurable_chest")};
        ShapelessRecipeBuilder shapelessRecipeBuilder = it.with(resourceLocationArray);
        resourceLocationArray = new ResourceLocation[]{MI.id((String)"configurable_tank")};
        ShapelessRecipeBuilder shapelessRecipeBuilder2 = shapelessRecipeBuilder.with(resourceLocationArray);
        resourceLocationArray = new ItemLike[]{MIMaterials.STAINLESS_STEEL.get(MIMaterialParts.CLEAN_MACHINE_CASING).asBlock()};
        ShapelessRecipeBuilder shapelessRecipeBuilder3 = shapelessRecipeBuilder2.with((ItemLike[])resourceLocationArray);
        resourceLocationArray = new ItemLike[]{MIItem.ELECTRONIC_CIRCUIT};
        shapelessRecipeBuilder3.with((ItemLike[])resourceLocationArray);
        return Unit.INSTANCE;
    }

    private static final Unit buildMachineRecipes$lambda$18(ShapedRecipeBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ItemLike[] itemLikeArray = new ItemLike[]{MIMaterials.STAINLESS_STEEL.get(MIMaterialParts.CLEAN_MACHINE_CASING).asBlock()};
        ShapedRecipeBuilder shapedRecipeBuilder = it.define('S', itemLikeArray);
        itemLikeArray = new ItemLike[]{MIItem.ELECTRONIC_CIRCUIT};
        ShapedRecipeBuilder shapedRecipeBuilder2 = shapedRecipeBuilder.define('E', itemLikeArray);
        itemLikeArray = new ResourceLocation[]{MI.id((String)"configurable_chest")};
        ShapedRecipeBuilder shapedRecipeBuilder3 = shapedRecipeBuilder2.define('C', (ResourceLocation[])itemLikeArray);
        itemLikeArray = new ResourceLocation[]{MI.id((String)"configurable_tank")};
        shapedRecipeBuilder3.define('T', (ResourceLocation[])itemLikeArray).pattern("SEC").pattern("T");
        return Unit.INSTANCE;
    }

    private static final Unit addArboreousGreenhouseRecipe$lambda$20(ItemLike $input, Fluid $fluid, List $output, ResourceLocation $tier, ResourceLocation $model, MIMachineRecipeBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.addItemInput($input, 1, 0.0f);
        it.addFluidInput($fluid, 1000, 1.0f);
        Iterable $this$forEach$iv = $output;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Triple triple = (Triple)element$iv;
            boolean bl = false;
            ItemLike item = (ItemLike)triple.component1();
            int amount = ((Number)triple.component2()).intValue();
            float chance = ((Number)triple.component3()).floatValue();
            it.addItemOutput(item, amount, chance);
        }
        it.addItemOutput($input, 1, 0.5f);
        it.addCondition((MachineProcessCondition)new ArboreousGreenhouseTierCondition($tier, $model));
        return Unit.INSTANCE;
    }

    private static final Unit addArboreousGreenhouseRecipe$lambda$22(ItemLike $input, Fluid $nutrientFluid, List $output, ResourceLocation $tier, ResourceLocation $model, MIMachineRecipeBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.addItemInput($input, 1, 0.0f);
        it.addFluidInput($nutrientFluid, 1000, 1.0f);
        Iterable $this$forEach$iv = $output;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Triple triple = (Triple)element$iv;
            boolean bl = false;
            ItemLike item = (ItemLike)triple.component1();
            int amount = ((Number)triple.component2()).intValue();
            float chance = ((Number)triple.component3()).floatValue();
            it.addItemOutput(item, amount * 2, RangesKt.coerceAtMost((float)(chance * (float)2), (float)1.0f));
        }
        it.addItemOutput($input, 1, 1.0f);
        it.addCondition((MachineProcessCondition)new ArboreousGreenhouseTierCondition($tier, $model));
        return Unit.INSTANCE;
    }

    private static final Unit buildCryogenicPrecipitatorRecipes$lambda$23(MIMachineRecipeBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.addItemInput((ItemLike)Items.BUCKET, 1, 1.0f);
        it.addFluidInput((Fluid)Fluids.WATER, 1000, 1.0f);
        it.addFluidInput((FluidLike)MIFluids.CRYOFLUID, 4, 1.0f);
        it.addItemOutput((ItemLike)Items.POWDER_SNOW_BUCKET, 1, 1.0f);
        it.addFluidOutput(MIFluids.ARGON.asFluid(), 2, 1.0f);
        return Unit.INSTANCE;
    }

    private static final Unit buildCryogenicPrecipitatorRecipes$lambda$24(MIMachineRecipeBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.addItemInput((ItemLike)Items.BUCKET, 2, 1.0f);
        it.addFluidInput((FluidLike)YAIFluids.INSTANCE.getNUTRIENT_RICH_WATER(), 1000, 1.0f);
        it.addFluidInput((FluidLike)MIFluids.CRYOFLUID, 4, 1.0f);
        it.addItemOutput((ItemLike)Items.POWDER_SNOW_BUCKET, 1, 1.0f);
        it.addItemOutput((ItemLike)Items.POWDER_SNOW_BUCKET, 1, 1.0f);
        it.addFluidOutput(MIFluids.ARGON.asFluid(), 2, 1.0f);
        return Unit.INSTANCE;
    }

    private static final Unit addCryogenicPrecipitatorRecipe$lambda$25(Fluid $fluid, int $fluidAmount, int $cryofluidAmount, ItemLike $output, int $outputAmount, int $argonAmount, int $heliumAmount, MIMachineRecipeBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.addFluidInput($fluid, $fluidAmount, 1.0f);
        it.addFluidInput((FluidLike)MIFluids.CRYOFLUID, $cryofluidAmount, 1.0f);
        it.addItemOutput($output, $outputAmount, 1.0f);
        if ($argonAmount > 0) {
            it.addFluidOutput(MIFluids.ARGON.asFluid(), $argonAmount, 1.0f);
            if ($heliumAmount > 0) {
                it.addFluidOutput(MIFluids.HELIUM.asFluid(), $heliumAmount, 1.0f);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit addCryogenicPrecipitatorRecipe$lambda$26(Fluid $nutrientFluid, int $fluidAmount, int $cryofluidAmount, ItemLike $output, int $outputAmount, int $argonAmount, int $heliumAmount, MIMachineRecipeBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.addFluidInput($nutrientFluid, $fluidAmount, 1.0f);
        it.addFluidInput((FluidLike)MIFluids.CRYOFLUID, $cryofluidAmount, 1.0f);
        it.addItemOutput($output, $outputAmount * 2, 1.0f);
        if ($argonAmount > 0) {
            it.addFluidOutput(MIFluids.ARGON.asFluid(), $argonAmount, 1.0f);
            if ($heliumAmount > 0) {
                it.addFluidOutput(MIFluids.HELIUM.asFluid(), $argonAmount, 1.0f);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit buildDragonSiphonRecipes$lambda$27(MIMachineRecipeBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.addItemInput((ItemLike)YAIItems.INSTANCE.getDRAGON_EGG_SIPHON_CATALYST().get(), 1, 1.0f);
        it.addFluidInput(YAIFluids.INSTANCE.getDRAGONS_BREATH().asFluid(), 1000, 1.0f);
        it.addFluidOutput(YAIFluids.INSTANCE.getIMPURE_DRAGONS_BREATH().asFluid(), 1250, 1.0f);
        it.addCondition((MachineProcessCondition)new EnergyGenerationCondition(10000L));
        return Unit.INSTANCE;
    }

    private static final Unit buildDragonSiphonRecipes$lambda$28(MIMachineRecipeBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.addItemInput((ItemLike)YAIItems.INSTANCE.getDRAGON_EGG_SIPHON_CATALYST().get(), 1, 1.0f);
        it.addFluidInput(YAIFluids.INSTANCE.getNUTRIENT_RICH_DRAGONS_BREATH().asFluid(), 1000, 1.0f);
        it.addFluidOutput(YAIFluids.INSTANCE.getIMPURE_DRAGONS_BREATH().asFluid(), 2500, 1.0f);
        it.addCondition((MachineProcessCondition)new EnergyGenerationCondition(45000L));
        return Unit.INSTANCE;
    }

    private static final Unit buildPartRecipes$lambda$29(MIMachineRecipeBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.addItemInput((ItemLike)MIMaterials.STEEL.get(MIMaterialParts.PLATE), 8, 1.0f);
        it.addItemInput((ItemLike)MIMaterials.QUARTZ.get(MIMaterialParts.TINY_DUST), 1, 1.0f);
        it.addFluidInput(YAIFluids.INSTANCE.getDRAGONS_BREATH().asFluid(), 50, 1.0f);
        it.addItemOutput((ItemLike)YAIItems.INSTANCE.getDRAGON_EGG_SIPHON_CATALYST().get(), 1, 1.0f);
        return Unit.INSTANCE;
    }

    private static final Unit buildPartRecipes$lambda$30(MIMachineRecipeBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.addItemInput((ItemLike)MIMaterials.STEEL.get(MIMaterialParts.PLATE), 8, 1.0f);
        it.addItemInput((ItemLike)MIMaterials.QUARTZ.get(MIMaterialParts.TINY_DUST), 1, 1.0f);
        it.addFluidInput(YAIFluids.INSTANCE.getNUTRIENT_RICH_DRAGONS_BREATH().asFluid(), 50, 1.0f);
        it.addItemOutput((ItemLike)YAIItems.INSTANCE.getDRAGON_EGG_SIPHON_CATALYST().get(), 4, 1.0f);
        return Unit.INSTANCE;
    }

    private static final Unit buildPartRecipes$lambda$31(ShapedRecipeBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ItemLike[] itemLikeArray = new ItemLike[]{MIMaterials.STEEL.get(MIMaterialParts.PLATE).asItem()};
        ShapedRecipeBuilder shapedRecipeBuilder = it.define('P', itemLikeArray);
        itemLikeArray = new ItemLike[]{Blocks.END_STONE_BRICKS};
        shapedRecipeBuilder.define('B', itemLikeArray).pattern("PPP").pattern("PBP").pattern("PPP");
        return Unit.INSTANCE;
    }

    private static final Unit buildFluidRecipes$lambda$32(MIMachineRecipeBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.addFluidInput((Fluid)Fluids.WATER, 1000, 1.0f);
        it.addItemInput((ItemLike)Items.BONE_MEAL, 6, 1.0f);
        it.addFluidOutput(YAIFluids.INSTANCE.getNUTRIENT_RICH_WATER().asFluid(), 1000, 1.0f);
        return Unit.INSTANCE;
    }

    private static final Unit buildFluidRecipes$lambda$33(MIMachineRecipeBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.addFluidInput((Fluid)Fluids.LAVA, 1000, 1.0f);
        it.addItemInput((ItemLike)Items.NETHER_WART, 6, 1.0f);
        it.addFluidOutput(YAIFluids.INSTANCE.getNUTRIENT_RICH_LAVA().asFluid(), 1000, 1.0f);
        return Unit.INSTANCE;
    }

    private static final Unit buildFluidRecipes$lambda$34(MIMachineRecipeBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.addItemInput((ItemLike)Items.DRAGON_BREATH, 1, 1.0f);
        it.addItemOutput((ItemLike)Items.GLASS_BOTTLE, 1, 1.0f);
        it.addFluidOutput(YAIFluids.INSTANCE.getDRAGONS_BREATH().asFluid(), 350, 1.0f);
        return Unit.INSTANCE;
    }

    private static final Unit buildFluidRecipes$lambda$35(MIMachineRecipeBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.addFluidInput(YAIFluids.INSTANCE.getDRAGONS_BREATH().asFluid(), 1000, 1.0f);
        it.addItemInput((ItemLike)Items.POPPED_CHORUS_FRUIT, 6, 1.0f);
        it.addFluidOutput(YAIFluids.INSTANCE.getNUTRIENT_RICH_DRAGONS_BREATH().asFluid(), 1000, 1.0f);
        return Unit.INSTANCE;
    }

    private static final Unit buildFluidRecipes$lambda$36(MIMachineRecipeBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.addItemInput((ItemLike)Blocks.DRAGON_EGG, 1, 1.0f);
        it.addFluidOutput(YAIFluids.INSTANCE.getNUTRIENT_RICH_DRAGONS_BREATH().asFluid(), 16000, 1.0f);
        return Unit.INSTANCE;
    }

    private static final Unit buildFluidRecipes$lambda$37(MIMachineRecipeBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.addFluidInput(YAIFluids.INSTANCE.getIMPURE_DRAGONS_BREATH().asFluid(), 250, 1.0f);
        it.addFluidOutput(YAIFluids.INSTANCE.getDRAGONS_BREATH().asFluid(), 250, 1.0f);
        it.addItemOutput((ItemLike)MIMaterials.QUARTZ.get(MIMaterialParts.TINY_DUST), 1, 0.15f);
        return Unit.INSTANCE;
    }

    private static final Unit buildFluidRecipes$lambda$38(MIMachineRecipeBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.addFluidInput(YAIFluids.INSTANCE.getIMPURE_DRAGONS_BREATH().asFluid(), 500, 1.0f);
        it.addItemInput((ItemLike)Items.POPPED_CHORUS_FRUIT, 2, 1.0f);
        it.addFluidOutput(YAIFluids.INSTANCE.getNUTRIENT_RICH_DRAGONS_BREATH().asFluid(), 500, 1.0f);
        it.addItemOutput((ItemLike)MIMaterials.QUARTZ.get(MIMaterialParts.TINY_DUST), 1, 0.4f);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JB\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00050\u000e2\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"Lme/luligabi/yet_another_industrialization/datagen/server/provider/recipe/RecipeProvider$Companion;", "", "<init>", "()V", "addMachineRecipe", "", "path", "", "recipeType", "Laztech/modern_industrialization/machines/recipe/MachineRecipeType;", "eu", "", "duration", "crafting", "Lkotlin/Function1;", "Lnet/swedz/tesseract/neoforge/compat/mi/recipe/MIMachineRecipeBuilder;", "output", "Lnet/minecraft/data/recipes/RecipeOutput;", "yet_another_industrialization"})
    public static final class Companion {
        private Companion() {
        }

        public final void addMachineRecipe(@NotNull String path, @NotNull MachineRecipeType recipeType, int eu, int duration, @NotNull Function1<? super MIMachineRecipeBuilder, Unit> crafting, @NotNull RecipeOutput output) {
            MIMachineRecipeBuilder mIMachineRecipeBuilder;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)recipeType, (String)"recipeType");
            Intrinsics.checkNotNullParameter(crafting, (String)"crafting");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            MIMachineRecipeBuilder $this$addMachineRecipe_u24lambda_u240 = mIMachineRecipeBuilder = new MIMachineRecipeBuilder(recipeType, eu, duration);
            boolean bl = false;
            crafting.invoke((Object)$this$addMachineRecipe_u24lambda_u240);
            $this$addMachineRecipe_u24lambda_u240.offerTo(output, YAI.Companion.id(path));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

