/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.yet_another_industrialization.client.model.multiblock;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.luligabi.yet_another_industrialization.client.model.multiblock.MultiBlockModel;
import me.luligabi.yet_another_industrialization.common.model.multiblock.MultiBlockGeometryBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0006H\u0016J\u0018\u0010\"\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u00062\u0006\u0010#\u001a\u00020$H\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\u0006H\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010'\u001a\u00020\u0006H\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010'\u001a\u00020\u0006H\u0016J\b\u0010,\u001a\u00020\u001eH\u0016J\b\u0010-\u001a\u00020\u001eH\u0016J\u0018\u0010.\u001a\u00020\u001e2\u0006\u0010/\u001a\u00020\u00062\u0006\u00100\u001a\u00020\u001eH\u0016J(\u0010\u0015\u001a\u00020\u00162\u0006\u00101\u001a\u00020\u00162\u0006\u00102\u001a\u00020\u00162\u0006\u00103\u001a\u00020\u00162\u0006\u00104\u001a\u00020\u001aH\u0016J\u0010\u00105\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020\u0006H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u00066"}, d2={"Lme/luligabi/yet_another_industrialization/client/model/multiblock/MultiBlockFakeLevel;", "Lnet/minecraft/world/level/BlockAndTintGetter;", "model", "Lme/luligabi/yet_another_industrialization/client/model/multiblock/MultiBlockModel;", "realLevel", "lightAndTintPosition", "Lnet/minecraft/core/BlockPos;", "<init>", "(Lme/luligabi/yet_another_industrialization/client/model/multiblock/MultiBlockModel;Lnet/minecraft/world/level/BlockAndTintGetter;Lnet/minecraft/core/BlockPos;)V", "getModel", "()Lme/luligabi/yet_another_industrialization/client/model/multiblock/MultiBlockModel;", "setModel", "(Lme/luligabi/yet_another_industrialization/client/model/multiblock/MultiBlockModel;)V", "getRealLevel", "()Lnet/minecraft/world/level/BlockAndTintGetter;", "setRealLevel", "(Lnet/minecraft/world/level/BlockAndTintGetter;)V", "getLightAndTintPosition", "()Lnet/minecraft/core/BlockPos;", "setLightAndTintPosition", "(Lnet/minecraft/core/BlockPos;)V", "getShade", "", "pDirection", "Lnet/minecraft/core/Direction;", "pShade", "", "getLightEngine", "Lnet/minecraft/world/level/lighting/LevelLightEngine;", "getBrightness", "", "pLightType", "Lnet/minecraft/world/level/LightLayer;", "pBlockPos", "getBlockTint", "pColorResolver", "Lnet/minecraft/world/level/ColorResolver;", "getBlockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "pPos", "getBlockState", "Lnet/minecraft/world/level/block/state/BlockState;", "getFluidState", "Lnet/minecraft/world/level/material/FluidState;", "getHeight", "getMinBuildHeight", "getRawBrightness", "blockPos", "amount", "normalX", "normalY", "normalZ", "shade", "canSeeSky", "yet_another_industrialization"})
public final class MultiBlockFakeLevel
implements BlockAndTintGetter {
    @NotNull
    private MultiBlockModel model;
    @NotNull
    private BlockAndTintGetter realLevel;
    @NotNull
    private BlockPos lightAndTintPosition;

    public MultiBlockFakeLevel(@NotNull MultiBlockModel model, @NotNull BlockAndTintGetter realLevel, @NotNull BlockPos lightAndTintPosition) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)realLevel, (String)"realLevel");
        Intrinsics.checkNotNullParameter((Object)lightAndTintPosition, (String)"lightAndTintPosition");
        this.model = model;
        this.realLevel = realLevel;
        this.lightAndTintPosition = lightAndTintPosition;
    }

    @NotNull
    public final MultiBlockModel getModel() {
        return this.model;
    }

    public final void setModel(@NotNull MultiBlockModel multiBlockModel) {
        Intrinsics.checkNotNullParameter((Object)multiBlockModel, (String)"<set-?>");
        this.model = multiBlockModel;
    }

    @NotNull
    public final BlockAndTintGetter getRealLevel() {
        return this.realLevel;
    }

    public final void setRealLevel(@NotNull BlockAndTintGetter blockAndTintGetter) {
        Intrinsics.checkNotNullParameter((Object)blockAndTintGetter, (String)"<set-?>");
        this.realLevel = blockAndTintGetter;
    }

    @NotNull
    public final BlockPos getLightAndTintPosition() {
        return this.lightAndTintPosition;
    }

    public final void setLightAndTintPosition(@NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"<set-?>");
        this.lightAndTintPosition = blockPos;
    }

    public float getShade(@NotNull Direction pDirection, boolean pShade) {
        Intrinsics.checkNotNullParameter((Object)pDirection, (String)"pDirection");
        return this.realLevel.getShade(pDirection, pShade);
    }

    @NotNull
    public LevelLightEngine getLightEngine() {
        LevelLightEngine levelLightEngine = this.realLevel.getLightEngine();
        Intrinsics.checkNotNullExpressionValue((Object)levelLightEngine, (String)"getLightEngine(...)");
        return levelLightEngine;
    }

    public int getBrightness(@NotNull LightLayer pLightType, @NotNull BlockPos pBlockPos) {
        Intrinsics.checkNotNullParameter((Object)pLightType, (String)"pLightType");
        Intrinsics.checkNotNullParameter((Object)pBlockPos, (String)"pBlockPos");
        return Intrinsics.areEqual((Object)this.lightAndTintPosition, (Object)BlockPos.ZERO) ? 255 : this.realLevel.getBrightness(pLightType, this.lightAndTintPosition);
    }

    public int getBlockTint(@NotNull BlockPos pBlockPos, @NotNull ColorResolver pColorResolver) {
        Intrinsics.checkNotNullParameter((Object)pBlockPos, (String)"pBlockPos");
        Intrinsics.checkNotNullParameter((Object)pColorResolver, (String)"pColorResolver");
        return this.realLevel.getBlockTint(this.lightAndTintPosition, pColorResolver);
    }

    @Nullable
    public BlockEntity getBlockEntity(@NotNull BlockPos pPos) {
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        return null;
    }

    @NotNull
    public BlockState getBlockState(@NotNull BlockPos pPos) {
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        MultiBlockGeometryBase.Voxel voxel = this.model.getBlocks().get(pPos);
        if (voxel == null) {
            BlockState blockState = Blocks.AIR.defaultBlockState();
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"defaultBlockState(...)");
            return blockState;
        }
        return voxel.getState();
    }

    @NotNull
    public FluidState getFluidState(@NotNull BlockPos pPos) {
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        FluidState fluidState = Fluids.EMPTY.defaultFluidState();
        Intrinsics.checkNotNullExpressionValue((Object)fluidState, (String)"defaultFluidState(...)");
        return fluidState;
    }

    public int getHeight() {
        return this.model.getGeometry().getSize().getY();
    }

    public int getMinBuildHeight() {
        return 0;
    }

    public int getRawBrightness(@NotNull BlockPos blockPos, int amount) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        return this.realLevel.getRawBrightness(this.lightAndTintPosition, amount);
    }

    public float getShade(float normalX, float normalY, float normalZ, boolean shade) {
        return this.realLevel.getShade(normalX, normalY, normalZ, shade);
    }

    public boolean canSeeSky(@NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        return this.realLevel.canSeeSky(this.lightAndTintPosition);
    }
}

