/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.yet_another_industrialization.common.item;

import aztech.modern_industrialization.MIComponents;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.inventory.MIFluidStorage;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.inventory.MIItemStorage;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.util.Simulation;
import aztech.modern_industrialization.util.TextHelper;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.luligabi.yet_another_industrialization.common.misc.YAIDataComponents;
import me.luligabi.yet_another_industrialization.common.misc.YAISounds;
import me.luligabi.yet_another_industrialization.common.misc.component.SlotLockerData;
import me.luligabi.yet_another_industrialization.common.util.YAIDraggable;
import me.luligabi.yet_another_industrialization.common.util.YAIText;
import me.luligabi.yet_another_industrialization.common.util.YAIUtilKt;
import me.luligabi.yet_another_industrialization.mixin.MIStorageAccessor;
import me.luligabi.yet_another_industrialization.mixin.UseOnContextAccessor;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.HitResult;
import net.swedz.tesseract.neoforge.compat.mi.tooltip.MICompatibleTextLine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u00010B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0001H\u0002J \u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\fH\u0016J \u0010\u001d\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\fH\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J.\u0010#\u001a\u00020$2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u00020)2\u0006\u0010-\u001a\u00020.H\u0002\u00a8\u00061"}, d2={"Lme/luligabi/yet_another_industrialization/common/item/StorageSlotLockerItem;", "Lnet/minecraft/world/item/Item;", "Lme/luligabi/yet_another_industrialization/common/util/YAIDraggable;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "useOn", "Lnet/minecraft/world/InteractionResult;", "ctx", "Lnet/minecraft/world/item/context/UseOnContext;", "toggleItemLocks", "", "inventory", "Laztech/modern_industrialization/inventory/MIInventory;", "enable", "item", "toggleFluidLocks", "fluid", "Lnet/minecraft/world/level/material/Fluid;", "getInventory", "machine", "Laztech/modern_industrialization/machines/MachineBlockEntity;", "dragItem", "stack", "Lnet/minecraft/world/item/ItemStack;", "itemKey", "Laztech/modern_industrialization/thirdparty/fabrictransfer/api/item/ItemVariant;", "simulation", "dragFluid", "fluidKey", "Laztech/modern_industrialization/thirdparty/fabrictransfer/api/fluid/FluidVariant;", "getTooltipImage", "Ljava/util/Optional;", "Lnet/minecraft/world/inventory/tooltip/TooltipComponent;", "appendHoverText", "", "context", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltipComponents", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "itemTooltipComponent", "data", "Lme/luligabi/yet_another_industrialization/common/misc/component/SlotLockerData;", "fluidTooltipComponent", "TooltipData", "yet_another_industrialization"})
@SourceDebugExtension(value={"SMAP\nStorageSlotLockerItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StorageSlotLockerItem.kt\nme/luligabi/yet_another_industrialization/common/item/StorageSlotLockerItem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,186:1\n1863#2,2:187\n1863#2,2:189\n*S KotlinDebug\n*F\n+ 1 StorageSlotLockerItem.kt\nme/luligabi/yet_another_industrialization/common/item/StorageSlotLockerItem\n*L\n79#1:187,2\n96#1:189,2\n*E\n"})
public final class StorageSlotLockerItem
extends Item
implements YAIDraggable {
    public StorageSlotLockerItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties.stacksTo(1).component((DataComponentType)YAIDataComponents.INSTANCE.getSLOT_LOCKER_DATA().get(), (Object)SlotLockerData.Companion.getEMPTY()).component(MIComponents.ENERGY, (Object)0L));
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext ctx) {
        InteractionResult interactionResult;
        boolean success;
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (ctx.getLevel().isClientSide) {
            return InteractionResult.FAIL;
        }
        if (((UseOnContextAccessor)ctx).getHitResult().getType() != HitResult.Type.BLOCK) {
            return InteractionResult.PASS;
        }
        SlotLockerData slotLockerData = (SlotLockerData)ctx.getItemInHand().get((Supplier)YAIDataComponents.INSTANCE.getSLOT_LOCKER_DATA());
        if (slotLockerData == null) {
            return InteractionResult.PASS;
        }
        SlotLockerData data = slotLockerData;
        BlockEntity blockEntity = ctx.getLevel().getBlockEntity(ctx.getClickedPos());
        MachineBlockEntity machineBlockEntity = blockEntity instanceof MachineBlockEntity ? (MachineBlockEntity)blockEntity : null;
        if (machineBlockEntity == null) {
            return InteractionResult.PASS;
        }
        MachineBlockEntity machine = machineBlockEntity;
        MIInventory mIInventory = this.getInventory(machine);
        if (mIInventory == null) {
            return InteractionResult.PASS;
        }
        MIInventory inventory = mIInventory;
        SlotLockerData.Mode mode = data.getMode();
        Boolean bl3 = mode.getLockItem();
        if (Intrinsics.areEqual((Object)bl3, (Object)true)) {
            if (!data.getItemVariant().isBlank()) {
                Item item = data.getItemVariant().getItem();
                Intrinsics.checkNotNullExpressionValue((Object)item, (String)"getItem(...)");
                bl2 = this.toggleItemLocks(inventory, true, item);
            } else {
                bl2 = false;
            }
        } else if (Intrinsics.areEqual((Object)bl3, (Object)false)) {
            Item item = data.getItemVariant().getItem();
            Intrinsics.checkNotNullExpressionValue((Object)item, (String)"getItem(...)");
            bl2 = this.toggleItemLocks(inventory, false, item);
        } else if (bl3 == null) {
            bl2 = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        boolean modifiedItem = bl2;
        Boolean bl4 = mode.getLockFluid();
        if (Intrinsics.areEqual((Object)bl4, (Object)true)) {
            if (!data.getFluidVariant().isBlank()) {
                Fluid fluid = data.getFluidVariant().getFluid();
                Intrinsics.checkNotNullExpressionValue((Object)fluid, (String)"getFluid(...)");
                bl = this.toggleFluidLocks(inventory, true, fluid);
            } else {
                bl = false;
            }
        } else if (Intrinsics.areEqual((Object)bl4, (Object)false)) {
            Fluid fluid = data.getFluidVariant().getFluid();
            Intrinsics.checkNotNullExpressionValue((Object)fluid, (String)"getFluid(...)");
            bl = this.toggleFluidLocks(inventory, false, fluid);
        } else if (bl4 == null) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        boolean modifiedFluid = bl;
        boolean bl5 = success = modifiedItem || modifiedFluid;
        if (success) {
            ctx.getLevel().playSound(null, ctx.getClickedPos(), YAISounds.INSTANCE.getSTORAGE_SLOT_LOCKER_LOCK().get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        if (success) {
            InteractionResult interactionResult2 = InteractionResult.sidedSuccess((boolean)ctx.getLevel().isClientSide);
            interactionResult = interactionResult2;
            Intrinsics.checkNotNullExpressionValue((Object)interactionResult2, (String)"sidedSuccess(...)");
        } else {
            interactionResult = InteractionResult.FAIL;
        }
        return interactionResult;
    }

    private final boolean toggleItemLocks(MIInventory inventory, boolean enable, Item item) {
        boolean modifiedAny = false;
        MIItemStorage mIItemStorage = inventory.itemStorage;
        Intrinsics.checkNotNull((Object)mIItemStorage, (String)"null cannot be cast to non-null type me.luligabi.yet_another_industrialization.mixin.MIStorageAccessor");
        List<?> list = ((MIStorageAccessor)mIItemStorage).getStacks();
        Intrinsics.checkNotNull(list, (String)"null cannot be cast to non-null type kotlin.collections.List<aztech.modern_industrialization.inventory.ConfigurableItemStack>");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConfigurableItemStack it = (ConfigurableItemStack)element$iv;
            boolean bl = false;
            if (enable) {
                if (!it.getVariant().isBlank() || it.getLockedInstance() != null) continue;
                it.playerLock((Object)item, Simulation.ACT);
                modifiedAny = true;
                continue;
            }
            if (!Intrinsics.areEqual((Object)it.getLockedInstance(), (Object)item)) continue;
            it.togglePlayerLock();
            modifiedAny = true;
        }
        return modifiedAny;
    }

    private final boolean toggleFluidLocks(MIInventory inventory, boolean enable, Fluid fluid) {
        boolean modifiedAny = false;
        MIFluidStorage mIFluidStorage = inventory.fluidStorage;
        Intrinsics.checkNotNull((Object)mIFluidStorage, (String)"null cannot be cast to non-null type me.luligabi.yet_another_industrialization.mixin.MIStorageAccessor");
        List<?> list = ((MIStorageAccessor)mIFluidStorage).getStacks();
        Intrinsics.checkNotNull(list, (String)"null cannot be cast to non-null type kotlin.collections.List<aztech.modern_industrialization.inventory.ConfigurableFluidStack>");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConfigurableFluidStack it = (ConfigurableFluidStack)element$iv;
            boolean bl = false;
            if (enable) {
                if (!it.getVariant().isBlank() || it.getLockedInstance() != null) continue;
                it.playerLock((Object)fluid, Simulation.ACT);
                modifiedAny = true;
                continue;
            }
            if (!Intrinsics.areEqual((Object)it.getLockedInstance(), (Object)fluid)) continue;
            it.togglePlayerLock();
            modifiedAny = true;
        }
        return modifiedAny;
    }

    private final MIInventory getInventory(MachineBlockEntity machine) {
        if (Intrinsics.areEqual((Object)machine.getInventory(), (Object)MIInventory.EMPTY)) {
            return null;
        }
        return machine.getInventory();
    }

    @Override
    public boolean dragItem(@NotNull ItemStack stack, @NotNull ItemVariant itemKey, boolean simulation) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)itemKey, (String)"itemKey");
        if (simulation) {
            return true;
        }
        SlotLockerData slotLockerData = (SlotLockerData)stack.get((Supplier)YAIDataComponents.INSTANCE.getSLOT_LOCKER_DATA());
        if (slotLockerData == null || (slotLockerData = SlotLockerData.copy$default(slotLockerData, itemKey, null, null, 6, null)) == null) {
            return false;
        }
        SlotLockerData data = slotLockerData;
        stack.set((Supplier)YAIDataComponents.INSTANCE.getSLOT_LOCKER_DATA(), (Object)data);
        return true;
    }

    @Override
    public boolean dragFluid(@NotNull ItemStack stack, @NotNull FluidVariant fluidKey, boolean simulation) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)fluidKey, (String)"fluidKey");
        if (simulation) {
            return true;
        }
        SlotLockerData slotLockerData = (SlotLockerData)stack.get((Supplier)YAIDataComponents.INSTANCE.getSLOT_LOCKER_DATA());
        if (slotLockerData == null || (slotLockerData = SlotLockerData.copy$default(slotLockerData, null, fluidKey, null, 5, null)) == null) {
            return false;
        }
        SlotLockerData data = slotLockerData;
        stack.set((Supplier)YAIDataComponents.INSTANCE.getSLOT_LOCKER_DATA(), (Object)data);
        return true;
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        SlotLockerData slotLockerData = (SlotLockerData)stack.get((Supplier)YAIDataComponents.INSTANCE.getSLOT_LOCKER_DATA());
        if (slotLockerData == null) {
            Optional<TooltipComponent> optional = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
            return optional;
        }
        SlotLockerData data = slotLockerData;
        Optional<TooltipComponent> optional = Optional.of(new TooltipData(data.getItemVariant(), data.getFluidVariant(), data.getMode()));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
        return optional;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(tooltipComponents, (String)"tooltipComponents");
            Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
            SlotLockerData slotLockerData = (SlotLockerData)stack.get((Supplier)YAIDataComponents.INSTANCE.getSLOT_LOCKER_DATA());
            if (slotLockerData == null) break block1;
            SlotLockerData it = slotLockerData;
            boolean bl = false;
            if (Screen.hasShiftDown()) {
                MICompatibleTextLine mICompatibleTextLine = YAIText.SLOT_LOCKER_TOOLTIP_1.arg(this.itemTooltipComponent(it)).arg((Object)this.fluidTooltipComponent(it));
                Intrinsics.checkNotNullExpressionValue((Object)mICompatibleTextLine, (String)"arg(...)");
                tooltipComponents.add((Component)mICompatibleTextLine);
            }
            Object[] objectArray = new Object[1];
            MutableComponent mutableComponent = it.getMode().getText().text();
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"text(...)");
            Style style = TextHelper.NUMBER_TEXT;
            Intrinsics.checkNotNullExpressionValue((Object)style, (String)"NUMBER_TEXT");
            objectArray[0] = YAIUtilKt.applyStyle(mutableComponent, style);
            MutableComponent mutableComponent2 = YAIText.SLOT_LOCKER_MODE_PREFIX.text(objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"text(...)");
            Style style2 = TextHelper.GRAY_TEXT;
            Intrinsics.checkNotNullExpressionValue((Object)style2, (String)"GRAY_TEXT");
            tooltipComponents.add((Component)YAIUtilKt.applyStyle(mutableComponent2, style2));
        }
    }

    private final Component itemTooltipComponent(SlotLockerData data) {
        ItemVariant variant = data.getItemVariant();
        if (variant.isBlank()) {
            MutableComponent mutableComponent = YAIText.NONE.text();
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"text(...)");
            Style style = TextHelper.GRAY_TEXT;
            Intrinsics.checkNotNullExpressionValue((Object)style, (String)"GRAY_TEXT");
            return (Component)YAIUtilKt.applyStyle(mutableComponent, style);
        }
        MutableComponent mutableComponent = variant.getItem().getName(variant.toStack()).copy();
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"copy(...)");
        Style style = YAIUtilKt.getITEM_STYLE();
        Intrinsics.checkNotNullExpressionValue((Object)style, (String)"<get-ITEM_STYLE>(...)");
        return (Component)YAIUtilKt.applyStyle(mutableComponent, style);
    }

    private final Component fluidTooltipComponent(SlotLockerData data) {
        FluidVariant variant = data.getFluidVariant();
        if (variant.isBlank()) {
            MutableComponent mutableComponent = YAIText.NONE.text();
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"text(...)");
            Style style = TextHelper.GRAY_TEXT;
            Intrinsics.checkNotNullExpressionValue((Object)style, (String)"GRAY_TEXT");
            return (Component)YAIUtilKt.applyStyle(mutableComponent, style);
        }
        MutableComponent mutableComponent = variant.toStack(1).getHoverName().copy();
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"copy(...)");
        Style style = YAIUtilKt.getFLUID_STYLE();
        Intrinsics.checkNotNullExpressionValue((Object)style, (String)"<get-FLUID_STYLE>(...)");
        return (Component)YAIUtilKt.applyStyle(mutableComponent, style);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lme/luligabi/yet_another_industrialization/common/item/StorageSlotLockerItem$TooltipData;", "Lnet/minecraft/world/inventory/tooltip/TooltipComponent;", "itemVariant", "Laztech/modern_industrialization/thirdparty/fabrictransfer/api/item/ItemVariant;", "fluidVariant", "Laztech/modern_industrialization/thirdparty/fabrictransfer/api/fluid/FluidVariant;", "mode", "Lme/luligabi/yet_another_industrialization/common/misc/component/SlotLockerData$Mode;", "<init>", "(Laztech/modern_industrialization/thirdparty/fabrictransfer/api/item/ItemVariant;Laztech/modern_industrialization/thirdparty/fabrictransfer/api/fluid/FluidVariant;Lme/luligabi/yet_another_industrialization/common/misc/component/SlotLockerData$Mode;)V", "getItemVariant", "()Laztech/modern_industrialization/thirdparty/fabrictransfer/api/item/ItemVariant;", "getFluidVariant", "()Laztech/modern_industrialization/thirdparty/fabrictransfer/api/fluid/FluidVariant;", "getMode", "()Lme/luligabi/yet_another_industrialization/common/misc/component/SlotLockerData$Mode;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "yet_another_industrialization"})
    public static final class TooltipData
    implements TooltipComponent {
        @NotNull
        private final ItemVariant itemVariant;
        @NotNull
        private final FluidVariant fluidVariant;
        @NotNull
        private final SlotLockerData.Mode mode;

        public TooltipData(@NotNull ItemVariant itemVariant, @NotNull FluidVariant fluidVariant, @NotNull SlotLockerData.Mode mode) {
            Intrinsics.checkNotNullParameter((Object)itemVariant, (String)"itemVariant");
            Intrinsics.checkNotNullParameter((Object)fluidVariant, (String)"fluidVariant");
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            this.itemVariant = itemVariant;
            this.fluidVariant = fluidVariant;
            this.mode = mode;
        }

        @NotNull
        public final ItemVariant getItemVariant() {
            return this.itemVariant;
        }

        @NotNull
        public final FluidVariant getFluidVariant() {
            return this.fluidVariant;
        }

        @NotNull
        public final SlotLockerData.Mode getMode() {
            return this.mode;
        }

        @NotNull
        public final ItemVariant component1() {
            return this.itemVariant;
        }

        @NotNull
        public final FluidVariant component2() {
            return this.fluidVariant;
        }

        @NotNull
        public final SlotLockerData.Mode component3() {
            return this.mode;
        }

        @NotNull
        public final TooltipData copy(@NotNull ItemVariant itemVariant, @NotNull FluidVariant fluidVariant, @NotNull SlotLockerData.Mode mode) {
            Intrinsics.checkNotNullParameter((Object)itemVariant, (String)"itemVariant");
            Intrinsics.checkNotNullParameter((Object)fluidVariant, (String)"fluidVariant");
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            return new TooltipData(itemVariant, fluidVariant, mode);
        }

        public static /* synthetic */ TooltipData copy$default(TooltipData tooltipData, ItemVariant itemVariant, FluidVariant fluidVariant, SlotLockerData.Mode mode, int n, Object object) {
            if ((n & 1) != 0) {
                itemVariant = tooltipData.itemVariant;
            }
            if ((n & 2) != 0) {
                fluidVariant = tooltipData.fluidVariant;
            }
            if ((n & 4) != 0) {
                mode = tooltipData.mode;
            }
            return tooltipData.copy(itemVariant, fluidVariant, mode);
        }

        @NotNull
        public String toString() {
            return "TooltipData(itemVariant=" + this.itemVariant + ", fluidVariant=" + this.fluidVariant + ", mode=" + this.mode + ")";
        }

        public int hashCode() {
            int result = this.itemVariant.hashCode();
            result = result * 31 + this.fluidVariant.hashCode();
            result = result * 31 + this.mode.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TooltipData)) {
                return false;
            }
            TooltipData tooltipData = (TooltipData)other;
            if (!Intrinsics.areEqual((Object)this.itemVariant, (Object)tooltipData.itemVariant)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.fluidVariant, (Object)tooltipData.fluidVariant)) {
                return false;
            }
            return this.mode == tooltipData.mode;
        }
    }
}

