/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.yet_another_industrialization.client.model.multiblock;

import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.luligabi.yet_another_industrialization.client.model.multiblock.MultiBlockBakedQuad;
import me.luligabi.yet_another_industrialization.client.model.multiblock.MultiBlockGeometry;
import me.luligabi.yet_another_industrialization.common.model.multiblock.MultiBlockGeometryBase;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.IQuadTransformer;
import net.neoforged.neoforge.client.model.QuadTransformers;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 22\u00020\u0001:\u00012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J<\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020#H\u0016J\b\u0010%\u001a\u00020#H\u0016J\b\u0010&\u001a\u00020#H\u0016J\u0015\u0010'\u001a\n )*\u0004\u0018\u00010(0(H\u0016\u00a2\u0006\u0002\u0010*J \u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020\u001fH\u0016J\b\u00100\u001a\u000201H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\"\u0010\b\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00063"}, d2={"Lme/luligabi/yet_another_industrialization/client/model/multiblock/MultiBlockModel;", "Lnet/neoforged/neoforge/client/model/IDynamicBakedModel;", "geometry", "Lme/luligabi/yet_another_industrialization/client/model/multiblock/MultiBlockGeometry;", "<init>", "(Lme/luligabi/yet_another_industrialization/client/model/multiblock/MultiBlockGeometry;)V", "getGeometry", "()Lme/luligabi/yet_another_industrialization/client/model/multiblock/MultiBlockGeometry;", "cache", "", "Lnet/minecraft/core/Direction;", "", "Lnet/minecraft/client/renderer/block/model/BakedQuad;", "scaleToBlocks", "", "scale", "", "blocks", "", "Lnet/minecraft/core/BlockPos;", "Lme/luligabi/yet_another_industrialization/common/model/multiblock/MultiBlockGeometryBase$Voxel;", "getBlocks", "()Ljava/util/Map;", "getQuads", "", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "direction", "randomSource", "Lnet/minecraft/util/RandomSource;", "modelData", "Lnet/neoforged/neoforge/client/model/data/ModelData;", "renderType", "Lnet/minecraft/client/renderer/RenderType;", "useAmbientOcclusion", "", "isGui3d", "usesBlockLight", "isCustomRenderer", "getParticleIcon", "Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "kotlin.jvm.PlatformType", "()Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "getRenderTypes", "Lnet/neoforged/neoforge/client/ChunkRenderTypeSet;", "state", "rand", "data", "getOverrides", "Lnet/minecraft/client/renderer/block/model/ItemOverrides;", "Companion", "yet_another_industrialization"})
public final class MultiBlockModel
implements IDynamicBakedModel {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final MultiBlockGeometry geometry;
    @NotNull
    private final Map<Direction, List<BakedQuad>> cache;
    private final int scaleToBlocks;
    private final float scale;
    @NotNull
    private final Map<BlockPos, MultiBlockGeometryBase.Voxel> blocks;
    @NotNull
    private static final Material MISSING_TEXTURE = new Material(TextureAtlas.LOCATION_BLOCKS, MissingTextureAtlasSprite.getLocation());

    public MultiBlockModel(@NotNull MultiBlockGeometry geometry) {
        Intrinsics.checkNotNullParameter((Object)geometry, (String)"geometry");
        this.geometry = geometry;
        this.cache = new HashMap();
        this.scaleToBlocks = this.geometry.getScaleToBlocks();
        this.blocks = this.geometry.getVoxels();
        int width = 0;
        int height = 0;
        int depth = 0;
        for (BlockPos pos : this.blocks.keySet()) {
            if (pos.getX() > width) {
                width = pos.getX();
            }
            if (pos.getY() > height) {
                height = pos.getY();
            }
            if (pos.getZ() <= depth) continue;
            depth = pos.getZ();
        }
        int dim = Math.max(height, Math.max(width, depth));
        if (height > 6 || ++dim <= 4) {
            dim = Math.max(6, dim);
        }
        this.scale = (float)this.scaleToBlocks / (float)dim;
    }

    @NotNull
    public final MultiBlockGeometry getGeometry() {
        return this.geometry;
    }

    @NotNull
    public final Map<BlockPos, MultiBlockGeometryBase.Voxel> getBlocks() {
        return this.blocks;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState blockState, @Nullable Direction direction, @NotNull RandomSource randomSource, @NotNull ModelData modelData, @Nullable RenderType renderType) {
        Intrinsics.checkNotNullParameter((Object)randomSource, (String)"randomSource");
        Intrinsics.checkNotNullParameter((Object)modelData, (String)"modelData");
        if (this.cache.isEmpty() || !this.cache.containsKey(direction)) {
            this.cache.put(direction, new ArrayList());
            Vector3f centerOffset = new Vector3f((float)this.geometry.getTrunkPos().getX() + 0.5f, 0.0f, (float)this.geometry.getTrunkPos().getZ() + 0.5f);
            for (MultiBlockGeometryBase.Voxel voxel : this.blocks.values()) {
                List modelQuads;
                IQuadTransformer scaler;
                IQuadTransformer centerer;
                IQuadTransformer translator;
                Intrinsics.checkNotNullExpressionValue((Object)voxel.model().getQuads(voxel.getState(), direction, randomSource, modelData, null), (String)"getQuads(...)");
                Transformation translate = new Transformation(new Matrix4f().translate((float)voxel.getPos().getX(), (float)voxel.getPos().getY(), (float)voxel.getPos().getZ()));
                Transformation translateCenter = new Transformation(new Matrix4f().translate(-centerOffset.x, 0.0f, -centerOffset.z));
                Transformation scale = new Transformation(new Matrix4f().scale(this.scale));
                Intrinsics.checkNotNullExpressionValue((Object)QuadTransformers.applying((Transformation)translate), (String)"applying(...)");
                Intrinsics.checkNotNullExpressionValue((Object)QuadTransformers.applying((Transformation)translateCenter), (String)"applying(...)");
                Intrinsics.checkNotNullExpressionValue((Object)QuadTransformers.applying((Transformation)scale), (String)"applying(...)");
                List transformedQuads = translator.andThen(centerer).andThen(scaler).process(modelQuads);
                for (BakedQuad quad : transformedQuads) {
                    List<BakedQuad> list = this.cache.get(direction);
                    Intrinsics.checkNotNull(list);
                    Intrinsics.checkNotNull((Object)quad);
                    list.add(MultiBlockBakedQuad.Companion.of(quad, voxel.getState(), voxel.getPos()));
                }
            }
        }
        List<BakedQuad> list = this.cache.get(direction);
        Intrinsics.checkNotNull(list);
        return list;
    }

    public boolean useAmbientOcclusion() {
        return true;
    }

    public boolean isGui3d() {
        return false;
    }

    public boolean usesBlockLight() {
        return false;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    public TextureAtlasSprite getParticleIcon() {
        return MISSING_TEXTURE.sprite();
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        RenderType[] renderTypeArray = new RenderType[]{RenderType.TRANSLUCENT};
        ChunkRenderTypeSet chunkRenderTypeSet = ChunkRenderTypeSet.of((RenderType[])renderTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)chunkRenderTypeSet, (String)"of(...)");
        return chunkRenderTypeSet;
    }

    @NotNull
    public ItemOverrides getOverrides() {
        ItemOverrides itemOverrides = ItemOverrides.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)itemOverrides, (String)"EMPTY");
        return itemOverrides;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lme/luligabi/yet_another_industrialization/client/model/multiblock/MultiBlockModel$Companion;", "", "<init>", "()V", "MISSING_TEXTURE", "Lnet/minecraft/client/resources/model/Material;", "getMISSING_TEXTURE", "()Lnet/minecraft/client/resources/model/Material;", "yet_another_industrialization"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Material getMISSING_TEXTURE() {
            return MISSING_TEXTURE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

