/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.yet_another_industrialization.common.block.machine.misc;

import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.AutoExtract;
import aztech.modern_industrialization.machines.multiblocks.HatchBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.HatchType;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.luligabi.yet_another_industrialization.common.misc.YAIHatchTypes;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u0016\u0010\u0014\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u0016\u0010\u0015\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00160\u0012H\u0016J\u0016\u0010\u0017\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00160\u0012H\u0016J\b\u0010\u0018\u001a\u00020\u0010H\u0014J\u0015\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001aH\u0016\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\u001d\u001a\u00020\nH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lme/luligabi/yet_another_industrialization/common/block/machine/misc/MixedHatch;", "Laztech/modern_industrialization/machines/multiblocks/HatchBlockEntity;", "bep", "Laztech/modern_industrialization/machines/BEP;", "machineId", "", "input", "", "upgradesToSteel", "inventory", "Laztech/modern_industrialization/inventory/MIInventory;", "backgroundHeight", "", "<init>", "(Laztech/modern_industrialization/machines/BEP;Ljava/lang/String;ZZLaztech/modern_industrialization/inventory/MIInventory;I)V", "appendItemInputs", "", "list", "", "Laztech/modern_industrialization/inventory/ConfigurableItemStack;", "appendItemOutputs", "appendFluidInputs", "Laztech/modern_industrialization/inventory/ConfigurableFluidStack;", "appendFluidOutputs", "tickTransfer", "getHatchType", "Laztech/modern_industrialization/machines/multiblocks/HatchType;", "kotlin.jvm.PlatformType", "()Laztech/modern_industrialization/machines/multiblocks/HatchType;", "getInventory", "yet_another_industrialization"})
public final class MixedHatch
extends HatchBlockEntity {
    private final boolean input;
    private final boolean upgradesToSteel;
    @NotNull
    private final MIInventory inventory;

    public MixedHatch(@NotNull BEP bep, @NotNull String machineId, boolean input, boolean upgradesToSteel, @NotNull MIInventory inventory, int backgroundHeight) {
        Intrinsics.checkNotNullParameter((Object)bep, (String)"bep");
        Intrinsics.checkNotNullParameter((Object)machineId, (String)"machineId");
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        super(bep, new MachineGuiParameters.Builder(machineId, true).backgroundHeight(backgroundHeight).build(), new OrientationComponent.Params(true, true, true));
        this.input = input;
        this.upgradesToSteel = upgradesToSteel;
        this.inventory = inventory;
        IComponent[] iComponentArray = new IComponent[]{this.inventory};
        this.registerComponents(iComponentArray);
        iComponentArray = new GuiComponent.Server[]{new AutoExtract.Server(this.orientation, this.input)};
        this.registerGuiComponent((GuiComponent.Server[])iComponentArray);
    }

    public void appendItemInputs(@NotNull List<ConfigurableItemStack> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        if (this.input) {
            List list2 = this.inventory.getItemStacks();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getItemStacks(...)");
            list.addAll(list2);
        }
    }

    public void appendItemOutputs(@NotNull List<ConfigurableItemStack> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        if (!this.input) {
            List list2 = this.inventory.getItemStacks();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getItemStacks(...)");
            list.addAll(list2);
        }
    }

    public void appendFluidInputs(@NotNull List<ConfigurableFluidStack> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        if (this.input) {
            List list2 = this.inventory.getFluidStacks();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getFluidStacks(...)");
            list.addAll(list2);
        }
    }

    public void appendFluidOutputs(@NotNull List<ConfigurableFluidStack> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        if (!this.input) {
            List list2 = this.inventory.getFluidStacks();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getFluidStacks(...)");
            list.addAll(list2);
        }
    }

    protected void tickTransfer() {
        if (this.orientation.extractItems) {
            if (this.input) {
                this.inventory.autoInsertItems(this.level, this.worldPosition, this.orientation.outputDirection);
            } else {
                this.inventory.autoExtractItems(this.level, this.worldPosition, this.orientation.outputDirection);
            }
        }
        if (this.orientation.extractFluids) {
            if (this.input) {
                this.inventory.autoInsertFluids(this.level, this.worldPosition, this.orientation.outputDirection);
            } else {
                this.inventory.autoExtractFluids(this.level, this.worldPosition, this.orientation.outputDirection);
            }
        }
    }

    public HatchType getHatchType() {
        return this.input ? YAIHatchTypes.INSTANCE.getMIXED_INPUT() : YAIHatchTypes.INSTANCE.getMIXED_OUTPUT();
    }

    public boolean upgradesToSteel() {
        return this.upgradesToSteel;
    }

    @NotNull
    public MIInventory getInventory() {
        return this.inventory;
    }
}

