/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.yet_another_industrialization.datagen.server.provider.recipe;

import aztech.modern_industrialization.machines.recipe.condition.MachineProcessCondition;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import me.luligabi.yet_another_industrialization.common.YAI;
import me.luligabi.yet_another_industrialization.common.block.machine.YAIMachines;
import me.luligabi.yet_another_industrialization.common.block.machine.arboreous_greenhouse.ArboreousGreenhouseTierCondition;
import me.luligabi.yet_another_industrialization.common.misc.YAIFluids;
import me.luligabi.yet_another_industrialization.common.misc.datamap.ArboreousGreenhouseTier;
import me.luligabi.yet_another_industrialization.datagen.server.provider.ArboreousGreenhouseSaplingExtractor;
import me.luligabi.yet_another_industrialization.datagen.server.provider.DataMapProvider;
import me.luligabi.yet_another_industrialization.datagen.server.provider.recipe.YAIRecipeProvider;
import me.luligabi.yet_another_industrialization.datagen.server.util.ArboreousGreenhouseSapling;
import me.luligabi.yet_another_industrialization.mixin.LootItemAccessor;
import me.luligabi.yet_another_industrialization.mixin.MIRecipeJsonAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.gametest.framework.GameTestServer;
import net.minecraft.gametest.framework.TestFunction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.FolderRepositorySource;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.server.packs.repository.ServerPacksSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.CompositeEntryBase;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.validation.DirectoryValidator;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.resource.ResourcePackLoader;
import net.swedz.tesseract.neoforge.compat.mi.recipe.MIMachineRecipeBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J0\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J4\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u0012H\u0002J\u0018\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002Jd\u0010 \u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010$2\u001e\u0010\u0006\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)0'0&2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u0007H\u0002\u00a8\u0006,"}, d2={"Lme/luligabi/yet_another_industrialization/datagen/server/provider/recipe/ArboreousGreenhouseRecipeProvider;", "Lme/luligabi/yet_another_industrialization/datagen/server/provider/recipe/YAIRecipeProvider;", "<init>", "()V", "buildRecipes", "", "output", "Lnet/minecraft/data/recipes/RecipeOutput;", "lookup", "Lnet/minecraft/core/HolderLookup$Provider;", "generateSaplingRecipes", "id", "", "itemId", "Lnet/minecraft/resources/ResourceLocation;", "data", "Lme/luligabi/yet_another_industrialization/datagen/server/util/ArboreousGreenhouseSapling;", "server", "Lnet/minecraft/server/MinecraftServer;", "generateRecipe", "Lnet/swedz/tesseract/neoforge/compat/mi/recipe/MIMachineRecipeBuilder;", "tier", "Lme/luligabi/yet_another_industrialization/common/misc/datamap/ArboreousGreenhouseTier;", "sapling", "Lnet/minecraft/world/item/Item;", "isNutrient", "", "getFirstStaticLootItemId", "table", "Lnet/minecraft/world/level/storage/loot/LootTable;", "startFakeServer", "buildManualArboreousGreenhouseRecipes", "addArboreousGreenhouseRecipe", "input", "Lnet/minecraft/world/level/ItemLike;", "fluid", "Lnet/minecraft/world/level/material/Fluid;", "nutrientFluid", "", "Lkotlin/Triple;", "", "", "model", "recipeOutput", "yet_another_industrialization"})
@SourceDebugExtension(value={"SMAP\nArboreousGreenhouseRecipeProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArboreousGreenhouseRecipeProvider.kt\nme/luligabi/yet_another_industrialization/datagen/server/provider/recipe/ArboreousGreenhouseRecipeProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,260:1\n1863#2,2:261\n295#2,2:263\n1863#2,2:265\n1863#2,2:267\n1863#2,2:269\n*S KotlinDebug\n*F\n+ 1 ArboreousGreenhouseRecipeProvider.kt\nme/luligabi/yet_another_industrialization/datagen/server/provider/recipe/ArboreousGreenhouseRecipeProvider\n*L\n102#1:261,2\n148#1:263,2\n136#1:265,2\n228#1:267,2\n249#1:269,2\n*E\n"})
public final class ArboreousGreenhouseRecipeProvider
implements YAIRecipeProvider {
    @NotNull
    public static final ArboreousGreenhouseRecipeProvider INSTANCE = new ArboreousGreenhouseRecipeProvider();

    private ArboreousGreenhouseRecipeProvider() {
    }

    @Override
    public void buildRecipes(@NotNull RecipeOutput output, @NotNull HolderLookup.Provider lookup) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        MinecraftServer server = this.startFakeServer();
        for (Map.Entry<ResourceLocation, ArboreousGreenhouseSapling> entry : ArboreousGreenhouseSaplingExtractor.Companion.getSAPLING_DATA().entrySet()) {
            ResourceLocation id = entry.getKey();
            ArboreousGreenhouseSapling data = entry.getValue();
            this.generateSaplingRecipes("arboreous_greenhouse/" + id.getNamespace() + "/" + id.getPath(), id, data, server, output);
        }
        server.stopServer();
        this.buildManualArboreousGreenhouseRecipes(output, lookup);
    }

    private final void generateSaplingRecipes(String id, ResourceLocation itemId, ArboreousGreenhouseSapling data, MinecraftServer server, RecipeOutput output) {
        ArboreousGreenhouseTier arboreousGreenhouseTier = DataMapProvider.Companion.getAG_TIERS().get(data.getTier());
        if (arboreousGreenhouseTier == null) {
            return;
        }
        ArboreousGreenhouseTier tier = arboreousGreenhouseTier;
        Object object = BuiltInRegistries.ITEM.get(itemId);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Item sapling = (Item)object;
        if (Intrinsics.areEqual((Object)sapling, (Object)Items.AIR)) {
            return;
        }
        ModLoadedCondition condition = new ModLoadedCondition(itemId.getNamespace());
        MIMachineRecipeBuilder mIMachineRecipeBuilder = ArboreousGreenhouseRecipeProvider.generateRecipe$default(this, data, tier, sapling, server, false, 16, null);
        if (mIMachineRecipeBuilder == null) {
            return;
        }
        ICondition[] iConditionArray = new ICondition[]{condition};
        mIMachineRecipeBuilder.offerTo(output.withConditions(iConditionArray), YAI.Companion.id(id + "/regular"));
        mIMachineRecipeBuilder = this.generateRecipe(data, tier, sapling, server, true);
        if (mIMachineRecipeBuilder != null) {
            ICondition[] iConditionArray2 = new ICondition[]{condition};
            mIMachineRecipeBuilder.offerTo(output.withConditions(iConditionArray2), YAI.Companion.id(id + "/nutrient"));
        }
    }

    private final MIMachineRecipeBuilder generateRecipe(ArboreousGreenhouseSapling data, ArboreousGreenhouseTier tier, Item sapling, MinecraftServer server, boolean isNutrient) {
        MIMachineRecipeBuilder mIMachineRecipeBuilder;
        if (isNutrient && tier.getNutrientFluid().isEmpty()) {
            return null;
        }
        MIMachineRecipeBuilder $this$generateRecipe_u24lambda_u241 = mIMachineRecipeBuilder = new MIMachineRecipeBuilder(YAIMachines.RecipeTypes.INSTANCE.getARBOREOUS_GREENHOUSE(), 15, 1200);
        boolean bl = false;
        $this$generateRecipe_u24lambda_u241.addItemInput((ItemLike)sapling, 1, 0.0f);
        Iterable $this$forEach$iv = data.getLootData();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LootTable lootTable;
            Item output;
            ArboreousGreenhouseSapling.LootData it = (ArboreousGreenhouseSapling.LootData)element$iv;
            boolean bl2 = false;
            if (server.reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)it.getLootTable())) == null || (output = INSTANCE.getFirstStaticLootItemId(lootTable)) == null || Intrinsics.areEqual((Object)output, (Object)Items.AIR)) continue;
            int amount = !isNutrient ? it.getAmount() : it.getAmount() * 2;
            $this$generateRecipe_u24lambda_u241.addItemOutput((ItemLike)output, amount, it.getProbability());
        }
        if (((MIRecipeJsonAccessor)$this$generateRecipe_u24lambda_u241).getRecipe().itemOutputs.isEmpty()) {
            return null;
        }
        if (!isNutrient) {
            ArboreousGreenhouseTier.FluidByIdInput fluidByIdInput = (ArboreousGreenhouseTier.FluidByIdInput)OptionalsKt.getOrNull(tier.getFluid());
            if (fluidByIdInput != null) {
                fluidByIdInput.addToRecipeInput($this$generateRecipe_u24lambda_u241);
            }
            v1 = (MIMachineRecipeBuilder)$this$generateRecipe_u24lambda_u241.addItemOutput((ItemLike)sapling, 1, 0.5f);
        } else {
            ArboreousGreenhouseTier.FluidByIdInput fluidByIdInput = (ArboreousGreenhouseTier.FluidByIdInput)OptionalsKt.getOrNull(tier.getNutrientFluid());
            if (fluidByIdInput != null) {
                fluidByIdInput.addToRecipeInput($this$generateRecipe_u24lambda_u241);
            }
            v1 = (MIMachineRecipeBuilder)$this$generateRecipe_u24lambda_u241.addItemOutput((ItemLike)sapling, 1, 1.0f);
        }
        $this$generateRecipe_u24lambda_u241.addCondition((MachineProcessCondition)new ArboreousGreenhouseTierCondition(data.getTier(), data.getModel()));
        return mIMachineRecipeBuilder;
    }

    static /* synthetic */ MIMachineRecipeBuilder generateRecipe$default(ArboreousGreenhouseRecipeProvider arboreousGreenhouseRecipeProvider, ArboreousGreenhouseSapling arboreousGreenhouseSapling, ArboreousGreenhouseTier arboreousGreenhouseTier, Item item, MinecraftServer minecraftServer, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return arboreousGreenhouseRecipeProvider.generateRecipe(arboreousGreenhouseSapling, arboreousGreenhouseTier, item, minecraftServer, bl);
    }

    private final Item getFirstStaticLootItemId(LootTable table) {
        Item item;
        Object v1;
        List allItems;
        block4: {
            allItems = new ArrayList();
            for (LootPool pool : table.pools) {
                for (LootPoolEntryContainer entry : pool.entries) {
                    Intrinsics.checkNotNull((Object)entry);
                    ArboreousGreenhouseRecipeProvider.getFirstStaticLootItemId$collectItems(allItems, entry);
                }
            }
            Iterable $this$firstOrNull$iv = allItems;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Item it = (Item)element$iv;
                boolean bl = false;
                String string = BuiltInRegistries.ITEM.getKey((Object)it).getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"leaves", (boolean)false, (int)2, null)) continue;
                v1 = element$iv;
                break block4;
            }
            v1 = null;
        }
        if ((item = (Item)v1) == null) {
            item = (Item)CollectionsKt.firstOrNull((List)allItems);
        }
        return item;
    }

    private final MinecraftServer startFakeServer() {
        LevelStorageSource.LevelStorageAccess storageAccess = LevelStorageSource.createDefault((Path)Paths.get("dummy_saves", new String[0])).createAccess("dummy_world");
        Path worldPath = storageAccess.getLevelPath(LevelResource.ROOT);
        DirectoryValidator validator = new DirectoryValidator(ArboreousGreenhouseRecipeProvider::startFakeServer$lambda$3);
        RepositorySource[] repositorySourceArray = new RepositorySource[]{new ServerPacksSource(validator), new FolderRepositorySource(worldPath.resolve("datapacks"), PackType.SERVER_DATA, PackSource.SERVER, validator)};
        PackRepository packRepository = new PackRepository(repositorySourceArray);
        ResourcePackLoader.populatePackRepository((PackRepository)packRepository, (PackType)PackType.SERVER_DATA, (boolean)true);
        TestFunction dummyTest = new TestFunction("dummy_tests", "dummiest_test_ever", "dummy_tower", Rotation.CLOCKWISE_90, 20, 10L, true, true, 10, 1, true, ArboreousGreenhouseRecipeProvider::startFakeServer$lambda$4);
        GameTestServer server = GameTestServer.create((Thread)Thread.currentThread(), (LevelStorageSource.LevelStorageAccess)storageAccess, (PackRepository)packRepository, (Collection)CollectionsKt.listOf((Object)dummyTest), (BlockPos)BlockPos.ZERO);
        server.initServer();
        Intrinsics.checkNotNull((Object)server);
        return (MinecraftServer)server;
    }

    private final void buildManualArboreousGreenhouseRecipes(RecipeOutput output, HolderLookup.Provider lookup) {
        Item item = Items.CHORUS_FRUIT;
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"CHORUS_FRUIT");
        ItemLike itemLike = (ItemLike)item;
        Fluid fluid = YAIFluids.INSTANCE.getDRAGONS_BREATH().asFluid();
        Fluid fluid2 = YAIFluids.INSTANCE.getNUTRIENT_RICH_DRAGONS_BREATH().asFluid();
        Object[] objectArray = new Triple[]{new Triple((Object)Items.CHORUS_FRUIT, (Object)8, (Object)Float.valueOf(1.0f)), new Triple((Object)Items.CHORUS_FLOWER, (Object)1, (Object)Float.valueOf(1.0f))};
        List list = CollectionsKt.listOf((Object[])objectArray);
        ResourceLocation resourceLocation = YAI.Companion.id("end_stone");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
        ResourceLocation resourceLocation2 = ResourceLocation.withDefaultNamespace((String)"chorus_flower");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"withDefaultNamespace(...)");
        this.addArboreousGreenhouseRecipe("minecraft/chorus_fruit", itemLike, fluid, fluid2, list, resourceLocation, resourceLocation2, output);
    }

    private final void addArboreousGreenhouseRecipe(String id, ItemLike input, Fluid fluid, Fluid nutrientFluid, List<? extends Triple<? extends ItemLike, Integer, Float>> output, ResourceLocation tier, ResourceLocation model, RecipeOutput recipeOutput) {
        if (fluid != null) {
            this.addMachineRecipe("arboreous_greenhouse/" + id + "/regular", YAIMachines.RecipeTypes.INSTANCE.getARBOREOUS_GREENHOUSE(), 15, 1200, (Function1<? super MIMachineRecipeBuilder, Unit>)((Function1)arg_0 -> ArboreousGreenhouseRecipeProvider.addArboreousGreenhouseRecipe$lambda$6(input, fluid, output, tier, model, arg_0)), recipeOutput);
        }
        if (nutrientFluid == null) {
            return;
        }
        this.addMachineRecipe("arboreous_greenhouse/" + id + "/nutrient", YAIMachines.RecipeTypes.INSTANCE.getARBOREOUS_GREENHOUSE(), 15, 1200, (Function1<? super MIMachineRecipeBuilder, Unit>)((Function1)arg_0 -> ArboreousGreenhouseRecipeProvider.addArboreousGreenhouseRecipe$lambda$8(input, nutrientFluid, output, tier, model, arg_0)), recipeOutput);
    }

    private static final void getFirstStaticLootItemId$collectItems(List<Item> allItems, LootPoolEntryContainer entry) {
        LootPoolEntryContainer lootPoolEntryContainer = entry;
        if (lootPoolEntryContainer instanceof LootItem) {
            LootPoolEntryContainer lootPoolEntryContainer2 = entry;
            Intrinsics.checkNotNull((Object)lootPoolEntryContainer2, (String)"null cannot be cast to non-null type me.luligabi.yet_another_industrialization.mixin.LootItemAccessor");
            Item item = (Item)((LootItemAccessor)lootPoolEntryContainer2).getItem().value();
            ((Collection)allItems).add(item);
        } else if (lootPoolEntryContainer instanceof CompositeEntryBase) {
            List list = ((CompositeEntryBase)entry).children;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"children");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LootPoolEntryContainer p0 = (LootPoolEntryContainer)element$iv;
                boolean bl = false;
                boolean $i$f$getFirstStaticLootItemId$collectItems$stub_for_inlining = false;
                ArboreousGreenhouseRecipeProvider.getFirstStaticLootItemId$collectItems(allItems, p0);
            }
        }
    }

    private static final boolean startFakeServer$lambda$3(Path it) {
        return true;
    }

    private static final void startFakeServer$lambda$4(GameTestHelper it) {
        it.startSequence();
        it.assertTrue(true, "no way :o");
    }

    private static final Unit addArboreousGreenhouseRecipe$lambda$6(ItemLike $input, Fluid $fluid, List $output, ResourceLocation $tier, ResourceLocation $model, MIMachineRecipeBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.addItemInput($input, 1, 0.0f);
        it.addFluidInput($fluid, 1000, 1.0f);
        Iterable $this$forEach$iv = $output;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Triple triple = (Triple)element$iv;
            boolean bl = false;
            ItemLike item = (ItemLike)triple.component1();
            int amount = ((Number)triple.component2()).intValue();
            float chance = ((Number)triple.component3()).floatValue();
            it.addItemOutput(item, amount, chance);
        }
        it.addItemOutput($input, 1, 0.5f);
        it.addCondition((MachineProcessCondition)new ArboreousGreenhouseTierCondition($tier, $model));
        return Unit.INSTANCE;
    }

    private static final Unit addArboreousGreenhouseRecipe$lambda$8(ItemLike $input, Fluid $nutrientFluid, List $output, ResourceLocation $tier, ResourceLocation $model, MIMachineRecipeBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.addItemInput($input, 1, 0.0f);
        it.addFluidInput($nutrientFluid, 1000, 1.0f);
        Iterable $this$forEach$iv = $output;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Triple triple = (Triple)element$iv;
            boolean bl = false;
            ItemLike item = (ItemLike)triple.component1();
            int amount = ((Number)triple.component2()).intValue();
            float chance = ((Number)triple.component3()).floatValue();
            it.addItemOutput(item, amount * 2, RangesKt.coerceAtMost((float)(chance * (float)2), (float)1.0f));
        }
        it.addItemOutput($input, 1, 1.0f);
        it.addCondition((MachineProcessCondition)new ArboreousGreenhouseTierCondition($tier, $model));
        return Unit.INSTANCE;
    }
}

