/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.yet_another_industrialization.client.model.multiblock;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.BitSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.luligabi.yet_another_industrialization.client.model.multiblock.MultiBlockAmbientOcclusionFace;
import me.luligabi.yet_another_industrialization.client.model.multiblock.MultiBlockBakedQuad;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0080\u0001\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020)2\u0006\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020)H\u0016J^\u0010.\u001a\u00020\u00182\u0006\u0010/\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u001b2\u0006\u00101\u001a\u00020\u00072\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u001e2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\"062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020)H\u0016J^\u0010>\u001a\u00020\u00182\u0006\u0010/\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u001b2\u0006\u00101\u001a\u00020\u00072\u0006\u0010?\u001a\u00020)2\u0006\u0010=\u001a\u00020)2\u0006\u0010@\u001a\u00020\t2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u001e2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\"062\u0006\u00109\u001a\u00020:H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006A"}, d2={"Lme/luligabi/yet_another_industrialization/client/model/multiblock/MultiBlockRenderer;", "Lnet/minecraft/client/renderer/block/ModelBlockRenderer;", "pBlockColors", "Lnet/minecraft/client/color/block/BlockColors;", "realLevel", "Lnet/minecraft/world/level/BlockAndTintGetter;", "lightAndTintPosition", "Lnet/minecraft/core/BlockPos;", "isItemRender", "", "<init>", "(Lnet/minecraft/client/color/block/BlockColors;Lnet/minecraft/world/level/BlockAndTintGetter;Lnet/minecraft/core/BlockPos;Z)V", "getRealLevel", "()Lnet/minecraft/world/level/BlockAndTintGetter;", "setRealLevel", "(Lnet/minecraft/world/level/BlockAndTintGetter;)V", "getLightAndTintPosition", "()Lnet/minecraft/core/BlockPos;", "setLightAndTintPosition", "(Lnet/minecraft/core/BlockPos;)V", "()Z", "setItemRender", "(Z)V", "putQuadData", "", "level", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "pos", "consumer", "Lcom/mojang/blaze3d/vertex/VertexConsumer;", "pose", "Lcom/mojang/blaze3d/vertex/PoseStack$Pose;", "quad", "Lnet/minecraft/client/renderer/block/model/BakedQuad;", "brightness0", "", "brightness1", "brightness2", "brightness3", "lightmap0", "", "lightmap1", "lightmap2", "lightmap3", "packedOverlay", "renderModelFaceAO", "pLevel", "pState", "pPos", "pPoseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "pConsumer", "pQuads", "", "pShape", "", "pShapeFlags", "Ljava/util/BitSet;", "pAoFace", "Lnet/minecraft/client/renderer/block/ModelBlockRenderer$AmbientOcclusionFace;", "pPackedOverlay", "renderModelFaceFlat", "pPackedLight", "pRepackLight", "yet_another_industrialization"})
public final class MultiBlockRenderer
extends ModelBlockRenderer {
    @NotNull
    private BlockAndTintGetter realLevel;
    @NotNull
    private BlockPos lightAndTintPosition;
    private boolean isItemRender;

    public MultiBlockRenderer(@NotNull BlockColors pBlockColors, @NotNull BlockAndTintGetter realLevel, @NotNull BlockPos lightAndTintPosition, boolean isItemRender) {
        Intrinsics.checkNotNullParameter((Object)pBlockColors, (String)"pBlockColors");
        Intrinsics.checkNotNullParameter((Object)realLevel, (String)"realLevel");
        Intrinsics.checkNotNullParameter((Object)lightAndTintPosition, (String)"lightAndTintPosition");
        super(pBlockColors);
        this.realLevel = realLevel;
        this.lightAndTintPosition = lightAndTintPosition;
        this.isItemRender = isItemRender;
    }

    @NotNull
    public final BlockAndTintGetter getRealLevel() {
        return this.realLevel;
    }

    public final void setRealLevel(@NotNull BlockAndTintGetter blockAndTintGetter) {
        Intrinsics.checkNotNullParameter((Object)blockAndTintGetter, (String)"<set-?>");
        this.realLevel = blockAndTintGetter;
    }

    @NotNull
    public final BlockPos getLightAndTintPosition() {
        return this.lightAndTintPosition;
    }

    public final void setLightAndTintPosition(@NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"<set-?>");
        this.lightAndTintPosition = blockPos;
    }

    public final boolean isItemRender() {
        return this.isItemRender;
    }

    public final void setItemRender(boolean bl) {
        this.isItemRender = bl;
    }

    public void putQuadData(@NotNull BlockAndTintGetter level, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull VertexConsumer consumer, @NotNull PoseStack.Pose pose, @NotNull BakedQuad quad, float brightness0, float brightness1, float brightness2, float brightness3, int lightmap0, int lightmap1, int lightmap2, int lightmap3, int packedOverlay) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        Intrinsics.checkNotNullParameter((Object)quad, (String)"quad");
        if (quad instanceof MultiBlockBakedQuad) {
            float r = 1.0f;
            float g = 1.0f;
            float b = 1.0f;
            if (quad.isTinted()) {
                int i = this.blockColors.getColor(((MultiBlockBakedQuad)quad).getState(), level, pos, quad.getTintIndex());
                r = (float)(i >> 16 & 0xFF) / 255.0f;
                g = (float)(i >> 8 & 0xFF) / 255.0f;
                b = (float)(i & 0xFF) / 255.0f;
            }
            Object[] objectArray = new float[]{brightness0, brightness1, brightness2, brightness3};
            float[] fArray = objectArray;
            objectArray = new int[4];
            objectArray[0] = lightmap0;
            objectArray[1] = lightmap1;
            objectArray[2] = lightmap2;
            objectArray[3] = lightmap3;
            consumer.putBulkData(pose, quad, fArray, r, g, b, 1.0f, (int[])objectArray, packedOverlay, true);
            return;
        }
        super.putQuadData(level, state, pos, consumer, pose, quad, brightness0, brightness1, brightness2, brightness3, lightmap0, lightmap1, lightmap2, lightmap3, packedOverlay);
    }

    public void renderModelFaceAO(@NotNull BlockAndTintGetter pLevel, @NotNull BlockState pState, @NotNull BlockPos pPos, @NotNull PoseStack pPoseStack, @NotNull VertexConsumer pConsumer, @NotNull List<BakedQuad> pQuads, @NotNull float[] pShape, @NotNull BitSet pShapeFlags, @NotNull ModelBlockRenderer.AmbientOcclusionFace pAoFace, int pPackedOverlay) {
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pState, (String)"pState");
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pPoseStack, (String)"pPoseStack");
        Intrinsics.checkNotNullParameter((Object)pConsumer, (String)"pConsumer");
        Intrinsics.checkNotNullParameter(pQuads, (String)"pQuads");
        Intrinsics.checkNotNullParameter((Object)pShape, (String)"pShape");
        Intrinsics.checkNotNullParameter((Object)pShapeFlags, (String)"pShapeFlags");
        Intrinsics.checkNotNullParameter((Object)pAoFace, (String)"pAoFace");
        float[] shape = new float[12];
        BitSet shapeFlags = new BitSet(3);
        shapeFlags.set(1, false);
        int levelColor = LevelRenderer.getLightColor((BlockAndTintGetter)this.realLevel, (BlockPos)this.lightAndTintPosition);
        for (BakedQuad bakedquad : pQuads) {
            BlockState state = pState;
            BlockPos pos = pPos;
            float[] brightness = pAoFace.brightness;
            int[] lightmap = pAoFace.lightmap;
            if (bakedquad instanceof MultiBlockBakedQuad) {
                state = ((MultiBlockBakedQuad)bakedquad).getState();
                pos = ((MultiBlockBakedQuad)bakedquad).getPos();
                if (((MultiBlockBakedQuad)bakedquad).getAoFace() == null) {
                    MultiBlockAmbientOcclusionFace face = new MultiBlockAmbientOcclusionFace();
                    Direction direction = bakedquad.getDirection();
                    Intrinsics.checkNotNullExpressionValue((Object)direction, (String)"getDirection(...)");
                    face.calculate(pLevel, state, pos, direction, shape, shapeFlags, bakedquad.isShade());
                    ((MultiBlockBakedQuad)bakedquad).setAoFace(face);
                }
                MultiBlockAmbientOcclusionFace multiBlockAmbientOcclusionFace = ((MultiBlockBakedQuad)bakedquad).getAoFace();
                Intrinsics.checkNotNull((Object)multiBlockAmbientOcclusionFace);
                brightness = multiBlockAmbientOcclusionFace.getBrightness();
                MultiBlockAmbientOcclusionFace multiBlockAmbientOcclusionFace2 = ((MultiBlockBakedQuad)bakedquad).getAoFace();
                Intrinsics.checkNotNull((Object)multiBlockAmbientOcclusionFace2);
                lightmap = multiBlockAmbientOcclusionFace2.getLightmap();
            }
            float b1 = Math.min(1.0f, brightness[0] + 0.2f);
            float b2 = Math.min(1.0f, brightness[1] + 0.2f);
            float b3 = Math.min(1.0f, brightness[2] + 0.2f);
            float b4 = Math.min(1.0f, brightness[3] + 0.2f);
            int l1 = lightmap[0] + levelColor >> 1;
            int l2 = lightmap[1] + levelColor >> 1;
            int l3 = lightmap[2] + levelColor >> 1;
            int l4 = lightmap[3] + levelColor >> 1;
            if (this.isItemRender) {
                l1 = 0xFF00FF;
                l2 = 0xFF00FF;
                l3 = 0xFF00FF;
                l4 = 0xFF00FF;
            }
            BlockState blockState = state;
            Intrinsics.checkNotNull((Object)blockState);
            BlockPos blockPos = pos;
            Intrinsics.checkNotNull((Object)blockPos);
            PoseStack.Pose pose = pPoseStack.last();
            Intrinsics.checkNotNullExpressionValue((Object)pose, (String)"last(...)");
            this.putQuadData(pLevel, blockState, blockPos, pConsumer, pose, bakedquad, b1, b2, b3, b4, l1, l2, l3, l4, pPackedOverlay);
        }
    }

    public void renderModelFaceFlat(@NotNull BlockAndTintGetter pLevel, @NotNull BlockState pState, @NotNull BlockPos pPos, int pPackedLight, int pPackedOverlay, boolean pRepackLight, @NotNull PoseStack pPoseStack, @NotNull VertexConsumer pConsumer, @NotNull List<BakedQuad> pQuads, @NotNull BitSet pShapeFlags) {
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pState, (String)"pState");
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pPoseStack, (String)"pPoseStack");
        Intrinsics.checkNotNullParameter((Object)pConsumer, (String)"pConsumer");
        Intrinsics.checkNotNullParameter(pQuads, (String)"pQuads");
        Intrinsics.checkNotNullParameter((Object)pShapeFlags, (String)"pShapeFlags");
        int pPackedLight2 = pPackedLight;
        float[] shape = new float[12];
        BitSet shapeFlags = new BitSet(3);
        for (BakedQuad bakedquad : pQuads) {
            BlockState state = pState;
            BlockPos pos = pPos;
            if (bakedquad instanceof MultiBlockBakedQuad) {
                state = ((MultiBlockBakedQuad)bakedquad).getState();
                pos = ((MultiBlockBakedQuad)bakedquad).getPos();
            }
            if (pRepackLight) {
                BlockPos blockpos;
                this.calculateShape(pLevel, state, pos, bakedquad.getVertices(), bakedquad.getDirection(), shape, shapeFlags);
                Intrinsics.checkNotNull((Object)(shapeFlags.get(0) ? pos.relative(bakedquad.getDirection()) : pos));
                blockpos = blockpos;
                pPackedLight2 = LevelRenderer.getLightColor((BlockAndTintGetter)pLevel, (BlockState)state, (BlockPos)blockpos);
            }
            float f = pLevel.getShade(bakedquad.getDirection(), bakedquad.isShade());
            PoseStack.Pose pose = pPoseStack.last();
            Intrinsics.checkNotNullExpressionValue((Object)pose, (String)"last(...)");
            this.putQuadData(pLevel, state, pos, pConsumer, pose, bakedquad, f, f, f, f, pPackedLight2, pPackedLight2, pPackedLight2, pPackedLight2, pPackedOverlay);
        }
    }
}

