/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.yet_another_industrialization.common.item;

import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.api.machine.component.EnergyAccess;
import aztech.modern_industrialization.api.machine.component.InventoryAccess;
import aztech.modern_industrialization.api.machine.holder.EnergyListComponentHolder;
import aztech.modern_industrialization.api.machine.holder.MultiblockInventoryComponentHolder;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.blockentities.GeneratorMachineBlockEntity;
import aztech.modern_industrialization.machines.blockentities.SteamCraftingMachineBlockEntity;
import aztech.modern_industrialization.machines.blockentities.SteamWaterPumpBlockEntity;
import aztech.modern_industrialization.machines.blockentities.multiblocks.GeneratorMultiblockBlockEntity;
import aztech.modern_industrialization.machines.blockentities.multiblocks.LargeTankMultiblockBlockEntity;
import aztech.modern_industrialization.machines.blockentities.multiblocks.NuclearReactorMultiblockBlockEntity;
import aztech.modern_industrialization.machines.blockentities.multiblocks.SteamCraftingMultiblockBlockEntity;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.machines.components.MultiblockInventoryComponent;
import aztech.modern_industrialization.machines.components.RedstoneControlComponent;
import aztech.modern_industrialization.machines.multiblocks.HatchFlags;
import aztech.modern_industrialization.machines.multiblocks.HatchTypes;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBlockEntity;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.util.TextHelper;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.luligabi.yet_another_industrialization.common.YAI;
import me.luligabi.yet_another_industrialization.common.block.machine.dragon_siphon.DragonSiphonBlockEntity;
import me.luligabi.yet_another_industrialization.common.util.YAIText;
import me.luligabi.yet_another_industrialization.common.util.YAIUtilKt;
import me.luligabi.yet_another_industrialization.mixin.CrafterComponentAccessor;
import me.luligabi.yet_another_industrialization.mixin.UseOnContextAccessor;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.HitResult;
import net.swedz.tesseract.neoforge.compat.mi.machine.blockentity.multiblock.multiplied.AbstractSteamMultipliedCraftingMultiblockBlockEntity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001&B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J$\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J,\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u001e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J&\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0018\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0!0 *\u00020\u001bH\u0002J \u0010\"\u001a\u00020#*\b\u0012\u0004\u0012\u00020%0$2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a8\u0006'"}, d2={"Lme/luligabi/yet_another_industrialization/common/item/MachineDiagnoserItem;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "useOn", "Lnet/minecraft/world/InteractionResult;", "ctx", "Lnet/minecraft/world/item/context/UseOnContext;", "diagnose", "", "Lme/luligabi/yet_another_industrialization/common/item/MachineDiagnoserItem$DiagnosisType;", "machine", "Laztech/modern_industrialization/machines/MachineBlockEntity;", "diagnoseHatches", "Laztech/modern_industrialization/machines/multiblocks/MultiblockMachineBlockEntity;", "diagnosis", "diagnoseMultiblockInventory", "", "access", "Laztech/modern_industrialization/api/machine/component/InventoryAccess;", "allowedHatches", "", "Laztech/modern_industrialization/machines/multiblocks/HatchFlags;", "diagnosePreRecipe", "crafter", "Laztech/modern_industrialization/machines/components/CrafterComponent;", "diagnoseRecipe", "recipe", "Laztech/modern_industrialization/machines/recipe/MachineRecipe;", "getRecipes", "", "Lnet/minecraft/world/item/crafting/RecipeHolder;", "diagnoseSteam", "", "", "Laztech/modern_industrialization/inventory/ConfigurableFluidStack;", "DiagnosisType", "yet_another_industrialization"})
@SourceDebugExtension(value={"SMAP\nMachineDiagnoserItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MachineDiagnoserItem.kt\nme/luligabi/yet_another_industrialization/common/item/MachineDiagnoserItem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,299:1\n1755#2,3:300\n1755#2,3:303\n1755#2,3:306\n1734#2,3:309\n1755#2,3:312\n1755#2,3:315\n1755#2,3:318\n1755#2,3:321\n1734#2,3:324\n2632#2,3:327\n*S KotlinDebug\n*F\n+ 1 MachineDiagnoserItem.kt\nme/luligabi/yet_another_industrialization/common/item/MachineDiagnoserItem\n*L\n108#1:300,3\n126#1:303,3\n131#1:306,3\n137#1:309,3\n154#1:312,3\n158#1:315,3\n162#1:318,3\n166#1:321,3\n180#1:324,3\n224#1:327,3\n*E\n"})
public final class MachineDiagnoserItem
extends Item {
    public MachineDiagnoserItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (ctx.getLevel().isClientSide) {
            return InteractionResult.FAIL;
        }
        if (((UseOnContextAccessor)ctx).getHitResult().getType() != HitResult.Type.BLOCK) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = ctx.getLevel().getBlockEntity(ctx.getClickedPos());
        MachineBlockEntity machineBlockEntity = blockEntity instanceof MachineBlockEntity ? (MachineBlockEntity)blockEntity : null;
        if (machineBlockEntity == null) {
            return InteractionResult.PASS;
        }
        MachineBlockEntity machine = machineBlockEntity;
        Player player = ctx.getPlayer();
        Intrinsics.checkNotNull((Object)player);
        DiagnosisType.Companion.sendDiagnosis(player, this.diagnose(machine), machine);
        int it = YAI.Companion.getCONFIG().machineDiagnoser().cooldownTicks();
        boolean bl = false;
        if (it > 0) {
            Player player2 = ctx.getPlayer();
            Intrinsics.checkNotNull((Object)player2);
            player2.getCooldowns().addCooldown((Item)this, it);
        }
        return InteractionResult.SUCCESS;
    }

    private final Set<DiagnosisType> diagnose(MachineBlockEntity machine) {
        RedstoneControlComponent it;
        Set diagnosis = new LinkedHashSet();
        RedstoneControlComponent redstoneControlComponent = (RedstoneControlComponent)machine.components.get(RedstoneControlComponent.class);
        if (redstoneControlComponent != null) {
            it = redstoneControlComponent;
            boolean bl = false;
            if (!it.doAllowNormalOperation(machine)) {
                diagnosis.add(DiagnosisType.REDSTONE_BLOCKED);
                return diagnosis;
            }
        }
        if (machine instanceof MultiblockMachineBlockEntity) {
            if (!((MultiblockMachineBlockEntity)machine).isShapeValid()) {
                diagnosis.add(DiagnosisType.INVALID_MULTIBLOCK_SHAPE);
                return diagnosis;
            }
            this.diagnoseHatches((MultiblockMachineBlockEntity)machine, diagnosis);
        } else if (machine instanceof SteamCraftingMachineBlockEntity || machine instanceof SteamWaterPumpBlockEntity) {
            List list = machine.getInventory().getFluidStacks();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFluidStacks(...)");
            if (this.diagnoseSteam(list, diagnosis)) {
                return diagnosis;
            }
        } else if (!(machine instanceof GeneratorMachineBlockEntity)) {
            EnergyComponent energyComponent = (EnergyComponent)machine.components.get(EnergyComponent.class);
            if (energyComponent != null) {
                it = energyComponent;
                boolean bl = false;
                if (it.getEu() == 0L) {
                    diagnosis.add(DiagnosisType.NO_ENERGY);
                    return diagnosis;
                }
            }
        }
        CrafterComponent crafterComponent = (CrafterComponent)machine.components.get(CrafterComponent.class);
        if (crafterComponent == null) {
            return diagnosis;
        }
        CrafterComponent crafter = crafterComponent;
        MachineRecipe activeRecipe = ((CrafterComponentAccessor)crafter).getActiveRecipe();
        MachineRecipe machineRecipe = activeRecipe;
        if (machineRecipe != null && (machineRecipe = (MachineRecipe)machineRecipe.value()) != null) {
            MachineRecipe it2 = machineRecipe;
            boolean bl = false;
            this.diagnoseRecipe(it2, crafter, diagnosis);
        } else {
            this.diagnosePreRecipe(crafter, diagnosis);
        }
        return diagnosis;
    }

    private final Set<DiagnosisType> diagnoseHatches(MultiblockMachineBlockEntity machine, Set<DiagnosisType> diagnosis) {
        InventoryAccess inventoryAccess;
        Object object;
        HatchFlags it;
        boolean $i$f$any;
        Iterable $this$any$iv;
        Set allowedHatches = CollectionsKt.toSet((Iterable)machine.getActiveShape().hatchFlags.values());
        HatchFlags matchedHatches = YAIUtilKt.getMatchedHatches(machine);
        MultiblockMachineBlockEntity multiblockMachineBlockEntity = machine;
        if (multiblockMachineBlockEntity instanceof LargeTankMultiblockBlockEntity) {
            boolean bl;
            block26: {
                $this$any$iv = allowedHatches;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (HatchFlags)element$iv;
                        boolean bl2 = false;
                        if (!it.allows(HatchTypes.LARGE_TANK)) continue;
                        bl = true;
                        break block26;
                    }
                    bl = false;
                }
            }
            if (bl && !matchedHatches.allows(HatchTypes.LARGE_TANK)) {
                diagnosis.add(DiagnosisType.NO_LARGE_TANK_HATCH);
                return diagnosis;
            }
        } else if (multiblockMachineBlockEntity instanceof MultiblockInventoryComponentHolder) {
            InventoryAccess inventoryAccess2 = ((MultiblockInventoryComponentHolder)machine).getMultiblockInventoryComponent();
            Intrinsics.checkNotNullExpressionValue((Object)inventoryAccess2, (String)"getMultiblockInventoryComponent(...)");
            this.diagnoseMultiblockInventory(inventoryAccess2, allowedHatches, diagnosis);
        } else {
            MultiblockInventoryComponent multiblockInventoryComponent = (MultiblockInventoryComponent)machine.components.get(MultiblockInventoryComponent.class);
            if (multiblockInventoryComponent != null) {
                MultiblockInventoryComponent inventory = multiblockInventoryComponent;
                boolean bl = false;
                this.diagnoseMultiblockInventory((InventoryAccess)inventory, allowedHatches, diagnosis);
            }
        }
        if (machine instanceof EnergyListComponentHolder) {
            boolean bl;
            boolean warning;
            block28: {
                boolean bl3;
                block27: {
                    warning = true;
                    $this$any$iv = allowedHatches;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (HatchFlags)element$iv;
                            boolean bl4 = false;
                            if (!it.allows(HatchTypes.ENERGY_INPUT)) continue;
                            bl3 = true;
                            break block27;
                        }
                        bl3 = false;
                    }
                }
                if (bl3 && !matchedHatches.allows(HatchTypes.ENERGY_INPUT)) {
                    diagnosis.add(DiagnosisType.NO_ENERGY_INPUT);
                    warning = false;
                }
                $this$any$iv = allowedHatches;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (HatchFlags)element$iv;
                        boolean bl5 = false;
                        if (!it.allows(HatchTypes.ENERGY_OUTPUT)) continue;
                        bl = true;
                        break block28;
                    }
                    bl = false;
                }
            }
            if (bl && !matchedHatches.allows(HatchTypes.ENERGY_OUTPUT)) {
                diagnosis.add(DiagnosisType.NO_ENERGY_OUTPUT);
                warning = true;
            }
            if (!(machine instanceof GeneratorMultiblockBlockEntity) && !(machine instanceof DragonSiphonBlockEntity)) {
                boolean bl6;
                block29: {
                    List list = ((EnergyListComponentHolder)machine).getEnergyComponents();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEnergyComponents(...)");
                    Iterable $this$all$iv = list;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl6 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            it = (EnergyAccess)element$iv;
                            boolean bl7 = false;
                            if (it.getEu() == 0L) continue;
                            bl6 = false;
                            break block29;
                        }
                        bl6 = true;
                    }
                }
                if (bl6) {
                    diagnosis.add(warning ? DiagnosisType.NO_ENERGY_WARNING : DiagnosisType.NO_ENERGY);
                }
            }
        } else if ((machine instanceof SteamCraftingMultiblockBlockEntity || machine instanceof AbstractSteamMultipliedCraftingMultiblockBlockEntity) && (object = (inventoryAccess = ((MultiblockInventoryComponentHolder)machine).getMultiblockInventoryComponent()) instanceof MultiblockInventoryComponent ? (MultiblockInventoryComponent)inventoryAccess : null) != null && (object = object.getFluidInputs()) != null) {
            this.diagnoseSteam((List<? extends ConfigurableFluidStack>)object, diagnosis);
        }
        if (machine instanceof NuclearReactorMultiblockBlockEntity) {
            diagnosis.add(DiagnosisType.UNSUPPORTED);
        }
        return diagnosis;
    }

    private final void diagnoseMultiblockInventory(InventoryAccess access, Set<? extends HatchFlags> allowedHatches, Set<DiagnosisType> diagnosis) {
        HatchFlags it;
        boolean $i$f$any;
        Iterable $this$any$iv;
        if (access.getItemInputs().isEmpty()) {
            boolean bl;
            block20: {
                $this$any$iv = allowedHatches;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (HatchFlags)element$iv;
                        boolean bl2 = false;
                        if (!it.allows(HatchTypes.ITEM_INPUT)) continue;
                        bl = true;
                        break block20;
                    }
                    bl = false;
                }
            }
            if (bl) {
                diagnosis.add(DiagnosisType.CANT_TAKE_ITEM_INPUT);
            }
        }
        if (access.getItemOutputs().isEmpty()) {
            boolean bl;
            block21: {
                $this$any$iv = allowedHatches;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (HatchFlags)element$iv;
                        boolean bl3 = false;
                        if (!it.allows(HatchTypes.ITEM_OUTPUT)) continue;
                        bl = true;
                        break block21;
                    }
                    bl = false;
                }
            }
            if (bl) {
                diagnosis.add(DiagnosisType.CANT_PUT_ITEM_OUTPUT_WARNING);
            }
        }
        if (access.getFluidInputs().isEmpty()) {
            boolean bl;
            block22: {
                $this$any$iv = allowedHatches;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (HatchFlags)element$iv;
                        boolean bl4 = false;
                        if (!it.allows(HatchTypes.FLUID_INPUT)) continue;
                        bl = true;
                        break block22;
                    }
                    bl = false;
                }
            }
            if (bl) {
                diagnosis.add(DiagnosisType.CANT_TAKE_FLUID_INPUT);
            }
        }
        if (access.getFluidOutputs().isEmpty()) {
            boolean bl;
            block23: {
                $this$any$iv = allowedHatches;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (HatchFlags)element$iv;
                        boolean bl5 = false;
                        if (!it.allows(HatchTypes.FLUID_OUTPUT)) continue;
                        bl = true;
                        break block23;
                    }
                    bl = false;
                }
            }
            if (bl) {
                diagnosis.add(DiagnosisType.CANT_PUT_FLUID_OUTPUT_WARNING);
            }
        }
    }

    private final void diagnosePreRecipe(CrafterComponent crafter, Set<DiagnosisType> diagnosis) {
        boolean bl;
        block5: {
            Iterable<RecipeHolder<MachineRecipe>> recipes = this.getRecipes(crafter);
            if (!recipes.iterator().hasNext()) {
                diagnosis.add(DiagnosisType.NO_RECIPE);
                return;
            }
            Iterable<RecipeHolder<MachineRecipe>> $this$all$iv = recipes;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator<RecipeHolder<MachineRecipe>> iterator = $this$all$iv.iterator();
                while (iterator.hasNext()) {
                    RecipeHolder<MachineRecipe> element$iv;
                    RecipeHolder<MachineRecipe> it = element$iv = iterator.next();
                    boolean bl2 = false;
                    if (crafter.getBehavior().banRecipe((MachineRecipe)it.value())) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (bl) {
            diagnosis.add(DiagnosisType.BANNED_RECIPE);
        }
    }

    private final void diagnoseRecipe(MachineRecipe recipe, CrafterComponent crafter, Set<DiagnosisType> diagnosis) {
        Intrinsics.checkNotNull((Object)crafter, (String)"null cannot be cast to non-null type me.luligabi.yet_another_industrialization.mixin.CrafterComponentAccessor");
        if (!((CrafterComponentAccessor)crafter).invokeTakeItemInputs(recipe, true)) {
            diagnosis.add(DiagnosisType.CANT_TAKE_ITEM_INPUT);
        }
        if (!((CrafterComponentAccessor)crafter).invokeTakeFluidInputs(recipe, true)) {
            diagnosis.add(DiagnosisType.CANT_TAKE_FLUID_INPUT);
        }
        if (!((CrafterComponentAccessor)crafter).invokePutItemOutputs(recipe, true, false)) {
            diagnosis.add(DiagnosisType.CANT_PUT_ITEM_OUTPUT);
        }
        if (!((CrafterComponentAccessor)crafter).invokePutFluidOutputs(recipe, true, false)) {
            diagnosis.add(DiagnosisType.CANT_PUT_FLUID_OUTPUT);
        }
        if (!recipe.conditionsMatch(((CrafterComponentAccessor)crafter).getConditionContext())) {
            diagnosis.add(DiagnosisType.UNMET_CONDITION);
        }
    }

    private final Iterable<RecipeHolder<MachineRecipe>> getRecipes(CrafterComponent $this$getRecipes) {
        if ($this$getRecipes.getEfficiencyTicks() > 0) {
            return SetsKt.emptySet();
        }
        ServerLevel serverWorld = $this$getRecipes.getBehavior().getCrafterWorld();
        MachineRecipeType recipeType = $this$getRecipes.getBehavior().recipeType();
        Collection collection = recipeType.getFluidOnlyRecipes(serverWorld);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getFluidOnlyRecipes(...)");
        Set recipes = CollectionsKt.toMutableSet((Iterable)collection);
        for (ConfigurableItemStack stack : $this$getRecipes.getInventory().getItemInputs()) {
            if (stack.isEmpty()) continue;
            Collection collection2 = recipeType.getMatchingRecipes(serverWorld, ((ItemVariant)stack.getResource()).getItem());
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getMatchingRecipes(...)");
            recipes.addAll(collection2);
        }
        return recipes;
    }

    private final boolean diagnoseSteam(List<? extends ConfigurableFluidStack> $this$diagnoseSteam, Set<DiagnosisType> diagnosis) {
        boolean bl;
        block4: {
            Iterable $this$none$iv = $this$diagnoseSteam;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    ConfigurableFluidStack it = (ConfigurableFluidStack)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)((FluidVariant)it.getResource()).getFluid(), (Object)MIFluids.STEAM.asFluid()) && it.getAmount() > 0L)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (bl) {
            diagnosis.add(DiagnosisType.NO_STEAM);
            return true;
        }
        return false;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001c\b\u0086\u0081\u0002\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002 !B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001f\u00a8\u0006\""}, d2={"Lme/luligabi/yet_another_industrialization/common/item/MachineDiagnoserItem$DiagnosisType;", "", "title", "Lme/luligabi/yet_another_industrialization/common/util/YAIText;", "description", "severity", "Lme/luligabi/yet_another_industrialization/common/item/MachineDiagnoserItem$DiagnosisType$Severity;", "<init>", "(Ljava/lang/String;ILme/luligabi/yet_another_industrialization/common/util/YAIText;Lme/luligabi/yet_another_industrialization/common/util/YAIText;Lme/luligabi/yet_another_industrialization/common/item/MachineDiagnoserItem$DiagnosisType$Severity;)V", "getTitle", "()Lme/luligabi/yet_another_industrialization/common/util/YAIText;", "getDescription", "getSeverity", "()Lme/luligabi/yet_another_industrialization/common/item/MachineDiagnoserItem$DiagnosisType$Severity;", "NO_STEAM", "NO_ENERGY", "NO_ENERGY_WARNING", "NO_ENERGY_INPUT", "NO_ENERGY_OUTPUT", "NO_RECIPE", "BANNED_RECIPE", "CANT_TAKE_ITEM_INPUT", "CANT_TAKE_FLUID_INPUT", "CANT_PUT_ITEM_OUTPUT", "CANT_PUT_FLUID_OUTPUT", "CANT_PUT_ITEM_OUTPUT_WARNING", "CANT_PUT_FLUID_OUTPUT_WARNING", "UNMET_CONDITION", "INVALID_MULTIBLOCK_SHAPE", "REDSTONE_BLOCKED", "NO_LARGE_TANK_HATCH", "UNSUPPORTED", "Companion", "Severity", "yet_another_industrialization"})
    public static final class DiagnosisType
    extends Enum<DiagnosisType> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final YAIText title;
        @NotNull
        private final YAIText description;
        @NotNull
        private final Severity severity;
        public static final /* enum */ DiagnosisType NO_STEAM;
        public static final /* enum */ DiagnosisType NO_ENERGY;
        public static final /* enum */ DiagnosisType NO_ENERGY_WARNING;
        public static final /* enum */ DiagnosisType NO_ENERGY_INPUT;
        public static final /* enum */ DiagnosisType NO_ENERGY_OUTPUT;
        public static final /* enum */ DiagnosisType NO_RECIPE;
        public static final /* enum */ DiagnosisType BANNED_RECIPE;
        public static final /* enum */ DiagnosisType CANT_TAKE_ITEM_INPUT;
        public static final /* enum */ DiagnosisType CANT_TAKE_FLUID_INPUT;
        public static final /* enum */ DiagnosisType CANT_PUT_ITEM_OUTPUT;
        public static final /* enum */ DiagnosisType CANT_PUT_FLUID_OUTPUT;
        public static final /* enum */ DiagnosisType CANT_PUT_ITEM_OUTPUT_WARNING;
        public static final /* enum */ DiagnosisType CANT_PUT_FLUID_OUTPUT_WARNING;
        public static final /* enum */ DiagnosisType UNMET_CONDITION;
        public static final /* enum */ DiagnosisType INVALID_MULTIBLOCK_SHAPE;
        public static final /* enum */ DiagnosisType REDSTONE_BLOCKED;
        public static final /* enum */ DiagnosisType NO_LARGE_TANK_HATCH;
        public static final /* enum */ DiagnosisType UNSUPPORTED;
        private static final /* synthetic */ DiagnosisType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private DiagnosisType(YAIText title, YAIText description, Severity severity) {
            this.title = title;
            this.description = description;
            this.severity = severity;
        }

        @NotNull
        public final YAIText getTitle() {
            return this.title;
        }

        @NotNull
        public final YAIText getDescription() {
            return this.description;
        }

        @NotNull
        public final Severity getSeverity() {
            return this.severity;
        }

        public static DiagnosisType[] values() {
            return (DiagnosisType[])$VALUES.clone();
        }

        public static DiagnosisType valueOf(String value) {
            return Enum.valueOf(DiagnosisType.class, value);
        }

        @NotNull
        public static EnumEntries<DiagnosisType> getEntries() {
            return $ENTRIES;
        }

        static {
            NO_STEAM = new DiagnosisType(YAIText.DIAGNOSER_NO_STEAM, YAIText.DIAGNOSER_NO_STEAM_DESCRIPTION, Severity.ERROR);
            NO_ENERGY = new DiagnosisType(YAIText.DIAGNOSER_NO_ENERGY, YAIText.DIAGNOSER_NO_ENERGY_DESCRIPTION, Severity.ERROR);
            NO_ENERGY_WARNING = new DiagnosisType(YAIText.DIAGNOSER_NO_ENERGY, YAIText.DIAGNOSER_NO_ENERGY_WARNING_DESCRIPTION, Severity.WARNING);
            NO_ENERGY_INPUT = new DiagnosisType(YAIText.DIAGNOSER_NO_ENERGY_INPUT, YAIText.DIAGNOSER_NO_ENERGY_INPUT_DESCRIPTION, Severity.ERROR);
            NO_ENERGY_OUTPUT = new DiagnosisType(YAIText.DIAGNOSER_NO_ENERGY_OUTPUT, YAIText.DIAGNOSER_NO_ENERGY_OUTPUT_DESCRIPTION, Severity.ERROR);
            NO_RECIPE = new DiagnosisType(YAIText.DIAGNOSER_NO_RECIPE, YAIText.DIAGNOSER_NO_RECIPE_DESCRIPTION, Severity.ERROR);
            BANNED_RECIPE = new DiagnosisType(YAIText.DIAGNOSER_BANNED_RECIPE, YAIText.DIAGNOSER_BANNED_RECIPE_DESCRIPTION, Severity.ERROR);
            CANT_TAKE_ITEM_INPUT = new DiagnosisType(YAIText.DIAGNOSER_CANT_TAKE_ITEM_INPUT, YAIText.DIAGNOSER_CANT_TAKE_ITEM_INPUT_DESCRIPTION, Severity.WARNING);
            CANT_TAKE_FLUID_INPUT = new DiagnosisType(YAIText.DIAGNOSER_CANT_TAKE_FLUID_INPUT, YAIText.DIAGNOSER_CANT_TAKE_FLUID_INPUT_DESCRIPTION, Severity.WARNING);
            CANT_PUT_ITEM_OUTPUT = new DiagnosisType(YAIText.DIAGNOSER_CANT_PUT_ITEM_OUTPUT, YAIText.DIAGNOSER_CANT_PUT_ITEM_OUTPUT_DESCRIPTION, Severity.ERROR);
            CANT_PUT_FLUID_OUTPUT = new DiagnosisType(YAIText.DIAGNOSER_CANT_PUT_FLUID_OUTPUT, YAIText.DIAGNOSER_CANT_PUT_FLUID_OUTPUT_DESCRIPTION, Severity.ERROR);
            CANT_PUT_ITEM_OUTPUT_WARNING = new DiagnosisType(YAIText.DIAGNOSER_CANT_PUT_ITEM_OUTPUT, YAIText.DIAGNOSER_CANT_PUT_ITEM_OUTPUT_DESCRIPTION, Severity.WARNING);
            CANT_PUT_FLUID_OUTPUT_WARNING = new DiagnosisType(YAIText.DIAGNOSER_CANT_PUT_FLUID_OUTPUT, YAIText.DIAGNOSER_CANT_PUT_FLUID_OUTPUT_DESCRIPTION, Severity.WARNING);
            UNMET_CONDITION = new DiagnosisType(YAIText.DIAGNOSER_UNMET_CONDITION, YAIText.DIAGNOSER_UNMET_CONDITION_DESCRIPTION, Severity.ERROR);
            INVALID_MULTIBLOCK_SHAPE = new DiagnosisType(YAIText.DIAGNOSER_INVALID_MULTIBLOCK_SHAPE, YAIText.DIAGNOSER_INVALID_MULTIBLOCK_SHAPE_DESCRIPTION, Severity.ERROR);
            REDSTONE_BLOCKED = new DiagnosisType(YAIText.DIAGNOSER_REDSTONE_BLOCKED, YAIText.DIAGNOSER_REDSTONE_BLOCKED_DESCRIPTION, Severity.ERROR);
            NO_LARGE_TANK_HATCH = new DiagnosisType(YAIText.DIAGNOSER_NO_LARGE_TANK_HATCH, YAIText.DIAGNOSER_NO_LARGE_TANK_HATCH_DESCRIPTION, Severity.ERROR);
            UNSUPPORTED = new DiagnosisType(YAIText.DIAGNOSER_UNSUPPORTED, YAIText.DIAGNOSER_UNSUPPORTED_DESCRIPTION, Severity.INFO);
            $VALUES = diagnosisTypeArray = new DiagnosisType[]{DiagnosisType.NO_STEAM, DiagnosisType.NO_ENERGY, DiagnosisType.NO_ENERGY_WARNING, DiagnosisType.NO_ENERGY_INPUT, DiagnosisType.NO_ENERGY_OUTPUT, DiagnosisType.NO_RECIPE, DiagnosisType.BANNED_RECIPE, DiagnosisType.CANT_TAKE_ITEM_INPUT, DiagnosisType.CANT_TAKE_FLUID_INPUT, DiagnosisType.CANT_PUT_ITEM_OUTPUT, DiagnosisType.CANT_PUT_FLUID_OUTPUT, DiagnosisType.CANT_PUT_ITEM_OUTPUT_WARNING, DiagnosisType.CANT_PUT_FLUID_OUTPUT_WARNING, DiagnosisType.UNMET_CONDITION, DiagnosisType.INVALID_MULTIBLOCK_SHAPE, DiagnosisType.REDSTONE_BLOCKED, DiagnosisType.NO_LARGE_TANK_HATCH, DiagnosisType.UNSUPPORTED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u0005*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lme/luligabi/yet_another_industrialization/common/item/MachineDiagnoserItem$DiagnosisType$Companion;", "", "<init>", "()V", "sendDiagnosis", "", "Lnet/minecraft/world/entity/player/Player;", "diagnosis", "", "Lme/luligabi/yet_another_industrialization/common/item/MachineDiagnoserItem$DiagnosisType;", "machine", "Laztech/modern_industrialization/machines/MachineBlockEntity;", "yet_another_industrialization"})
        @SourceDebugExtension(value={"SMAP\nMachineDiagnoserItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MachineDiagnoserItem.kt\nme/luligabi/yet_another_industrialization/common/item/MachineDiagnoserItem$DiagnosisType$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,299:1\n1053#2:300\n*S KotlinDebug\n*F\n+ 1 MachineDiagnoserItem.kt\nme/luligabi/yet_another_industrialization/common/item/MachineDiagnoserItem$DiagnosisType$Companion\n*L\n266#1:300\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            public final void sendDiagnosis(@NotNull Player $this$sendDiagnosis, @NotNull Set<DiagnosisType> diagnosis, @NotNull MachineBlockEntity machine) {
                Intrinsics.checkNotNullParameter((Object)$this$sendDiagnosis, (String)"<this>");
                Intrinsics.checkNotNullParameter(diagnosis, (String)"diagnosis");
                Intrinsics.checkNotNullParameter((Object)machine, (String)"machine");
                MutableComponent mutableComponent = machine.getBlockState().getBlock().getName();
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"getName(...)");
                Style style = TextHelper.NUMBER_TEXT;
                Intrinsics.checkNotNullExpressionValue((Object)style, (String)"NUMBER_TEXT");
                MutableComponent machineName = YAIUtilKt.applyStyle(mutableComponent, style);
                if (diagnosis.isEmpty()) {
                    Object[] objectArray = new Object[]{machineName};
                    MutableComponent mutableComponent2 = YAIText.DIAGNOSER_TITLE_NONE.text(objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"text(...)");
                    Style style2 = TextHelper.NEUTRONS;
                    Intrinsics.checkNotNullExpressionValue((Object)style2, (String)"NEUTRONS");
                    $this$sendDiagnosis.sendSystemMessage((Component)YAIUtilKt.applyStyle(mutableComponent2, style2));
                    return;
                }
                Object object = new Object[]{machineName};
                MutableComponent mutableComponent3 = YAIText.DIAGNOSER_TITLE.text((Object[])object);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent3, (String)"text(...)");
                Style style3 = TextHelper.GRAY_TEXT;
                Intrinsics.checkNotNullExpressionValue((Object)style3, (String)"GRAY_TEXT");
                MutableComponent title = YAIUtilKt.applyStyle(mutableComponent3, style3);
                Iterable $this$sortedBy$iv = diagnosis;
                boolean $i$f$sortedBy = false;
                List sortedList = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        DiagnosisType it = (DiagnosisType)((Object)a);
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getSeverity().ordinal());
                        it = (DiagnosisType)((Object)b);
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getSeverity().ordinal()));
                    }
                });
                object = ((Iterable)sortedList).iterator();
                int n = 0;
                while (object.hasNext()) {
                    int i = n++;
                    DiagnosisType type = (DiagnosisType)((Object)object.next());
                    MutableComponent mutableComponent4 = Component.literal((String)(type.getSeverity().getIcon() + " "));
                    Intrinsics.checkNotNullExpressionValue((Object)mutableComponent4, (String)"literal(...)");
                    MutableComponent diagnosis2 = YAIUtilKt.applyColor(mutableComponent4, type.getSeverity().getDarkColor());
                    MutableComponent mutableComponent5 = type.getTitle().text();
                    Intrinsics.checkNotNullExpressionValue((Object)mutableComponent5, (String)"text(...)");
                    MutableComponent message = YAIUtilKt.applyColor(mutableComponent5, type.getSeverity().getLightColor());
                    MutableComponent mutableComponent6 = diagnosis2.append((Component)message);
                    MutableComponent mutableComponent7 = type.getDescription().text();
                    Intrinsics.checkNotNullExpressionValue((Object)mutableComponent7, (String)"text(...)");
                    Style style4 = TextHelper.GRAY_TEXT;
                    Intrinsics.checkNotNullExpressionValue((Object)style4, (String)"GRAY_TEXT");
                    mutableComponent6.withStyle(Style.EMPTY.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)YAIUtilKt.applyStyle(mutableComponent7, style4))));
                    if (i != CollectionsKt.getLastIndex((List)sortedList)) {
                        diagnosis2.append("\n");
                    }
                    title.append((Component)diagnosis2);
                }
                $this$sendDiagnosis.sendSystemMessage((Component)title);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B#\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lme/luligabi/yet_another_industrialization/common/item/MachineDiagnoserItem$DiagnosisType$Severity;", "", "lightColor", "Lnet/minecraft/ChatFormatting;", "darkColor", "icon", "", "<init>", "(Ljava/lang/String;ILnet/minecraft/ChatFormatting;Lnet/minecraft/ChatFormatting;Ljava/lang/String;)V", "getLightColor", "()Lnet/minecraft/ChatFormatting;", "getDarkColor", "getIcon", "()Ljava/lang/String;", "ERROR", "WARNING", "INFO", "yet_another_industrialization"})
        public static final class Severity
        extends Enum<Severity> {
            @NotNull
            private final ChatFormatting lightColor;
            @NotNull
            private final ChatFormatting darkColor;
            @NotNull
            private final String icon;
            public static final /* enum */ Severity ERROR = new Severity("ERROR", 0, ChatFormatting.RED, ChatFormatting.DARK_RED, null, 4, null);
            public static final /* enum */ Severity WARNING = new Severity("WARNING", 1, ChatFormatting.YELLOW, ChatFormatting.GOLD, null, 4, null);
            public static final /* enum */ Severity INFO = new Severity(ChatFormatting.BLUE, ChatFormatting.DARK_BLUE, "\u24d8");
            private static final /* synthetic */ Severity[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private Severity(ChatFormatting lightColor, ChatFormatting darkColor, String icon) {
                this.lightColor = lightColor;
                this.darkColor = darkColor;
                this.icon = icon;
            }

            /* synthetic */ Severity(String string, int n, ChatFormatting chatFormatting, ChatFormatting chatFormatting2, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n2 & 4) != 0) {
                    string2 = "\u26a0";
                }
                this(chatFormatting, chatFormatting2, string2);
            }

            @NotNull
            public final ChatFormatting getLightColor() {
                return this.lightColor;
            }

            @NotNull
            public final ChatFormatting getDarkColor() {
                return this.darkColor;
            }

            @NotNull
            public final String getIcon() {
                return this.icon;
            }

            public static Severity[] values() {
                return (Severity[])$VALUES.clone();
            }

            public static Severity valueOf(String value) {
                return Enum.valueOf(Severity.class, value);
            }

            @NotNull
            public static EnumEntries<Severity> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = severityArray = new Severity[]{Severity.ERROR, Severity.WARNING, Severity.INFO};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }
}

