/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.yet_another_industrialization.common.item;

import aztech.modern_industrialization.MIComponents;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBlockEntity;
import dev.technici4n.grandpower.api.ISimpleEnergyItem;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import me.luligabi.yet_another_industrialization.common.YAI;
import me.luligabi.yet_another_industrialization.common.item.ChaChaRealSmoothItem;
import me.luligabi.yet_another_industrialization.common.misc.YAISounds;
import me.luligabi.yet_another_industrialization.common.misc.YAITags;
import me.luligabi.yet_another_industrialization.common.util.YAIText;
import me.luligabi.yet_another_industrialization.common.util.YAIUtilKt;
import me.luligabi.yet_another_industrialization.mixin.MultiblockMachineBlockEntityAccessor;
import me.luligabi.yet_another_industrialization.mixin.UseOnContextAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 /2\u00020\u00012\u00020\u0002:\u0001/B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J0\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J0\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J4\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u00142\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010#\u001a\u00020!2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010$\u001a\u00020!2\u0006\u0010\r\u001a\u00020\u000eH\u0016J1\u0010%\u001a&\u0012\f\u0012\n '*\u0004\u0018\u00010\u001f0\u001f '*\u0012\u0012\f\u0012\n '*\u0004\u0018\u00010\u001f0\u001f\u0018\u00010&0&H\u0016\u00a2\u0006\u0002\u0010(J\u0010\u0010)\u001a\u00020\u001f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010*\u001a\u00020\u001f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010+\u001a\u00020\u001f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0014\u0010,\u001a\u00020\u001b*\u00020\u00102\u0006\u0010-\u001a\u00020.H\u0002\u00a8\u00060"}, d2={"Lme/luligabi/yet_another_industrialization/common/item/MachineRemoverItem;", "Lnet/minecraft/world/item/Item;", "Ldev/technici4n/grandpower/api/ISimpleEnergyItem;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "useOn", "Lnet/minecraft/world/InteractionResult;", "ctx", "Lnet/minecraft/world/item/context/UseOnContext;", "removeMultiblock", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "player", "Lnet/minecraft/world/entity/player/Player;", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "controller", "Laztech/modern_industrialization/machines/multiblocks/MultiblockMachineBlockEntity;", "removeSingleMachine", "machine", "Laztech/modern_industrialization/machines/MachineBlockEntity;", "removeBlock", "", "blockPos", "dropPos", "getMultiblockCost", "", "blockCount", "", "isBarVisible", "getBarWidth", "getBarColor", "getEnergyComponent", "Lnet/minecraft/core/component/DataComponentType;", "kotlin.jvm.PlatformType", "()Lnet/minecraft/core/component/DataComponentType;", "getEnergyCapacity", "getEnergyMaxInput", "getEnergyMaxOutput", "sendError", "message", "Lme/luligabi/yet_another_industrialization/common/util/YAIText;", "Companion", "yet_another_industrialization"})
@SourceDebugExtension(value={"SMAP\nMachineRemoverItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MachineRemoverItem.kt\nme/luligabi/yet_another_industrialization/common/item/MachineRemoverItem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,151:1\n1863#2,2:152\n*S KotlinDebug\n*F\n+ 1 MachineRemoverItem.kt\nme/luligabi/yet_another_industrialization/common/item/MachineRemoverItem\n*L\n90#1:152,2\n*E\n"})
public final class MachineRemoverItem
extends Item
implements ISimpleEnergyItem {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public MachineRemoverItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties.stacksTo(1).component(MIComponents.ENERGY, (Object)0L));
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext ctx) {
        InteractionResult interactionResult;
        boolean success;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (ctx.getLevel().isClientSide) {
            return InteractionResult.FAIL;
        }
        if (((UseOnContextAccessor)ctx).getHitResult().getType() != HitResult.Type.BLOCK) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = ctx.getLevel().getBlockEntity(ctx.getClickedPos());
        MachineBlockEntity machineBlockEntity = blockEntity instanceof MachineBlockEntity ? (MachineBlockEntity)blockEntity : null;
        if (machineBlockEntity == null) {
            return InteractionResult.PASS;
        }
        MachineBlockEntity machine = machineBlockEntity;
        Holder.Reference reference = machine.getType().builtInRegistryHolder();
        Intrinsics.checkNotNull((Object)reference);
        if (reference.is(YAITags.INSTANCE.getMACHINE_REMOVER_BANNED())) {
            Player player = ctx.getPlayer();
            Intrinsics.checkNotNull((Object)player);
            this.sendError(player, YAIText.MACHINE_REMOVER_BANNED);
            InteractionResult interactionResult2 = InteractionResult.sidedSuccess((boolean)ctx.getLevel().isClientSide);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResult2, (String)"sidedSuccess(...)");
            return interactionResult2;
        }
        if (machine instanceof MultiblockMachineBlockEntity) {
            ItemStack itemStack = ctx.getItemInHand();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemInHand(...)");
            Player player = ctx.getPlayer();
            Intrinsics.checkNotNull((Object)player);
            Level level = ctx.getLevel();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"getLevel(...)");
            BlockPos blockPos = ctx.getClickedPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getClickedPos(...)");
            v8 = this.removeMultiblock(itemStack, player, level, blockPos, (MultiblockMachineBlockEntity)machine);
        } else {
            ItemStack itemStack = ctx.getItemInHand();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemInHand(...)");
            Player player = ctx.getPlayer();
            Intrinsics.checkNotNull((Object)player);
            Level level = ctx.getLevel();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"getLevel(...)");
            BlockPos blockPos = ctx.getClickedPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getClickedPos(...)");
            v8 = success = this.removeSingleMachine(itemStack, player, level, blockPos, machine);
        }
        if (success) {
            ctx.getLevel().playSound(null, ctx.getClickedPos(), YAISounds.INSTANCE.getMACHINE_REMOVER_REMOVE().get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            int it = YAI.Companion.getCONFIG().machineRemover().cooldownTicks();
            boolean bl = false;
            if (it > 0) {
                Player player = ctx.getPlayer();
                Intrinsics.checkNotNull((Object)player);
                player.getCooldowns().addCooldown((Item)this, it);
            }
        }
        if (success) {
            InteractionResult interactionResult3 = InteractionResult.sidedSuccess((boolean)ctx.getLevel().isClientSide);
            interactionResult = interactionResult3;
            Intrinsics.checkNotNullExpressionValue((Object)interactionResult3, (String)"sidedSuccess(...)");
        } else {
            interactionResult = InteractionResult.FAIL;
        }
        return interactionResult;
    }

    private final boolean removeMultiblock(ItemStack stack, Player player, Level level, BlockPos pos, MultiblockMachineBlockEntity controller) {
        if (!controller.isShapeValid()) {
            return this.removeSingleMachine(stack, player, level, pos, (MachineBlockEntity)controller);
        }
        Intrinsics.checkNotNull((Object)controller, (String)"null cannot be cast to non-null type me.luligabi.yet_another_industrialization.mixin.MultiblockMachineBlockEntityAccessor");
        Set members = ((MultiblockMachineBlockEntityAccessor)controller).getShapeMatcher().getPositions();
        if (members.size() > 128) {
            this.sendError(player, YAIText.MACHINE_REMOVER_TOO_LARGE);
            return false;
        }
        if (this.tryUseEnergy(stack, this.getMultiblockCost(members.size()))) {
            Intrinsics.checkNotNull((Object)members);
            Iterable $this$forEach$iv = members;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BlockPos it = (BlockPos)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                MachineRemoverItem.removeBlock$default(this, level, player, it, pos, null, 16, null);
            }
            this.removeBlock(level, player, pos, pos, (MachineBlockEntity)controller);
            return true;
        }
        this.sendError(player, YAIText.MACHINE_REMOVER_INSUFFICIENT_ENERGY);
        return false;
    }

    private final boolean removeSingleMachine(ItemStack stack, Player player, Level level, BlockPos pos, MachineBlockEntity machine) {
        if (!this.tryUseEnergy(stack, Companion.getSINGLE_BLOCK_REMOVE_COST())) {
            this.sendError(player, YAIText.MACHINE_REMOVER_INSUFFICIENT_ENERGY);
            return false;
        }
        this.removeBlock(level, player, pos, pos, machine);
        return true;
    }

    private final void removeBlock(Level level, Player player, BlockPos blockPos, BlockPos dropPos, MachineBlockEntity machine) {
        BlockState it = level.getBlockState(blockPos);
        boolean bl = false;
        MachineBlockEntity machineBlockEntity = machine;
        it.getBlock().playerDestroy(level, player, dropPos, it, machineBlockEntity != null ? (BlockEntity)machineBlockEntity : level.getBlockEntity(blockPos), ChaChaRealSmoothItem.Companion.create(level));
        level.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 35);
    }

    static /* synthetic */ void removeBlock$default(MachineRemoverItem machineRemoverItem, Level level, Player player, BlockPos blockPos, BlockPos blockPos2, MachineBlockEntity machineBlockEntity, int n, Object object) {
        if ((n & 0x10) != 0) {
            machineBlockEntity = null;
        }
        machineRemoverItem.removeBlock(level, player, blockPos, blockPos2, machineBlockEntity);
    }

    private final long getMultiblockCost(int blockCount) {
        return Companion.getMULTIBLOCK_REMOVE_BASE_COST() + (long)blockCount * Companion.getMULTIBLOCK_REMOVE_BLOCK_COST();
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return !stack.has(DataComponents.CUSTOM_DATA);
    }

    public int getBarWidth(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return MathKt.roundToInt((double)((double)this.getStoredEnergy(stack) / (double)Companion.getENERGY_CAPACITY() * (double)13));
    }

    public int getBarColor(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return 0xFF0000;
    }

    public DataComponentType<Long> getEnergyComponent() {
        return (DataComponentType)MIComponents.ENERGY.get();
    }

    public long getEnergyCapacity(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return Companion.getENERGY_CAPACITY();
    }

    public long getEnergyMaxInput(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return Companion.getENERGY_CAPACITY();
    }

    public long getEnergyMaxOutput(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return 0L;
    }

    private final void sendError(Player $this$sendError, YAIText message) {
        MutableComponent mutableComponent = message.text();
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"text(...)");
        Style style = YAIUtilKt.getMACHINE_REMOVER_STYLE();
        Intrinsics.checkNotNullExpressionValue((Object)style, (String)"<get-MACHINE_REMOVER_STYLE>(...)");
        $this$sendError.displayClientMessage((Component)YAIUtilKt.applyStyle(mutableComponent, style), true);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lme/luligabi/yet_another_industrialization/common/item/MachineRemoverItem$Companion;", "", "<init>", "()V", "ENERGY_CAPACITY", "", "getENERGY_CAPACITY", "()J", "SINGLE_BLOCK_REMOVE_COST", "getSINGLE_BLOCK_REMOVE_COST", "MULTIBLOCK_REMOVE_BASE_COST", "getMULTIBLOCK_REMOVE_BASE_COST", "MULTIBLOCK_REMOVE_BLOCK_COST", "getMULTIBLOCK_REMOVE_BLOCK_COST", "yet_another_industrialization"})
    public static final class Companion {
        private Companion() {
        }

        public final long getENERGY_CAPACITY() {
            return YAI.Companion.getCONFIG().machineRemover().capacity();
        }

        public final long getSINGLE_BLOCK_REMOVE_COST() {
            return YAI.Companion.getCONFIG().machineRemover().singleBlockRemoveCost();
        }

        public final long getMULTIBLOCK_REMOVE_BASE_COST() {
            return YAI.Companion.getCONFIG().machineRemover().multiblockBaseRemoveCost();
        }

        public final long getMULTIBLOCK_REMOVE_BLOCK_COST() {
            return YAI.Companion.getCONFIG().machineRemover().multiblockBlockRemoveCost();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

