/*
 * Decompiled with CFR 0.152.
 */
package ctb_vehicles;

import ctb.CTB;
import ctb_vehicles.CTBVEvents;
import ctb_vehicles.client.packet.PacketDriveClient;
import ctb_vehicles.client.packet.PacketVehicleSoundClient;
import ctb_vehicles.common.CTBVCommon;
import ctb_vehicles.common.CTBVEntityRegistry;
import ctb_vehicles.common.CTBVItemRegistry;
import ctb_vehicles.common.VehicleProgression;
import ctb_vehicles.common.packet.PacketDrive;
import ctb_vehicles.common.packet.PacketShellFire;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="ctb_vehicles", name="Call to Battle Vehicles", version="3.5", dependencies="required-after:ctb", acceptedMinecraftVersions="[1.12.2]")
public class CTBVehicles {
    public static final String ctbv_version = "3.5";
    @SidedProxy(clientSide="ctb_vehicles.client.CTBVClient", serverSide="ctb_vehicles.common.CTBVCommon")
    public static CTBVCommon proxy;
    @Mod.Instance(value="ctb_vehicles")
    public static CTBVehicles instance;
    public static final String RESOURCE_LOCATION = "ctb_vehicles";
    public static SimpleNetworkWrapper ctbvChannel;
    private int packetID;

    private int getNextPacketID() {
        return this.packetID++;
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        CTB.ctbvInstalled = true;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        CTB.ctbvInstalled = true;
        ctbvChannel = NetworkRegistry.INSTANCE.newSimpleChannel("ctbvChannel");
        ctbvChannel.registerMessage(PacketDrive.Handler.class, PacketDrive.class, this.getNextPacketID(), Side.SERVER);
        ctbvChannel.registerMessage(PacketDriveClient.Handler.class, PacketDriveClient.class, this.getNextPacketID(), Side.CLIENT);
        ctbvChannel.registerMessage(PacketShellFire.Handler.class, PacketShellFire.class, this.getNextPacketID(), Side.SERVER);
        ctbvChannel.registerMessage(PacketVehicleSoundClient.Handler.class, PacketVehicleSoundClient.class, this.getNextPacketID(), Side.CLIENT);
        if (event.getSide() == Side.CLIENT) {
            // empty if block
        }
        CTBVEntityRegistry.registerEntities();
        CTBVItemRegistry.registerItems();
        proxy.registerEvents();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        proxy.registerRenders();
        CTB.tabvehicles.item = CTBVItemRegistry.willys_mb_mg;
        MinecraftForge.EVENT_BUS.register((Object)new CTBVEvents());
        if (event.getSide() == Side.CLIENT) {
            // empty if block
        }
        VehicleProgression.registerUtilityVehicles();
    }
}

