/*
 * Decompiled with CFR 0.152.
 */
package ctb_vehicles.client.packet;

import ctb_vehicles.common.entity.EntitySeat;
import ctb_vehicles.common.entity.EntityVehicle;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketDriveClient
implements IMessage {
    private int pid;
    private int vid;
    private float seatRotYaw;
    private float throttleSpeed;
    private ArrayList<Integer> seatingSan = new ArrayList();

    public PacketDriveClient() {
    }

    public PacketDriveClient(EntityPlayer p, EntitySeat seat, float throttle) {
        this.pid = p.func_145782_y();
        this.seatRotYaw = seat.field_70177_z;
        if (seat.getParentVehicle() != null) {
            EntityVehicle vehicle = seat.getParentVehicle();
            this.vid = vehicle.func_145782_y();
            for (int i = 0; i < vehicle.seats.size(); ++i) {
                EntitySeat passenger = vehicle.seats.get(i);
                this.seatingSan.add(passenger.func_145782_y());
            }
        }
        this.throttleSpeed = throttle;
    }

    public void fromBytes(ByteBuf buf) {
        this.pid = buf.readInt();
        this.vid = buf.readInt();
        this.seatRotYaw = buf.readFloat();
        this.throttleSpeed = buf.readFloat();
        int seatCount = buf.readInt();
        if (seatCount > 0) {
            for (int i = 0; i < seatCount; ++i) {
                this.seatingSan.add(buf.readInt());
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pid);
        buf.writeInt(this.vid);
        buf.writeFloat(this.seatRotYaw);
        buf.writeFloat(this.throttleSpeed);
        if (!this.seatingSan.isEmpty()) {
            buf.writeInt(this.seatingSan.size());
            for (Integer integer : this.seatingSan) {
                buf.writeInt(integer.intValue());
            }
        } else {
            buf.writeInt(0);
        }
    }

    public static class Handler
    implements IMessageHandler<PacketDriveClient, IMessage> {
        public IMessage onMessage(PacketDriveClient message, MessageContext ctx) {
            this.readMessage(message);
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        public void readMessage(PacketDriveClient message) {
            Minecraft mc = Minecraft.func_71410_x();
            EntityPlayer player = null;
            if (mc.field_71441_e.func_73045_a(message.pid) instanceof EntityPlayer) {
                player = (EntityPlayer)mc.field_71441_e.func_73045_a(message.pid);
            }
            if (mc.field_71441_e.func_73045_a(message.vid) instanceof EntityVehicle) {
                EntityVehicle parent = (EntityVehicle)mc.field_71441_e.func_73045_a(message.vid);
                if (player != mc.field_71439_g) {
                    parent.throttleSpeed = message.throttleSpeed;
                }
                for (int i = 0; i < message.seatingSan.size(); ++i) {
                    if (!(mc.field_71441_e.func_73045_a(((Integer)message.seatingSan.get(i)).intValue()) instanceof EntitySeat)) continue;
                    ((EntitySeat)mc.field_71441_e.func_73045_a((int)((Integer)((PacketDriveClient)message).seatingSan.get((int)i)).intValue())).parent = parent;
                }
            }
            if (player != null && player != mc.field_71439_g && player.func_184187_bx() instanceof EntitySeat) {
                EntitySeat seat = (EntitySeat)player.func_184187_bx();
                if (seat.isDriver) {
                    if (seat.getParentVehicle() != null) {
                        seat.getParentVehicle().driversSeat = seat;
                    } else if (mc.field_71441_e.func_73045_a(message.vid) instanceof EntityVehicle) {
                        seat.parent = (EntityVehicle)mc.field_71441_e.func_73045_a(message.vid);
                    }
                    seat.field_70126_B = seat.field_70177_z = message.seatRotYaw;
                    seat.internalYaw = message.seatRotYaw;
                }
            }
        }
    }
}

