/*
 * Decompiled with CFR 0.152.
 */
package ctb_vehicles.client.packet;

import ctb_vehicles.client.CTBVClient;
import ctb_vehicles.common.entity.EntityVehicle;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketVehicleSoundClient
implements IMessage {
    private String sName;
    private int sID;
    private int vID;
    private boolean repeats;

    public PacketVehicleSoundClient() {
    }

    public PacketVehicleSoundClient(String sn, EntityLivingBase sntFrm, EntityVehicle vehicle, boolean repeats) {
        this.sName = sn;
        if (sntFrm != null) {
            this.sID = sntFrm.func_145782_y();
        }
        if (vehicle != null) {
            this.vID = vehicle.func_145782_y();
        }
        this.repeats = repeats;
    }

    public void fromBytes(ByteBuf buf) {
        this.sName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.repeats = buf.readBoolean();
        this.sID = buf.readInt();
        this.vID = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.sName);
        buf.writeBoolean(this.repeats);
        buf.writeInt(this.sID);
        buf.writeInt(this.vID);
    }

    public static class Handler
    implements IMessageHandler<PacketVehicleSoundClient, IMessage> {
        public IMessage onMessage(final PacketVehicleSoundClient message, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                Minecraft.func_71410_x().func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        this.doMessage(message);
                    }
                });
            }
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        public void doMessage(PacketVehicleSoundClient message) {
            Minecraft mc = Minecraft.func_71410_x();
            EntityPlayerSP player = mc.field_71439_g;
            EntityPlayer sentFrom = null;
            EntityVehicle vehicle = null;
            if (Minecraft.func_71410_x().field_71441_e.func_73045_a(message.sID) instanceof EntityPlayer) {
                sentFrom = (EntityPlayer)Minecraft.func_71410_x().field_71441_e.func_73045_a(message.sID);
            }
            if (Minecraft.func_71410_x().field_71441_e.func_73045_a(message.vID) instanceof EntityVehicle) {
                vehicle = (EntityVehicle)Minecraft.func_71410_x().field_71441_e.func_73045_a(message.vID);
            }
            if (sentFrom != null && vehicle != null) {
                CTBVClient.playVehicleSound((EntityPlayer)player, message.sName, vehicle, message.repeats);
            }
        }
    }
}

