/*
 * Decompiled with CFR 0.152.
 */
package ctb_vehicles.client.renders;

import com.mojang.realmsclient.gui.ChatFormatting;
import ctb.CTBClientTicker;
import ctb.ClientProxy;
import ctb.loading.Settings;
import ctb_vehicles.common.CTBVItemRegistry;
import ctb_vehicles.common.entity.EntitySeat;
import ctb_vehicles.common.entity.EntityVehicle;
import ctb_vehicles.common.entity.hitboxes.VHFace;
import ctb_vehicles.common.entity.hitboxes.VehicleHitbox;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.Item;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class CTBVRenderHooks {
    public static Minecraft mc = Minecraft.func_71410_x();

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        for (Item item : CTBVItemRegistry.itemList) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW, receiveCanceled=true)
    public void onWorldRender(RenderWorldLastEvent event) {
        List list;
        EntityPlayerSP player = CTBVRenderHooks.mc.field_71439_g;
        double x = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
        double y = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
        double z = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
        if (mc.func_175606_aa() != player) {
            x = CTBVRenderHooks.mc.func_175606_aa().field_70142_S + (CTBVRenderHooks.mc.func_175606_aa().field_70165_t - CTBVRenderHooks.mc.func_175606_aa().field_70142_S) * (double)event.getPartialTicks();
            y = CTBVRenderHooks.mc.func_175606_aa().field_70137_T + (CTBVRenderHooks.mc.func_175606_aa().field_70163_u - CTBVRenderHooks.mc.func_175606_aa().field_70137_T) * (double)event.getPartialTicks();
            z = CTBVRenderHooks.mc.func_175606_aa().field_70136_U + (CTBVRenderHooks.mc.func_175606_aa().field_70161_v - CTBVRenderHooks.mc.func_175606_aa().field_70136_U) * (double)event.getPartialTicks();
        }
        WorldClient world = CTBVRenderHooks.mc.field_71441_e;
        if (CTBVRenderHooks.mc.field_71474_y.field_74330_P && (list = player.field_70170_p.func_72872_a(EntityVehicle.class, player.func_174813_aQ().func_72314_b(10.0, 10.0, 10.0))) != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                EntityVehicle vehicle = (EntityVehicle)((Object)list.get(i));
                for (VehicleHitbox hitbox : vehicle.mainHitboxes) {
                    hitbox.updateHitbox(vehicle);
                    this.drawVehicleHitbox(hitbox, vehicle, x, y, z);
                }
            }
        }
    }

    private void drawVehicleHitbox(VehicleHitbox hitbox, EntityVehicle vehicle, double d0, double d1, double d2) {
        GL11.glDisable((int)3008);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.5f, (float)0.7f);
        GL11.glLineWidth((float)2.0f);
        GL11.glDisable((int)3553);
        Tessellator var2 = Tessellator.func_178181_a();
        var2.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181705_e);
        GL11.glColor4f((float)0.5f, (float)0.5f, (float)1.0f, (float)0.5f);
        GL11.glPushMatrix();
        GL11.glBegin((int)7);
        for (VHFace face : hitbox.hitboxFaces) {
            for (Vec3d point : face.points) {
                GL11.glVertex3f((float)((float)(point.field_72450_a - d0)), (float)((float)(point.field_72448_b - d1)), (float)((float)(point.field_72449_c - d2)));
            }
        }
        GL11.glEnd();
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        var2.func_78381_a();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2884);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRender(RenderGameOverlayEvent event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        ScaledResolution scaledresolution = new ScaledResolution(mc);
        int width = scaledresolution.func_78326_a();
        int height = scaledresolution.func_78328_b();
        EntityPlayerSP player = CTBVRenderHooks.mc.field_71439_g;
        FontRenderer fontRenderer = CTBVRenderHooks.mc.field_71466_p;
        if (player.func_184187_bx() instanceof EntitySeat) {
            EntitySeat seat = (EntitySeat)player.func_184187_bx();
            if (seat.isTurret && seat.getParentVehicle() != null) {
                EntityVehicle vehicle = seat.getParentVehicle();
                float number = vehicle.currentFireDelay > 0 ? (float)vehicle.currentFireDelay : (float)vehicle.fireDelay;
                TextFormatting color = vehicle.currentFireDelay > 0 ? TextFormatting.RED : TextFormatting.GREEN;
                number /= 20.0f;
                number = (float)Math.round(number * 10.0f) / 10.0f;
                String delayString = color + "" + number + "s";
                this.drawString(fontRenderer, delayString, width - fontRenderer.func_78256_a(delayString) - fontRenderer.field_78288_b, height - fontRenderer.field_78288_b * 2, 0xFFFFFF);
                int direction = (int)((player.field_70759_as + 180.0f) % 360.0f) < 0 ? 360 + (int)((player.field_70759_as + 180.0f) % 360.0f) : (int)((player.field_70759_as + 180.0f) % 360.0f);
                String bearingString = Integer.toString(direction);
                this.drawString(fontRenderer, bearingString, width - fontRenderer.func_78256_a(bearingString) - fontRenderer.field_78288_b, height - fontRenderer.field_78288_b * 3, 0xFFFFFF);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (seat.isScoped && seat.isMGSeat() && seat.getMGItem() != null) {
                int maxAmmo = seat.getMGItem().getMaxAmmo();
                if (seat.getMgAmmoType() >= 0 && seat.getMgAmmoType() < seat.getMGItem().ammo.length) {
                    maxAmmo = seat.getMGItem().ammo[seat.getMgAmmoType()].maxAmmo;
                }
                String ammoString = seat.mgAmmo + "/" + maxAmmo;
                if (seat.reloading) {
                    float number = seat.currentMGFireDelay;
                    TextFormatting color = TextFormatting.RED;
                    number /= 20.0f;
                    number = (float)Math.round(number * 10.0f) / 10.0f;
                    ammoString = color + "" + number + "s";
                }
                this.drawString(fontRenderer, ammoString, width - fontRenderer.func_78256_a(ammoString) - fontRenderer.field_78288_b, height - fontRenderer.field_78288_b * 2, 0xFFFFFF);
            }
            if (seat.isDriver && seat.getParentVehicle() != null && !(CTBVRenderHooks.mc.field_71462_r instanceof GuiChat) && (CTBClientTicker.tactView || !Settings.healthTact)) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int yp = seat.isScoped ? 0 : 14;
                EntityVehicle vehicle = seat.getParentVehicle();
                mc.func_110434_K().func_110577_a(ClientProxy.healthbarback);
                ClientProxy.drawFullRect((int)10, (int)(height - 20 - yp), (int)152, (int)12);
                float health = vehicle.getHealth() / vehicle.getMaxHealth();
                int hw = (int)(health * 150.0f);
                mc.func_110434_K().func_110577_a(ClientProxy.healthbarv);
                ClientProxy.drawFullRect((int)11, (int)(height - 19 - yp), (int)hw, (int)10);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                ClientProxy.drawCenteredString((FontRenderer)fontRenderer, (String)(ChatFormatting.WHITE + "" + (int)(health * 100.0f) + "%"), (int)86, (int)(height - 18 - yp), (int)0xFFFFFF);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    public void drawString(FontRenderer par1FontRenderer, String par2Str, int par3, int par4, int par5) {
        par1FontRenderer.func_175063_a(par2Str, (float)par3, (float)par4, par5);
    }

    @SubscribeEvent
    public void renderHandEvent(RenderHandEvent event) {
        if (CTBVRenderHooks.mc.field_71439_g.func_184187_bx() instanceof EntitySeat && ((EntitySeat)CTBVRenderHooks.mc.field_71439_g.func_184187_bx()).playerInvisible) {
            event.setCanceled(true);
        }
    }
}

