/*
 * Decompiled with CFR 0.152.
 */
package ctb_vehicles.client.renders;

import ctb.handlers.api.CTBVConnector;
import ctb.renders.utility.Model;
import ctb.renders.utility.OBJLoader;
import ctb_vehicles.client.CTBVTickerClient;
import ctb_vehicles.client.renders.RenderVehicleMGs;
import ctb_vehicles.common.entity.EntitySeat;
import ctb_vehicles.common.entity.EntityVehicle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;

@SideOnly(value=Side.CLIENT)
public class RenderVehicle
extends Render {
    private static final HashMap<String, ResourceLocation> vehicleTextures = new HashMap();
    private static final HashMap<String, ResourceLocation> secondaryVehicleTextures = new HashMap();
    private static final HashMap<String, Model> vehicleModels = new HashMap();
    private static final HashMap<String, Integer> vehicleDisplayLists = new HashMap();
    private static final HashMap<String, ArrayList<Model.OBJObject>> secondaryDisplayLists = new HashMap();
    private static final HashMap<String, ArrayList<Model.OBJObject>> trackObjects = new HashMap();
    private static final ArrayList<String> resourceNames = new ArrayList();
    private static final ResourceLocation TRACKS_TEXTURE = new ResourceLocation("ctb_vehicles:textures/vehicles/treads.png");
    private static final ResourceLocation CRATE_TEXTURE = new ResourceLocation("ctb", "textures/blocks/decor/crate.png");

    public RenderVehicle() {
        super(Minecraft.func_71410_x().func_175598_ae());
        this.field_76989_e = 0.0f;
    }

    public static void refreshModels() {
        resourceNames.clear();
        vehicleModels.clear();
        vehicleDisplayLists.clear();
        vehicleTextures.clear();
        secondaryDisplayLists.clear();
        trackObjects.clear();
    }

    public void doRender(EntityVehicle vehicle, double p_76986_2_, double p_76986_4_, double p_76986_6_, float p_76986_8_, float par9) {
        EntitySeat seat;
        EntityPlayerSP player;
        float wheelForRot;
        float wheelRot;
        int mainDisplayList;
        block55: {
            block54: {
                if (!resourceNames.contains(vehicle.getResourceName()) || !vehicleTextures.containsKey(vehicle.getTextureResourceName())) {
                    try {
                        if (!resourceNames.contains(vehicle.getResourceName())) {
                            resourceNames.add(vehicle.getResourceName());
                            if (!vehicleModels.containsKey(vehicle.getResourceName())) {
                                Model model = OBJLoader.loadModel((ResourceLocation)new ResourceLocation("ctb_vehicles", "models/vehicles/" + vehicle.getResourceName()));
                                vehicleModels.put(vehicle.getResourceName(), model);
                                secondaryDisplayLists.put(vehicle.getResourceName(), new ArrayList());
                                trackObjects.put(vehicle.getResourceName(), new ArrayList());
                                for (Model.OBJObject object : model.getOBJObjects()) {
                                    String fileToLoad;
                                    if (!object.getName().startsWith("load") || vehicleModels.containsKey(fileToLoad = object.getName().substring(5, object.getName().indexOf(".")))) continue;
                                    vehicleModels.put(fileToLoad, OBJLoader.loadModel((ResourceLocation)new ResourceLocation("ctb_vehicles", "models/vehicles/" + fileToLoad)));
                                    GL11.glPushMatrix();
                                    vehicleDisplayLists.put(fileToLoad, OBJLoader.createDisplayList((Model)vehicleModels.get(fileToLoad)));
                                    GL11.glPopMatrix();
                                }
                            }
                        }
                        if (!vehicleTextures.containsKey(vehicle.getTextureResourceName())) {
                            vehicleTextures.put(vehicle.getTextureResourceName(), new ResourceLocation("ctb_vehicles:textures/vehicles/" + vehicle.getTextureResourceName() + ".png"));
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return;
                }
                Model model = vehicleModels.get(vehicle.getResourceName());
                if (model == null) {
                    return;
                }
                switch (vehicle.getResourceName()) {
                    case "m1pack": {
                        model.setOffset("gun", 0.0f, -0.7158f, 1.1f);
                        break;
                    }
                    case "leig18": {
                        model.setOffset("gun", 0.0f, -0.3535f, 1.088f);
                        break;
                    }
                    case "type92bat": {
                        model.setOffset("gun", 0.0f, 0.0f, 4.5586f);
                        break;
                    }
                    case "m1927reg": 
                    case "m1927regcap": {
                        model.setOffset("gun", 0.0f, -1.045f, 1.258f);
                        break;
                    }
                }
                if (!vehicleDisplayLists.containsKey(vehicle.getResourceName())) {
                    ArrayList<Model.OBJObject> mainObjObjects = new ArrayList<Model.OBJObject>();
                    ArrayList<Model.OBJObject> secondaryObjObjects = new ArrayList<Model.OBJObject>();
                    for (Model.OBJObject objObject : model.getOBJObjects()) {
                        if (objObject.getName().toLowerCase().contains("glass")) continue;
                        if (objObject.getName().toLowerCase().contains("track")) {
                            trackObjects.get(vehicle.getResourceName()).add(objObject);
                            continue;
                        }
                        if (objObject.getName().toLowerCase().contains("wheel") || objObject.getName().toLowerCase().contains("handguncrate") || objObject.getName().toLowerCase().contains("steering") || objObject.getName().toLowerCase().contains("mgmount") || objObject.getName().toLowerCase().contains("gun") || objObject.getName().toLowerCase().startsWith("load")) {
                            GL11.glPushMatrix();
                            objObject.setRenderList(OBJLoader.createDisplayListFromObject((Model)vehicleModels.get(vehicle.getResourceName()), (Model.OBJObject)objObject));
                            if (objObject.getName().toLowerCase().startsWith("load")) {
                                Vector3f center = objObject.getCenter(vehicleModels.get(vehicle.getResourceName()));
                                objObject.prevRotationPointX = objObject.rotationPointX = center.x;
                                objObject.prevRotationPointY = objObject.rotationPointY = center.y;
                                objObject.prevRotationPointZ = objObject.rotationPointZ = center.z;
                            }
                            secondaryObjObjects.add(objObject);
                            GL11.glPopMatrix();
                            continue;
                        }
                        mainObjObjects.add(objObject);
                    }
                    GL11.glPushMatrix();
                    mainDisplayList = OBJLoader.createDisplayListFromObjects((Model)vehicleModels.get(vehicle.getResourceName()), mainObjObjects);
                    GL11.glPopMatrix();
                    vehicleDisplayLists.put(vehicle.getResourceName(), mainDisplayList);
                    secondaryDisplayLists.put(vehicle.getResourceName(), secondaryObjObjects);
                } else {
                    mainDisplayList = vehicleDisplayLists.get(vehicle.getResourceName());
                }
                GL11.glPushMatrix();
                GL11.glTranslatef((float)((float)p_76986_2_), (float)((float)p_76986_4_), (float)((float)p_76986_6_));
                wheelRot = 0.0f;
                wheelForRot = 0.0f;
                player = Minecraft.func_71410_x().field_71439_g;
                Entity driver = null;
                EntitySeat controllingSeat = vehicle.getControllingSeat();
                if ((controllingSeat == null || controllingSeat.field_70128_L) && vehicle.driversSeat != null) {
                    controllingSeat = vehicle.driversSeat;
                }
                if (controllingSeat == null || controllingSeat.field_70128_L) break block54;
                if (!controllingSeat.func_184188_bt().isEmpty()) {
                    driver = (Entity)controllingSeat.func_184188_bt().get(0);
                }
                GL11.glRotatef((float)(-(controllingSeat.prevPYaw + (controllingSeat.pYaw - controllingSeat.prevPYaw) * par9)), (float)0.0f, (float)1.0f, (float)0.0f);
                if (driver != player) break block55;
                wheelRot = CTBVTickerClient.wheelRot;
                wheelForRot = CTBVTickerClient.wheelForRot;
                break block55;
            }
            if (vehicle.driversSeat == null && vehicle.field_70173_aa % 20 == 0) {
                float f = 8.0f;
                List list = vehicle.field_70170_p.func_72872_a(EntitySeat.class, new AxisAlignedBB(vehicle.field_70165_t - (double)f, vehicle.field_70163_u - (double)f, vehicle.field_70161_v - (double)f, vehicle.field_70165_t + 1.0 + (double)f, vehicle.field_70163_u + 1.0 + (double)f, vehicle.field_70161_v + 1.0 + (double)f));
                for (Object o : list) {
                    EntitySeat seat2 = (EntitySeat)((Object)o);
                    if (!seat2.isDriver || seat2.parent != vehicle) continue;
                    vehicle.driversSeat = seat2;
                    break;
                }
            }
        }
        if (player.func_184187_bx() instanceof EntitySeat && (seat = (EntitySeat)player.func_184187_bx()).getParentVehicle() == vehicle && seat.isScoped && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
            GL11.glPopMatrix();
            return;
        }
        this.setupTransformFor(vehicle.getResourceName());
        if (vehicleTextures.containsKey(vehicle.getTextureResourceName())) {
            this.func_110776_a(vehicleTextures.get(vehicle.getTextureResourceName()));
        }
        if (vehicle.getHealth() <= 0.0f) {
            GL11.glColor3f((float)0.3f, (float)0.3f, (float)0.3f);
        }
        GL11.glShadeModel((int)7425);
        GL11.glCallList((int)mainDisplayList);
        GL11.glEnable((int)2977);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        for (Model.OBJObject object : secondaryDisplayLists.get(vehicle.getResourceName())) {
            if (object.getName().toLowerCase().contains("mgmount") && CTBVConnector.inMGSeat((Entity)Minecraft.func_71410_x().field_71439_g)) continue;
            GL11.glPushMatrix();
            if (object.getName().toLowerCase().contains("canopy")) {
                GL11.glDisable((int)2884);
            }
            GL11.glTranslatef((float)(-object.offsetX), (float)object.offsetZ, (float)(-object.offsetY));
            if (object.getName().toLowerCase().contains("wheel")) {
                if (vehicle.getResourceName().startsWith("kp")) {
                    if (object.getName().toLowerCase().contains("left")) {
                        GL11.glRotatef((float)-5.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    }
                    if (object.getName().toLowerCase().contains("right")) {
                        GL11.glRotatef((float)5.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    }
                    GL11.glRotatef((float)(wheelForRot / 2.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                } else {
                    if (object.getName().toLowerCase().contains("left") || object.getName().toLowerCase().contains("right") || object.getName().toLowerCase().contains("fl") || object.getName().toLowerCase().contains("fr")) {
                        GL11.glRotatef((float)(wheelRot / 3.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                    }
                    GL11.glRotatef((float)(wheelForRot / 2.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                }
            } else if (object.getName().toLowerCase().contains("steering")) {
                if (!vehicle.getResourceName().contains("ucarrier")) {
                    GL11.glRotatef((float)(wheelRot / 3.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                GL11.glRotatef((float)(wheelRot / 2.0f), (float)0.0f, (float)0.0f, (float)-1.0f);
            }
            if (object.getName().toLowerCase().contains("gun")) {
                GL11.glRotatef((float)(vehicle.prevGunPitch + (vehicle.gunPitch - vehicle.prevGunPitch) * par9), (float)1.0f, (float)0.0f, (float)0.0f);
            }
            GL11.glTranslatef((float)object.offsetX, (float)(-object.offsetZ), (float)object.offsetY);
            if (object.getName().toLowerCase().startsWith("load")) {
                GL11.glTranslatef((float)object.rotationPointX, (float)object.rotationPointY, (float)object.rotationPointZ);
                String fileToLoad = object.getName().substring(5, object.getName().indexOf("."));
                GL11.glCallList((int)vehicleDisplayLists.get(fileToLoad));
            } else if (object.getName().toLowerCase().contains("handguncrate")) {
                this.func_110776_a(CRATE_TEXTURE);
                GL11.glCallList((int)object.getRenderList());
                this.func_110776_a(vehicleTextures.get(vehicle.getTextureResourceName()));
            } else {
                GL11.glCallList((int)object.getRenderList());
            }
            if (object.getName().toLowerCase().contains("canopy")) {
                GL11.glEnable((int)2884);
            }
            GL11.glPopMatrix();
        }
        ArrayList<Model.OBJObject> tracks = trackObjects.get(vehicle.getResourceName());
        if (!tracks.isEmpty()) {
            this.func_110776_a(TRACKS_TEXTURE);
            for (int i = 0; i < tracks.size(); ++i) {
                Model.OBJObject objObject = tracks.get(i);
                String name = objObject.getBaseName();
                float v = name.toLowerCase().contains("left") ? (wheelRot > 1.0f ? -wheelForRot : wheelForRot) / 100.0f : (wheelRot < 1.0f ? -wheelForRot : wheelForRot) / 100.0f;
                GL11.glPushMatrix();
                OBJLoader.renderObjectWithUVOffset((Model)vehicleModels.get(vehicle.getResourceName()), (Model.OBJObject)objObject, (float)0.0f, (float)v);
                GL11.glPopMatrix();
            }
        }
        int mgInd = 0;
        for (int i = 0; i < vehicle.seats.size(); ++i) {
            EntitySeat seat3 = vehicle.seats.get(i);
            if (!seat3.isMGSeat()) continue;
            RenderVehicleMGs.renderMGFor(vehicle, seat3, mgInd);
            ++mgInd;
        }
        GL11.glDisable((int)2977);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    private ResourceLocation getResourceLocationFor(String vehicleName, String objectName) {
        String key = vehicleName + "_" + objectName;
        if (!secondaryVehicleTextures.containsKey(key)) {
            return vehicleTextures.get(vehicleName);
        }
        return secondaryVehicleTextures.get(vehicleName + "_" + objectName);
    }

    private void setupTransformFor(String resourceName) {
        float scale = 1.0f;
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)-0.1f, (float)0.0f);
        if (resourceName.contains("opel_blitz") || resourceName.contains("maultier") || resourceName.contains("cckw") || resourceName.contains("type94_truck")) {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-1.0f);
        }
        GL11.glScalef((float)scale, (float)scale, (float)scale);
    }

    protected ResourceLocation func_110775_a(Entity p_110775_1_) {
        return null;
    }

    public void func_76986_a(Entity p_76986_1_, double p_76986_2_, double p_76986_4_, double p_76986_6_, float p_76986_8_, float p_76986_9_) {
        this.doRender((EntityVehicle)p_76986_1_, p_76986_2_, p_76986_4_, p_76986_6_, p_76986_8_, p_76986_9_);
    }
}

