/*
 * Decompiled with CFR 0.152.
 */
package ctb_vehicles.common;

import ctb.CTB;
import ctb.progression.CTB2Class;
import ctb.progression.CTBClassGun;
import ctb.progression.CTBClassItem;
import ctb.progression.CTBClassVehicle;
import ctb.progression.ProgressionSystem;
import ctb_vehicles.common.CTBVItemRegistry;
import java.time.ZoneId;
import java.time.ZonedDateTime;

public class VehicleProgression
extends ProgressionSystem {
    private static final ZoneId PST = ZoneId.of("America/Los_Angeles");

    public static void registerUtilityVehicles() {
        VehicleProgression.registerUSVehicles();
        VehicleProgression.registerUKVehicles();
        VehicleProgression.registerFrenchVehicles();
        VehicleProgression.registerUSSRVehicles();
        VehicleProgression.registerPolishVehicles();
        VehicleProgression.registerBelgianVehicles();
        VehicleProgression.registerDutchVehicles();
        VehicleProgression.registerGreekVehicles();
        VehicleProgression.registerGermanVehicles();
        VehicleProgression.registerJapanVehicles();
        VehicleProgression.registerItalianVehicles();
        VehicleProgression.registerFinnishVehicles();
    }

    public static void registerUSVehicles() {
        CTB2Class utility_vehicle = new CTB2Class("Utility Vehicle");
        CTBClassVehicle willys_mb = new CTBClassVehicle(CTBVItemRegistry.willys_mb, "Willys MB", 0);
        utility_vehicle.addVehicle(willys_mb);
        CTBClassVehicle willys_mb_mg = new CTBClassVehicle(CTBVItemRegistry.willys_mb_mg, "Willys MB (.30 Cal)", 3);
        utility_vehicle.addVehicle(willys_mb_mg);
        CTBClassVehicle willys_mb_canopy = new CTBClassVehicle(CTBVItemRegistry.willys_mb_canopy, "Willys MB (Canopy)", 5);
        utility_vehicle.addVehicle(willys_mb_canopy);
        CTBClassVehicle willys_mb_mg50 = new CTBClassVehicle(CTBVItemRegistry.willys_mb_mg50, "Willys MB (.50 Cal)", 7);
        utility_vehicle.addVehicle(willys_mb_mg50);
        CTBClassVehicle wc51 = new CTBClassVehicle(CTBVItemRegistry.wc51, "WC-51", 10);
        utility_vehicle.addVehicle(wc51);
        CTBClassVehicle wc51_mg = new CTBClassVehicle(CTBVItemRegistry.wc51_mg50, "WC-51 (.50 Cal)", 13);
        utility_vehicle.addVehicle(wc51_mg);
        CTB2Class transport_vehicle = new CTB2Class("Transport Vehicle");
        CTBClassVehicle cckw = new CTBClassVehicle(CTBVItemRegistry.cckw, "GMC CCKW 343", 0);
        transport_vehicle.addVehicle(cckw);
        CTBClassVehicle cckwc = new CTBClassVehicle(CTBVItemRegistry.cckw_canvas, "GMC CCKW 343 (Canvas Top)", 3);
        transport_vehicle.addVehicle(cckwc);
        CTBClassGun thommy = new CTBClassGun(CTB.thompsonM1A1, "Thompson M1A1", "Thompson", 1.0, 1930);
        thommy.setDescription("The driver of a utility vehicle was typically issued a close range weapon. The Thompson M1A1 was commonly issued and kept inside the vehicle. The drive was typically an NCO.");
        thommy.setAmmo(CTB.t30Mag, 3);
        utility_vehicle.setDefaultGun(thommy);
        transport_vehicle.setDefaultGun(thommy);
        CTBClassGun m1Carbine = new CTBClassGun(CTB.m1carbine, "M1 Carbine", "M1 Carbine", 1.0, 1938);
        m1Carbine.setDescription("The M1 Carbine was commonly issued to vehicle crew for protection.");
        m1Carbine.setAmmo(CTB.m1Mag, 4);
        utility_vehicle.setGunUnlock(5, m1Carbine);
        transport_vehicle.setGunUnlock(5, m1Carbine);
        CTBClassGun m3smg = new CTBClassGun(CTB.greasegun, "M3 'Grease Gun'", "Grease Gun", 2.0, 1943);
        m3smg.setDescription("The M3 'Grease Gun' was sometimes issued to vehicle drivers or crew near the end of the war, though it was much less common than the Thompson or M1 Carbine.");
        m3smg.rpmmod = 40;
        m3smg.setAmmo(CTB.m3Mag, 3);
        utility_vehicle.setGunUnlock(7, m3smg);
        transport_vehicle.setGunUnlock(7, m3smg);
        CTBClassGun reirei = new CTBClassGun(CTB.reising55, "M55 Reising", "M55 Reising", 2.0, 1940);
        reirei.setDescription("Along with being used by paramarines, the compact M55 Reising was issued to armored vehicle crews.");
        reirei.rpmmod = 40;
        reirei.setAmmo(CTB.reiMag, 3);
        utility_vehicle.setGunUnlock(10, reirei);
        transport_vehicle.setGunUnlock(10, m3smg);
        CTBClassItem mk2 = new CTBClassItem(CTB.fragGrenade, "Mk II Frag Grenade", "Mk2 Frag", 0.5);
        mk2.setDescription("The Mk II Frag Grenade was the standard issue anti-personnel grenade of U.S. forces during World War II. Upon exploding it splits into fragments, causing even more devastation.");
        utility_vehicle.addGrenade(mk2);
        transport_vehicle.addGrenade(mk2);
        VehicleProgression.addClass((String)"US", (CTB2Class)utility_vehicle);
        VehicleProgression.addClass((String)"US", (CTB2Class)transport_vehicle);
    }

    private static void registerUKVehicles() {
        CTB2Class utility_vehicle = new CTB2Class("Utility Vehicle");
        CTBClassVehicle universal_carrier = new CTBClassVehicle(CTBVItemRegistry.universal_carrier, "Universal Carrier", 0);
        utility_vehicle.addVehicle(universal_carrier);
        CTBClassVehicle universal_carrierat = new CTBClassVehicle(CTBVItemRegistry.universal_carrier_at, "Universal Carrier(Boys AT)", 0);
        utility_vehicle.addVehicle(universal_carrierat);
        CTBClassVehicle willys_mb = new CTBClassVehicle(CTBVItemRegistry.willys_mb, "Willys MB (Lend Lease)", 3);
        utility_vehicle.addVehicle(willys_mb);
        CTBClassVehicle willys_mb_mg = new CTBClassVehicle(CTBVItemRegistry.willys_mb_mg, "Willys MB (.30 Cal)", 5);
        utility_vehicle.addVehicle(willys_mb_mg);
        CTBClassVehicle willys_mb_canopy = new CTBClassVehicle(CTBVItemRegistry.willys_mb_canopy, "Willys MB (Canopy)", 7);
        utility_vehicle.addVehicle(willys_mb_canopy);
        CTBClassVehicle willys_mb_mg50 = new CTBClassVehicle(CTBVItemRegistry.willys_mb_mg50, "Willys MB (.50 Cal)", 10);
        utility_vehicle.addVehicle(willys_mb_mg50);
        CTB2Class armored_car = new CTB2Class("Armored Car");
        CTBClassVehicle carden_loyd = new CTBClassVehicle(CTBVItemRegistry.cardenloyd, "Carden-Loyd Tankette", 0);
        armored_car.addVehicle(carden_loyd);
        CTBClassGun thompson = new CTBClassGun(CTB.thompsonM1928, "Thompson M1928A1", "Thompson M1928A1", 1.0, 1930);
        thompson.setDescription("The Thompson M1928A1 was lend-leased in large numbers to the UK. Often it came with lend-lease vehicles such as the Willys MB.");
        thompson.setAmmo(CTB.t20Mag, 5);
        utility_vehicle.setDefaultGun(thompson);
        armored_car.setDefaultGun(thompson);
        CTBClassGun sten = new CTBClassGun(CTB.sten, "Sten Mk II", "Sten MkII", 0.0, 1941);
        sten.setDescription("The Sten was a great compact weapon, and was commonly issued to vehicle crews.");
        sten.setAmmo(CTB.stenMag, 3);
        utility_vehicle.setGunUnlock(3, sten);
        armored_car.setGunUnlock(3, sten);
        CTBClassGun sten3 = new CTBClassGun(CTB.stenmk3, "Sten Mk III", "Sten Mk III", 1.0, 1942);
        sten3.setDescription("The Sten Mk.III was a cheaper development of the Sten Mk.II.");
        sten3.setAmmo(CTB.stenMag, 3);
        utility_vehicle.setGunUnlock(5, sten3);
        armored_car.setGunUnlock(5, sten3);
        CTBClassGun stenSupp = new CTBClassGun(CTB.sten, "Sten Mk.II(S)", "Sten Mk.II(S)", 1.0, 1943);
        stenSupp.setDescription("The Sten Mk.II could be equipped with a Suppressor. While it effectively lowered the sound profile, it wore out quickly.");
        stenSupp.setAmmo(CTB.stenMag, 3);
        stenSupp.setBarrel(CTB.stenSupp);
        utility_vehicle.setGunUnlock(10, stenSupp);
        armored_car.setGunUnlock(10, stenSupp);
        CTBClassGun welgun = new CTBClassGun(CTB.welgun, "BSA Welgun", "BSA Welgun", 1.0, 1930);
        welgun.setDescription("The Welgun was developed by the SOE, who favoured cheap short-range rapid fire weapons. It was intended to replace the early Sten, however the newer Sten Mk. VI was chosen instead. It still saw combat, however.");
        welgun.setAmmo(CTB.stenMag, 3);
        utility_vehicle.setGunUnlock(16, welgun);
        armored_car.setGunUnlock(16, welgun);
        CTBClassItem mk2 = new CTBClassItem(CTB.millBomb, "Mills Bomb", "Mills Bomb", 0.5);
        mk2.setDescription("The Mills Bomb was the standard issue anti-personnel grenade of the UK Army during World War II.");
        CTBClassItem no69 = new CTBClassItem(CTB.no69Grenade, "No. 69 Grenade", "No. 69 Grenade", 0.5);
        no69.setDescription("The No. 69 Grenade was made out of bakelite to prevent fragmentation, so that the user would not be hit by fragmentation. It had an 'all-ways' fuse, which allowed it to explode on impact no matter the angle.");
        utility_vehicle.addGrenade(mk2);
        utility_vehicle.addGrenade(no69);
        armored_car.addGrenade(mk2);
        armored_car.addGrenade(no69);
        VehicleProgression.addClass((String)"UK", (CTB2Class)utility_vehicle);
        VehicleProgression.addClass((String)"UK", (CTB2Class)armored_car);
    }

    private static void registerFrenchVehicles() {
        CTB2Class armored_car = new CTB2Class("Armored Car");
        CTBClassVehicle carden_loyd = new CTBClassVehicle(CTBVItemRegistry.cardenloydfr, "Carden-Loyd Tankette", 0);
        armored_car.addVehicle(carden_loyd);
        CTBClassGun berthiers = new CTBClassGun(CTB.berthier, "Berthier Mousqueton Mle 1892", "Berthier M1892", 0.0, 1892);
        berthiers.setDescription("The Berthier Mousqueton Mle 1892 was developed to partially replace the Lebel rifle for mounted troops and other roles that needed shorter rifles. Another requirement was to replace the tube fed system with a more modern magazine system. It was used extensively in both world wars.");
        berthiers.setAmmo(CTB.berthierClip, 10);
        armored_car.setDefaultGun(berthiers);
        CTBClassItem f1 = new CTBClassItem(CTB.frnF1Grenade, "F1 Frag Grenade", "F1 Grenade", 0.5);
        f1.setDescription("The F1 Frag Grenade was mass produced by France before and after WW1, and was standard issue in both world wars. A successful design, many other nations used it during WW1 and developed their own versions afterwards.");
        armored_car.addGrenade(f1);
        VehicleProgression.addClass((String)"France", (CTB2Class)armored_car);
    }

    private static void registerGreekVehicles() {
        CTB2Class utility_vehicle = new CTB2Class("Utility Vehicle");
        CTBClassVehicle universal_carrier = new CTBClassVehicle(CTBVItemRegistry.universal_carrier, "Universal Carrier", 0);
        utility_vehicle.addVehicle(universal_carrier);
        CTB2Class armored_car = new CTB2Class("Armored Car");
        CTBClassVehicle carden_loyd = new CTBClassVehicle(CTBVItemRegistry.cardenloyd, "Carden-Loyd Tankette", 0);
        armored_car.addVehicle(carden_loyd);
        CTBClassVehicle carden_loydg = new CTBClassVehicle(CTBVItemRegistry.l335g, "L3/35 (Captured", 3);
        armored_car.addVehicle(carden_loydg);
        CTBClassGun berthier4xe = new CTBClassGun(CTB.berthier16, "Berthier Mousqueton Mle 1892/M16", "Berthier M16", 0.0, 1916);
        berthier4xe.setDescription("France supplied Greece with large numbers of Berthier Mle 1892/M16 rifles. During the Greco-Italian war, they were primarily used by second-line troops.");
        berthier4xe.setAmmo(CTB.berthierClip5, 6);
        utility_vehicle.setDefaultGun(berthier4xe);
        armored_car.setDefaultGun(berthier4xe);
        CTBClassGun berthier190732 = new CTBClassGun(CTB.berthier190732, "Berthier Mle.1907/32", "Berthier 32", 0.0, 1932);
        berthier190732.setDescription("France produced more than 2 Million Berthier Rifles, many of which ended up in the service of nations across the world. During WW1, France supplied Greece with Berthier Rifles upon entering the war in 1917. By WWII, the Greeks had cut down many rifles into carbines and issued them to second line units during the Greco-Italian war.");
        berthier190732.setAmmo(CTB.berthierClip, 5);
        utility_vehicle.setGunUnlock(3, berthier190732);
        armored_car.setGunUnlock(3, berthier190732);
        CTBClassGun mann031430 = new CTBClassGun(CTB.mann031430, "Mannlicher Schoenauer Y1903/30 Carbine", "Mannlicher 30", 0.0, 1930);
        mann031430.setDescription("Beginning in 1927, Greece received about 105,000 Breda marked Mannlicher rifles. Some examples included carbines designated Mannlicher Schoenauer Y1903/14/30 Carbines and used throughout WW2 and the Greek Civil War.");
        mann031430.setAmmo(CTB.gre6554clip, 5);
        utility_vehicle.setGunUnlock(5, mann031430);
        armored_car.setGunUnlock(5, mann031430);
        CTBClassItem mk2 = new CTBClassItem(CTB.millBomb, "Mills Bomb", "Mills Bomb", 0.5);
        mk2.setDescription("The Mills Bomb was imported and used by the Greek during World War II.");
        utility_vehicle.addGrenade(mk2);
        armored_car.addGrenade(mk2);
        VehicleProgression.addClass((String)"Greece", (CTB2Class)utility_vehicle);
        VehicleProgression.addClass((String)"Greece", (CTB2Class)armored_car);
    }

    private static void registerUSSRVehicles() {
        CTB2Class utility_vehicle = new CTB2Class("Utility Vehicle");
        CTBClassVehicle willys_mb = new CTBClassVehicle(CTBVItemRegistry.willys_mbs, "Willys MB (Lend Lease)", 0);
        utility_vehicle.addVehicle(willys_mb);
        CTBClassVehicle willys_mb_mg = new CTBClassVehicle(CTBVItemRegistry.willys_mbs_mg, "Willys MB (.30 Cal)", 3);
        utility_vehicle.addVehicle(willys_mb_mg);
        CTBClassVehicle willys_mb_canopy = new CTBClassVehicle(CTBVItemRegistry.willys_mbs_canopy, "Willys MB (Canopy)", 5);
        utility_vehicle.addVehicle(willys_mb_canopy);
        CTBClassVehicle willys_mb_mg50 = new CTBClassVehicle(CTBVItemRegistry.willys_mbs_mg50, "Willys MB (.50 Cal)", 7);
        utility_vehicle.addVehicle(willys_mb_mg50);
        CTB2Class armored_car = new CTB2Class("Armored Car");
        CTBClassVehicle t27 = new CTBClassVehicle(CTBVItemRegistry.t27, "T-27 Tankette", 0);
        armored_car.addVehicle(t27);
        CTBClassGun thompson = new CTBClassGun(CTB.thompsonM1928, "Thompson M1928A1", "Thompson M1928A1", 1.0, 1930);
        thompson.setDescription("The Thompson M1928A1 was lend-leased in large numbers to the USSR. Often it came with lend-lease vehicles such as the Willys MB.");
        thompson.setAmmo(CTB.t20Mag, 5);
        utility_vehicle.setDefaultGun(thompson);
        armored_car.setDefaultGun(thompson);
        CTBClassGun reirei = new CTBClassGun(CTB.reising, "M50 Reising", "M50 Reising", 2.0, 1940);
        reirei.setDescription("Like the Thompson, the M50 Reising was Lend-Leased to the USSR.");
        reirei.rpmmod = 40;
        reirei.setAmmo(CTB.reiMag, 3);
        utility_vehicle.setGunUnlock(3, reirei);
        armored_car.setGunUnlock(3, reirei);
        CTBClassGun c96Carx = new CTBClassGun(CTB.mosinM38, "Mosin-Nagant M38", "M38 Carbine", 1.0, 1938);
        c96Carx.setDescription("Being more compact than a standard Mosin, the Mosin-Nagant M38 was an easy weapon to store in a vehicle.");
        c96Carx.setAmmo(CTB.mClip, 6);
        utility_vehicle.setGunUnlock(5, c96Carx);
        armored_car.setGunUnlock(5, c96Carx);
        CTBClassGun pps42 = new CTBClassGun(CTB.pps42, "PPS-42 Submachine Gun", "PPS-42", 0.0, 1942);
        pps42.setDescription("The folding stock of the PPS-42 makes it an ideal weapon for vehicle crews.");
        pps42.setAmmo(CTB.ppshMag, 3);
        utility_vehicle.setGunUnlock(7, pps42);
        armored_car.setGunUnlock(7, pps42);
        CTBClassGun pps43 = new CTBClassGun(CTB.pps43, "PPS-43 Submachine Gun", "PPS-43", 0.0, 1943);
        pps43.setDescription("The folding stock of the PPS-42 makes it an ideal weapon for vehicle crews.");
        utility_vehicle.setGunUnlock(10, pps43);
        armored_car.setGunUnlock(10, pps43);
        CTBClassItem rgd33 = new CTBClassItem(CTB.rgdGrenade, "RGD-33 Grenade", "RGD-33", 0.5);
        rgd33.setDescription("The RGD-33 was one of the standard issue hand grenades of the Red Army, alongside the F1 Frag grenade that was released in 1941.");
        CTBClassItem f1 = new CTBClassItem(CTB.f1Grenade, "F1 Frag Grenade", "F1 Grenade", 0.5);
        f1.setDescription("A copy of the successful French grenade, the Soviet F1 Frag Grenade was one of the standard issue hand grenades of the Red Army.");
        utility_vehicle.addGrenade(rgd33);
        utility_vehicle.addGrenade(f1);
        armored_car.addGrenade(rgd33);
        armored_car.addGrenade(f1);
        VehicleProgression.addClass((String)"USSR", (CTB2Class)utility_vehicle);
        VehicleProgression.addClass((String)"USSR", (CTB2Class)armored_car);
    }

    private static void registerPolishVehicles() {
        CTB2Class armored_car = new CTB2Class("Armored Car");
        CTBClassVehicle carden_loyd = new CTBClassVehicle(CTBVItemRegistry.tks, "TKS Tankette", 0);
        armored_car.addVehicle(carden_loyd);
        CTBClassGun pz = new CTBClassGun(CTB.wz29, "Karabinek wz.29", "Kb wz.29", 0.0, 1930);
        pz.setDescription("Based on the Kar98AZ, the Karabinek wz.29 was one of the most common Polish infantry rifles during World War II. Though officially replaced by the wz.98a long rifle, production of the Kb wz.29 still continued");
        pz.setAmmo(CTB.kClip, 6);
        armored_car.setDefaultGun(pz);
        CTBClassItem mk2 = new CTBClassItem(CTB.fragGrenade, "Granat Obronny wz. 33", "Granat wz.33", 0.5);
        mk2.setDescription("The Granat Obronny wz. 33 was the standard issue anti-personnel grenade of the Polish Army during World War II.");
        armored_car.addGrenade(mk2);
        VehicleProgression.addClass((String)"Poland", (CTB2Class)armored_car);
    }

    private static void registerBelgianVehicles() {
        CTB2Class armored_car = new CTB2Class("Armored Car");
        CTBClassVehicle carden_loyd = new CTBClassVehicle(CTBVItemRegistry.cardenloydb, "Carden-Loyd Tankette", 0);
        armored_car.addVehicle(carden_loyd);
        CTBClassGun berthier1 = new CTBClassGun(CTB.b1889c, "Belgian Mauser M1889 Carbine", "M1889 Carbine", 0.0, 1889);
        berthier1.setDescription("The success of the Mauser system becoming apparent, Belgium sought to use it when they required a service rifle of their own. FN acquired a license, and the new rifle was designated the Mauser Model 1889. A carbine variant was developed and used as well.");
        berthier1.setAmmo(CTB.bel76553clip, 6);
        armored_car.setDefaultGun(berthier1);
        CTBClassGun berthier1x = new CTBClassGun(CTB.b1889c16, "Belgian Mauser M89/16 Carbine", "M89/16 Carbine", 0.0, 1889);
        berthier1x.setDescription("The M89/16 Carbine was an updated design to replace earlier carbines.");
        berthier1x.setAmmo(CTB.bel76553clip, 6);
        armored_car.setGunUnlock(3, berthier1x);
        CTBClassGun berthier1xc = new CTBClassGun(CTB.b1889c16c, "Belgian Mauser M89/16 Carbine C", "M89/16 Carbine C", 0.0, 1889);
        berthier1xc.setDescription("A variant of the M89/16 Carbine.");
        berthier1xc.setAmmo(CTB.bel76553clip, 6);
        armored_car.setGunUnlock(5, berthier1xc);
        CTBClassGun s2 = new CTBClassGun(CTB.mp28, "Mitraillette Modele 1934", "MI-34", 0.0, 1928);
        s2.setDescription("Belgium produced their own licensed copy of the MP-28, designating it the Mitraillette Modele 1934.");
        s2.setAmmo(CTB.mp28mag, 3);
        armored_car.setGunUnlock(10, s2);
        CTBClassItem mk2 = new CTBClassItem(CTB.millBomb, "Mills Bomb", "Mills Bomb", 0.5);
        mk2.setDescription("The Mills Bomb was the standard issue anti-personnel grenade of Belgium during World War II.");
        armored_car.addGrenade(mk2);
        VehicleProgression.addClass((String)"Belgium", (CTB2Class)armored_car);
    }

    private static void registerDutchVehicles() {
        CTB2Class armored_car = new CTB2Class("Armored Car");
        CTBClassVehicle carden_loyd = new CTBClassVehicle(CTBVItemRegistry.cardenloydn, "Carden-Loyd Tankette", 0);
        armored_car.addVehicle(carden_loyd);
        CTBClassGun berthier1 = new CTBClassGun(CTB.mannM95c5, "M. 95 Karabijn No.5", "Karabijn No.5", 0.0, 1936);
        berthier1.setDescription("The Karabijn No.5 is a cut down version of the Geweer M. 95, intended for specialty and second-line roles such as field artillery. Over 35,300 were converted into these carbines.");
        berthier1.setAmmo(CTB.r6553Clip, 6);
        armored_car.setDefaultGun(berthier1);
        CTBClassGun berthier1x = new CTBClassGun(CTB.mannM95c3, "M. 95 Karabijn No.3", "Karabijn No.3", 0.0, 1900);
        berthier1x.setDescription("The Karabijn No.3 is a carbine variant of the Geweer M. 95, and was issued primarily to pioneers and field artillery.");
        berthier1x.setAmmo(CTB.r6553Clip, 6);
        armored_car.setGunUnlock(3, berthier1x);
        CTBClassGun berthier1xc = new CTBClassGun(CTB.mannM95c4, "M. 95 Karabijn No.4", "Karabijn No.4", 0.0, 1909);
        berthier1xc.setDescription("The Karabijn No.4 is a shortened  Geweer M. 95 for Dutch bicycle troops. It has a wood fairing on the left side of the magazine.");
        berthier1xc.setAmmo(CTB.r6553Clip, 6);
        armored_car.setGunUnlock(5, berthier1xc);
        CTBClassItem sc = new CTBClassItem(CTB.eiGranaat, "Scherpe Eihandgranaat No.3", "Scherpe No.3", 0.5);
        sc.setDescription("The Scherpe Eihandgranaat No.3 was a Dutch grenade.");
        CTBClassItem scj = new CTBClassItem(CTB.schokGranaat, "Scherpe Schokhandgranaat", "Scherpe Schok", 0.5);
        scj.setDescription("The Scherpe Schokhandgranaat was a Dutch grenade that exploded on impact.");
        armored_car.addGrenade(sc);
        armored_car.addGrenade(scj);
        VehicleProgression.addClass((String)"Netherlands", (CTB2Class)armored_car);
    }

    private static void registerGermanVehicles() {
        CTB2Class utility_vehicle = new CTB2Class("Utility Vehicle");
        CTBClassVehicle kubelwagen = new CTBClassVehicle(CTBVItemRegistry.kubelwagen, "Kubelwagen", 0);
        utility_vehicle.addVehicle(kubelwagen);
        CTBClassVehicle kubelwagen2 = new CTBClassVehicle(CTBVItemRegistry.kubelwagen_mg, "Kubelwagen (MG-34)", 3);
        utility_vehicle.addVehicle(kubelwagen2);
        utility_vehicle.addVehicle(new CTBClassVehicle(CTBVItemRegistry.kubelwagen_canvas, "Kubelwagen (Canvas Top)", 5));
        CTBClassVehicle kubelwagen3 = new CTBClassVehicle(CTBVItemRegistry.kubelwagen_mg42, "Kubelwagen (MG-42)", 7);
        utility_vehicle.addVehicle(kubelwagen3);
        CTB2Class transport_vehicle = new CTB2Class("Transport Vehicle");
        CTBClassVehicle opel_blitz = new CTBClassVehicle(CTBVItemRegistry.opel_blitz, "Opel Blitz Kfz.305", 0);
        transport_vehicle.addVehicle(opel_blitz);
        CTBClassVehicle maultier = new CTBClassVehicle(CTBVItemRegistry.maultier, "Maultier Sd.Kfz.3", 3);
        transport_vehicle.addVehicle(maultier);
        CTBClassVehicle opel_blitzc = new CTBClassVehicle(CTBVItemRegistry.opel_blitz_canvas, "Opel Blitz Kfz.305 (Canvas Top)", 5);
        transport_vehicle.addVehicle(opel_blitzc);
        CTBClassVehicle maultierc = new CTBClassVehicle(CTBVItemRegistry.maultier_canvas, "Maultier Sd.Kfz.3 (Canvas Top)", 7);
        transport_vehicle.addVehicle(maultierc);
        CTB2Class armored_car = new CTB2Class("Armored Car");
        CTBClassVehicle kugelpanzer = new CTBClassVehicle(CTBVItemRegistry.kugelpanzer, "Kugelpanzer", 0);
        armored_car.addVehicle(kugelpanzer);
        CTBClassGun thom = new CTBClassGun(CTB.mp38, "Maschinenpistole 38", "MP 38", 0.0, 1938);
        thom.setDescription("The compact MP 38 was a great weapon for vehicle crews, and it's predecessor the MP 40 was widely issued for vehicles.");
        thom.setAmmo(CTB.mp40Mag, 3);
        thom.rpmmod = 20;
        utility_vehicle.setDefaultGun(thom);
        transport_vehicle.setDefaultGun(thom);
        armored_car.setDefaultGun(thom);
        CTBClassGun mp40t = new CTBClassGun(CTB.mp40, "Maschinenpistole 40", "MP 40", 2.0, 1938);
        mp40t.setDescription("Due to it's compact size, the MP 40 was one of the most common small arms issued to vehicle crew.");
        mp40t.rpmmod = 140;
        mp40t.setAmmo(CTB.mp40Mag, 3);
        utility_vehicle.setGunUnlock(2, mp40t);
        transport_vehicle.setGunUnlock(2, mp40t);
        armored_car.setGunUnlock(2, mp40t);
        CTBClassGun c96Carbs = new CTBClassGun(CTB.c96Carbine, "Mauser C96 Carbine", "C96 Carbine", 3.0, 1910);
        c96Carbs.setDescription("The Mauser C96 had a carbine variant produced in small numbers. It was intended for use by light cavalry and other specialty troops.");
        c96Carbs.setAmmo(CTB.c96Clip, 2);
        utility_vehicle.setGunUnlock(5, c96Carbs);
        transport_vehicle.setGunUnlock(5, c96Carbs);
        armored_car.setGunUnlock(5, c96Carbs);
        CTBClassGun m1m2 = new CTBClassGun(CTB.m712, "M712 Schnellfeuer", "M712", 4.0, 1932);
        m1m2.setDescription("The M712 Schnellfeuer is a select fire, mag loaded variant of the C96 that has an insane rate of fire. While mostly exported to other countries such as China, it was issued to some Wermacht specialty troops.");
        m1m2.setAmmo(CTB.c96Mag, 2);
        utility_vehicle.setGunUnlock(7, m1m2);
        transport_vehicle.setGunUnlock(7, m1m2);
        armored_car.setGunUnlock(7, m1m2);
        CTBClassItem stiel = new CTBClassItem(CTB.stielGrenade, "M24 Stielhandgranate", "M24 Granate", 0.5);
        stiel.setDescription("The M24 Stielhandgranate was Germany's standard issue hand grenade during World War II. It was a concussion grenade with little fragmentation, but attachable fragmentation sleeves were somtimes used. It's shape allowed it to be thrown a lot farther than the standard 'pineapple' grenades of other nations.");
        utility_vehicle.addGrenade(stiel);
        transport_vehicle.addGrenade(stiel);
        armored_car.addGrenade(stiel);
        VehicleProgression.addClass((String)"Germany", (CTB2Class)utility_vehicle);
        VehicleProgression.addClass((String)"Germany", (CTB2Class)transport_vehicle);
        VehicleProgression.addClass((String)"Germany", (CTB2Class)armored_car);
    }

    private static void registerJapanVehicles() {
        CTB2Class utility_vehicle = new CTB2Class("Utility Vehicle");
        CTBClassVehicle kurogane = new CTBClassVehicle(CTBVItemRegistry.kurogane, "Kurogane Type 95", 0);
        utility_vehicle.addVehicle(kurogane);
        CTB2Class transport_vehicle = new CTB2Class("Transport Vehicle");
        CTBClassVehicle cckw = new CTBClassVehicle(CTBVItemRegistry.type94_truck, "Type 94 Truck", 0);
        transport_vehicle.addVehicle(cckw);
        CTB2Class armored_car = new CTB2Class("Armored Car");
        CTBClassVehicle carden_loyd = new CTBClassVehicle(CTBVItemRegistry.cardenloydj, "Type Ka Machine Gun Car", 0);
        armored_car.addVehicle(carden_loyd);
        CTBClassVehicle kugelpanzer = new CTBClassVehicle(CTBVItemRegistry.kugelpanzerj, "Kugelpanzer (Imported)", 3);
        armored_car.addVehicle(kugelpanzer);
        CTBClassGun ari38cb = new CTBClassGun(CTB.arisaka38Carbine, "Arisaka Type 38 Carbine", "T38 Carbine", 0.0, 1906);
        ari38cb.setDescription("The Arisaka Type 38 Carbine is a light carbine varient of the Type 38 Long Rifle. It was issued to specialty troops such as engineers.");
        ari38cb.setAmmo(CTB.ari50Clip, 4);
        utility_vehicle.setDefaultGun(ari38cb);
        transport_vehicle.setDefaultGun(ari38cb);
        armored_car.setDefaultGun(ari38cb);
        CTBClassGun t100 = new CTBClassGun(CTB.type100, "Nambu Type 100", "Type 100", 1.0, 1942);
        t100.setDescription("The Nambu Type 100 Submachinegun was Japan's standard issue during WW2. With it's light 8x22 Nambu round it has light recoil that is made even morecontrollable by it's fire rate. ");
        t100.setAmmo(CTB.type100Mag, 2);
        t100.rpmmod = 10;
        utility_vehicle.setGunUnlock(2, t100);
        transport_vehicle.setGunUnlock(2, t100);
        armored_car.setGunUnlock(2, t100);
        CTBClassGun t1004 = new CTBClassGun(CTB.type10044, "Nambu Type 100/44", "Type 100/44", 3.0, 1944);
        t1004.setDescription("The Nambu Type 100/44 is a simplified version of the Type 100. While it eliminated the ability to have a bipod, it is more reliable and has a faster fire rate. ");
        t1004.setAmmo(CTB.type100Mag, 2);
        t1004.rpmmod = 200;
        utility_vehicle.setGunUnlock(5, t1004);
        transport_vehicle.setGunUnlock(5, t1004);
        armored_car.setGunUnlock(5, t1004);
        CTBClassGun ari44cb = new CTBClassGun(CTB.arisaka44, "Arisaka Type 44 Carbine", "T44 Carbine", 1.0, 1912);
        ari44cb.setDescription("A further development of the Type 38 Carbine, the Arisaka Type 44 Carbine is equipped with a folding bayonet. It was issued to cavalry and other specialty troops.");
        ari44cb.setAmmo(CTB.ari50Clip, 4);
        utility_vehicle.setGunUnlock(7, ari44cb);
        transport_vehicle.setGunUnlock(7, ari44cb);
        armored_car.setGunUnlock(7, ari44cb);
        CTBClassGun type2 = new CTBClassGun(CTB.type2, "NM-A Type II A", "NM-A Type II A", 2.0, 1935);
        type2.setDescription("The NM-A Type II is a prototype submachinegun that has 3 rates of fire to choose from, and a 50-round banana mag.");
        type2.setAmmo(CTB.type2Mag, 2);
        utility_vehicle.setGunUnlock(13, type2);
        transport_vehicle.setGunUnlock(13, type2);
        armored_car.setGunUnlock(13, type2);
        CTBClassGun type2a = new CTBClassGun(CTB.type2b, "NM-A Type II B", "NM-A Type II B", 2.0, 1935);
        type2a.setDescription("The NM-A Type II B is a prototype submachinegun that has 3 rates of fire to choose from, and a 50-round banana mag, and is an improved version of the Type II A.");
        type2a.setAmmo(CTB.type2Mag, 2);
        utility_vehicle.setGunUnlock(16, type2a);
        transport_vehicle.setGunUnlock(16, type2a);
        armored_car.setGunUnlock(16, type2a);
        CTBClassItem mk2 = new CTBClassItem(CTB.type97Grenade, "Type 97 Frag Grenade", "Type 97 Grenade", 0.5);
        mk2.setDescription("The Type 97 Grenade was the standard issue anti-personnel grenade of Japanese forces during World War II. Upon exploding it splits into fragments, causing even more devestation.");
        utility_vehicle.addGrenade(mk2);
        transport_vehicle.addGrenade(mk2);
        armored_car.addGrenade(mk2);
        VehicleProgression.addClass((String)"Japan", (CTB2Class)utility_vehicle);
        VehicleProgression.addClass((String)"Japan", (CTB2Class)transport_vehicle);
        VehicleProgression.addClass((String)"Japan", (CTB2Class)armored_car);
    }

    private static void registerItalianVehicles() {
        CTB2Class armored_car = new CTB2Class("Armored Car");
        CTBClassVehicle carden_loyd = new CTBClassVehicle(CTBVItemRegistry.l335, "L3/35", 0);
        armored_car.addVehicle(carden_loyd);
        CTBClassGun beretta42x = new CTBClassGun(CTB.beretta42, "Beretta M1938/42 Submachine Gun (20 round magazines)", "Beretta 42 20rnd", 0.0, 1942);
        beretta42x.setDescription("Initially developed by Tullio Marengoni, the Beretta M1938 Submachine Guns were the most common and effective SMGs Italy had to offer. Produced until 1975, over a million Berettas 38 SMGs of 7 variants were produced. The Beretta 1938/42 was a simplified version of the original design.");
        beretta42x.setAmmo(CTB.berettaMag20, 3);
        armored_car.setDefaultGun(beretta42x);
        CTBClassGun beretta42 = new CTBClassGun(CTB.beretta42, "Beretta M1938/42 (40 round magazine)", "Beretta42 40rnd", 0.0, 1942);
        beretta42.setDescription("Beretta Submachine guns were initially produced with several magazines ranging from 10, 20 and 40 rounds of 9mm Parabellum. 30 round mags were also produced later.This Beretta M1938/42 comes with 40 round magazines.");
        beretta42.setAmmo(CTB.berettaMag40, 2);
        armored_car.setGunUnlock(3, beretta42);
        CTBClassGun fnab43 = new CTBClassGun(CTB.fnab43, "FNAB-43 Submachine Gun", "FNAB-43", 0.0, 1942);
        fnab43.setDescription("The Fabbrica Nazionale d'Armi di Brescia (Brescia National Arms Factor) 43 was a submachine gun developed by the Italian Social Republic and used by both German and Italian troops fighting in Northern Italy. The first prototypes were produced in 1942 with a total of about 7,000 being made overall. The weapons production ceased when it was deemed to be too complex to field in great numbers.");
        fnab43.setAmmo(CTB.berettaMag40, 3);
        armored_car.setGunUnlock(5, fnab43);
        CTBClassGun beretta38 = new CTBClassGun(CTB.beretta38, "Beretta M1938A Submachine Gun", "Beretta 38A", 0.0, 1938);
        beretta38.setDescription("Considered to be the best quality Beretta and a sought after trophy for Allied Troops, the Beretta M1938A was a pre-war version of the more Common Beretta 1938/42. It's longer barrel and adjustable sights allowed it to be more effective at range and a dust cover for the magazine slot helped prevent jams.");
        beretta38.setAmmo(CTB.berettaMag40, 4);
        armored_car.setGunUnlock(7, beretta38);
        CTBClassGun tz45 = new CTBClassGun(CTB.tz45, "TZ-45 SMG", "TZ-45", 0.0, 1944);
        tz45.setDescription("Produced by the Italian Social Republic to arm front line troops quickly and cheaply, the TZ-45 was a last-ditch weapon which was crudely made and unreliable. After WW2 the rights of the weapon were sold to Burma and produced as the BA-52.");
        tz45.setAmmo(CTB.berettaMag40, 3);
        armored_car.setGunUnlock(10, tz45);
        CTBClassGun og43 = new CTBClassGun(CTB.og43, "OG-43 Prototype Submachine Gun", "OG-43", 0.0, 1943);
        og43.setDescription("The OG-43 and OG-44 SMGs are Italian prototypes of which not too much is known. Using surprisingly advanced operating systems and stamped parts for ease of production, the OG-43 had a folding stock for ease of transfer.");
        og43.setAmmo(CTB.berettaMag40, 3);
        armored_car.setGunUnlock(13, og43);
        CTBClassItem srcm35 = new CTBClassItem(CTB.srcm35, "SRCM Mod. 35 Grenade", "SRCM 35", 0.0);
        srcm35.setDescription("The SRCM Modello 1935, along with two other grenade types(Breda Mod 35 and OTO Mod 35), became the standard issue offensive type grenades of the Royal Italian Army for the duration of World War 2. The most common being the SRCM model which saw continued use until the 1980s. Nicknamed 'Red Devils' by the British for their bright red color, the grenades proved effective throughout the war.");
        armored_car.addGrenade(srcm35);
        VehicleProgression.addClass((String)"Italy", (CTB2Class)armored_car);
    }

    private static void registerFinnishVehicles() {
        CTB2Class armored_car = new CTB2Class("Armored Car");
        CTBClassVehicle carden_loyd = new CTBClassVehicle(CTBVItemRegistry.cardenloydf, "Carden-Loyd Tankette", 0);
        armored_car.addVehicle(carden_loyd);
        if (VehicleProgression.isAprilFools() && !VehicleProgression.isAprilFoolsOver()) {
            CTBClassVehicle kp = new CTBClassVehicle(CTBVItemRegistry.kugelpanzer, "Kugelpanzer", 0);
            armored_car.addVehicle(kp);
        }
        CTBClassGun s = new CTBClassGun(CTB.suomi, "Suomi KP/-31", "Suomi KP/-31", 0.0, 1931);
        s.setDescription("The Suomi KP/-31 was such a successful and effective submachinegun, that the Soviets copied it's design for their PPD-40, and in turn the PPSh-41. It was even initially used as a subsitute for a light machine gun.");
        s.setAmmo(CTB.suomiMag, 3);
        armored_car.setDefaultGun(s);
        CTBClassGun s2 = new CTBClassGun(CTB.suomi, "Suomi KP/-31(Drum)", "Suomi (Drum)", 0.0, 1931);
        s2.setDescription("Shortly after it's deployment, a 71-round drum magazine was developed for Suomi KP/-31. This too, was copied by the Russians in their PPD-40 and PPSh-41.");
        s2.setAmmo(CTB.suomiDrum, 1);
        armored_car.setGunUnlock(3, s2);
        CTBClassGun pp = new CTBClassGun(CTB.ppd40, "PPD-40 (Captured)", "PPD (Captured)", 0.0, 1940);
        pp.setDescription("The Soviets were defeated in such large numbers by tiny Finland, that they were able to amass numerous PPD-40's, the Russian copy of their very own Suomi KP/-31.");
        pp.setAmmo(CTB.ppshDrum, 1);
        armored_car.setGunUnlock(5, pp);
        CTBClassGun s2c = new CTBClassGun(CTB.suomi, "Suomi KP/-31 Extended", "Suomi Extended", 0.0, 1931);
        s2c.setDescription("The Suomi KP/-31 had a special casket, or coffin magazine developed for it. The quad-column design allowed for it to carry 50 rounds, while being even shorter than the 36 round magazine! It's compact size allows it to be reloaded much quicker than a drum magazine");
        s2c.setAmmo(CTB.suomiMag2, 3);
        armored_car.setGunUnlock(7, s2c);
        CTBClassGun s2ct = new CTBClassGun(CTB.suomitrench, "Suomi KP/-31 Bunker", "Suomi Bunker", 0.0, 1931);
        s2ct.setDescription("The Suomi KP/-31 had a special Bunker varient with a handgrip and longer barrel. It lacked a stock, and was intended for being fired through slits in a bunker or tank.");
        s2ct.setAmmo(CTB.suomiDrum, 1);
        armored_car.setGunUnlock(10, s2ct);
        CTBClassItem mk2 = new CTBClassItem(CTB.fragGrenade, "Aasen Hand Grenade", "Aasen Hand Grenade", 0.5);
        mk2.setDescription("The Aasen Hand Grenade was the standard issue anti-personnel grenade of the Norwegian Army during World War II.");
        armored_car.addGrenade(mk2);
        VehicleProgression.addClass((String)"Finland", (CTB2Class)armored_car);
    }

    public static boolean isAprilFools() {
        ZonedDateTime aprilFirst;
        ZonedDateTime now = ZonedDateTime.now(PST);
        if (now.isAfter(aprilFirst = ZonedDateTime.of(now.getYear(), 4, 1, 0, 0, 0, 0, PST))) {
            return true;
        }
        return now.getMonthValue() == 4 && now.getDayOfMonth() == 1;
    }

    public static boolean isAprilFoolsOver() {
        ZonedDateTime now = ZonedDateTime.now(PST);
        ZonedDateTime aprilFirst = ZonedDateTime.of(now.getYear(), 4, 1, 0, 0, 0, 0, PST);
        return now.isAfter(aprilFirst.plusDays(7L));
    }
}

